$('#tutorial').on('click', function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false
    })
    driver.defineSteps([
      {
        element: "#tutorial-step1",
        popover: {
          title: "Campos",
          description:
            "Aqui se encontram os campos essenciais para consultar e gravar as informações.",
          position: "bottom",
        },
      },
      {
        element: '#btnVoltar',
        popover: {
          title: 'Voltar',
          description: 'Aqui está o botão para voltar à consulta.',
          position: 'bottom'
        }
      },
      {
        element: '#btnGravar',
        popover: {
          title: 'Gravar',
          description: 'Aqui está o botão para gravar as informações.',
          position: 'bottom'
        }
      }
    ])
    driver.start()
  })
})

$(document).ready(async function () {
  ItensCotacaoNegociados.criarTabelaItens()
  $('#tabelaItens').on('click', '#btnMapaCotacao', async function () {
    const datatable = $('#tabelaItens').DataTable()
    const { numero } = datatable?.row($(this)?.parents('tr'))?.data()
    $.LoadingOverlay('show')
    ModalMapaCotacaoNegociados.buscarDados(numero).then((dados) => {
      if (!dados) {
        return
      }

      ModalMapaCotacaoNegociados.carregar({ ...dados })
    }).catch((error) => {
      console.error(error)
      msgErro('Ocorreu um erro ao carregar os dados.')
    }).finally(() => $.LoadingOverlay('hide'))
  })

  $('#btnVoltar').on('click', function () {
    window.location.href = `${BASE_URI}/central_compras`
  })
})

window.ItensCotacaoNegociados = window.ItensCotacaoNegociados || {}

ItensCotacaoNegociados.idSelecionado = 0

ItensCotacaoNegociados.criarTabelaItens = () => {
  if ($.fn.DataTable.isDataTable('#tabelaItens')) {
    $('#tabelaItens').DataTable().destroy()
    $('#tabelaItens').empty()
  }

  const columns = [
    {
      data: 'numero',
      title: 'Número',
      render: (data) => (
        '<div style="text-align:start;"> ' +
        '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" id="tutorialTabela" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
        '      ' + data + ' ' +
        '    </button> ' +
        '    <div class="dropdown-menu"> ' +
        '    <button class="dropdown-item" type="button" title="Mapa Cotação" id="btnMapaCotacao">Mapa Cotação</button>     ' +
        '</div>'
      )
    },
    {
      data: 'dataCadastro',
      title: 'Cadastro',
      render(data) {
        return new Intl.DateTimeFormat('pt-BR').format(new Date(`${data.split('T')[0]} 23:59:59`))
      },
    },
    {
      data: 'dataEntrega',
      title: 'Entrega',
      render(data) {
        return new Intl.DateTimeFormat('pt-BR').format(new Date(`${data.split('T')[0]} 23:59:59`))
      },
    },
    {
      data: 'centroCusto',
      title: 'Centro de Custo',
    },
    {
      data: 'descricaoCentroCusto',
      title: 'Descrição Centro de Custo',
    },
    {
      data: 'tipoItem',
      title: 'Tipo Item',
    },
    {
      data: 'codigo',
      title: 'Código',
    },
    {
      data: 'descricao',
      title: 'Descrição',
    },
    {
      data: 'cor',
      title: 'Cor',
    },
    {
      data: 'descricaoCor',
      title: 'Descrição Cor',
    },
    {
      data: 'tamanho',
      title: 'Tamanho',
    },
    {
      data: 'descricaoTamanho',
      title: 'Descrição Tamanho',
      visible: false,
    },
    {
      data: 'deposito',
      title: 'Depósito',
    },
    {
      data: 'descricaoDeposito',
      title: 'Descrição Depósito',
    },
    {
      data: 'fornecedor',
      title: 'Fornecedor',
    },
    {
      data: 'nomeFornecedor',
      title: 'Nome Fornecedor',
    },
    {
      data: 'especificacao',
      title: 'Especificação',
    },
    {
      data: 'unidade',
      title: 'Unidade',
    },
    {
      data: 'unidadeCompra',
      title: 'Unidade de Compra',
    },
    {
      data: 'quantidade',
      title: 'Quantidade',
      className: 'text-right',
      render: function (data) {
        if (!data) {
          return '0.00'
        }
        return parseFloat(data).toFixed(2)
      }
    },
    {
      data: 'preco',
      title: 'Preço',
      className: 'text-right',
      render: function (data) {
        if (!data) {
          return '0.00'
        }
        return parseFloat(data).toFixed(2)
      }
    },
    {
      data: 'valor',
      title: 'Valor',
      className: 'text-right',
      render: function (data) {
        if (!data) {
          return '0.00'
        }
        return parseFloat(data).toFixed(2)
      }
    },
    {
      data: 'status',
      title: 'Situação',
    },
    {
      data: 'observacao',
      title: 'Observação',
    },
    {
      data: 'usuario',
      title: 'Usuário',
    },
    {
      data: 'id',
      title: 'Id',
      visible: false,
    },
  ]

  $('#tabelaItens').DataTable({
    sort: false,
    paging: true,
    destroy: true,
    lengthChange: false,
    filter: false,
    info: false,
    ordering: false,
    sorting: false,
    order: false,
    pageLength: 23,
    colReorder: true,
    serverSide: true,
    ajax: {
      url: `${getCookie('protocolo')}://${getCookie('ip_api')}/sisplan/centralcompras/cotacao/v1/retornaritens`,
      type: "GET",
      headers: {
        'Authorization': getCookie('accessToken') ? 'Bearer ' + getCookie('accessToken') : '',
      },
      data: {
        EMPRESA: getCookie('empresa'),
        STATUS: 'N',
      },
      dataSrc: function (json) {
        if (!json || !json.data) {
          return []
        }
        ItensCotacaoNegociados.idSelecionado = json.data[0]?.id
        return json.data
      },
      cache: true,
      beforeSend: function () {
        $.LoadingOverlay('show')
      },
      complete: function () {
        $.LoadingOverlay('hide')
      },
    },
    autoWidth: true,
    columns,
    scrollX: true,
    scrollY: '737px',
  })
  UtilsCentralCompras.criarContainerBotoes({
    tabela: 'tabelaItens',
  })
  UtilsCentralCompras.habilitarEsconderColunas({
    tabela: 'tabelaItens',
    tela: 'ItensCotacaoNegociados',
  })
  UtilsCentralCompras.habilitarExportarCsv({
    tabela: 'tabelaItens',
    status: 'N',
    tipo: 'COT',
  })
}