<?php include_once('../../../config.php') ?>

<!DOCTYPE html>
<html>

<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Sisplan Web | Centro de Custo</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link rel="stylesheet" href="plugins/fontawesome-free/css/all.min.css?versao=3.258.7.1">
  <link rel="stylesheet" href="dist/css/adminlte.min.css?versao=3.258.7.1">
  <link href='https://fonts.googleapis.com/css?family=Roboto:400,300,500,600,700,400italic' rel='stylesheet' type='text/css'>
  <link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700" rel="stylesheet">
  <link rel="stylesheet" href="dist/css/custom.css?versao=3.258.7.1">
  <link rel="stylesheet" href="dist/css/sisplan.css?versao=3.258.7.1">
  <link rel="stylesheet" type="text/css" href="dist/css/dataTables.bootstrap4.min.css?versao=3.258.7.1" />
  <link rel="shortcut icon" href="favicon.ico">
  <link rel="stylesheet" href="plugins/toastr/toastr.min.css?versao=3.258.7.1">
  <link rel="stylesheet" type="text/css" href="dist/css/driver.min.css?versao=3.258.7.1" />
  <link rel="stylesheet" href="dist/css/jquery-ui.css?versao=3.258.7.1">
  <style>
    #tabelaAcessoCC td div button {
      padding: .0rem .5rem;
      margin-top: .1rem;
      margin-bottom: .2rem;
    }

    #tabelaAcessoCC td {
      padding: 0 !important;
      padding-left: 10px !important;
    }
  </style>
</head>

<body class="hold-transition sidebar-mini layout-fixed">
  <div class="wrapper">

    <div class="content-wrapper">
      <div class="content-header">
        <div class="container-fluid">
          <div class="row mb-2">
            <div class="col-sm-6 flex">
              <h1 class="m-0 text-dark">Cadastro de Centro de Custo</h1>
              <button type="button" class="btn btn-info btn-sm ml-2" title="Tutorial" style="color: white;" id="tutorial">
                <i class="fas fa-question-circle"></i></button>
            </div>
            <div class="col-sm-6">

            </div>
          </div>
        </div>
        <div class="container-fluid" id="tabelAcessoCC">
          <div class="row card">
            <div class="col-sm-12 mt-3">
              <button class="btn btn-success btn-sisp" id="btnFiltros"><span class="fas fa-search"></span> Filtros</button>
              <button class="btn btn-danger btn-sisp" id="btnIncluir"><span class="fas fa-plus"></span> Incluir</button>
            </div>
            <div class="col-sm-12 table-responsive card-body">
              <h5>Lista de Centro de Custo</h5>
              <table id="tabelaAcessoCC" class="table table-sm table-select table-hover" width="100%">
                <thead>
                  <tr>
                    <th class="th-sm">Código</th>
                    <th class="th-sm">Descrição</th>
                    <th class="th-sm">Estrutura</th>
                    <th class="th-sm">Grupo</th>
                    <th class="th-sm">Tipo</th>
                  </tr>
                </thead>
                <tbody>
                </tbody>
              </table>
            </div>
          </div>
        </div>
        <div id="modal-filtros" class="modal" tabindex="-1" role="dialog">
          <div class="modal-dialog modal-xl" role="document">
            <div class="modal-content" id="modalBody">
              <div class="modal-header">
                <h4 class="modal-title">Filtros</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                  <span aria-hidden="true">&times;</span>
                </button>
              </div>
              <div class="modal-body">
                <div class="row">
                  <div class="col-4 col-md-4 col-sm-12">
                    <label data-error="wrong" data-success="right" for="txtCentroCusto">Centro de Custo: </label>
                    <div class="input-group">
                      <input type="text" autocomplete="off" class="input-default focus form-control" id="txtCentroCusto" name="txtCentroCusto" class="form-control" placeholder="Centro de Custo">
                      <div class="input-group-append">
                        <button class="btn bg-danger" id="btnCentroCusto" name="btnCentroCusto" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                        <button class="btn bg-danger" id="btnLimpaCentroCusto" name="btnLimpaCentroCusto" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                      </div>
                    </div>
                  </div>
                  <div class="col-4 col-md-4 col-sm-12">
                    <label data-error="wrong" data-success="right" for="txtGrupoCCusto">Grupo de Centro de Custo: </label>
                    <div class="input-group">
                      <input type="text" autocomplete="off" class="input-default focus form-control" id="txtGrupoCCusto" name="txtGrupoCCusto" class="form-control" placeholder="Grupo de Centro de Custo">
                      <div class="input-group-append">
                        <button class="btn bg-danger" id="btnGrupoCCusto" name="btnGrupoCCusto" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                        <button class="btn bg-danger" id="btnLimpaGrupoCCusto" name="btnLimpaGrupoCCusto" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                      </div>
                    </div>
                  </div>
                  <div class="col-4 col-md-4 col-sm-12">
                    <label data-error="wrong" data-success="right" for="rgTipo">Tipo: </label>
                    <select id="rgTipo" class="input-default focus custom-select">
                      <option value="" selected disabled>Selecione uma opção</option>
                      <option value="">Todas</option>
                      <option value="T">Título</option>
                      <option value="A">Analítica</option>
                    </select>
                  </div>
                </div>
              </div>
              <div class="modal-footer">
                <div class="row">
                  <button class="btn btn-primary btn-sisp" id="btnLimparFiltros" style="background-color: #B22222; border-color: #B22222"><span class="fas fa-trash"></span> Limpar Filtros</button>     
                  <button class="btn btn-primary btn-sisp" id="btnConsultar"><span class="fas fa-search"></span> Consultar</button>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
  <?php
  include_once('../../../modais.php');
  ?>
  <aside class="control-sidebar control-sidebar-dark">
  </aside>
  </div>
  <script src="plugins/jquery/jquery.min.js?versao=3.258.7.1"></script>
  <script type="text/javascript" src="dist/js/jquery.dataTables.js?versao=3.258.7.1"></script>
  <script type="text/javascript" src="dist/js/dataTables.bootstrap4.min.js?versao=3.258.7.1"></script>
  <script src="plugins/jquery-ui/jquery-ui.min.js?versao=3.258.7.1"></script>
  <script>
    $.widget.bridge('uibutton', $.ui.button);
  </script>
  <script src="plugins/bootstrap/js/bootstrap.bundle.min.js?versao=3.258.7.1"></script>
  <script src="dist/js/adminlte.min.js?versao=3.258.7.1"></script>
  <script src="dist/js/sisplan.js?versao=3.258.7.1"></script>
  <script src="utils/funcoes.js?versao=3.258.7.1"></script>
  <script src="utils/cookies.js?versao=3.258.7.1"></script>
  <script src="dist/js/requisicoes.js?versao=3.258.7.1"></script>
  <script src="dist/js/loadingoverlay.min.js?versao=3.258.7.1"></script>
  <script src="dist/js/driver.min.js?versao=3.258.7.1"></script>
  <script src="plugins/toastr/toastr.min.js?versao=3.258.7.1"></script>
  <script type="text/javascript" src="dist/js/sum().js?versao=3.258.7.1"></script>
  <script type="text/javascript" src="config.js?versao=3.258.7.1"></script>
  <script>
    $(document).ready(async function() {
      if (getCookie('usuario') == "") {
        window.location.href = `${BASE_URI}/login`;
        return;
      }

      let usuario = getCookie('usuario');
      let empresa = getCookie('empresa');

      ipInterno = IP_INTERNO;
      ipExterno = IP_EXTERNO;
      basicAuth = BASIC_AUTH;

      const temAcesso = await temAcessoTela('CENTROCUSTO');
      if (!temAcesso.resultado) {
        toastrAcesso(temAcesso, BASE_URI);
        return;
      }

      sArquivo = `${BASE_URI}/pages/centrocusto/acesso_centrocusto/acesso_centrocusto.js?versao=3.258.7.1`;
      insereJavaScriptPagina(sArquivo);

    });
  </script>
</body>

</html>