
$("#tutorial").on("click", function () {
    $("#geral-tab").trigger("click");
    const driver = new Driver({
        doneBtnText: "Sair",
        closeBtnText: "Fechar",
        nextBtnText: "Próximo",
        prevBtnText: "Anterior",
        allowClose: false,
        onHighlightStarted: (Element) => {

        },
        onPrevious: (Element) => {

        },
        onNext: (Element) => {

            if ((Element.node.id == 'avancar1')) {
                // if (pegaChave('#txtCliente') == '') {
                //     insereValor('#txtFornecedor', ' ', ' ')
                // };

                $('#avancar1').trigger('click');
            }
        },
    });

    driver.defineSteps([{
        element: "#geral-tab",
        popover: {
            title: "Aba Geral",
            description: "Clique aqui para abrir a aba geral.",
            position: "top",
        },
    },
    {
        element: "#geral",
        popover: {
            title: "Cadastro Geral",
            description: "Aqui você pode informar os dados gerais de cadastro da ordem de compra.",
            position: "bottom",
        },
    },
    ]);
    driver.start();
    driver.getHighlightedElement();
});
$(document).ready(async function () {
    let idItens = [];
    let isAlteracao = false;
    const parametroPermiteEstoqueNegativo = ["1", "2"].includes(await CopiaParametro('VENDA', 4));
    const depositoParam = await CopiaParametro('VENDA', 1)

    await setarDataAtual('dtIni')
    await setarDataAtual('dtAcerto')

    const formataValor = (valor) => new Intl.NumberFormat('pt-BR', {
        minimumFractionDigits: 2,
        maximumFractionDigits: 2,
    }).format(valor);

    criaDataTablePadrao('#tabelaItensConsignado', false, false, false, false, true, true, '400px', null, null, [], [], [], [7, 9], {}, 2, '', '', false, [], [6, 8, 9, 10], []);

    const columnsConsignadoAberto = [
        { "data": "codcli", "title": "Cliente" },
        { "data": "nome", "title": "Nome" },
        { "data": "codrep", "title": "Representante" },
        { "data": "nome_representante", "title": "Nome Representante" },
        { "data": "status", "title": "Status" },
        { "data": "desc_status", "title": "Desc. Status" },
        { "data": "dataAcerto", "title": "Data de Acerto" },
        { "data": "qtde_saida", "title": "Qtde. Saída" },
        { "data": "qtde_entrada", "title": "Qtde. Entrada" },
        { "data": "saldo", "title": "Saldo" },
        { "data": "situacao", "title": "Situação" },
        { "data": "valorMinimo", "title": "Valor Mínimo" },
        { "data": "dias", "title": "Dias" },
    ]

    function totalQuantidade() {
        $('#txtQtdeTotal').val(TruncaDecimaisNova(2, $('#tabelaItensConsignado').DataTable().rows().data().reduce((acc, current) => { return acc + parseFloat(current[5]) }, 0)))
    }

    function totalValorItem() {
        const preco = $('#tabelaItensConsignado').DataTable().rows().data().reduce((acc, current) => { return acc + current[9] }, 0)
        $('#txtValorTotalItem').val(formataValor(TruncaDecimaisNova(2, preco)))
    }

    function totalValorLiquido() {
        const preco = $('#tabelaItensConsignado').DataTable().rows().data().reduce((acc, current) => { return acc + current[9] }, 0)
        const desconto = $('#tabelaItensConsignado').DataTable().rows().data().reduce((acc, current) => { return acc + current[8] }, 0)

        const total = preco - desconto

        $('#txtValorTotal').val(formataValor(TruncaDecimaisNova(2, total)))
    }

    function addSelected(add = true) {
        for (let i = 0; i < $('#tabelaSolicitacao').DataTable().rows().data().length; i++) {
            if (add) {
                $($("table#tabelaSolicitacao tr")[i + 1]).addClass("selected");
            } else {
                $($("table#tabelaSolicitacao tr")[i + 1]).removeClass("selected");
            }
        }
    };

    function botaoSelecionarGrid() {
        return (
            '<div class="form-check">' +
            '<input type="checkbox" class="align-self-center checkSolicitacao" value"" checked>' +
            '</div>'
        );
    };

    function preencheComZero() {
        setTimeout(() => {
            $('.camposGrade').map((index) => {
                if ($($('.camposGrade')[index]).val() == '') {
                    $($('.camposGrade')[index]).val('0');
                }
            });
        }, 100);
    };

    function limpaCamposProduto() {
        $('#txtProduto').val('');
        $('#txtCor').val('');
        $('#txtTamanho').val('');
        $('#txtTotal').val('');
        $('#txtQtde').val('');
        $('#txtPreco').val('');
        $('#txtDesconto').val('');
    };

    async function BuscaPreco(item = {}) {
        let where = '';
        let retorno = '';
        let vPreco = 0;
        let desconto = TruncaDecimaisNova(2, $('#txtDesconto').val())

        if (!Object.keys(item).length > 0) {
            item.codigo = pegaChave('#txtProduto')
            item.cor = pegaChave('#txtCor')
            item.tamanho = pegaChave('#txtTamanho')
            item.tabPreco = pegaChave('#txtTabelaPreco')
        }

        const { codigo, cor, tamanho, tabPreco } = item

        try {
            const getPreco = (query) => retornaJsonPesquisaPadrao(JSON.stringify(query));

            // if ($('#txtTipoConsignado').val() === 'D') {
            //     where = `AND VEN.CODCLI = '${pegaChave('#txtCliente')}'
            //             AND VEN.EMP_ID = ${getCookie('g_emp_id')}
            //             AND VEN.SITUACAO = 'P'
            //             AND VEN.STATUS = ''
            //             AND ITENS.TIPO = 'S'
            //             AND ITENS.CODIGO = '${codigo}'
            //             AND ITENS.COR = '${cor}'
            //             AND ITENS.TAM = '${tamanho}'`;

            //     const pesquisa = {
            //         tabela: 'VEN_CONSIG',
            //         innerJoin: [{ tabela: 'VEN_CONSIG_ITENS', condicao: 'VEN.ID = ITENS.ID_VEN_CONSIG', alias: 'ITENS' }],
            //         camposSelect: ['PRECO', 'DESCONTO', 'QTDE'],
            //         orderBy: ['PRECO DESC'],
            //         where: [`1=1 ${where}`]
            //     };

            //     retorno = await getPreco(pesquisa);
            //     if (retorno.length > 0) {
            //         for (let item of retorno) {
            //             const { PRECO, DESCONTO, QTDE } = item;
            //             vPreco = DESCONTO > 0 ? PRECO - (PRECO * (DESCONTO / 100)) : PRECO;

            //             const itemEncontrado = await verificaItemTabela({
            //                 codigo,
            //                 cor,
            //                 tamanho,
            //                 preco: vPreco.toFixed(2),
            //                 qtde: QTDE
            //             });

            //             if (!itemEncontrado) return;
            //         }
            //     }
            // } else {
            if ($('#cbTabPreco').is(':checked')) {
                where = `
                        AND CODIGO = '${codigo}'
                        AND REGIAO = '${tabPreco}'
                    `;
                const pesquisa = {
                    tabela: 'TABPRECO',
                    camposSelect: ['PRECO_00 PRECO', '0 DESCONTO'],
                    where: [`1=1 ${where}`]
                };

                retorno = await getPreco(pesquisa);
                if (retorno.length > 0) {
                    const { PRECO } = retorno[0];
                    vPreco = desconto > 0 ? PRECO - (PRECO * (desconto / 100)) : PRECO;
                }
            } else {
                where = `
                        AND CODIGO = '${codigo}'
                        AND COR = '${cor}'
                        AND TAM = '${tamanho}'
                        AND REGIAO = '${tabPreco}'
                    `;
                const pesquisa = {
                    tabela: 'PRECO_COR_TAM',
                    camposSelect: ['PRECO', '0 DESCONTO'],
                    where: [`1=1 ${where}`]
                };

                retorno = await getPreco(pesquisa);
                if (retorno.length > 0) {
                    const { PRECO } = retorno[0];
                    vPreco = desconto > 0 ? PRECO - (PRECO * (desconto / 100)) : PRECO;
                }
            }
            // }


            $('#txtPreco').val(formataValor(vPreco))
            $('#txtTotal').val(formataValor(vPreco))
            return { preco: vPreco, desconto: desconto }
        } catch (e) {
            console.error('Erro na busca de preço:', e);
        }
    }

    async function confirmaItem() {
        try {
            if ($('#tabelaGradeProduto').DataTable().rows().count() == 0) {
                $('#modalItem').modal('hide');
                return;
            }

            if ($('#txtProdutoGrade').val() == '') {
                msgAlerta('Produto não informado, impossível continuar');
                return;
            }

            let grade = [];
            const listaDados = $('#tabelaGradeProduto').DataTable().data().toArray();

            for (let dado of listaDados) {
                const objeto = Object.entries(dado);
                let coluna;
                const colunas = objeto.map(prop => prop[0]);

                for (let i = 0; i < colunas.length; i++) {
                    if ((!['COR', 'DESC_COR'].includes(colunas[i])) && (colunas[i].indexOf('/') == -1)) {
                        coluna = RetornaIdTamFormatado(colunas[i], true);
                        const idSemFormatacao = dado[colunas[i]].split('id="')[1].replace('"', '');
                        const idFormatado = idSemFormatacao.split("value=")[0];
                        const { preco, desconto } = await BuscaPreco({
                            codigo: pegaChave('#txtProdutoGrade'),
                            cor: dado.COR,
                            tamanho: coluna,
                            tabPreco: pegaChave('#txtTabelaPreco')
                        });

                        const quantidade = $(`#${idFormatado}`).val() ? $(`#${idFormatado}`).val() : 0;
                        const retorno = {
                            codigo: pegaChave('#txtProdutoGrade'),
                            descricao: pegaDescricao('#txtProdutoGrade'),
                            tipo: $('#txtTipoConsignado').val(),
                            cor: dado.COR,
                            tamanho: coluna,
                            quantidade: TruncaDecimaisNova(2, quantidade),
                            tabelaPreco: pegaChave('#txtTabelaPreco'),
                            preco: TruncaDecimaisNova(2, preco),
                            desconto: desconto,
                            precoTotal: TruncaDecimaisNova(2, preco) * TruncaDecimaisNova(2, quantidade),
                            barra: '',
                            barra28: '',
                            tipoDesconto: $('#txtDesconto').val() > 0 ? $('#tpDesconto').val() : 0,
                        };
                        grade.push(retorno);
                    }
                }
            }

            grade.forEach(item => {
                if (parseFloat(item.quantidade) > 0) {
                    addItem(item);
                }
            });

            totalQuantidade();
            totalValorLiquido();
            totalValorItem();
            $('#modalItem').modal('hide');
            limpaCamposProduto();

        } catch (error) {
            console.error('Erro ao confirmar item:', error);
        }
    }

    function calcularPrecoTotal() {
        let preco = parseDouble($('#txtPreco').val());
        let desconto = TruncaDecimaisNova(2, $('#txtDesconto').val());
        let quantidade = parseDouble($('#txtQtde').val());

        if (preco && quantidade) {
            $('#txtTotal').val(preco * quantidade)
        }
        let precoTotal = TruncaDecimaisNova(2, $('#txtTotal').val());

        if (!precoTotal || !quantidade || precoTotal <= 0 || quantidade <= 0) {
            $('#txtTotal').val('');
            return;
        }

        if (desconto === undefined || desconto < 0) {
            desconto = 0;
        }
        let precoFinal = precoTotal;

        if (desconto > 0) {
            if ($('#tpDesconto').val() === 'P') {
                precoFinal = precoTotal * (1 - desconto / 100);
            } else if ($('#tpDesconto').val() === 'V') {
                precoFinal = precoTotal - desconto;
            }
        }
        if (precoFinal < 0) {
            $('#txtDesconto').val(0)
            $('#txtQtde').val(0)
            return msgAlerta('O preço final não pode ser igual a zero ou negativo. Por favor, verifique os valores inseridos!')
        }

        $('#txtTotal').val(formataValor(TruncaDecimaisNova(2, precoFinal)));
    }

    $('#txtDesconto, #txtQtde, #tpDesconto').on('change', calcularPrecoTotal);

    function editaProduto(item) {
        insereValor('#txtProduto', $(item[0]).find('button').first().html().trim(), item[1]);
        insereValor('#txtCor', item[3], { tabela: 'CADCOR', campoBusca: 'DESCRICAO', campoWhere: 'COR', valorWhere: item[3] })
        insereValor('#txtTamanho', item[4], item[4])
        insereValor('#txtQtde', item[5]);
        insereValor('#txtTabelaPreco', item[6], { tabela: 'REGIAO', campoBusca: 'DESCRICAO', campoWhere: 'REGIAO', valorWhere: item[6] })
        insereValor('#txtPreco', formataValor(item[7]));
        insereValor('#txtDesconto', item[8]);
        insereValor('#txtTotal', formataValor(item[9]));
        insereValor('#tpDesconto', item[10] === 0 ? 'P' : item[12]);
    };

    async function buscaConsignadoAberto() {
        try {
            const url = '/sisplan/consignado/v1/buscaconsignadoaberto?';

            const response = await requisicao('GET', url, `&CODCLI=${pegaChave('#txtCliente')}`, false, 30000);

            if (!response) {
                return false;
            }

            if (response.status != 200) {
                const jsonStr = await response.json();
                throw new Error(jsonStr.mensagem);
            }
            const jsonStr = await response.json();

            return jsonStr
        } catch (error) {
            throw new Error(error || 'Não conseguiu validar o estoque, por favor verifique!');
        }
    }

    async function ValidaEstoque(item = {}) {
        try {
            if ($('#radioNormal').prop('checked') == true || isChecked('#radioNotaEntra')) {
                return true;
            }

            const { codigo, cor, tam, deposito, quantidade } = item

            const params = `CODIGO=${codigo}` +
                `&COR=${cor}` +
                `&LOTE=${'000000'}` +
                `&TAM=${tam}` +
                `&DEPOSITO=${deposito}` +
                `&QUALIDADE=${'1'}` +
                `&TIPO=${'P'}` +
                `&QUANTIDADE=${quantidade}` +
                `&LANCAMENTO=-99`;
            const url = '/sisplan/estoque/v1/validaestoque?';

            const response = await requisicao('GET', url, params, false, 30000);

            if (!response) {
                return false;
            }

            if (response.status != 200) {
                const jsonStr = await response.json();
                throw new Error(jsonStr.mensagem);
            }
        } catch (error) {
            throw new Error(error || 'Não conseguiu validar o estoque, por favor verifique!');
        }
    }

    function adicionaIdExclusao(id_iten) {
        idItens.push({
            ID_ITEN: id_iten
        });
    };

    function retornaItens() {
        let arrItens = [];
        $('#tabelaItensConsignado').DataTable().rows().data().map(item => {
            arrItens.push({
                codigo: $(item[0]).find('button').first().html().trim(),
                tipo: item[2],
                cor: item[3],
                tamanho: item[4],
                quantidade: item[5],
                tabelaPreco: item[6],
                preco: item[7],
                desconto: item[8],
                precoTotal: item[9],
                barra: item[10],
                tipoDesconto: item[12]
            })
        });

        return arrItens;
    };

    function adicionaBotoes(data, row) {
        var retorno = '<div style="text-align:start;"> ' +
            '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
            '      ' + data + ' ' +
            '    </button> ' +
            '    <div class="dropdown-menu"> ' +
            '    <button class="dropdown-item btn-editar" type="button" title="Editar" id="btn-editar">Editar</button>     ' +
            '    <button class="dropdown-item btn-excluir" type="button" title="Excluir" id="btn-excluir">Excluir</button>     ' +
            '</div>';
        return retorno;
    };

    function addItem(sItem) {
        if (!$('#txtTipoConsignado').val()) {
            $('#txtTipoConsignado').val(sItem.tipo)
            $('#txtTipoConsignado').prop('disabled', true)
        }

        if (!$('#txtTabelaPreco').val()) {
            insereValor('#txtTabelaPreco', sItem.tabelaPreco, { tabela: 'REGIAO', campoBusca: 'DESCRICAO', campoWhere: 'REGIAO', valorWhere: sItem.tabelaPreco })
        }

        const tabelaItensConsignado = $('#tabelaItensConsignado').DataTable()
        const existeItemTabela = tabelaItensConsignado.rows().data().toArray().some((linha) =>
            $(linha[0]).find('button').first().html().trim() == sItem.codigo && linha[3] == sItem.cor && linha[4] == sItem.tam
        );

        if (existeItemTabela) {
            return msgAlertaSemConfirmacao('Item já foi adicionado no consignado. Por favor, verifique.')
        }

        tabelaItensConsignado.row.add(
            [
                adicionaBotoes(sItem.codigo),
                sItem.descricao,
                sItem.tipo,
                sItem.cor,
                sItem.tamanho,
                sItem.quantidade,
                sItem.tabelaPreco,
                sItem.preco,
                sItem.desconto,
                TruncaDecimaisNova(2, sItem.precoTotal),
                sItem.barra,
                sItem.barra28,
                sItem.tipoDesconto
            ]).draw(false);
    };

    $('#txtObservacao').on('keydown', function (e) {
        if (e.key === 'Enter') {
            e.preventDefault()
            var cursorPos = this.selectionStart;
            var value = $(this).val();
            $(this).val(value.substring(0, cursorPos) + "\n" + value.substring(cursorPos));
            this.selectionStart = this.selectionEnd = cursorPos + 1;
        }
    });

    $('#txtBarra').on('blur', async function () {
        const barra = $(this).val()
        if (barra && barra !== '') {
            await bipaBarra(barra.trim());
        }
    })

    $('#txtBarra').on('keydown', function (e) {
        if (e.key === 'Enter') {
            $('#txtBarra').trigger('blur')
        }
    })

    // async function verificaStatusValido(codigo) {
    //     try {
    //         const statusProd = (await buscaValor('PRODUTO', 'STATUS', 'CODIGO', codigo)).STATUS

    //         if (pegaChave('#txtStatus') != statusProd) {
    //             throw new Error('Produto não pertence ao Status do consignado, por favor verifique');
    //         }
    //     } catch (error) {
    //         throw new Error(error.message || 'Erro ao verificar status');
    //     }
    // }

    async function bipaBarra(barra) {
        $.LoadingOverlay('show')
        try {
            if (!$('#txtTipoConsignado').val()) {
                return msgAlerta('Tipo não informado. Por favor, verifique!')
            }
            if (barra == '') {
                return;
            }
            const tabPreco = pegaChave('#txtTabelaPreco')
            if (!tabPreco || tabPreco === '' || tabPreco === '999') {
                msgErro('Tabela de preço não informada, impossível continuar.')
                return
            }

            const bBarraLog = await CopiaParametro('SISTEMA', 0);
            let barraLog = false;
            let barra28 = '';
            if ((bBarraLog === '1') || (bBarraLog === '2')) {
                barra28 = await extraiBarra28(barra);
                if (barra28 && (barra28 != '')) {
                    barraLog = barra;
                    barra = barra28;
                }
            }

            if (!barraLog && (bBarraLog == '2')) {
                msgAlerta('Necessário bipar uma barra log.', undefined, undefined, () => { $('#txtBarra').val('').focus() });
                $('#txtBarra').val('').focus();
                return;
            }

            await bipaBarraProduto(barraLog || barra, tabPreco);
        } catch (error) {
            console.log(error)
            msgErro(error.message || 'Ocorreu um problema ao bipar a barra, tente novamente.')
        } finally {
            $(`#txtBarra`).val('');
            $(`#txtBarra`).focus();
            $.LoadingOverlay('hide')
        }
    }

    function bloqueiaCampos(situacao) {
        if (situacao != 0) {
            $('.campoData').prop('disabled', true)
        }
        $('.campoCliente').prop('disabled', true)
        // $('.campoVendedor').prop('disabled', true)
        $('.campoStatus').prop('disabled', true)
        $('.campoDias').prop('disabled', true)
        $('.campoDtAcerto').prop('disabled', true)
        $('.campoValorMinimo').prop('disabled', true)
        $('.campoObservacao').prop('disabled', true)
        
        $('.campoTabelaPreco').prop('disabled', true)
        $('.campoDeposito').prop('disabled', true)
        $('.campoProduto').prop('disabled', true)
        $('.campoCor').prop('disabled', true)
        $('.campoTamanho').prop('disabled', true)
        $('.campoQuantidade').prop('disabled', true)
        $('.campoPreco').prop('disabled', true)
        $('.campoDesconto').prop('disabled', true)
        $('.campoTipoDesconto').prop('disabled', true)
        $('.campoBarra').prop('disabled', true)

        if (situacao == 2) {
            manipulaBotoes(true)
            $('.campoTabelaPreco').prop('disabled', true)
            $('.campoProduto').prop('disabled', true)
            $('.campoCor').prop('disabled', true)
            $('.campoTamanho').prop('disabled', true)
            $('.campoQuantidade').prop('disabled', true)
            $('.campoDesconto').prop('disabled', true)
            $('.campoTipoDesconto').prop('disabled', true)
            $('#btnAdicionarProduto').prop('disabled', true)
            $('#btnGradeProduto').prop('disabled', true)
        }
    }

    async function bipaBarraProduto(barra, tabelaPreco) {
        try {
            const tipoBarra = await retornaTipoBarra(barra)

            const dadosBarra = await retornaProdutoBarra(barra, tipoBarra === 'barra_log')

            if (dadosBarra && dadosBarra.length > 0) {
                const item = dadosBarra[0];

                let precoTabPreco;
                precoTabPreco = await retornaPrecoCorTamProdutoAoBiparBarra(tabelaPreco, item.CODIGO, item.COR, item.TAM);

                if (!precoTabPreco || precoTabPreco === 0) {
                    return msgErro('Preço na tabela de preço informada está zerado, impossível continuar.')
                }

                const dados = $('#tabelaItensConsignado').DataTable().rows().data().toArray()
                const indiceProdutoEncontrado = dados.findIndex(e =>
                    $(e[0]).find('button').first().html().trim() === item.CODIGO &&
                    e[3] === item.COR &&
                    e[4] === item.TAM
                )

                const linha = $('#tabelaItensConsignado').DataTable().row(indiceProdutoEncontrado).data()
                if (linha && !parametroPermiteEstoqueNegativo) {
                    if (((linha[5] + 1) > item.QUANTIDADE) || item.QUANTIDADE === 0) {
                        return msgErro('A soma da quantidade na tabela com a quantidade bipada excede o estoque disponível. Por favor, verifique!')
                    }
                }

                // await ValidaEstoque({
                //     codigo: item.CODIGO,
                //     cor: item.COR,
                //     tam: item.TAM,
                //     deposito: pegaChave('#txtDeposito'),
                //     quantidade: linha[6] + 1
                // })

                if (tipoBarra !== 'barra_log') {
                    const parametroValidarEstoque = await CopiaParametro('PEDIDO', 3)
                    if (parametroValidarEstoque !== '0') {
                        const objProduto = {
                            CODIGO: item.CODIGO,
                            COR: item.COR,
                            TAM: item.TAM,
                            DEPOSITO: pegaChave('#txtDeposito'),
                            QTDE: indiceProdutoEncontrado !== -1 ? dados[indiceProdutoEncontrado][7] : 0
                        }
                        let response = await requisicao("POST", `/Sisplan/pedido/V1/validaestoquebarra?&CODUSUARIO=${getCookie('cod_usuario')}`, `&EMPRESA=${getCookie('empresa')}&PARAMETRO_ESTOQUE=${parametroValidarEstoque}`, JSON.stringify(objProduto));

                        if (!response) {
                            return;
                        }

                        let msgResposta = await response.json();
                        if (response.status != 200) {
                            msgErro(msgResposta.mensagem);
                            return;
                        }
                    }
                } else {
                    if (listaBarrasLog.find(e => e.BARRA === barra)) {
                        msgErro('Barra já foi bipada, favor verificar.')
                        return;
                    }

                    if (!await validaBarraLogLiberada(barra.replaceAll('#', '[HASHTAG]'))) {
                        msgErro('Barra já foi lida, favor verificar.')
                        return;
                    }


                    listaBarrasLog.push({
                        BARRA: barra,
                        CODIGO: item.CODIGO,
                        COR: item.COR,
                        TAM: item.TAM
                    })
                }

                if (indiceProdutoEncontrado !== -1) {
                    const dadosIndice = $('#tabelaItensConsignado').DataTable().row(indiceProdutoEncontrado).data()
                    dadosIndice[5] = parseFloat(dadosIndice[5]) + 1 //qtde
                    let grade = [{
                        codigo: $(dadosIndice[0]).find('button').first().html().trim(),
                        descricao: dadosIndice[1],
                        tipo: dadosIndice[2],
                        cor: dadosIndice[3],
                        tamanho: dadosIndice[4],
                        quantidade: dadosIndice[5],
                        tabelaPreco: dadosIndice[6],
                        preco: parseFloat(dadosIndice[7]),
                        desconto: dadosIndice[8],
                        precoTotal: parseFloat(dadosIndice[7]) * dadosIndice[5],
                        barra: dadosIndice[10] === '' ? barra : dadosIndice[10],
                        barra28: dadosIndice[11],
                        tipoDesconto: dadosIndice[12],
                    }]

                    const table = $('#tabelaItensConsignado').DataTable();

                    table.row(indiceProdutoEncontrado).data([
                        adicionaBotoes(grade[0].codigo),
                        grade[0].descricao,
                        grade[0].tipo,
                        grade[0].cor,
                        grade[0].tamanho,
                        grade[0].quantidade,
                        grade[0].tabelaPreco,
                        grade[0].preco,
                        grade[0].desconto,
                        TruncaDecimaisNova(2, grade[0].precoTotal),
                        grade[0].barra,
                        grade[0].barra28,
                        grade[0].tipoDesconto,
                    ]).draw(false).node();

                } else {
                    let grade = [{
                        codigo: item.CODIGO,
                        descricao: item.DESCRICAO,
                        tipo: $('#txtTipoConsignado').val(),
                        cor: item.COR,
                        tamanho: item.TAM,
                        deposito: pegaChave('#txtDeposito'),
                        quantidade: 1,
                        tabelaPreco: tabelaPreco,
                        preco: precoTabPreco,
                        desconto: 0,
                        precoTotal: precoTabPreco,
                        barra: barra,
                        barra28: '',
                        tipoDesconto: $('#txtDesconto').val() > 0 ? $('#tpDesconto').val() : 0
                    }]

                    addItem(grade[0])
                }

                const table = $('#tabelaItensConsignado').DataTable()
                const rowNode = table.row(indiceProdutoEncontrado == -1 ? $('#tabelaItensConsignado').DataTable().data().length - 1 : indiceProdutoEncontrado).node()
                $("#tabelaItensConsignado tbody tr.selected").removeClass("selected");
                $(rowNode).addClass("selected");
                $(rowNode).get(0).scrollIntoView({ behavior: 'smooth', block: 'center' })
                $('#tabelaItensConsignado').addClass('selected')

                totalQuantidade()
                totalValorLiquido()
                totalValorItem()
            } else {
                throw new Error('Barra não encontrada, favor verificar.')
            }
        } catch (error) {
            msgErro(error.message || 'Não foi possível bipar a barra, verifique!')
        } finally {
            $(`#txtBarra`).val('');
            $(`#txtBarra`).focus();
        }
    }

    function manipulaBotoes(acao) {
        $('#txtBarra').prop('disabled', acao)
        $('#btnGradeProduto').prop('disabled', acao)
        $('#tabelaItensConsignado').prop('disabled', acao)
        $('.btn-editar').prop('disabled', acao)
        $('.btn-excluir').prop('disabled', acao)
        $('.btn-excluir').prop('disabled', acao)
        $('.btn-excluir').prop('disabled', acao)
        $('.divBtnOpcoes').css('background-color', acao ? 'black' : 'var(--background-btnOpcoes)')
    }

    async function retornaPrecoCorTamProdutoAoBiparBarra(sTabPreco, sCodProd, sCor, sTam) {
        const dadosSelect = {
            tabela: 'PRECO_COR_TAM',
            camposSelect: ['PRECO'],
            where: [`REGIAO = '${sTabPreco}' AND CODIGO = '${sCodProd}' AND COR = '${sCor}' AND TAM = '${sTam}'`]
        };
        const retornoSelect = await retornaJsonPesquisaPadrao(JSON.stringify(dadosSelect));
        if (!retornoSelect) {
            return;
        }
        if (retornoSelect.length == 0) {
            return;
        }

        return retornoSelect[0].PRECO;
    };

    async function retornaPrecoProduto(sTabPreco, sCodProd) {
        const dadosSelect = {
            tabela: 'TABPRECO',
            camposSelect: ['PRECO_00'],
            where: [`REGIAO = '${sTabPreco}' AND CODIGO = '${sCodProd}'`]
        };
        const retornoSelect = await retornaJsonPesquisaPadrao(JSON.stringify(dadosSelect));
        if (!retornoSelect) {
            return;
        }
        if (retornoSelect.length == 0) {
            return;
        }
        return retornoSelect[0].PRECO_00;
    };

    async function retornaProdutoBarra(sBarra, bBarraLog) {
        let barra28 = sBarra.substr(0, 6);
        if (bBarraLog) {
            barra28 = await extraiBarra28(sBarra);
        }
        const deposito = pegaChave('#txtDeposito');

        if (deposito == '') {
            throw new Error('Depósito não informado, impossível continuar!');
        }

        let url = `/sisplan/funcoes/v1/pesquisa?`;
        let params = encodeURIComponent(`JSON={"tabela":"PA_ITEN", "camposSelect":["PA_ITEN.CODIGO", "PRODUTO.DESCRICAO", "PA_ITEN.COR", "CADCOR.DESCRICAO DESC_COR", "PA_ITEN.TAM", "PA_ITEN.QUANTIDADE"],
    "innerjoin": [
        { "tabela" : "PRODUTO", "condicao" : "PA_ITEN.CODIGO = PRODUTO.CODIGO" },
        { "tabela": "CADCOR", "condicao": "PA_ITEN.COR = CADCOR.COR"}
    ],
    "where": ["PA_ITEN.DEPOSITO = '${deposito}' AND (PA_ITEN.BARRA = '${sBarra}' OR PA_ITEN.BARRA28 = '${sBarra}' OR PA_ITEN.BARRA28 = '${barra28}' OR PA_ITEN.BARRACLI = '${sBarra}')"]}`);

        try {
            let response = await requisicao('GET', url, params, null);
            if (!response) {
                return '';
            }
            let jsonStr = await response.json();
            if (response.status != 200) {
                msgErro(jsonStr.RESULT[0].mensagem);
                SomAlerta(BASE_URI, true);
                return '';
            }

            return jsonStr.RESULT[0];

        } catch (error) {
            throw new Error(error.message || 'Não foi possível buscar os dados da barra.');
        }
    }

    $("#msform").validate({
        debug: false,
        ignore: "",
        rules: {
            txtCliente: {
                required: true,
            },
            txtVendedor: {
                required: true,
            },
            txtStatus: {
                required: true,
            },
        },
        messages: {
            txtCliente: {
                required: "Informe um cliente",
            },
            txtVendedor: {
                required: "Informe um vendedor.",
            },
            txtStatus: {
                required: "Informe um status.",
            },
        },
        errorElement: "span",
        errorPlacement(error, element) {
            error.addClass("invalid-feedback");
            element.closest(".form-group").append(error);
        },
        highlight(element) {
            $(element).addClass("is-invalid");
        },
        unhighlight(element) {
            $(element).removeClass("is-invalid");
        },
        invalidHandler(e, validator) {
            if (validator.errorList.length) {
                console.log(`erro no: ${$(`#${$(validator.errorList[0].element).prop('id')}`)}`);
            }
        },

        async submitHandler(form, event) {
            event.preventDefault();
            try {
                if ($('#tabelaItensConsignado').DataTable().rows().data().length === 0) {
                    return msgAlerta('Nenhum item adicionado ao consignado. Por favor, verifique!')
                }
                $.LoadingOverlay("show");
                try {
                    const consignado = {
                        numeroDocumento: $('#txtDocumento').val(),
                        data: pegaValor('#dtIni'),
                        codcli: pegaChave('#txtCliente'),
                        codrep: pegaChave('#txtVendedor'),
                        status: pegaChave('#txtStatus'),
                        dias: pegaValor('#txtDias'),
                        dataAcerto: pegaValor('#dtAcerto'),
                        valorMinimo: pegaValor('#txtValorMinimo'),
                        deposito: pegaChave('#txtDeposito'),
                        observacao: pegaValor('#txtObservacao'),
                        itens: retornaItens(),
                    };

                    let response = await requisicao("POST", `/sisplan/consignado/v1/gravar?`, '', JSON.stringify(consignado));

                    if (response.status != 200) {
                        const jsonStr = await response.json()
                        throw new Error(jsonStr.mensagem)
                    }

                    const jsonStr = await response.json()

                    toastr
                        .success("Cadastro efetuado com sucesso!", "Confirmação", {
                            toastClass: "alert",
                            iconClasses: {
                                error: "alert-error",
                                info: "alert-info",
                                success: "alert-success",
                                warning: "alert-warning",
                            },
                            positionClass: "toast-top-center",
                            progressBar: true,
                            timeOut: 3000,
                            fadeOut: 1000,
                            onHidden() {
                                imprimirItem({ id: jsonStr }
                                ).then((response) => {
                                    window.location.href = `${BASE_URI}/consignado`
                                })
                            },
                        })
                        .css({
                            "margin-top": "20%",
                            width: "500px",
                            "max-width": "500px",
                        });
                } catch (error) {
                    console.error(error);
                    msgAlerta(error.message || 'Não foi possível gravar os dados do consignado!');
                }

            } finally {
                $.LoadingOverlay("hide");
            }
        },
    });

    const imprimirItem = async ({ id }) => {
        $.LoadingOverlay('show');
        try {
            const url = `/sisplan/impressao/v1/consignado_individual?`;
            const ordem = `&TELA_ORDENACAO=RelConsignadoIndividual&ORDEM_ORDENACAO=0`;
            const bImprimeAutomatico = await verificaImprimirAutomatico('RelConsignadoIndividual');
            let arquivo = await GeraRelatorio(`${url}${ordem}&ID=${id}`, 'GET', 1000000, false, 'RelConsignadoIndividual');
            if (arquivo != undefined) {
                if (!bImprimeAutomatico) {
                    window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
                }
                await limparRelatorios();
            }

        } catch (error) {
            console.error(error);
            msgErro('Ocorreu um erro ao realizar a impressão.')
        } finally {
            $.LoadingOverlay('hide');
        }
    }

    function adicionaPaginacao() {
        $(".next").click(async function () {
            let validator = $("#msform").validate();
            let liberado = true;

            if ($(this).attr("id") == "avancar1") {
                validator.element("#txtCliente");
                validator.element("#txtVendedor");
                validator.element("#txtStatus");
            }

            if (!(validator.element("#txtCliente") && validator.element("#txtVendedor") && validator.element("#txtStatus"))) {
                liberado = false;
            }

            if (liberado) {
                $('#spanStatus').html($('#txtStatus').val())

                currentFs = $(this).closest("fieldset");
                nextFs = currentFs.next("fieldset");

                var nextIndex = $("fieldset").index(nextFs);
                $("#progressbar li").eq(nextIndex).addClass("active");

                nextFs.show();
                currentFs.animate({
                    opacity: 0,
                }, {
                    step(now) {
                        opacity = 1 - now;
                        currentFs.css({
                            display: "none",
                            position: "relative",
                        });
                        nextFs.css({
                            opacity,
                        });
                    },
                    duration: 600,
                });

                $("#tabelaItensConsignado").DataTable().columns.adjust().draw(false);
            }
        });

        $(".previous").click(async function () {
            currentFs = $(this).closest("fieldset");
            previousFs = currentFs.prev("fieldset");

            var currentIndex = $("fieldset").index(currentFs);
            $("#progressbar li").eq(currentIndex).removeClass("active");

            previousFs.show();

            currentFs.animate({
                opacity: 0,
            }, {
                step(now) {
                    opacity = 1 - now;
                    currentFs.css({
                        display: "none",
                        position: "relative",
                    });
                    previousFs.css({
                        opacity,
                    });
                },
                duration: 600,
            });
        });
    };

    $('#txtDias').on('blur', function () {
        if ($(this).val() == '') {
            $(this).val(0)
        }

        const dias = parseInt($(this).val());
        const dataAtual = new Date();

        dataAtual.setDate(dataAtual.getDate() + dias);

        const dia = ("0" + dataAtual.getDate()).slice(-2);
        const mes = ("0" + (dataAtual.getMonth() + 1)).slice(-2);
        const ano = dataAtual.getFullYear();
        const dataFormatada = `${ano}-${mes}-${dia}`;

        $('#dtAcerto').val(dataFormatada);
    });

    $('#txtDias').on('focus', function () {
        if ($(this).val() == 0) {
            $(this).val('')
        }
    })

    $('#txtTamanho').on('input', function () {
        $(this).val($(this).val().toUpperCase());
    });

    $('#txtTipoConsignado').on('blur', function () {
        if ($(this).val() === 'S' || $(this).val() === 'D') {
            $(this).prop('disabled', true)
        }
    })

    adicionaPaginacao();
    adicionaMascaraCampos();
    adicionaValidacoes();

    const depositosEmpresaLogada = await verificaDepositosEmpresaLogada(getCookie('empresa'));
    const json = await retornaJsonPesquisaPadrao(`{"tabela":"DEPOSITO", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": ["EMPRESA <> ''"] }`);
    const depositoUsuario = await retornaDepositoUsuario(getCookie('cod_usuario'));

    if (depositoUsuario != 'null') {
        $('#txtDeposito').autocompleta(1, `JSON={ "tabela":"DEPOSITO", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": ${depositoUsuario}}`, [], [], []);
        $('#btnDeposito').pesquisa_array(['#txtDeposito'], ['CODIGO'], ['DESCRICAO'], `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"DEPOSITO", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": ${depositoUsuario}}`, 'Pesquisa Depósito', 'DEPOSITO');
        rotinaSaidaDeposito()
        $('#txtDeposito').trigger('blur')
    } else if (depositosEmpresaLogada != '') {
        $('#txtDeposito').autocompleta(1, `JSON={ "tabela":"DEPOSITO", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": ["CODIGO IN (${depositosEmpresaLogada})"] }`, [], [], []);
        $('#btnDeposito').pesquisa_array(['#txtDeposito'], ['CODIGO'], ['DESCRICAO'], `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"DEPOSITO", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": ["CODIGO IN (${depositosEmpresaLogada})"]}`, 'Pesquisa Depósito', 'DEPOSITO');
        rotinaSaidaDeposito()
        $('#txtDeposito').trigger('blur')
    } else if (json.length == 0) {
        $('#txtDeposito').autocompleta(1, `JSON={ "tabela":"DEPOSITO", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": [] }`, [], [], []);
        $('#btnDeposito').pesquisa_array(['#txtDeposito'], ['CODIGO'], ['DESCRICAO'], `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"DEPOSITO", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": []}`, 'Pesquisa Depósito', 'DEPOSITO');
        rotinaSaidaDeposito()
        $('#txtDeposito').trigger('blur')
    } else {
        $('#txtDeposito').autocompleta(1, `JSON={ "tabela":"DEPOSITO", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": ["EMPRESA = '${getCookie('empresa').replace('_', '')}'"] }`, [], [], []);
        $('#btnDeposito').pesquisa_array(['#txtDeposito'], ['CODIGO'], ['DESCRICAO'], `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"DEPOSITO", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": ["EMPRESA = '${getCookie('empresa').replace('_', '')}'"]}`, 'Pesquisa Depósito', 'DEPOSITO');
        rotinaSaidaDeposito()
        $('#txtDeposito').trigger('blur')
    }

    componenteFiltro('cliente', false, false)
    componenteFiltro('representante', false, false, 'Vendedor')
    componenteFiltro('status', false, false, '', ["ORCAMENTO = 'S'"])
    // componenteFiltro('depositoUsuario', false, false, 'Deposito', [], false, rotinaSaidaDeposito)
    componenteFiltro('tabPreco', false, false, 'TabelaPreco')

    $('#txtProduto').autocompleta(1, `JSON={ "tabela":"PRODUTO", "camposSelect":["CODIGO CHAVE, DESCRICAO DESCRICAO"], "where": ["1=1 "]}`, [], [], [], rotinaSaidaProduto);//${!parametroPermiteEstoqueNegativo ? ` AND PA_ITEN.QUANTIDADE > 0` : ``}
    $("#btnProduto").pesquisa_serverside(["#txtProduto"], ["CODIGO"], ["DESCRICAO"], `{"tabela":"PRODUTO", "camposSelect":[ "CODIGO", "CODIGO2", "DESCRICAO" ], "where": ["1=1 "]}`, "Pesquisa Produto", rotinaSaidaProduto); //${!parametroPermiteEstoqueNegativo ? ` AND PA_ITEN.QUANTIDADE > 0` : ``}
    $('#btnLimpaProduto').on('click', function () { $('#txtProduto, #txtValor, #txtQuantidadeEstoque').val('') });
    componenteFiltro('cor', false, false)
    componenteFiltro('tamanho2', false, false, 'Tamanho')

    $('#txtProdutoGrade').autocompleta(1, `JSON={ "tabela":"PRODUTO", "camposSelect":["CODIGO CHAVE, DESCRICAO DESCRICAO"], "where": null}`);
    $("#btnProdutoGrade").pesquisa_serverside(["#txtProdutoGrade"], ["CODIGO"], ["DESCRICAO"], `{"tabela":"PRODUTO", "camposSelect":[ "CODIGO", "CODIGO2", "DESCRICAO" ]}`, "Pesquisa Produto");
    $('#btnLimpaProdutoGrade').on('click', function () { $('#txtProdutoGrade, #txtValorGrade, #txtQuantidadeEstoqueGrade').val('') });

    rotinaSaidaProduto()
    rotinaSaidaCor()
    rotinaSaidaDeposito()


    $('#btnLimpaDeposito').on('click', function () {
        $('#txtDeposito').val('')
    })

    function rotinaSaidaProduto() {
        const quantidade = ``
        // const quantidade = !parametroPermiteEstoqueNegativo ? ` AND QUANTIDADE > 0` : ``
        $("#txtProduto").on("blur", async function () {
            $("#txtCor").autocompleta(
                1,
                `JSON={"tabela": "CADCOR", "camposSelect": ["COR CHAVE", "DESCRICAO DESCRICAO"], "where": ["COR IN (SELECT DISTINCT COR FROM [PA_ITEN] WHERE CODIGO='${pegaChave(
                    "#txtProduto"
                )}' AND DEPOSITO='${pegaChave(
                    "#txtDeposito"
                )}' ${quantidade})"], "orderBy": ["COR ASC"]}`,
                [],
                [],
                [],
                BuscaPreco
            );

            $("#btnCor").pesquisa_array(
                ["#txtCor"],
                ["CHAVE"],
                ["DESCRICAO"],
                `/sisplan/funcoes/v1/pesquisa?JSON={"tabela": "CADCOR", "camposSelect": ["COR CHAVE", "DESCRICAO DESCRICAO"], "where": ["COR IN (SELECT DISTINCT COR FROM [PA_ITEN] WHERE CODIGO='${pegaChave(
                    "#txtProduto"
                )}' AND DEPOSITO='${pegaChave(
                    "#txtDeposito"
                )}' ${quantidade})"], "orderBy": ["COR ASC"]}`,
                "Pesquisa Cor",
                "cadcor",
                BuscaPreco
            )

            $('#btnLimpaCor').on('click', function () {
                $('#txtCor').val('')
            })

            rotinaSaidaCor()
        });
    }

    function rotinaSaidaCor() {
        const quantidade = ``
        // const quantidade = !parametroPermiteEstoqueNegativo ? ` AND QUANTIDADE > 0` : ``
        $("#txtCor").on("blur", async function () {
            $("#txtTamanho").autocompleta(
                1,
                `JSON={"tabela": "TABTAM", "camposSelect": ["TAM CHAVE", "FAIXA DESCRICAO"], "where": ["TAM IN (SELECT DISTINCT TAM FROM [PA_ITEN] WHERE CODIGO='${pegaChave(
                    "#txtProduto"
                )}' AND DEPOSITO='${pegaChave(
                    "#txtDeposito"
                )}' AND COR='${pegaChave(
                    "#txtCor"
                )}' ${quantidade})"], "orderBy": ["TAM ASC"]}`,
                [],
                [],
                [],
                BuscaPreco
            );

            $("#btnTamanho").pesquisa_array(
                ["#txtTamanho"],
                ["CHAVE"],
                ["DESCRICAO"],
                `/sisplan/funcoes/v1/pesquisa?JSON={"tabela": "TABTAM", "camposSelect": ["TAM CHAVE", "FAIXA DESCRICAO"], "where": ["TAM IN (SELECT DISTINCT TAM FROM [PA_ITEN] WHERE CODIGO='${pegaChave(
                    "#txtProduto"
                )}' AND DEPOSITO='${pegaChave(
                    "#txtDeposito"
                )}' AND COR='${pegaChave(
                    "#txtCor"
                )}' ${quantidade})"], "orderBy": ["TAM ASC"]}`,
                "Pesquisa Tamanho",
                "TABTAM",
                BuscaPreco
            )

            $('#btnLimpaCor').on('click', function () {
                $('#txtCor').val('')
            })
        });
    }

    function rotinaSaidaDeposito() {
        $("#txtDeposito").on("blur", async function () {
            const sDeposito = pegaChave("#txtDeposito");
            const quantidade = !parametroPermiteEstoqueNegativo ? ` AND PA_ITEN.QUANTIDADE > 0` : ``

            $("#txtProduto").autocompleta(
                1,
                `JSON={"tabela": "PRODUTO", "camposSelect": ["PRODUTO.CODIGO CHAVE", "PRODUTO.DESCRICAO", "PRODUTO.CUSTO"], "leftJoin": [{"tabela":"PA_ITEN", "condicao": "PA_ITEN.CODIGO = PRODUTO.CODIGO"}], "where": ["PA_ITEN.DEPOSITO = '${sDeposito}' ${quantidade}"], "groupBy": ["PRODUTO.CODIGO", "PRODUTO.DESCRICAO", "PRODUTO.CUSTO"]}`,
                ['#txtTotal'],
                ['CUSTO'],
                ['CUSTO'],
                BuscaPreco
            );

            $('#btnProduto').pesquisa_serverside(
                ['#txtProduto', '#txtTotal'],
                ['PRODUTO.CODIGO', 'PRODUTO.CUSTO', 'PRODUTO.CODIGO2'],
                ['PRODUTO.DESCRICAO', 'PRODUTO.CUSTO', 'PRODUTO.CODIGO2'],
                `{"tabela": "PRODUTO", "camposSelect": ["PRODUTO.CODIGO", "PRODUTO.DESCRICAO", "PRODUTO.CODIGO2", "PRODUTO.CUSTO"], "leftJoin": [{"tabela":"PA_ITEN", "condicao": "PA_ITEN.CODIGO = PRODUTO.CODIGO"}], "where": ["PA_ITEN.DEPOSITO = '${sDeposito}' ${quantidade}"], "camposWhereServerSide":["PRODUTO.CODIGO", "PRODUTO.DESCRICAO", "PRODUTO.CODIGO2", "PRODUTO.CUSTO"], "groupBy": ["PRODUTO.CODIGO", "PRODUTO.CODIGO2", "PRODUTO.DESCRICAO", "PRODUTO.CUSTO"]}`,
                'Pesquisa de Produto',
                BuscaPreco,
                [false, true]
            );

            $('#btnLimpaProduto').on('click', function () {
                $('#txtProduto').val('')
            })

            rotinaSaidaProduto()
        })
    }

    function adicionaValidacoes() {
        $("#msform").validate({
            debug: false,
            ignore: "",
            rules: {
                txtCliente: {
                    required: true,
                },
                txtVendedor: {
                    required: true,
                },
                txtDeposito: {
                    required: true,
                },
                txtStatus: {
                    required: true,
                },
            },
            messages: {
                txtCliente: {
                    required: "Informe um cliente.",
                },
                txtVendedor: {
                    required: "Informe um vendedor.",
                },
                txtDeposito: {
                    required: "Informa um depósito.",
                },
                txtStatus: {
                    required: "Informe um status",
                },
            },
            errorElement: "span",
            errorPlacement(error, element) {
                error.addClass("invalid-feedback");
                element.closest(".form-group").append(error);
            },
            highlight(element) {
                $(element).addClass("is-invalid");
            },
            unhighlight(element) {
                $(element).removeClass("is-invalid");
            },
        });
    };

    $('#txtSolicitacao').on('keydown', (event) => {
        const keyName = event.key;

        if (keyName === 'F8') {
            event.preventDefault();
            $('#modal-Solicitacao').modal('show');
        };
    });

    await validaEdicao();

    async function buscaConsignado(id) {
        $.LoadingOverlay('show')
        try {

            const response = await requisicao('GET', '/sisplan/consignado/v1/buscaconsignado?', `&ID=${id}`, ``, 90000);

            if (!response) {
                $.LoadingOverlay('hide');
                return;
            }

            const jsonStr = await response.json();
            if (response.status != 200) {
                $.LoadingOverlay('hide');
                msgAlerta(jsonStr.mensagem);
                return;
            }

            return jsonStr

        } catch (error) {
            console.log(error)
        } finally {
            $.LoadingOverlay('hide')
        }
    }

    $('#btnAdicionar').on('click', function () {
        $('#modalItem').modal('show');
    });

    if (depositoParam) {
        $('#txtDeposito').val(depositoParam);
    }

    async function validaEdicao() {
        const sId = $(window.location.href.split('/')).get(-1);

        if (sId == 'create') {
            // $('#txtDocumento').val(parseInt(await RetornaProximo('VEN_CONSIG', 'VEN_CONSIG', 'ID', 0)))
            return;
        };

        $.LoadingOverlay('show');
        try {
            const dados = await buscaConsignado(sId);

            insereValor('#txtDocumento', dados.numeroDocumento);
            insereValor('#txtCliente', dados.codcli, { tabela: 'ENTIDADE', campoBusca: 'NOME', campoWhere: 'CODCLI', valorWhere: dados.codcli });
            insereValor('#txtVendedor', dados.codrep, { tabela: 'REPRESEN', campoBusca: 'NOME', campoWhere: 'CODREP', valorWhere: dados.codrep });
            insereValor('#txtDeposito', dados.deposito, { tabela: 'DEPOSITO', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: dados.deposito });
            insereValor('#txtStatus', dados.status, { tabela: 'SITPROD', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: dados.status });
            insereValor('#dtIni', dados.data.slice(0, 10));
            insereValor('#txtHora', dados.data.slice(11, 19));
            insereValor('#txtDias', dados.dias);
            insereValor('#dtAcerto', dados.dataAcerto.split('T')[0]);
            insereValor('#txtValorMinimo', dados.valorMinimo);
            insereValor('#txtObservacao', dados.observacao);
            insereValor('#txtTipoConsignado', dados.tipo);

            dados.itens.map(item => { addItem(item) });

            totalQuantidade()
            totalValorLiquido()
            totalValorItem()
            $("#tabelaItensConsignado").DataTable().columns.adjust().draw(false);

            bloqueiaCampos(dados.situacao)

            $('.campoDeposito').prop('disabled', dados.deposito)
        } finally {
            setTimeout(async () => {
                await saiCampoDeposito()
            }, 100)
            $.LoadingOverlay('hide');
        }
    };

    async function saiCampoDeposito() {
        $('#txtDeposito').trigger('blur')
    }

    async function verificaCliente(codcli) {
        if (codcli == '') {
            return;
        }

        try {
            let response = await requisicao('GET', '/sisplan/funcoes/v1/pesquisa?',
                `JSON={ "tabela":"ENTIDADE", "camposSelect":["ativo", "bloqueio"],"where": ["codcli = '${codcli}'"]}`,
                null);

            if (!response) {
                return;
            }

            let jsonEntidade = await response.json();
            if (response.status != 200) {
                jsonEntidade['RESULT'][0].mensagem;
                return;
            }
            if (jsonEntidade['RESULT'][0][0].BLOQUEIO == 'S') {
                msgAlerta('Cliente bloqueado, deseja desbloquear?', () => {
                    senhaSupervisor('Desbloquear cliente',
                        async () => {
                            await alterarBloqueioCliente(codcli, false, "VENDA");
                            $('#txtCliente').focus();
                        },
                        '',
                        false,
                        () => { $('#txtCliente').val('') },
                        () => { $('#txtCliente').val('') },
                        () => { $('#txtCliente').val('') },
                        false,
                        'CONSIGNADO',
                    )
                },
                    () => { $('#txtCliente').val('') },
                    undefined,
                    () => { $('#txtCliente').val('') }
                );
                return false;
            } else if (jsonEntidade['RESULT'][0][0].ATIVO == 'N') {
                msgAlerta('Cliente inativo, impossível continuar.');
                $('#txtCliente').val('');
            }
            return true;
        } catch (error) {
            console.error(error);
        }
    };

    $('#txtCliente').on('focusout', async function () {
        if (!$(this).val()) {
            return
        }

        if (!await verificaCliente(pegaChave($(this).val()))) {
            return;
        };

        const data = await buscaConsignadoAberto()

        if (!data.itens) {
            return
        }

        $("#tabelaConsignadosAberto").DataTable({
            destroy: true,
            filter: false,
            lengthChange: false,
            search: false,
            paginate: false,
            info: false,
            ordering: false,
            language: {
                sEmptyTable: "Nenhum registro encontrado",
                sInfo: "_TOTAL_ registros",
                sInfoEmpty: " 0 registros",
                sInfoFiltered: "(Filtrados de _MAX_ registros)",
                sInfoPostFix: "",
                sInfoThousands: ".",
                sLengthMenu: "_MENU_ resultados",
                sLoadingRecords: "Carregando...",
                sProcessing: "Processando...",
                sZeroRecords: "Nenhum registro encontrado",
                sSearch: "Pesquisar",
                oPaginate: {
                    sNext: "Próximo",
                    sPrevious: "Anterior",
                    sFirst: "Primeiro",
                    sLast: "Último",
                },
                oAria: {
                    sSortAscending: ": Ordenar colunas de forma ascendente",
                    sSortDescending: ": Ordenar colunas de forma descendente",
                },
            },
            autoWidth: true,
            columns: columnsConsignadoAberto,
            data: data.itens ? data.itens : [],
            columnDefs: [{
                type: 'date-br',
                targets: [6],
                render: function (data) {
                    if (data != undefined && data != '') {
                        x = data.slice(0, 10).split('-');
                        hora = data.split(' ')[1]
                        if (x[2]) {
                            return `${x[2]}/${x[1]}/${x[0]}`
                        } else {
                            return `${x} ${hora} `;
                        }
                    } else {
                        return ''
                    }
                }
            },
            ],
        });

        $('#modalConsignadoAberto').modal('show')
    })

    $('#modalItem').on('hidden.bs.modal', function (_) {
        $('#txtProdutoGrade').val('');
        if ($.fn.DataTable.isDataTable('#tabelaGradeProduto')) {
            $('#tabelaGradeProduto').DataTable().destroy();
            $('#tabelaGradeProduto').empty();
        };
    });

    $('#txtProdutoGrade').on('blur', async function () {
        const codigo = pegaChave('#txtProdutoGrade');

        if (codigo == '') {
            return;
        };
        if ((await buscaValor('PRODUTO', 'ATIVO', 'CODIGO', codigo)).ATIVO == 'N') {
            msgAlerta('Produto inativo, impossível continuar.');
            limpaValor('#txtProduto');
            return;
        };

        await explodeGradeProduto(codigo);
    });

    async function explodeGradeProduto(codigo) {
        $.LoadingOverlay('show');
        try {
            let tam;
            if ($.fn.DataTable.isDataTable('#tabelaGradeProduto')) {
                $('#tabelaGradeProduto').DataTable().destroy();
                $('#tabelaGradeProduto').empty();
            };

            const response = await requisicao('GET', '/sisplan/funcoes/v1/gradeproduto?', `CODIGO=${codigo}`, null);
            let jsonStr = await response.json();
            if (response.status != 200) {
                msgAlerta(jsonStr.RESULT[0].mensagem);
            }

            jsonStr = jsonStr.filter(item => item.COR !== '');

            for (let i = 0; i < parseInt(jsonStr.length); i++) {
                const colunas = Object.keys(jsonStr[i]);
                const tamanhos = [];
                colunas.forEach((coluna) => {
                    if (!['CODIGO', 'COR', 'DESC_COR', 'POSICAO'].includes(coluna)) {
                        tamanhos.push(coluna);
                    }
                });

                tamanhos.sort();

                const jsonObject = jsonStr.map(obj => {
                    const newObject = { ...obj };
                    delete newObject.CODIGO;
                    delete newObject.POSICAO;
                    if (obj.COR) {
                        Object.keys(obj).forEach(key => {
                            tam = RetornaIdTamFormatado(key);
                            if (!['CODIGO', 'COR', 'POSICAO', 'DESC_COR'].includes(tam)) {
                                newObject[tam] = `<input type="text" class="input-default focus form-control camposGrade" id="${newObject.COR + tam}" value="${jsonStr[i][tam]}">`;
                                newObject[tam.split('HIFEN')[1]] = `<input type="text" class="input-default focus form-control camposGrade" id="${newObject.COR + tam}" value="0">`;
                                delete newObject[tam];
                            }
                        });
                    }
                    return { ...newObject };
                });

                if (i == 0) {
                    const titulosFixos = ['COR', 'DESC_COR'];
                    const titulosGeral = [...titulosFixos, ...tamanhos];
                    const titulos = titulosGeral.map(titulo => {
                        const coluna = ['COR', 'DESC_COR'].includes(titulo) ? titulo : titulo.split('HIFEN')[1];
                        const objeto = { title: coluna, data: RetornaIdTamFormatado(coluna) };
                        return objeto;
                    });
                    criaDataTablePadrao('#tabelaGradeProduto', false, false, false, false, true, false, '250px', jsonObject, titulos);
                }
            }

        } finally {
            $.LoadingOverlay('hide');

            $('.camposGrade').on('blur', function () {
                preencheComZero();
            });

            $('.camposGrade').maskMoney({
                decimal: ".",
                thousands: "",
                precision: 0,
            });
            preencheComZero();
        }
    };

    $("#voltarAcesso").on("click", async function () {
        window.location.href = `${BASE_URI}/consignado`;
    });

    function adicionaMascaraCampos() {
        $('.maskDecimais').maskMoney({
            decimal: ".",
            thousands: "",
            precision: 2,
        });

        $('.maskDecimais').on('blur', function () {
            if ($(this).val() == '') {
                $(this).val('0.00');
            }
        });
    };

    $('#tabelaItensConsignado').on('click', '.btn-editar', async function () {
        let index = $(this).closest('tr')[0].rowIndex - 1;
        let itens = $('#tabelaItensConsignado').DataTable().row($(this).parents('tr')).data();

        $("#tabelaItensConsignado tbody tr").removeClass("selected");

        $(this).closest('tr').addClass("selected");
        $('#btnCancelar').removeClass('d-none')

        isAlteracao = true;
        manipulaBotoes(true);
        editaProduto(itens);
    });

    async function verificaQuantidadePendente() {
        $.LoadingOverlay('show')
        try {
            let where = ''
            where += ` AND VEN_CONSIG.CODCLI = '${pegaChave('#txtCliente')}' `
            where += ` AND VEN_CONSIG.EMP_ID = ${getCookie('emp_id')} `
            where += ` AND VEN_CONSIG.SITUACAO = 'P' `
            where += ` AND VEN_CONSIG.ID <> 0 `
            where += ` AND VEN_CONSIG.STATUS = '${pegaChave('#txtStatus')}' `
            where += ` AND ITENS.CODIGO = '${pegaChave('#txtProduto')}' `
            where += ` AND ITENS.COR = '${pegaChave('#txtCor')}' `
            where += ` AND ITENS.TAM = '${pegaChave('#txtTamanho')}' `

            const pesquisa = {
                tabela: 'VEN_CONSIG',
                innerJoin: [{ tabela: 'VEN_CONSIG_ITENS', condicao: 'VEN_CONSIG.ID = ITENS.ID_VEN_CONSIG', alias: 'ITENS' }],
                camposSelectSubSelect: [`SUM(QTDE) QTDE`],
                camposSelect: [`CASE WHEN ITENS.TIPO = 'S' THEN SUM(ITENS.QTDE) ELSE SUM(-ITENS.QTDE) END QTDE`],
                groupBy: ['ITENS.TIPO'],
                where: [`1=1 ${where}`]
            };

            const data = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));

            if (parseFloat($('#txtQtde').val()) > data[0].QTDE) {
                throw new Error('Quantidade devolvida maior que as saídas pendentes. Impossível continuar!')
            }
        } catch (error) {
            throw new Error(error.message || 'Não conseguiu encontrar a quantidade devolvida')
        } finally {
            $.LoadingOverlay('hide')
        }
    }

    $('#btnCancelar').on('click', function () {
        isAlteracao = false
        $("#tabelaItensConsignado tbody tr").removeClass("selected");

        manipulaBotoes(false)
        $('#btnCancelar').addClass('d-none')

        insereValor('#txtTabelaPreco', pegaChave('#txtTabelaPreco'), { tabela: 'REGIAO', campoBusca: 'DESCRICAO', campoWhere: 'REGIAO', valorWhere: pegaChave('#txtTabelaPreco') })
        $('#txtProduto').val('');
        $('#txtCor').val('');
        $('#txtTamanho').val('');
        $('#txtQtde').val('');
        $('#txtPreco').val('');
        $('#txtDesconto').val('');
        $('#txtTotal').val('');
        $('#tpDesconto').val('P');
    })

    $('#tabelaItensConsignado').on('click', '.btn-excluir', async function () {
        adicionaIdExclusao($('#tabelaItensConsignado').DataTable().row($(this).parents('tr')).data()[0]);
        $('#tabelaItensConsignado').DataTable().row($(this).parents('tr')).remove().draw(false);
        totalValorItem()
        totalQuantidade()
    })

    async function buscaBarras(produto = {}) {
        const { codigo, cor, tam, deposito } = produto
        const barra = (await buscaValor('PA_ITEN', 'BARRA', 'CODIGO', `${codigo}' AND COR='${cor}'AND TAM='${tam}' AND DEPOSITO='${deposito}`)).BARRA
        const barra28 = (await buscaValor('PA_ITEN', 'BARRA28', 'CODIGO', `${codigo}' AND COR='${cor}' AND TAM='${tam}' AND DEPOSITO='${deposito}`)).BARRA28

        return { barra, barra28 }
    }

    async function AdicionarProduto() {
        try {
            const codigo = pegaChave('#txtProduto');
            const descricao = pegaDescricao('#txtProduto');
            const cor = pegaChave('#txtCor');
            const tam = pegaChave('#txtTamanho');
            const deposito = pegaChave('#txtDeposito');
            const quantidade = $('#txtQtde').val();
            const preco = parseDouble($('#txtPreco').val());
            const precoTotal = parseDouble($('#txtTotal').val())
            const desconto = ($('#txtDesconto').val() == '') ? 0 : TruncaDecimaisNova(2, $('#txtDesconto').val());
            const tipoDesconto = desconto > 0 ? $('#tpDesconto').val() : 0;
            const tipo = $('#txtTipoConsignado').val();
            const tabPreco = pegaChave('#txtTabelaPreco');
            const { barra, barra28 } = await buscaBarras({ codigo, cor, tam, deposito });

            if ($('#txtTipoConsignado').val() === 'D') {
                await verificaQuantidadePendente()
            }

            if (codigo == '') {
                throw new Error('Produto não informado, impossível continuar');
            }

            if (cor == '') {
                throw new Error('Cor não informada, impossível continuar');
            }

            if (tam == '') {
                throw new Error('Tamanho não informado, impossível continuar');
            }

            if (deposito == '') {
                throw new Error('Depósito não informado, impossível continuar');
            }

            if ((quantidade == '') || (quantidade == 0)) {
                throw new Error('Quantidade não informado, impossível continuar.');
            }

            if ((preco == '') || (preco == 0)) {
                throw new Error('Preço não informado, impossível continuar.');
            }

            try {
                const tabelaItensConsignado = $('#tabelaItensConsignado').DataTable()
                const indiceProdutoEncontrado = $('#tabelaItensConsignado').DataTable().rows().data().toArray().findIndex(e =>
                    $(e[0]).find('button').first().html().trim() === codigo &&
                    e[3] === cor &&
                    e[4] === tam
                )

                if (indiceProdutoEncontrado != -1 && !isAlteracao) {
                    throw new Error('Item já foi adicionado no consignado. Por favor, verifique.')
                }

                if (indiceProdutoEncontrado !== -1) {
                    const dadosIndice = tabelaItensConsignado.row(indiceProdutoEncontrado).data();
                    dadosIndice[5] = quantidade;
                    dadosIndice[7] = preco;
                    dadosIndice[8] = desconto;
                    dadosIndice[9] = precoTotal;
                    dadosIndice[10] = barra;
                    dadosIndice[11] = barra28;
                    dadosIndice[12] = tipoDesconto;

                    tabelaItensConsignado.row(indiceProdutoEncontrado).data(dadosIndice).draw(false);

                    $('#btnCancelar').trigger('click')
                } else {
                    if ($('#txtTipoConsignado').val() !== 'D') {
                        if (!parametroPermiteEstoqueNegativo) {
                            await ValidaEstoque({ codigo, cor, tam, deposito, quantidade });
                        }
                    }

                    tabelaItensConsignado.row.add([
                        adicionaBotoes(codigo),
                        descricao,
                        tipo,
                        cor,
                        tam,
                        quantidade,
                        tabPreco,
                        preco,
                        desconto,
                        precoTotal,
                        barra,
                        barra28,
                        tipoDesconto
                    ]).draw(false);
                }
            } finally {
                limpaCamposProduto();
            }
        } catch (error) {
            $('#btnCancelar').trigger('click')
            return msgAlerta(error.message || 'Não foi possível adicionar o produto ao grid.');
        }
    }

    $('#btnGradeProduto').on('click', async function () {
        if (pegaValor('#txtDeposito') == '') {
            msgAlertaSemConfirmacao('Necessário informar um depósito!');
            return;
        }

        $('#modalItem').modal('show');
    });

    $('#btnAdicionarProduto').on('click', async function () {
        if (!$('#txtTabelaPreco').val()) {
            return msgAlerta('Tabela de preço não informada. Por favor, verifique!')
        }
        if (!$('#txtTipoConsignado').val()) {
            return msgAlerta('Tipo não informado. Por favor, verifique!')
        }
        await AdicionarProduto();
        totalQuantidade()
        totalValorLiquido()
        totalValorItem()
        $('#btnCancelar').trigger('click')
    });

    $('#btnConfirmarItem').on('click', async function () {
        if (!$('#txtTabelaPreco').val()) {
            return msgAlerta('Tabela de preço não informada. Por favor, verifique!')
        }
        if (!$('#txtTipoConsignado').val()) {
            aa
            return msgAlerta('Tipo não informado. Por favor, verifique!')
        }
        confirmaItem();
        totalQuantidade()
        totalValorLiquido()
        totalValorItem()
    });

    $('#btnConsultarSolicitacao').on('click', async function () {
        await buscaSolicitacao();
        $('#check_todos').prop('checked', true);
    });

    $('#check_todos').on('click', async function () {
        $('.checkSolicitacao').prop('checked', $('#check_todos').prop('checked'));
        addSelected($('#check_todos').prop('checked'));
    });

    $(".collapse")
        .on("shown.bs.collapse", function (e) {
            let clicked = $(document).find(`[href='#${$(e.target).attr("id")}']`);

            clicked
                .parent()
                .find(".fa-angle-right")
                .removeClass("fa-angle-right")
                .addClass("fa-angle-down");

            $("#tabelaItensConsignado").DataTable().columns.adjust().draw(false);
        })
        .on("hidden.bs.collapse", function (e) {
            let clicked = $(document).find(`[href='#${$(e.target).attr("id")}']`);

            clicked
                .parent()
                .find(".fa-angle-down")
                .removeClass("fa-angle-down")
                .addClass("fa-angle-right");
        });
});