<?php include_once('../../config.php') ?>

<!DOCTYPE html>
<html>

<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Sisplan Web | Liberação Pedido Comercial</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link rel="stylesheet" href="plugins/fontawesome-free/css/all.min.css?versao=3.258.7.1">
  <link rel="stylesheet" href="dist/css/adminlte.min.css?versao=3.258.7.1">
  <link href='https://fonts.googleapis.com/css?family=Roboto:400,300,500,600,700,400italic' rel='stylesheet' type='text/css'>
  <link rel="stylesheet" href="dist/css/custom.css?versao=3.258.7.1">
  <link rel="stylesheet" href="dist/css/sisplan.css?versao=3.258.7.1">
  <link rel="stylesheet" type="text/css" href="dist/css/dataTables.bootstrap4.min.css?versao=3.258.7.1" />
  <link rel="shortcut icon" href="favicon.ico">
  <link rel="stylesheet" href="plugins/toastr/toastr.min.css?versao=3.258.7.1">
  <link rel="stylesheet" type="text/css" href="dist/css/driver.min.css?versao=3.258.7.1" />
  <link rel="stylesheet" href="dist/css/jquery-ui.css?versao=3.258.7.1">
  <link rel="stylesheet" href="dist/css/PesquisaVariosSelect2.css?versao=3.258.7.1">
  <link rel="stylesheet" href="plugins/select2/css/select2.min.css?versao=3.258.7.1">
  <link rel="stylesheet" href="plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css?versao=3.258.7.1">
  <style>
    .radioStyle {
      border: solid #e0e4e6;
      border-radius: 4px;
      border-width: 2px;
      padding: 6px;
    }

    .campoSel {
      display: inline-block;
      position: absolute;
      width: 22px;
      height: 22px;
      border: 1px solid #D3CFC8;
      border-radius: 0;
    }

    .border-Field {
      border: 1px solid var(--font-color) !important;
      padding: 0 1.0em 0 1.0em !important;
      margin: 0 0 1.0em 0 !important;
      -webkit-box-shadow: 0px 0px 0px 0px #000;
      box-shadow: 0px 0px 0px 0px #000;
      border-radius: 3px;
    }

    .border-Field .textoBorda {
      font-size: 1.1em !important;
      text-align: left !important;
      width: auto;
      padding: 0 10px;
      border-bottom: none;
    }

    .table-wrapper {
      max-height: 336px;
      overflow-y: auto;
    }

    .table-wrapper table {
      width: 100%;
      border-collapse: collapse;
      table-layout: auto;
    }
  </style>
</head>

<body class="hold-transition sidebar-mini layout-fixed">
  <div class="wrapper">

    <div class="content-wrapper">
      <div class="content-header">
        <div class="container-fluid">
          <div class="row mb-2">
            <div class="col-sm-6 flex">
              <h1 class="m-0 text-dark">Liberação de Pedido Comercial</h1>
              <button type="button" class="btn btn-info btn-sm ml-2" title="Tutorial" style="color: white;" id="tutorial">
                <i class="fas fa-question-circle"></i></button>
            </div>
            <div class="col-sm-6">
              <!-- <ol class="breadcrumb float-sm-right">
                
                <li class="breadcrumb-item active">Liberação de Pedido Comercial</li>
              </ol> -->
            </div>
          </div>
        </div>
        <div class="container-fluid card">
          <div class="row card-body" id="abaGeral">

            <div class="col-lg-3 form-group">
              <label data-error="wrong" data-success="right" for="txtPedido">Pedido: </label>
              <div class="input-group">
                <select class="js-example-programmatic js-states form-control" id="txtPedido" name="txtPedido" multiple="multiple"></select>
                <div class="input-group-append">
                  <button class="btn bg-danger" id="btnPedido" name="btnPedido" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                  <button class="btn bg-danger" id="btnLimpaPedido" name="btnLimpaPedido" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                </div>
              </div>
            </div>

            <div class="col-lg-3 form-group">
              <label data-error="wrong" data-success="right" for="txtCliente">Cliente: </label>
              <div class="input-group">
                <input type="text" class="input-default focus form-control" id="txtCliente" name="txtCliente" placeholder="Cliente">
                <div class="input-group-append">
                  <button class="btn bg-danger" id="btn-Cliente" name="btn-Cliente" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                  <button class="btn bg-danger" id="btn-limpa-Cliente" name="btn-limpa-Cliente" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                </div>
              </div>
            </div>

            <div class="col-lg-3 form-group">
              <label data-error="wrong" data-success="right" for="txtRepresentante">Representante: </label>
              <div class="input-group">
                <input type="text" class="input-default focus form-control" id="txtRepresentante" name="txtRepresentante" placeholder="Representante">
                <div class="input-group-append">
                  <button class="btn bg-danger" id="btn-Representante" name="btn-Representante" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                  <button class="btn bg-danger" id="btn-limpa-Representante" name="btn-limpa-Representante" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                </div>
              </div>
            </div>

            <div class="col-lg-3 form-group">
              <label data-error="wrong" data-success="right" for="txtStatus">Status: </label>
              <div class="input-group">
                <input type="text" class="input-default focus form-control" id="txtStatus" name="txtStatus" placeholder="Status">
                <div class="input-group-append">
                  <button class="btn bg-danger" id="btnStatus" name="btnStatus" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                  <button class="btn bg-danger" id="btnLimpaStatus" name="btnLimpaStatus" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                </div>
              </div>
            </div>

            <div class="col-lg-3 form-group">
              <label data-error="wrong" data-success="right" for="txtColecao">Coleção: </label>
              <div class="input-group">
                <input type="text" class="input-default focus form-control" id="txtColecao" name="txtColecao" placeholder="Coleção">
                <div class="input-group-append">
                  <button class="btn bg-danger" id="btn-Colecao" name="btn-Colecao" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                  <button class="btn bg-danger" id="btn-limpa-Colecao" name="btn-limpa-Colecao" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                </div>
              </div>
            </div>

            <div class="col-lg-3 form-group">
              <label data-error="wrong" data-success="right" for="txtDtFaturaDe">Período Fatura (de/até): </label>
              <div class="input-group">
                <input type="date" max="2500-12-31" class="input-default focus form-control" id="txtDtFaturaDe" name="txtDtFaturaDe">
                <input type="date" max="2500-12-31" class="input-default focus form-control" id="txtDtFaturaAte" name="txtDtFaturaAte">
              </div>
            </div>

            <div class="col-lg-3 form-group">
              <label data-error="wrong" data-success="right" for="txtDtEmissaoDe">Período Emissão (de/até): </label>
              <div class="input-group">
                <input type="date" max="2500-12-31" class="input-default focus form-control" id="txtDtEmissaoDe" name="txtDtEmissaoDe">
                <input type="date" max="2500-12-31" class="input-default focus form-control" id="txtDtEmissaoAte" name="txtDtEmissaoAte">
              </div>
            </div>

            <div class="col-lg-3 form-group">
              <label data-error="wrong" data-success="right" for="txtDtSaidaDe">Data de Saída (de/até): </label>
              <div class="input-group">
                <input type="date" max="2500-12-31" class="input-default focus form-control" id="txtDtSaidaDe" name="txtDtSaidaDe">
                <input type="date" max="2500-12-31" class="input-default focus form-control" id="txtDtSaidaAte" name="txtDtSaidaAte">
              </div>
            </div>

            <div class="col-lg-3 form-group">
              <label data-error="wrong" data-success="right" for="txtPeriodoEntDe">Período Entrega de: </label>
              <div class="input-group">
                <input type="text" class="input-default focus form-control" id="txtPeriodoEntDe" name="txtPeriodoEntDe" placeholder="de">
                <div class="input-group-append">
                  <button class="btn bg-danger" id="btn-PeriodoEntDe" name="btn-PeriodoEntDe" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                  <button class="btn bg-danger" id="btn-limpa-PeriodoEntDe" name="btn-limpa-PeriodoEntDe" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                </div>
              </div>
            </div>

            <div class="col-lg-3 form-group">
              <label data-error="wrong" data-success="right" for="txtPeriodoEntAte"> até: </label>
              <div class="input-group">
                <input type="text" class="input-default focus form-control" id="txtPeriodoEntAte" name="txtPeriodoEntAte" placeholder="até">
                <div class="input-group-append">
                  <button class="btn bg-danger" id="btn-PeriodoEntAte" name="btn-PeriodoEntAte" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                  <button class="btn bg-danger" id="btn-limpa-PeriodoEntAte" name="btn-limpa-PeriodoEntAte" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                </div>
              </div>
            </div>

            <div class="col-lg-3 form-group">
              <label data-error="wrong" data-success="right" for="txtTipoVenda">Tipo de Venda: </label>
              <div class="input-group">
                <input type="text" class="input-default focus form-control" id="txtTipoVenda" name="txtTipoVenda" placeholder="Tipo de Venda">
                <div class="input-group-append">
                  <button class="btn bg-danger" id="btnTipoVenda" name="btnTipoVenda" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                  <button class="btn bg-danger" id="btnLimpaTipoVenda" name="btLimpaTipoVenda" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                </div>
              </div>
            </div>

            <div class="col-sm-5 form-group mb-0">
              <fieldset class="form border-Field mb-0 pb-0">
                <legend class="textoBorda mb-0 pb-0">Financeiro/Comercial</legend>
                <div class="form-row">
                  <div class="form-group ml-2 icheck-primary">
                    <input type="radio" class="" checked name="tipo" id="radioTodos">
                    <label class="form-check-label pr-1" for="radioTodos">Todos</label>
                  </div>
                  <div class="form-group ml-2 icheck-primary">
                    <input type="radio" class="" name="tipo" id="radioBloqVendas">
                    <label class="form-check-label pr-1" for="radioBloqVendas">Bloq. Vendas</label>
                  </div>
                  <div class="form-group ml-2 icheck-primary">
                    <input type="radio" class="" name="tipo" id="radioBloqFinan">
                    <label class="form-check-label pr-1" for="radioBloqFinan">Bloq. Finan.</label>
                  </div>
                  <div class="form-group ml-2 icheck-primary">
                    <input type="radio" class="" name="tipo" id="radioBloqVendLibFinan">
                    <label class="form-check-label pr-1" for="radioBloqVendLibFinan">Bloq. Vendas / Lib. Finan.</label>
                  </div>
                  <div class="form-group ml-2 icheck-primary">
                    <input type="radio" class="" name="tipo" id="radioBloqExp">
                    <label class="form-check-label pr-1" for="radioBloqExp">Bloq. Expedição</label>
                  </div>
                </div>
              </fieldset>
            </div>

            <div class="col-sm-5 form-group mb-0">
              <fieldset class="form border-Field mb-0 pb-0">
                <legend class="textoBorda mb-0 pb-0">Situação Pedido</legend>
                <div class="form-row">
                  <div class="form-group ml-2 icheck-primary">
                    <input type="radio" class="" checked name="Pedido" id="rgPedidoTodos">
                    <label class="form-check-label pr-1" for="rgPedidoTodos">Todos</label>
                  </div>
                  <div class="form-group ml-2 icheck-primary">
                    <input type="radio" class="" name="Pedido" id="rgPedidoPendentes">
                    <label class="form-check-label pr-1" for="rgPedidoPendentes">Pendentes</label>
                  </div>
                  <div class="form-group ml-2 icheck-primary">
                    <input type="radio" class="" name="Pedido" id="rgPedidoFaturados">
                    <label class="form-check-label pr-1" for="rgPedidoFaturados">Faturados</label>
                  </div>
                  <div class="form-group ml-2 icheck-primary">
                    <input type="radio" class="" name="Pedido" id="rgPedidoParcFat">
                    <label class="form-check-label pr-1" for="rgPedidoParcFat">Parc. Fat.</label>
                  </div>
                  <div class="form-group ml-2 icheck-primary">
                    <input type="radio" class="" name="Pedido" id="rgPedidoExpPendente">
                    <label class="form-check-label pr-1" for="rgPedidoExpPendente">Exp. Pendente</label>
                  </div>
                  <div class="form-group ml-2 icheck-primary">
                    <input type="radio" class="" name="Pedido" id="rgPedidoSemExpedicao">
                    <label class="form-check-label pr-1" for="rgPedidoSemExpedicao">Sem Expedição</label>
                  </div>
                </div>
              </fieldset>
            </div>

            <div class="col-sm-2 form-group flex mt-2">
              <div class="flex align-items-center">
                <button class=" btn btn-primary btn-sisp" id="btnConsultar"><span class="fas fa-search"></span> Consultar</button>
              </div>
            </div>


            <div class="col-sm-6 table-responsive card-body">
              <h5>Pedidos</h5>
              <table id="tabelaPedido" class="table table-sm table-select table-hover" style="white-space: nowrap;" width="100%">
                <thead>
                </thead>
                <tbody>
                </tbody>
              </table>
            </div>

            <div class="col-sm-6 table-responsive card-body">
              <h5>Itens</h5>
              <div class="table-wrapper">
                <table id="tabelaItens" class="table table-sm table-select table-hover" style="white-space: nowrap;" width="100%">
                  <thead>
                  </thead>
                  <tbody>
                  </tbody>
                </table>
              </div>
            </div>

            <div class="col-sm-12 d-flex justify-content-end">
              <div class="radioStyle">
                <div class="form-row pr-2">
                  <div class="form-group ml-2 icheck-primary flex align-items-center pt-1">
                    <input type="radio" class="" checked name="liberarBloq" id="radioLiberar">
                    <label class="form-check-label pr-1" style="font-weight: bold;" for="radioLiberar">Liberar</label>
                  </div>
                  <div class="form-group ml-2 icheck-primary flex align-items-center pt-1">
                    <input type="radio" class="" name="liberarBloq" id="radioBloquear">
                    <label class="form-check-label pr-1" style="font-weight: bold;" for="radioBloquear">Bloquear</label>
                  </div>
                  <button id="btnLiberar" class="btn btn-danger btn-sisp">Confirmar</button>
                </div>
              </div>
            </div>

          </div>
        </div>
      </div>
      <!-- modal  -->
    </div>
  </div>
  <?php
  include_once('../../modais.php');
  ?>
  <aside class="control-sidebar control-sidebar-dark">
  </aside>
  </div>
  <script src="plugins/jquery/jquery.min.js?versao=3.258.7.1"></script>
  <script type="text/javascript" src="dist/js/jquery.dataTables.js?versao=3.258.7.1"></script>
  <script type="text/javascript" src="dist/js/dataTables.bootstrap4.min.js?versao=3.258.7.1"></script>
  <script src="plugins/jquery-ui/jquery-ui.min.js?versao=3.258.7.1"></script>
  <script>
    $.widget.bridge('uibutton', $.ui.button);
  </script>
  <script src="plugins/bootstrap/js/bootstrap.bundle.min.js?versao=3.258.7.1"></script>
  <script src="dist/js/adminlte.min.js?versao=3.258.7.1"></script>
  <script src="dist/js/sisplan.js?versao=3.258.7.1"></script>
  <script src="utils/funcoes.js?versao=3.258.7.1"></script>
  <script src="utils/cookies.js?versao=3.258.7.1"></script>
  <script src="dist/js/requisicoes.js?versao=3.258.7.1"></script>
  <script src="dist/js/loadingoverlay.min.js?versao=3.258.7.1"></script>
  <script src="dist/js/driver.min.js?versao=3.258.7.1"></script>
  <script src="plugins/toastr/toastr.min.js?versao=3.258.7.1"></script>
  <script src="plugins/select2/js/select2.full.min.js?versao=3.258.7.1"></script>
  <script type="text/javascript" src="dist/js/sum().js?versao=3.258.7.1"></script>
  <script type="text/javascript" src="config.js?versao=3.258.7.1"></script>
  <script>
    $(document).ready(async function() {
      if (getCookie('usuario') == "") {
        window.location.href = `${BASE_URI}/login`;
        return;
      }

      let usuario = getCookie('usuario');
      let empresa = getCookie('empresa');

      ipInterno = IP_INTERNO;
      ipExterno = IP_EXTERNO;
      basicAuth = BASIC_AUTH;

      const temAcesso = await temAcessoTela('LIBERACAO_COMERCIAL');
      if (!temAcesso.resultado) {
        toastrAcesso(temAcesso, BASE_URI);
        return;
      }

      sArquivo = `${BASE_URI}/pages/liberacao_comercial/liberacao_comercial.js?versao=3.258.7.1`;
      insereJavaScriptPagina(sArquivo);

    });
  </script>
</body>

</html>