$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false
        });
        driver.defineSteps([{
            element: '#btn-filtros',
            popover: {
                title: 'Botão Filtros',
                description: 'Clique aqui para abrir os campos disponíveis de filtro.',
                position: 'right'
            }
        },
        {
            element: '#btnIncluir',
            popover: {
                title: 'Botão Incluir',
                description: 'Clique aqui para ir para realizar a inclusão de uma movimentação bancária.',
                position: 'right'
            }
        },
        {
            element: '#btnImprimir',
            popover: {
                title: 'Botão Imprimir',
                description: 'Clique aqui para imprimir o relatório',
                position: 'right'
            }
        }
        ]);
        //inicio tour

        driver.start();

        // inicior tuor
        //final
    });
});
$(document).ready(async function () {
    const permissaoUsuarioLogado = await permissaoAcessos("MOVIMENTOBANCARIO");

    const colunasDataTableMovimento = [
        {data: 'SEL', title: 'Sel'},
        {data: 'LANCAMENTO', title: 'Lancamento'},
        {data: 'DOCTO', title: 'Docto'},
        {data: 'BANCO', title: 'Banco'},
        {data: 'NOME_BANCO', title: 'Nome Banco'},
        {data: 'CONTA', title: 'Conta'},
        {data: 'DESC_CONTA', title: 'Desc. Conta'},
        {data: 'DT_CONT', title: 'Data Cont.'},
        {data: 'VALOR', title: 'Valor'},
        {data: 'VALOR_ORIG_CC', title: 'Valor Orig. CC'},
        {data: 'OPERACAO', title: 'Operação'},
        {data: 'SALDO', title: 'Saldo'},
        {data: 'PENDENTE', title: 'Pendente'},
        {data: 'OBSERVACAO', title: 'Observacao'},
        {data: 'HISTORICO', title: 'Historico'},
        {data: 'DESC_HIST', title: 'Desc. Hist'},
        {data: 'LANC_CON', title: 'Lanc. Con'},
        {data: 'DT_LAN', title: 'Dt_Lan'},
        {data: 'CLASSE', title: 'Classe'},
        {data: 'DESC_CLASSE', title: 'Desc. Classe'},
        {data: 'TIPO', title: 'Tipo'},
        {data: 'CODCLI', title: 'Codcli'},
        {data: 'NOME', title: 'Nome'},
        {data: 'EMP_ID', title: 'Emp. Id'},
        {data: 'ORDEM', title: 'Ordem'},
        {data: 'MOEDA', title: 'Moeda'},
        {data: 'DESC_MOEDA', title: 'Desc. Moeda'}
    ]

    //autocomplete
    $('#txtConta').autocompleta(1, 'JSON={ "tabela":"CADCONTA", "camposSelect":[ "CONTA CHAVE", "DESCRICAO DESCRICAO" ], "where": null}');
    $('#txtHistorico').pesquisa_variosServerside(1, '{ "tabela":"HISTCP", "camposSelect":[ "HISTORICO", "DESCRICAO" ], "where": null}', 'HISTORICO', 'DESCRICAO');
    $('#txtClasseGer').pesquisa_variosServerside(1, '{ "tabela":"CLASSE_GER", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'CODIGO', 'DESCRICAO');
    $('#txtMoeda').pesquisa_variosServerside(1, '{ "tabela":"MOEDA", "camposSelect":[ "CODMOE", "DESCRICAO" ], "where": null}', 'CODMOE', 'DESCRICAO');
    $('#txtCliente').pesquisa_variosServerside(1, '{ "tabela":"ENTIDADE", "camposSelect":[ "CODCLI", "NOME" ], "where": null}', 'CODCLI', 'NOME');

    //btnconsultar
    $('#btn-ContaConsulta').pesquisa_serverside(['#txtConta'], ['CONTA'], ['DESCRICAO'], `{ "tabela":"CADCONTA", "camposSelect":[ "CONTA", "DESCRICAO" ], "where": null}`, 'Pesquisa de Conta');
    $('#btn-HistoricoConsulta').pesquisa_serversideSel('#txtHistorico', `{ "tabela":"HISTCP", "camposSelect":[ "HISTORICO", "DESCRICAO" ], "where": null}`, 'Pesquisa de Histórico');
    $('#btn-ClasseGerConsulta').pesquisa_serversideSel('#txtClasseGer', `{ "tabela":"CLASSE_GER", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}`, 'Pesquisa de Classe Gerencial');
    $('#btn-MoedaConsulta').pesquisa_serversideSel('#txtMoeda', `{ "tabela":"MOEDA", "camposSelect":[ "CODMOE", "DESCRICAO" ], "where": null}`, 'Pesquisa de Moeda');
    $('#btn-ClienteConsulta').pesquisa_serversideSel('#txtCliente', `{ "tabela":"ENTIDADE", "camposSelect":[ "CODCLI", "NOME" ], "where": null}`, 'Pesquisa de Cliente');

    //btnLimpar
    $('#btn-limpa-Conta').on('click', function () { $('#txtConta').val('') })
    $('#btn-limpa-Historico').on('click', function () { $('#txtHistorico').empty().trigger('change') })
    $('#btn-limpa-ClasseGer').on('click', function () { $('#txtClasseGer').empty().trigger('change') })
    $('#btn-limpa-Moeda').on('click', function () { $('#txtMoeda').empty().trigger('change') })
    $('#btn-limpa-Cliente').on('click', function () { $('#txtCliente').empty().trigger('change') })

    $('#btnLimparFiltros').click(async function () {
        $('#txtConta').val('')
        $('#txtDocumentoFiltro').val('')
        $('#txtLancamento').val('')
        $('#txtObservacao').val('')
        $('#txtValorDe').val('')
        $('#txtValorAte').val('')
        $('#txtHistorico').empty().trigger('change')
        $('#txtClasseGer').empty().trigger('change')
        $('#txtMoeda').empty().trigger('change')
        $('#txtCliente').empty().trigger('change')
        $('#rdPendentes').prop('checked', true)
        $('#dtLancamentoDe').val('1200-01-01')
        $('#dtVencimentoDe').val('1200-01-01')
        $('#dtContabilizacaoDe').val('1200-01-01')
        $('#dtLancamentoAte').val('2500-12-31')
        $('#dtVencimentoAte').val('2500-12-31')
        $('#dtContabilizacaoAte').val('2500-12-31')
    });

    $('#txtValorDe').maskMoney({
        decimal: '.',
        thousands: '',
        precision: 2
    });

    $('#txtValorAte').maskMoney({
        decimal: '.',
        thousands: '',
        precision: 2
    });

    $('#txtValorTransferencia').maskMoney({
        decimal: '.',
        thousands: '',
        precision: 2
    });

    function retornaBotaoOpcoes(data) {
        var retorno = '<div style="text-align:start;"> ' +
            '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
            '      ' + data + ' ' +
            '    </button> ' +
            '    <div class="dropdown-menu"> ' +
            '    <button class="dropdown-item" type="button" title="Editar" id="btn-editar">Editar</button>     ' +
            '    <button class="dropdown-item" type="button" title="Duplicar" id="btn-duplicar">Duplicar</button>     ' +
            '    <button class="dropdown-item" type="button" title="Gestao de Documentos" id="btnAnexos">Gestao de Documentos</button>     ' +
            '    <button class="dropdown-item" type="button" title="Excluir" id="btn-excluir">Excluir</button>  ' +
            '</div>';
        return retorno;
    };

    async function retornaFiltros() {
        const buscar = $('#rdPendentes').is(':checked') ? 1 : $('#rdBaixados').is(':checked') ? 2 : $('#rdCompensados').is(':checked') ? 3 : 0
        const considerarHistorico = $('#cbConsideraHistorico').is(':checked') ? 'S' : 'N'
        const considerarClasseGer = $('#cbConsideraClasseGer').is(':checked') ? 'S' : 'N'
        const empresasFiltradas = $(".empresa_selecionada:checked").toArray().length > 0 ? $(".empresa_selecionada:checked").toArray().map((input) => input.id.substring(input.id.indexOf("-") + 1, input.id.length)) : [getCookie("emp_id")];
        const empresasFiltradasFormatada = await formataListas(empresasFiltradas.toString());
        const todasEmpresas = $("#cbTodasAsEmpresas").is(':checked') ? true : false;

        const filtros =
            `LANCAMENTODE=${$('#dtLancamentoDe').val()}` +
            `&LANCAMENTOATE=${$('#dtLancamentoAte').val()}` +
            `&VENCIMENTODE=${$('#dtVencimentoDe').val()}` +
            `&VENCIMENTOATE=${$('#dtVencimentoAte').val()}` +
            `&CONTABILIZACAODE=${$('#dtContabilizacaoDe').val()}` +
            `&CONTABILIZACAOATE=${$('#dtContabilizacaoAte').val()}` +
            `&VALORDE=${$('#txtValorDe').val()}` +
            `&VALORATE=${$('#txtValorAte').val()}` +
            `&CONTA=${pegaChave('#txtConta')}` +
            `&CONSIDERARHISTORICO=${considerarHistorico}` +
            `&HISTORICO=${await formataListas($('#txtHistorico').val().toString())}` +
            `&CONSIDERARCLASSEGER=${considerarClasseGer}` +
            `&CLASSEGER=${await formataListas($('#txtClasseGer').val().toString())}` +
            `&MOEDA=${await formataListas($('#txtMoeda').val().toString())}` +
            `&CLIENTE=${await formataListas($('#txtCliente').val().toString())}` +
            `&DOCUMENTO=${$('#txtDocumentoFiltro').val()}` +
            `&LANCAMENTO=${$('#txtLancamento').val()}` +
            `&OBSERVACAO=${$('#txtObservacao').val()}` +
            `&BUSCAR=${buscar}` +
            `&EMPRESASFILTRADAS=${empresasFiltradasFormatada}` +
            `&TODASEMPRESAS=${todasEmpresas}`;
        return filtros;
    }

    $("#btnCarregaEmpresas").on("click", function () {
        carregaEmpresasDisponiveis();
    });

    retornaHintRelatorio('btnImprimir', 'RelAcessoMovimentoBancario')

    $('#btnImprimir').on('click', async function () {
        try {
            $.LoadingOverlay('show');
            try {
                const url = `/sisplan/movimentobancario/v1/imprimiracesso?`;
                const filtros = await retornaFiltros();
                const bImprimeAutomatico = await verificaImprimirAutomatico('RelAcessoMovimentoBancario');
                const arquivo = await GeraRelatorio(`${url}${filtros}&`, 'GET', 100000, false, 'RelAcessoMovimentoBancario');
                if (arquivo != undefined) {
                    if (!bImprimeAutomatico) {
                        window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
                    }
                    await limparRelatorios();
                }

            } catch (error) {
                console.error(error);
            }
        } finally {
            $.LoadingOverlay('hide');
        }
    });

    async function buscaRegistrosMovimento() {
        const url = "/sisplan/movimentobancario/v1/consultaacesso?";
        const filtros = await retornaFiltros();
        try {
            $.LoadingOverlay("Show");
            try {
                const response = await requisicao("GET", url, `${filtros}&EMPRESA=${getCookie("empresa")}`, "", 360000);

                if (!response) {
                    return;
                }

                let jsonStr = await response.json()
                if (response.status != 200) {
                    msgErro(jsonStr['RESULT'][0].mensagem);
                    return;
                }

                return jsonStr;
            } catch (error) {
                console.error(error);
                msgErro('Não foi possível buscar os dados.');
            }
        } finally {
            $.LoadingOverlay("Hide");
        }
    }

    let colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

    if (colunas == null || colunas.curvaCliente == undefined) {
        localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, acesso_movimentoBancario: ['EMPRESA'] }))
        colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))
    }

    $('#btnSelecionarEmpresas').on('click', function () {
        carregaEmpresasDisponiveis();
    });

    setarDataAtual('txtDataVendasAte');

    $('#btnConfirmarColunas').on('click', async function () {
        try {
            $.LoadingOverlay('show');

            const novasColunas = retornaNovasColunasInvisiveis();
            localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, acesso_movimentoBancario: novasColunas }))

            $('#tabelaMovimento').DataTable().columns().visible(true);

            $('#tabelaMovimento').DataTable().columns().every(function () {
                if ((novasColunas).indexOf(this.dataSrc()) != -1) {
                    this.visible(false);
                }
            })
        } finally {
            $.LoadingOverlay('hide');
            $('#modal-ColunasVisiveis').modal('hide');
        }
    })

    $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
        const cols = [];

        let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

        $('#tabelaMovimento').DataTable().columns().every(function () {
            cols.push({
                'title': $(this.header()).text(),
                'data': this.dataSrc()
            })
        });

        adicionaColunas(cols, colunasInvisiveis.acesso_movimentoBancario ?? ['EMPRESA'], ['SEL','LANCAMENTO'])
    })

    async function criaDataTableMovto() {
        if ($.fn.DataTable.isDataTable('#tabelaMovimento')) {
            $('#tabelaMovimento').DataTable().destroy();
            $('#tabelaMovimento').empty();
        }
        try {
            $.LoadingOverlay('show')
            const jsonStr = await buscaRegistrosMovimento();

            if (jsonStr.length <= 0) {
                msgAlerta('Nenhum registro encontrado!')
                return;
            }

            const dataCols = colunasDataTableMovimento
            const saldoIni = await calculaSaldoInicial()
            let saldo = saldoIni ? saldoIni : 0;

            dataCols[0].render = function (data, type, row, meta) {
                return '<div class="form-check pl-0">' +
                    '<div class="icheck-primary">' +
                    `<input style="height:20px" type="checkbox" id="check_col_${meta.row}_row_${meta.col}" class="align-self-start campoCheck"><label for="check_col_${meta.row}_row_${meta.col}"></label>` +
                    '</div>' +
                    '</div>';
            }

            jsonStr.forEach((item) => {
                saldo = item.OPERACAO === '+' ? saldo + item.VALOR : saldo - item.VALOR;

                item.SALDO = saldo.toLocaleString('pt-BR', { minimumFractionDigits: 2 });
            })

            $("#tabelaMovimento").DataTable({
                destroy: true,
                sort: true,
                colReorder: {
                    fixedColumnsLeft: 2
                },
                autoWidth: true,
                data: jsonStr,
                columns: dataCols,
                columnDefs: [
                    {
                        type: "date-br",
                        render(data) {
                            return new Intl.DateTimeFormat("pt-BR").format(
                                new Date(`${data.split(" ")[0]} 23:59:59`)
                            );
                        },
                        targets: [7, 17]
                    },
                    {
                        render(data) {
                            return parseFloat(data).toLocaleString("pt-br", {
                                minimumFractionDigits: 2,
                            });
                        },
                        targets: [8, 9, 11],
                        "className": 'pr-4 text-right'
                    },
                    {
                        targets: [1], render: function (data, type, row) {
                            return retornaBotaoOpcoes(data);
                        }
                    }
                ]
            });



            $('#tabelaMovimento_length').prepend('<button class="buttonColVis" id="buttonColVis"><i class="fas fa-cogs"></i></button>');
            $('#tabelaMovimento_length').prepend('<button class="buttonExcel" id="buttonExcel"><i class="fas fa-file-excel"></i></button>');

            $('#buttonColVis').prop('title', 'Configurar colunas visíveis')
            $('#buttonExcel').prop('title', 'Exportar')

            $('#buttonColVis').on('click', async function () {
                grid = 1;
                $.LoadingOverlay('show');
                $('#modal-ColunasVisiveis').modal('show');
                $.LoadingOverlay('hide');
            });

            $('#buttonExcel').on('click', async function () {
                $.LoadingOverlay('show');
                try {
                    const dados = $('#tabelaMovimento').DataTable().rows().data().toArray();
                    await exportaCSV("", "", undefined, null, 'Relatório de Movimentação Bancária', '', '', 999, false, false, dados);
                } catch (error) {
                    console.log(error.message);
                } finally {
                    $.LoadingOverlay('hide');
                };
            });

            $('#tabelaMovimento').on('click', '.campoCheck', async function () {
                const row = parseInt(this.id.split('col_')[1].split('_row')[0])
                if (this.checked) {
                    $('#tabelaMovimento').DataTable().rows(row).data()[0].SEL = 'S'
                } else {
                    $('#tabelaMovimento').DataTable().rows(row).data()[0].SEL = 'N'
                }
            });

            calculaTotais()

            $('#btnCompensar').prop('disabled', false)
            $('#btnEstCompensacao').prop('disabled', false)
            $('#btnSaldoContas').prop('disabled', false)
            $('#dtCompensacao').prop('disabled', false)
            $('#dtCompensacao').val('')
        } finally {
            $.LoadingOverlay('hide')
        }
    }

    function calculaTotais() {
        try {
            $('#containerTotalizadores').removeClass('d-none')

            $('#txtSaida').val(0)
            $('#txtEntrada').val(0)
            $('#txtSaldo').val(0)

            let saida = 0
            let entrada = 0
            let saldo = 0

            $('#tabelaMovimento').DataTable().rows().every(function () {
                let item = this.data();

                if (item.OPERACAO == '-') {
                    saida = parseFloat(saida) + parseFloat(item.VALOR)
                    saldo = parseFloat(saldo) - parseFloat(item.VALOR)
                } else {
                    entrada = parseFloat(entrada) + parseFloat(item.VALOR)
                    saldo = parseFloat(saldo) + parseFloat(item.VALOR)
                }
            })

            $('#txtSaida').val(formatarNumero(saida))
            $('#txtEntrada').val(formatarNumero(entrada))
            $('#txtSaldo').val(formatarNumero(saldo))
        } catch (error) {
            console.error(error)
        }
    }

    function formatarNumero(numero) {
        return numero.toFixed(2).replace('.', ',').replace(/\d(?=(\d{3})+,)/g, '$&.');
    }

    $('#btnConsultar').on('click', async function () {
        $.LoadingOverlay("Show");
        try {
            try {
                $('#containerTotalizadores').addClass('d-none')
                await criaDataTableMovto();
            } catch (error) {
                console.error(error);
                msgErro("Erro ao buscar os dados");
            }
        } finally {
            $("#modal-filtros").modal("hide");
            $.LoadingOverlay("hide");
        }
    });

    $('#btnIncluir').on('click', function () {
        if (permissaoUsuarioLogado.INCLUI == 'S') {
            window.location.href = "movimentobancario/create";
        } else {
            msgAlertaSemConfirmacao("Sem permissão para incluir!");
        }
    })

    $('#tabelaMovimento').on('click', '#btn-editar', async function () {
        if (permissaoUsuarioLogado.ALTERA == 'S') {
            let data = $('#tabelaMovimento').DataTable().row($(this).parents('tr')).data();
            if ((data.LANC_CON != 0) && (data.LANC_CON != '') && (data.LANC_CON != null)) {
                msgAlerta('Impossível Alterar, registro já conciliado!')
                return;
            }
            if (data.TIPO == 'TR' || data.TIPO == 'L') {
                msgAlerta('Impossível Alterar, registro com tipo L ou TR!')
                return;
            }
            const urlMontada = encodeURIComponent(JSON.stringify({
                lancamento: data.LANCAMENTO,
                operacao: data.OPERACAO,
                conta: data.CONTA,
                docto: data.DOCTO,
            }))
            let registroLiberado = await verificarRegistro('MOVIMENTOBANCARIO', data.LANCAMENTO);
            if (registroLiberado) {
                window.location.href = `movimentobancario/${criptografaUrl(urlMontada)}`;
            }
        } else {
            msgAlertaSemConfirmacao("Sem permissão para alterar!");
        }
    })

    $('#tabelaMovimento').on('click', '#btn-duplicar', async function () {
        if (permissaoUsuarioLogado.ALTERA == 'S') {
            let data = $('#tabelaMovimento').DataTable().row($(this).parents('tr')).data();
            const urlMontada = encodeURIComponent(JSON.stringify({
                lancamento: data.LANCAMENTO,
                operacao: data.OPERACAO,
                conta: data.CONTA,
                docto: data.DOCTO,
            }))
            localStorage.setItem('duplicarmovimento', 'true')
            window.location.href = `movimentobancario/${criptografaUrl(urlMontada)}`;
        } else {
            msgAlertaSemConfirmacao("Sem permissão para alterar!");
        }
    })

    $('#tabelaMovimento').on('click', '#btnAnexos', async function () {
        const data = $('#tabelaMovimento').DataTable().row($(this).parents('tr')).data();

        await abreModalAnexos(`${data.LANCAMENTO}.${data.DOCTO}.${data.CONTA}.${data.OPERACAO}`, data.LANCAMENTO, 'CC');
    })

    $('#tabelaMovimento').on('click', '#btn-excluir', async function () {
        if (permissaoUsuarioLogado.EXCLUI == 'S') {
            const data = $("#tabelaMovimento").DataTable().row($(this).parents("tr"));
            if ((data.LANC_CON != 0) && (data.LANC_CON != '') && (data.LANC_CON != null)) {
                msgAlerta('Impossível excluir, registro já conciliado!')
                return;
            }
            msgAlerta('Você realmente deseja excluir esse registro?', async () => {
                await excluiRegistro(data);
            });
        } else {
            msgAlertaSemConfirmacao("Sem permissão para excluir!");
        }
    })

    async function excluiRegistro(data) {
        try {
            $.LoadingOverlay("show");
            try {
                let valorLinha = data.data()
                const response = await requisicao("DELETE", "/sisplan/movimentobancario/v1/manutencao?", `LANCAMENTO=${valorLinha.LANCAMENTO}&DOCTO=${encodeURIComponent(valorLinha.DOCTO)}`, null);
                if (!response) {
                    return;
                }
                if (response.status != 200) {
                    let jsonStr = await response.json();
                    msgErro(jsonStr.mensagem);
                    return;
                }

                toastr.success("Exclusão efetuada com sucesso!", "Confirmação", {
                    toastClass: "success",
                    iconClasses: {
                        error: "alert-error",
                        info: "alert-info",
                        success: "alert-success",
                        warning: "alert-warning",
                    },
                    positionClass: "toast-top-center",
                    progressBar: true,
                    timeOut: 3000,
                    fadeOut: 1000,
                    onHidden() {
                        data.remove().draw(false);
                    },
                }).css({
                    "margin-top": "20%",
                    width: "500px",
                    "max-width": "500px",
                });

            } catch (error) {
                console.error(error);
            }
        } finally {
            $.LoadingOverlay("hide");
        }
    }

    $('#btnCompensar').on('click', async function () {
        $.LoadingOverlay('show')
        try {
            try {
                if ($('#dtCompensacao').val() == '') {
                    msgAlerta('Data de compensação não informada!')
                    return;
                }

                let possuiSel = false;
                $('#tabelaMovimento').DataTable().rows().every(function () {
                    const item = this.data()

                    if (item.SEL == 'S') {
                        possuiSel = true;
                    }
                })

                if (!possuiSel) {
                    msgAlerta('Nenhum registro selecionado!')
                    return;
                }

                msgAguardaConfirmacao('Deseja Compensar os Registros Selecionados?', async () => {
                    await realizaCompensacao()
                })
            } catch (error) {
                console.error(error)
            }
        } finally {
            $.LoadingOverlay('hide')
        }
    })

    async function realizaCompensacao() {
        $.LoadingOverlay('show')
        try {
            try {
                let lancCompensado = false

                $('#tabelaMovimento').DataTable().rows().every(function () {
                    const item = this.data()

                    if ((item.SEL == 'S') && (item.PENDENTE == 'N')) {
                        lancCompensado = true;
                    }
                })

                if (lancCompensado) {
                    msgAlerta('Existem lançamentos já compensados, favor verificar!');
                    return;
                }

                const classe = montaClasseMovimento()

                let response = await requisicao(
                    "POST",
                    "/sisplan/movimentobancario/v1/compensar?",
                    `JSON=${encodeURIComponent(JSON.stringify(classe))}`,
                    null
                );

                if (!response) {
                    $.LoadingOverlay("hide");
                    return;
                }

                let jsonStr = await response.json();
                if (response.status != 200) {
                    $.LoadingOverlay("hide");
                    msgErro(jsonStr.mensagem);
                    return;
                }
                $.LoadingOverlay("hide");
                toastr
                    .success(
                        `Registros compensados com sucesso!`,
                        "Confirmação",
                        {
                            toastClass: "alert",
                            iconClasses: {
                                error: "alert-error",
                                info: "alert-info",
                                success: "alert-success",
                                warning: "alert-warning",
                            },
                            positionClass: "toast-top-center",
                            progressBar: true,
                            timeOut: 5000,
                            fadeOut: 3000,
                            onHidden() {
                                window.location.href = `${BASE_URI}/movimentobancario`;
                            },
                        }
                    )
                    .css({
                        "margin-top": "20%",
                        width: "500px",
                        "max-width": "500px",
                    });

            } catch (error) {
                console.error(error)
            }
        } finally {
            $.LoadingOverlay('hide')
        }
    }

    function montaClasseMovimento() {
        const classe = {}
        classe.DTCOMPENSAR = $('#dtCompensacao').val()
        classe.REGISTROS = montaArrayMovimentos()

        return classe
    }

    function montaArrayMovimentos() {
        const arrayMov = []
        let novaRow = {}
        const tabela = $('#tabelaMovimento').DataTable().data().toArray()
        for (let i = 0; i < tabela.length; i++) {
            if (tabela[i].SEL == 'S') {
                novaRow = {}
                novaRow.LANCAMENTO = tabela[i].LANCAMENTO
                novaRow.HISTORICO = tabela[i].HISTORICO
                novaRow.DOCTO = tabela[i].DOCTO
                novaRow.CONTA = tabela[i].CONTA
                novaRow.VALOR = tabela[i].VALOR
                novaRow.DTLAN = tabela[i].DT_LAN
                novaRow.CLASSE = tabela[i].CLASSE
                novaRow.LANCCON = tabela[i].LANC_CON
                arrayMov.push(novaRow)
            }
        }

        return arrayMov
    }

    $('#btnEstCompensacao').on('click', async function () {
        $.LoadingOverlay('show')
        try {
            try {
                let possuiSel = false;
                $('#tabelaMovimento').DataTable().rows().every(function () {
                    const item = this.data()

                    if (item.SEL == 'S') {
                        possuiSel = true;
                    }
                })

                if (!possuiSel) {
                    msgAlerta('Nenhum registro selecionado!')
                    return;
                }

                msgAguardaConfirmacao('Deseja Estornar Compensação dos Registros Selecionados?', async () => {
                    await estornaCompensacao()
                })
            } catch (error) {
                console.error(error)
            }
        } finally {
            $.LoadingOverlay('hide');
        }
    })

    async function estornaCompensacao() {
        $.LoadingOverlay('show')
        try {
            try {
                let lancCompensado = false

                $('#tabelaMovimento').DataTable().rows().every(function () {
                    const item = this.data()

                    if ((item.SEL == 'S') && (item.PENDENTE == 'S')) {
                        lancCompensado = true;
                    }
                })

                if (lancCompensado) {
                    msgAlerta('Existem lançamentos em aberto. Impossível estornar!');
                    return;
                }

                if ($('#dtCompensacao').val() == '') {
                    $('#dtCompensacao').val('1200-01-01')
                }

                const classe = montaClasseMovimento()

                let response = await requisicao(
                    "POST",
                    "/sisplan/movimentobancario/v1/estornarcompensacao?",
                    `JSON=${encodeURIComponent(JSON.stringify(classe))}`,
                    null
                );

                if (!response) {
                    $.LoadingOverlay("hide");
                    return;
                }

                let jsonStr = await response.json();
                if (response.status != 200) {
                    $.LoadingOverlay("hide");
                    msgErro(jsonStr.mensagem);
                    return;
                }
                $.LoadingOverlay("hide");
                toastr
                    .success(
                        `Compensação estornada com sucesso!`,
                        "Confirmação",
                        {
                            toastClass: "alert",
                            iconClasses: {
                                error: "alert-error",
                                info: "alert-info",
                                success: "alert-success",
                                warning: "alert-warning",
                            },
                            positionClass: "toast-top-center",
                            progressBar: true,
                            timeOut: 5000,
                            fadeOut: 3000,
                            onHidden() {
                                window.location.href = `${BASE_URI}/movimentobancario`;
                            },
                        }
                    )
                    .css({
                        "margin-top": "20%",
                        width: "500px",
                        "max-width": "500px",
                    });

            } catch (error) {
                console.error(error)
            }
        } finally {
            $.LoadingOverlay('hide')
        }
    }

    $('#btnSaldoContas').on('click', async function () {
        $.LoadingOverlay('show')
        try {
            await SaldoContas()
        } catch (error) {
            console.error(error)
        } finally {
            $.LoadingOverlay('hide');
        }
    })

    $('#btnSaldoContas').on('click', async function () {
        try {
            $.LoadingOverlay('show');
            try {
                const url = `/sisplan/movimentobancario/v1/imprimirsaldo?`;
                const bImprimeAutomatico = await verificaImprimirAutomatico('');
                const arquivo = await GeraRelatorio(`${url}&`, 'GET', 100000, false, 'RelAcessoMovimentoBancario');
                if (arquivo != undefined) {
                    if (!bImprimeAutomatico) {
                        window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
                    }
                    await limparRelatorios();
                }

            } catch (error) {
                console.error(error);
            }
        } finally {
            $.LoadingOverlay('hide');
        }
    });

    $('#btnTransferencia').on('click', async function () {
        $('#modalTransferencia').modal('show');
    })

    $('#modalTransferencia').on('show.bs.modal', async function () {
        componenteFiltro('conta', false, false, 'ContaOrigemTransferencia', [`ATIVO = 'S'`])
        componenteFiltro('conta', false, false, 'ContaDestinoTransferencia', [`ATIVO = 'S'`])
        componenteFiltro('classe', false, false, 'ClasseGerCreditoTransferencia', [`TP_CONTA <> 'T'`])
        componenteFiltro('classe', false, false, 'ClasseGerDebitoTransferencia', [`TP_CONTA <> 'T'`])
        componenteFiltro('historico', false, false, 'HistoricoCreditoTransferencia')
        componenteFiltro('historico', false, false, 'HistoricoDebitoTransferencia')
        componenteFiltro('moeda', false, false, 'MoedaTransferencia')

        const dataAtual = retornaDataAtual()

        $('#dtLancamentoTransferencia').val(dataAtual)
        $('#dtContabilizaçãoTransferencia').val(dataAtual)
    })

    $('#txtDocumentoTransferencia').on('click', async function () {
        $.LoadingOverlay('show')
        try {
            if ($(this).val() == '') {
                await RetornaProximo('DOCTO', 'CONTABIL', 'DOCTO', 6)
            }
        } catch (error) {
            console.error(error)
            msgAlerta(error.message)
        } finally {
            $.LoadingOverlay('hide')
        }
    })

    $('#btnDesistirTransferencia').on('click', async function () {
        $('#modalTransferencia').modal('hide');
    })

    $('#btnConfirmarTransferencia').on('click', async function () {
        $.LoadingOverlay('show')
        try {
            await realizaTransferencia()
        } catch (error) {
            console.error(error)
            msgAlerta(error.message)
        } finally {
            $.LoadingOverlay('hide')
        }
    })

    $('#modalTransferencia').on('hidden.bs.modal', function () {
        $('#txtContaOrigemTransferencia').val('')
        $('#txtContaDestinoTransferencia').val('')
        $('#txtClasseGerCreditoTransferencia').val('')
        $('#txtHistoricoCreditoTransferencia').val('')
        $('#txtClasseGerDebitoTransferencia').val('')
        $('#txtHistoricoDebitoTransferencia').val('')
        $('#txtDocumentoTransferencia').val('')
        $('#txtValorTransferencia').val('')
        $('#dtLancamentoTransferencia').val('')
        $('#dtContabilizaçãoTransferencia').val('')
        $('#txtMoedaTransferencia').val('')
        $('#txtObsTransferencia').val('')
    })

    async function realizaTransferencia() {
        const objTransferencia = {
            CONTAORIGEM: pegaChave('#txtContaOrigemTransferencia'),
            CONTADESTINO: pegaChave('#txtContaDestinoTransferencia'),
            CLASSEGERCREDITO: pegaChave('#txtClasseGerCreditoTransferencia'),
            HISTORICOCREDITO: pegaChave('#txtHistoricoCreditoTransferencia'),
            CLASSEGERDEBITO: pegaChave('#txtClasseGerDebitoTransferencia'),
            HISTORICODEBITO: pegaChave('#txtHistoricoDebitoTransferencia'),
            DOCUMENTO: $('#txtDocumentoTransferencia').val(),
            VALOR: $('#txtValorTransferencia').val(),
            DTLANCAMENTO: $('#dtLancamentoTransferencia').val(),
            DTCONTABILIZACAO: $('#dtContabilizaçãoTransferencia').val(),
            MOEDA: pegaChave('#txtMoedaTransferencia'),
            OBS: $('#txtObsTransferencia').val()
        }

        const response = await requisicao("POST", "/sisplan/movimentobancario/v1/transferencia?", '', encodeURIComponent(JSON.stringify(objTransferencia)), 120000)

        if (!response || response.status != 200) {
            const jsonStr = await response?.json()
            if (jsonStr?.mensagem) {
                throw new Error(`${jsonStr.mensagem}`)
            }

            throw new Error('Erro ao realizar a transferência!')
        }

        criaMensagemSucesso('Tranferência realizada com sucesso!', async () => {
            $('#modalTransferencia').modal('hide')
        })
    }

    async function calculaSaldoInicial() {
        const url = '/sisplan/concilia/v1/consultasaldoini?';
        const filtros = `PERIODODE=${$('#dtContabilizacaoDe').val()}&CONTA=${pegaChave('#txtConta')}&EMPRESA=${getCookie("empresa")}&TIPO=''`;

        const response = await requisicao("GET", url, `${filtros}`, "", 360000);

        if (!response) {
            return;
        }

        const jsonStr = await response.json()
        if (response.status != 200) {
            msgErro(jsonStr['RESULT'][0].mensagem);
            return;
        }

        $('#txtSaldoInicial').val(jsonStr ? jsonStr.toLocaleString('pt-BR', { minimumFractionDigits: 2 }) : '0');

        return jsonStr;
    }

});