<?php include_once('../../../config.php') ?>

<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>Sisplan Web | Cadastro de Natureza</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="stylesheet" href="../dist/css/adminlte.min.css?versao=3.258.7.1">
    <link rel="stylesheet" href="../plugins/fontawesome-free/css/all.min.css?versao=3.258.7.1">
    <link href='https://fonts.googleapis.com/css?family=Roboto:400,300,500,600,700,400italic' rel='stylesheet' type='text/css'>
    <link rel="stylesheet" type="text/css" href="../dist/css/dataTables.bootstrap4.min.css?versao=3.258.7.1" />
    <link href='../dist/css/bootstrap.min.css?versao=3.258.7.1'>
    <link rel="stylesheet" href="../dist/css/custom.css?versao=3.258.7.1">
    <link rel="stylesheet" href="../dist/css/sisplan.css?versao=3.258.7.1">
    <link rel="stylesheet" href="../plugins/icheck-bootstrap/icheck-bootstrap.min.css?versao=3.258.7.1">
    <link rel="stylesheet" type="text/css" href="../plugins/datatables-keytable/css/keyTable.bootstrap4.min.css?versao=3.258.7.1">
    <link rel="stylesheet" type="text/css" href="../dist/css/responsive.bootstrap.min.css?versao=3.258.7.1">
    <link rel="shortcut icon" href="../favicon.ico">
    <link rel="stylesheet" href="../dist/css/cadastro.css?versao=3.258.7.1">
    <!-- Toastr -->
    <link rel="stylesheet" href="../plugins/toastr/toastr.min.css?versao=3.258.7.1">
    <link rel="stylesheet" type="text/css" href="../dist/css/driver.min.css?versao=3.258.7.1" />
    <link rel="stylesheet" href="../dist/css/jquery-ui.css?versao=3.258.7.1">
    <!-- Google Font: Source Sans Pro -->
    <link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700" rel="stylesheet">
    <style>
        #progressbar li {
            list-style-type: none;
            font-size: 12px;
            width: 33.33%;
            float: left;
            position: relative
        }

        .labelGeral {
            margin-top: 7px;
            margin-bottom: 3px;
        }

        .labelCheck {
            font-size: 120%;
            /* border-bottom: outset 2px;
            border-left: outset 2px; */
            padding: 0.2%;
            margin-left: 1%;
        }

        .configCheck {
            -ms-transform: scale(1.5);
            -moz-transform: scale(1.5);
            -webkit-transform: scale(1.5);
            -o-transform: scale(1.5);
            transform: scale(1.5);
            padding: 10px;
        }

        .radioTipo {
            font-size: 120%;
        }

        .bTipo {
            position: absolute;
            margin-bottom: 50%;
            font-size: 120%;
            font-weight: bolder;
        }

        .pTipo {
            margin-top: 2%;
            margin-left: -1%;
            margin-bottom: 0%;
        }

        .pCartao {
            margin-left: -1%;
            margin-bottom: 0%;
            margin-top: 2%;
        }

        .valMin {
            margin-top: 2%;
        }

        .frete {
            margin-left: 0.1%;
        }

        #contas-wrap {
            margin-top: 0%;
        }

        #labelcontas {
            margin-top: 2%;
        }

        .radioTop {
            margin-left: 2%;
            margin-top: 2%;
        }

        .labelFonte {
            font-size: 100%;
            margin-top: 20%;
        }

        .radiosStyle {
            margin-top: 2%;
            padding: 1%;
            border: solid #e0e4e6;
            border-radius: 4px;
            border-width: 2px;
            margin-left: 0%;
        }

        .checkboxMoeda {
            border: solid #e0e4e6;
            border-radius: 2px;
            border-width: 2px;
            padding-top: 1.6%;
            padding-bottom: 0%;
        }

        .border-Field .textoBorda {
            font-size: 1.1em !important;
            text-align: left !important;
            width: auto;
            padding: 0 10px;
            border-bottom: none;
        }

        .border-Field {
            border: 1px solid var(--font-color) !important;
            padding: 0 1.0em 1.0em 1.0em !important;
            padding: 0 0 1.0em 1.0em !important;
            margin: 0 0 1.0em 0 !important;
            -webkit-box-shadow: 0px 0px 0px 0px #000;
            box-shadow: 0px 0px 0px 0px #000;
            border-radius: 3px !important;
        }

        .icheck-primary {
            margin-bottom: 0px !important;
        }
    </style>
</head>

<body class="hold-transition sidebar-mini layout-fixed">
    <div class="wrapper">
        <?php
        ;
        ?>

        <div id="myModal" class="modal" tabindex="-1" role="dialog">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 id="myModalLabel" class="modal-title"></h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <p id="myModalText"></p>
                    </div>
                    <div class="modal-footer">
                        <button id="btnYes" type="button" class="btn btn-primary">Sim</button>
                        <button id="btnNo" type="button" class="btn btn-secondary" data-dismiss="modal">Não</button>
                    </div>
                </div>
            </div>
        </div>

        <div class="content-wrapper">
            <section class="content">
                <div class="content-header">
                    <div class="container-fluid">
                        <div class="row mb-2">
                            <div class="col-sm-6 flex">
                            </div>
                            <div class="col-sm-6">
                                <!-- <ol class="breadcrumb float-sm-right">
                                    
                                    <li class="breadcrumb-item"><a href="../natureza">Acesso Natureza</a></li>
                                    <li class="breadcrumb-item active">Cadastro de Natureza</li>
                                </ol> -->
                            </div><!-- /.col -->
                        </div><!-- /.row -->
                    </div>
                    <div class="row justify-content-center mt-0">
                        <div class="col-10 text-center p-0 mt-3 mb-2">
                            <div class="card px-0 pt-4 pb-0 mt-3 mb-3">
                                <div class="card-header text-center flex" style="border: none!important;box-shadow:none!important;">
                                    <h2>Cadastro de Natureza
                                        <button type="button" class="btn btn-info btn-sm ml-2" title="Tutorial" style="color: white;" id="tutorial">
                                            <i class="fas fa-question-circle"></i>
                                        </button>
                                    </h2>
                                </div>
                                <div class="row">
                                    <div class="col-md-12 mx-0">
                                        <form id="msform">
                                            <!-- progressbar -->
                                            <ul id="progressbar">
                                                <li class="active" id="account"><strong>Geral</strong></li>
                                                <li id="personal"><strong>Configuração</strong></li>
                                                <li id="confirm"><strong>Empresas</strong></li>
                                            </ul> <!-- fieldsets -->
                                            <p>Preencha os dados e clique em avançar para realizar o cadastro da natureza</p>
                                            <fieldset>
                                                <div class="form-card" id="formcard1">
                                                    <h2 class="fs-title">Dados Gerais</h2>
                                                    <div class="row">
                                                        <div class="col-lg-3  col-12 form-group">
                                                            <label data-error="wrong" class="labelGeral" data-success="right" for="txtCodigo">Código *</label>
                                                            <input type="text" class="input-default focus form-control" id="txtCodigo" required aria-describedby="codError" name="txtCodigo" class="form-control" placeholder="Código da Natureza">
                                                        </div>
                                                        <div class="col-lg-6  col-12 form-group">
                                                            <label data-error="wrong" class="labelGeral" data-success="right" for="txtDesc">Descrição *</label>
                                                            <input type="text" class="input-default focus form-control" id="txtDesc" required aria-describedby="descError" name="txtDesc" class="form-control" placeholder="Descrição">
                                                        </div>
                                                        <div class="col-sm-3 form-group">
                                                            <label class="labelGeral" data-error="wrong" data-success="right" for="selectSaiEnt">Saída/Entrada *</label>
                                                            <select class="input-default focus form-control" data-dropdown-css-class="select2-danger" required aria-describedby="saientError" id="selectSaiEnt" class="custom-select focus">
                                                                <option value="">Selecione uma opção</option>
                                                                <option value="1">1 - Saída</option>
                                                                <option value="2">2 - Entrada</option>
                                                            </select>
                                                        </div>
                                                        <div class="col-sm-3 form-group">
                                                            <label class="labelGeral" data-error="wrong" data-success="right" for="selectTipo">Tipo *</label>
                                                            <select class="input-default focus form-control" data-dropdown-css-class="select2-danger" required aria-describedby="tipoError" id="selectTipo" class="custom-select focus">
                                                                <option value="">Selecione um tipo</option>
                                                                <option value="V">0 - Venda/Compra</option>
                                                                <option value="D">1 - Devolução</option>
                                                                <option value="R">2 - Remessa</option>
                                                                <option value="O">3 - Retorno</option>
                                                                <option value="C">4 - Consignação</option>
                                                                <option value="A">5 - Antecipação</option>
                                                                <option value="S">6 - Serviço</option>
                                                                <option value="E">7 - Energia/Telefonia</option>
                                                                <option value="B">8 - Bonificação</option>
                                                                <option value="P">9 - Patrimonio</option>
                                                                <option value="I">10 - Estorno/Imposto</option>
                                                            </select>
                                                        </div>
                                                        <div class="col-sm-3 form-group">
                                                            <label class="labelGeral" data-error="wrong" data-success="right" for="selectGeraDup">Gera Duplicata *</label>
                                                            <select class="input-default focus form-control" data-dropdown-css-class="select2-danger" required aria-describedby="geraError" id="selectGeraDup" class="custom-select focus">
                                                                <option value="">Selecione uma opção</option>
                                                                <option value="S">1 - Sim</option>
                                                                <option value="N">2 - Não</option>
                                                            </select>
                                                        </div>
                                                        <div class="col-sm-3 form-group form-group">
                                                            <label class="labelGeral" data-error="wrong" data-success="right" for="selectTipoNat">Tipo Natureza</label>
                                                            <select class="input-default focus form-control" data-dropdown-css-class="select2-danger" id="selectTipoNat" class="custom-select focus">
                                                                <option value="">Selecione um tipo</option>
                                                                <option value="N">0 - Nacional</option>
                                                                <option value="E">1 - Exportação</option>
                                                                <option value="F">2 - Frete</option>
                                                                <option value="I">3 - Importação</option>
                                                            </select>
                                                        </div>
                                                        <div class="col-sm-3 form-group">
                                                            <label class="labelGeral" data-error="wrong" data-success="right" for="selectNf">Finalidade NF *</label>
                                                            <select class="input-default focus form-control" data-dropdown-css-class="select2-danger" required aria-describedby="finalidadeError" id="selectNf" class="custom-select focus">
                                                                <option value="">Selecione uma opção</option>
                                                                <option value="1">1 - Normal</option>
                                                                <option value="2">2 - Complemento</option>
                                                                <option value="3">3 - Ajuste</option>
                                                                <option value="4">4 - Devolução de Mercadoria</option>
                                                            </select>
                                                        </div>
                                                        <div class="col-lg-3  col-12 form-group">
                                                            <label data-error="wrong" class="labelGeral" data-success="right" for="txtAliquota">% Alíquota *</label>
                                                            <input type="text" class="input-default focus form-control" id="txtAliquota" required aria-describedby="alqerror" name="txtAliquota" placeholder="Alíquota">
                                                        </div>
                                                        <div class="col-lg-3  col-12 form-group">
                                                            <label data-error="wrong" class="labelGeral" data-success="right" for="txtPercAjuste">% Ajuste</label>
                                                            <input type="text" class="input-default focus form-control" id="txtPercAjuste" name="txtPercAjuste" placeholder="Percentual Ajuste">
                                                        </div>
                                                        <div class="col-lg-3  col-12 form-group">
                                                            <label data-error="wrong" class="labelGeral" data-success="right" for="txtPercReducao">% Redução CST ICMS</label>
                                                            <input type="text" class="input-default focus form-control" id="txtPercReducao" name="txtPercReducao" placeholder="Redução CST ICMS">
                                                        </div>
                                                        <div class="col-lg-3  col-12 form-group">
                                                            <label data-error="wrong" class="labelGeral" data-success="right" for="txtPercDife">% Diferimento CST ICMS</label>
                                                            <input type="text" class="input-default focus form-control" id="txtPercDife" name="txtPercDife" placeholder="Diferimento CST ICMS">
                                                        </div>
                                                        <div class="col-lg-4  col-12 form-group">
                                                            <label data-error="wrong" class="labelGeral" data-success="right" for="txtCstIcms">CST ICMS</label>
                                                            <div class="input-group">
                                                                <input type="text" class="input-default focus form-control" id="txtCstIcms" name="txtCstIcms" placeholder="CST ICMS">
                                                                <div class="input-group-append">
                                                                    <button class="btn bg-danger" id="btnCstIcms" name="btnCstIcms" data-button="absolute" type="button">
                                                                        <i class="m-0 p-0 fas fa-search"></i>
                                                                    </button>
                                                                    <button class="btn bg-danger" id="btnACstIcms" type="button">
                                                                        <i class="m-0 p-0 fas fa-trash"></i>
                                                                    </button>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="col-lg-4  col-12 form-group">
                                                            <label data-error="wrong" class="labelGeral" data-success="right" for="txtCsosn">CSOSN</label>
                                                            <div class="input-group">
                                                                <input type="text" class="input-default focus form-control" id="txtCsosn" name="txtCsosn" placeholder="CSOSN">
                                                                <div class="input-group-append">
                                                                    <button class="btn bg-danger" id="btnCsosn" name="btnCsosn" data-button="absolute" type="button">
                                                                        <i class="m-0 p-0 fas fa-search"></i>
                                                                    </button>
                                                                    <button class="btn bg-danger" id="btnACsosn" type="button">
                                                                        <i class="m-0 p-0 fas fa-trash"></i>
                                                                    </button>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="col-lg-4  col-12 form-group">
                                                            <label data-error="wrong" class="labelGeral" data-success="right" for="txtCstPis">CST PIS</label>
                                                            <div class="input-group">
                                                                <input type="text" class="input-default focus form-control" id="txtCstPis" name="txtCstPis" placeholder="CST PIS">
                                                                <div class="input-group-append">
                                                                    <button class="btn bg-danger" id="btnCstPis" name="btnCstPis" data-button="absolute" type="button">
                                                                        <i class="m-0 p-0 fas fa-search"></i>
                                                                    </button>
                                                                    <button class="btn bg-danger" id="btnACstPis" type="button">
                                                                        <i class="m-0 p-0 fas fa-trash"></i>
                                                                    </button>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="col-lg-4  col-12 form-group">
                                                            <label data-error="wrong" class="labelGeral" data-success="right" for="txtCstCofins">CST COFINS</label>
                                                            <div class="input-group">
                                                                <input type="text" class="input-default focus form-control" id="txtCstCofins" name="txtCstCofins" class="form-control" placeholder="CST COFINS">
                                                                <div class="input-group-append">
                                                                    <button class="btn bg-danger" id="btnCstCofins" name="btnCstCofins" data-button="absolute" type="button">
                                                                        <i class="m-0 p-0 fas fa-search"></i>
                                                                    </button>
                                                                    <button class="btn bg-danger" id="btnACstCofins" type="button">
                                                                        <i class="m-0 p-0 fas fa-trash"></i>
                                                                    </button>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="col-lg-4  col-12 form-group">
                                                            <label data-error="wrong" class="labelGeral" data-success="right" for="txtNcm">Código NCM</label>
                                                            <div class="input-group">
                                                                <input type="text" class="input-default focus form-control" id="txtNcm" name="txtNcm" placeholder="Código NCM">
                                                                <div class="input-group-append">
                                                                    <button class="btn bg-danger" id="btnNcm" name="btnNcm" data-button="absolute" type="button">
                                                                        <i class="m-0 p-0 fas fa-search"></i>
                                                                    </button>
                                                                    <button class="btn bg-danger" id="btnANcm" type="button">
                                                                        <i class="m-0 p-0 fas fa-trash"></i>
                                                                    </button>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="col-lg-4  col-12">
                                                            <label data-error="wrong" class="labelGeral" data-success="right" for="txtCstIpi">CST IPI</label>
                                                            <div class="input-group form-group">
                                                                <input type="text" class="input-default focus form-control" id="txtCstIpi" name="txtCstIpi" placeholder="CST IPI">
                                                                <div class="input-group-append">
                                                                    <button class="btn bg-danger" id="btnCstIpi" name="btnCstIpi" data-button="absolute" type="button">
                                                                        <i class="m-0 p-0 fas fa-search"></i>
                                                                    </button>
                                                                    <button class="btn bg-danger" id="btnACstIpi" type="button">
                                                                        <i class="m-0 p-0 fas fa-trash"></i>
                                                                    </button>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="col-lg-4  col-12 form-group">
                                                            <label data-error="wrong" class="labelGeral" data-success="right" for="txtEnqIpi">Enquadramento IPI</label>
                                                            <div class="input-group">
                                                                <input type="text" class="input-default focus form-control" id="txtEnqIpi" name="txtEnqIpi" placeholder="Enquadramento IPI">
                                                                <div class="input-group-append">
                                                                    <button class="btn bg-danger" id="btnEnqIpi" name="btnEnqIpi" data-button="absolute" type="button">
                                                                        <i class="m-0 p-0 fas fa-search"></i>
                                                                    </button>
                                                                    <button class="btn bg-danger" id="btnAEnqIpi" type="button">
                                                                        <i class="m-0 p-0 fas fa-trash"></i>
                                                                    </button>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="col-lg-4  col-12 form-group">
                                                            <label data-error="wrong" class="labelGeral" data-success="right" for="txtContabilizacao">Contabilização
                                                            </label>
                                                            <div class="input-group">
                                                                <input type="text" class="input-default focus form-control" id="txtContabilizacao" name="txtContabilizacao" placeholder="Contabilização">
                                                                <div class="input-group-append">
                                                                    <button class="btn bg-danger" id="btnConsultaContabil" name="btnConsultaContabil" data-button="absolute" type="button">
                                                                        <i class="m-0 p-0 fas fa-search"></i>
                                                                    </button>
                                                                    <button class="btn bg-danger" id="btnLimpaConsultaContabil" type="button">
                                                                        <i class="m-0 p-0 fas fa-trash"></i>
                                                                    </button>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="col-lg-4 col-4 form-group input-group">
                                                            <label data-error="wrong" data-success="right" for="selectMotDeson">Motivo desoneração ICMS</label>
                                                            <select style="width:100%;" class="form-control select2 select2-danger focus" data-dropdown-css-class="select2-danger" id="selectMotDeson" class="custom-select focus">
                                                                <option value="0" selected>Nenhum</option>
                                                                <option value="1">Táxi</option>
                                                                <option value="3">Produtor agropecuário</option>
                                                                <option value="4">Frotista/Locadora</option>
                                                                <option value="5">Diplomático/Consular</option>
                                                                <option value="6">Utilitários e Motocicletas da Amazônia Ocidental e Áreas de Livre Comércio</option>
                                                                <option value="7">SUFRAMA</option>
                                                                <option value="8">Venda a Órgão Público</option>
                                                                <option value="9">Outros</option>
                                                                <option value="10">Deficiente Condutor</option>
                                                                <option value="11">Deficiente Não Conduto</option>
                                                                <option value="12">Órgão de fomento e Desenvolvimento Regional</option>
                                                                <option value="16">Olimpíadas Rio 2016</option>
                                                                <option value="90">Outros (usado quando não se encaixa nos demais)</option>
                                                                </option>
                                                            </select>
                                                        </div>
                                                        <div class="col-lg-3 col-12 from-group">
                                                            <label for="txtSerie">Série</label>
                                                            <input type="text" class="input-default focus form-control" id="txtSerie" name="txtSerie" placeholder="Série">
                                                        </div>
                                                        <div class="col-lg-3 col-12 from-group">
                                                            <label for="txtPercCredPres">% Crédito presumido</label>
                                                            <input type="text" class="input-default focus form-control" id="txtPercCredPres" name="txtPercCredPres" placeholder="% Crédito presumido">
                                                        </div>
                                                        <div class="col-lg-3 col-12 from-group">
                                                            <label for="txtCodBenefCred">Cód. benef. crédito</label>
                                                            <input type="text" class="input-default focus form-control" id="txtCodBenefCred" name="txtCodBenefCred" placeholder="Cód. benef. crédito">
                                                        </div>
                                                        <div class="col-lg-3 col-12 from-group">
                                                            <label for="txtCod_Benef">Código Benefício Fiscal</label>
                                                            <input type="text" class="input-default focus form-control" id="txtCod_Benef" name="txtCod_Benef" placeholder="Código Benefício Fiscal">
                                                        </div>
                                                        <div class="col-lg-12  col-12 form-group" style="margin-top: 0.5rem">
                                                            <label data-error="wrong" class="labelGeral" data-success="right" for="txtMsg">Mensagem</label>
                                                            <input type="text" class="input-default focus form-control" id="txtMsg" name="txtMsg" class="form-control" placeholder="Mensagem">
                                                        </div>
                                                    </div>
                                                </div>
                                                <input type="button" name="next" class="btn-sisp next action-button" value="Avançar" id="avancar1" />
                                                <button type="button" id="btnVoltar" style="font-size:15px;" class="btn-sisp action-button-previous" data-dismiss="modal">Voltar</button>
                                            </fieldset>
                                            <fieldset>
                                                <div class="form-card">
                                                    <h2 class="fs-title">Configuração da natureza</h2>
                                                    <div class="row" id="configuracao">
                                                        <label class="labelGeral" style="font-size: 116%; margin-top: 3.2%;" data-error="wrong" data-success="right"></label>
                                                        <fieldset class="form border-Field col-lg-6 col-12">
                                                            <legend class="textoBorda pt-0 mb-0" style="font-size: 1.25em !important;">Opções</legend>
                                                            <div class="icheck-primary"><input type="checkbox" class="configCheck" id="checkAtivo"> <label class="labelCheck" for="checkAtivo">Ativo</label></div>
                                                            <div class="icheck-primary"><input type="checkbox" class="configCheck" id="checkNaoGeraDifal"><label class="labelCheck" for="checkNaoGeraDifal"> Não Gerar DIFAL</label></div>
                                                            <div class="icheck-primary"><input type="checkbox" class="configCheck" id="checkForcaDeVendas"><label class="labelCheck" for="checkForcaDeVendas">Força de Vendas</label></div>
                                                            <div class="icheck-primary"><input type="checkbox" class="configCheck" id="checkBaixarPedido"><label class="labelCheck" for="checkBaixarPedido"> Baixar Pedido</label></div>
                                                            <div class="icheck-primary"><input type="checkbox" class="configCheck" id="checkPisCofins"><label class="labelCheck" for="checkPisCofins"> PIS / COFINS</label></div>
                                                            <div class="icheck-primary"><input type="checkbox" class="configCheck" id="checkSubstituicaoTrib"><label class="labelCheck" for="checkSubstituicaoTrib"> Substituição Tributaria</label></div>
                                                            <div class="icheck-primary"><input type="checkbox" class="configCheck" id="checkMovEstoque"><label class="labelCheck" for="checkMovEstoque"> Movimenta Estoque</label></div>
                                                            <div class="icheck-primary"><input type="checkbox" class="configCheck" id="checkFci"><label class="labelCheck" for="checkFci"> FCI (Ficha Conteúdo Importação)</label></div>
                                                            <div class="icheck-primary"><input type="checkbox" class="configCheck" id="checkInfoImpor"><label class="labelCheck" for="checkInfoImpor">Informações de Importação.</label></div>
                                                            <div class="icheck-primary"><input type="checkbox" class="configCheck" id="checkLaudoTec"><label class="labelCheck" for="checkLaudoTec"> Laudo Técnico</label></div>
                                                            <div class="icheck-primary"><input type="checkbox" class="configCheck" id="checkFichaSeguranca"><label class="labelCheck" for="checkFichaSeguranca"> Ficha de Segurança</label></div>
                                                            <div class="icheck-primary"><input type="checkbox" class="configCheck" id="checkManterPercIcms"><label class="labelCheck" for="checkManterPercIcms"> Manter Perc ICMS Ret Ind. de insumos no processo produtivo</label></div>
                                                            <div class="icheck-primary"><input type="checkbox" class="configCheck" id="checkRomaneio"><label class="labelCheck" for="checkRomaneio"> Romaneio</label></div>
                                                            <div class="icheck-primary"><input type="checkbox" class="configCheck" id="checkDescIcmsBase"><label class="labelCheck" for="checkDescIcmsBase"> Descontar ICMS na Base Pis-Cofins.</label></div>
                                                            <div class="icheck-primary"><input type="checkbox" class="configCheck" id="checkBloqAbaGeral"><label class="labelCheck" for="checkBloqAbaGeral"> Bloqueia Aba (Geral)</label></div>
                                                            <div class="icheck-primary"><input type="checkbox" class="configCheck" id="checkBloqAbaServ"><label class="labelCheck" for="checkBloqAbaServ">Bloqueia Aba (Serviços/Retenção)</label></div>
                                                            <div class="icheck-primary"><input type="checkbox" class="configCheck" id="checkObrigarOrdemCompra"><label class="labelCheck" for="checkObrigarOrdemCompra"> Obrigar Ordem de Compra</label></div>
                                                            <div class="icheck-primary"><input type="checkbox" class="configCheck" id="checkObrigarClienteConta"><label class="labelCheck" for="checkObrigarClienteConta"> Obrigar Cliente Conta e Ordem (Entrada NF).</label></div>
                                                            <div class="icheck-primary"><input type="checkbox" class="configCheck" id="checkObrigarInfLote"><label class="labelCheck" for="checkObrigarInfLote"> Obrigar Informar Lote com estoque (Fat Simples)</label></div>
                                                            <div class="icheck-primary"><input type="checkbox" class="configCheck" id="checkObrigarInfVol"><label class="labelCheck" for="checkObrigarInfVol"> Obrigar Informar Volumes (Entrada NF)</label></div>
                                                            <div class="icheck-primary"><input type="checkbox" class="configCheck" id="checkControleEstTerc"><label class="labelCheck" for="checkControleEstTerc"> Controle Estoque Terceiro</label></div>
                                                            <div class="icheck-primary"><input type="checkbox" class="configCheck" id="checkRegEspTrib"><label class="labelCheck" for="checkRegEspTrib"> Regime Especial de Tributação (RET)</label></div>
                                                            <div class="icheck-primary"><input type="checkbox" class="configCheck" id="checkConsPrecoSug"><label class="labelCheck" for="checkConsPrecoSug"> Considerar Preço Sugerido para base ST</label></div>
                                                            <div class="icheck-primary"><input type="checkbox" class="configCheck" id="checkAplicaDesc"><label class="labelCheck" for="checkAplicaDesc"> Aplica desconto</label></div>
                                                            <div class="icheck-primary"><input type="checkbox" class="configCheck" id="checkCalculoIcmsDifal"><label class="labelCheck" for="checkCalculoIcmsDifal"> Fazer Cálculo ICMS DIFAL por dentro (NORMA EC 87/2015)</label></div>
                                                            <div class="icheck-primary"><input type="checkbox" class="configCheck" id="checkObrigaroAssociarRetorno"><label class="labelCheck" for="checkObrigaroAssociarRetorno"> Obrigar associar retorno de industrialização na NFE</label></div>
                                                            <div class="icheck-primary"><input type="checkbox" class="configCheck" id="checkObrigarInfNota"><label class="labelCheck" for="checkObrigarInfNota"> Obrigar informar nota referenciada</label></div>
                                                            <div class="icheck-primary"><input type="checkbox" class="configCheck" id="checkCalcCredPre"><label class="labelCheck" for="checkCalcCredPre"> Realizar cálculo de crédito presumido</label></div>
                                                        </fieldset>

                                                        <div class="radioTipo col-lg-6 col-12">
                                                            <div class="frete">
                                                                <div class="">
                                                                    <div>
                                                                        <fieldset class="form border-Field col d-md-flex d-block">
                                                                            <legend class="textoBorda pt-0 mb-0">Tributação ICMS</legend>
                                                                            <!-- <div class="radiosStyle radioTop"> -->
                                                                            <div class="icheck-primary mr-3"><input type="radio" checked="checked" id="radioBaseIcms" name="tribicms"> <label for="radioBaseIcms">Base ICMS</label></div>
                                                                            <div class="icheck-primary mr-3"><input type="radio" id="radioIsentaIcms" name="tribicms"><label for="radioIsentaIcms">Isentas ICMS</label></div>
                                                                            <div class="icheck-primary mr-3"><input type="radio" id="radioOutraIcms" name="tribicms"> <label for="radioOutraIcms">Outras ICMS </label></div>
                                                                            <!-- </div> -->
                                                                        </fieldset>
                                                                    </div>

                                                                    <div>
                                                                        <!-- <div class="radiosStyle radioTop"> -->
                                                                        <fieldset class="form border-Field col d-md-flex d-block">
                                                                            <legend class="textoBorda pt-0 mb-0">Tributação IPI</legend>
                                                                            <!-- <div class="radiosStyle radioTop"> -->
                                                                            <div class="icheck-primary mr-3"><input type="radio" checked="checked" id="radioBaseIpi" name="tribipi"> <label for="radioBaseIpi">Base IPI</label></div>
                                                                            <div class="icheck-primary mr-3"><input type="radio" id="radioIsentaIpi" name="tribipi"><label for="radioIsentaIpi">Isentas IPI</label></div>
                                                                            <div class="icheck-primary mr-3"><input type="radio" id="radioOutraIpi" name="tribipi"><label for="radioOutraIpi">Outras IPI</label></div>
                                                                            <!-- </div> -->
                                                                        </fieldset>
                                                                        <!-- </div> -->
                                                                    </div>
                                                                </div>
                                                            </div>

                                                        </div>

                                                    </div>
                                                    <div class="frete row">

                                                    </div>
                                                </div>
                                                <input type="button" name="next" class="btn-sisp next action-button" value="Avançar" id="avancar2" />
                                                <input type="button" name="previous" class="btn-sisp previous action-button-previous" value="Voltar" id="voltar3" />
                                            </fieldset>
                                            <fieldset>
                                                <div class="form-card">
                                                    <h2 class="fs-title">Empresas da natureza</h2>
                                                    <div class="row" id="configuracao">

                                                        <div class="col-md-12 col-12 table-responsive">
                                                            <table id="tabela-empAcesso" class="table table-sm table-hover table-select table-condensed">
                                                                <thead>
                                                                    <tr>
                                                                        <th>Sel</th>
                                                                        <th>Empresa</th>
                                                                    </tr>
                                                                </thead>
                                                                <tbody>
                                                                </tbody>
                                                            </table>
                                                        </div>

                                                    </div>
                                                </div>
                                                <input type="button" name="gravar" class="btn-sisp next action-button" value="Gravar" id="gravar">
                                                <input type="button" name="previous" class="btn-sisp previous action-button-previous" value="Voltar" id="voltar4" />
                                            </fieldset>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>

    <?php
    include_once('../../../modais.php');
    ?>

    <!-- Control Sidebar -->
    <aside class="control-sidebar control-sidebar-dark">
        <!-- Control sidebar content goes here -->
    </aside>
    <!-- /.control-sidebar -->
    </div>

    <!-- jQuery -->
    <script src="../plugins/jquery/jquery.min.js?versao=3.258.7.1"></script>
    <script src="../plugins/jquery-ui/jquery-ui.min.js?versao=3.258.7.1"></script>
    <script type="text/javascript" src="../dist/js/jquery.dataTables.js?versao=3.258.7.1"></script>
    <script type="text/javascript" src="../dist/js/dataTables.bootstrap4.min.js?versao=3.258.7.1"></script>
    <!-- SweetAlert2 -->
    <script src="../plugins/sweetalert2/sweetalert2.min.js?versao=3.258.7.1"></script>
    <script src="../plugins/toastr/toastr.min.js?versao=3.258.7.1"></script>

    <!-- Resolve conflict in jQuery UI tooltip with Bootstrap tooltip -->
    <script>
        $.widget.bridge('uibutton', $.ui.button);
    </script>

    <script src="../plugins/bootstrap/js/bootstrap.bundle.min.js?versao=3.258.7.1"></script>
    <script src="../dist/js/adminlte.min.js?versao=3.258.7.1"></script>
    <script src="../dist/js/requisicoes.js?versao=3.258.7.1"></script>
    <script src="../dist/js/cliente/entidade.js?versao=3.258.7.1"></script>
    <script src="../dist/js/loadingoverlay.min.js?versao=3.258.7.1"></script>
    <script src="../dist/js/valida_cpf_cnpj.js?versao=3.258.7.1"></script>
    <script src="../plugins/jquery-validation/jquery.validate.min.js?versao=3.258.7.1"></script>
    <script src="../dist/js/sisplan.js?versao=3.258.7.1"></script>
    <script src="../utils/funcoes.js?versao=3.258.7.1"></script>
    <script src="../utils/cookies.js?versao=3.258.7.1"></script>
    <script src="../dist/js/driver.min.js?versao=3.258.7.1"></script>
    <script src="../dist/js/jquery.maskMoney.min.js?versao=3.258.7.1"></script>
    <script src="../dist/js/jquery.mask.min.js?versao=3.258.7.1"></script>
    <script src="../dist/js/dataTables.keyTable2.js?versao=3.258.7.1"></script>
    <script type="text/javascript" src="../config.js?versao=3.258.7.1"></script>
    <script>
        $(document).ready(async function() {
            if (getCookie('usuario') == "") {
                window.location.href = `${BASE_URI}/login`;
                return;
            }

            let usuario = getCookie('usuario');
            let empresa = getCookie('empresa');

            ipInterno = IP_INTERNO;
            ipExterno = IP_EXTERNO;
            basicAuth = BASIC_AUTH;

            const temAcesso = await temAcessoTela('NATUREZA');
            if (!temAcesso.resultado) {
                toastrAcesso(temAcesso, BASE_URI);
                return;
            }

            const permissaoUsuarioLogado = await permissaoAcessos("NATUREZA");

            if (permissaoUsuarioLogado.INCLUI == 'N') {
                await criaMensagemErro("Sem permissão para incluir!", () => {
                    window.location.href = `${BASE_URI}/natureza`
                });
                return;
            }

            //código para liberar registro ao sair da tela clicando no menu, breadcrumb
            // const queryString = window.location.href;
            // const parametros = queryString.split('/');
            const natureza = atob($(window.location.href.split('/')).get(-1));

            $(window).on("beforeunload", function(e) {
                // e.preventDefault();
                e.stopPropagation();
                deletaRegistro('NATUREZA', getCookie('usuario'), natureza);
                return undefined;
            });

            sArquivo = `${BASE_URI}/pages/natureza/cadastro_natureza/natureza.js?versao=3.258.7.1`;
            insereJavaScriptPagina(sArquivo);

            const nomeTela = ('<?php echo basename(__FILE__) ?>').replace('.php', '');
            habilitaCamposObrigatoriosTela(nomeTela);
        });
    </script>
</body>

</html>