<?php include_once('../../../config.php') ?>

<!DOCTYPE html>
<html>

<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Sisplan Web | Orçamento de Cortina</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link rel="stylesheet" href="plugins/fontawesome-free/css/all.min.css?versao=3.258.7.1">
  <link rel="stylesheet" href="dist/css/adminlte.min.css?versao=3.258.7.1">
  <link href='https://fonts.googleapis.com/css?family=Roboto:400,300,500,600,700,400italic' rel='stylesheet' type='text/css'>
  <link rel="stylesheet" href="dist/css/custom.css?versao=3.258.7.1">
  <link rel="stylesheet" href="dist/css/sisplan.css?versao=3.258.7.1">
  <link rel="stylesheet" type="text/css" href="dist/css/dataTables.bootstrap4.min.css?versao=3.258.7.1" />
  <link rel="shortcut icon" href="favicon.ico">
  <link rel="stylesheet" href="plugins/toastr/toastr.min.css?versao=3.258.7.1">
  <link rel="stylesheet" type="text/css" href="dist/css/driver.min.css?versao=3.258.7.1" />
  <link rel="stylesheet" href="dist/css/PesquisaVariosSelect2.css?versao=3.258.7.1">
  <link rel="stylesheet" href="plugins/select2/css/select2.min.css?versao=3.258.7.1">
  <link rel="stylesheet" href="plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css?versao=3.258.7.1">
  <link rel="stylesheet" href="dist/css/jquery-ui.css?versao=3.258.7.1">
  <link rel="stylesheet" href="plugins/datatables-colreorder/css/colReorder.bootstrap4.min.css?versao=3.258.7.1">

  <style>
    .form-check {
      margin-left: 8px;
      margin-bottom: 10px;
    }

    .border-Field .textoBorda {
      font-size: 1.1em !important;
      text-align: left !important;
      width: auto;
      padding: 0 10px;
      border-bottom: none;
    }

    .border-Field {
      border: 1px solid var(--font-color) !important;
      padding: 0 0.5em 0 0.5rem !important;
      margin: 0 0 1.0em 0 !important;
      -webkit-box-shadow: 0px 0px 0px 0px #000;
      box-shadow: 0px 0px 0px 0px #000;
      border-radius: 3px !important;
    }

    .icheck-primary {
      margin-top: 0px !important;
    }
  </style>
</head>

<body class="hold-transition sidebar-mini layout-fixed">
  <div class="wrapper">

    <div class="content-wrapper">
      <div class="content-header">
        <div class="container-fluid">
          <div class="row mb-2">
            <div class="col-sm-6 flex">
              <h1 class="m-0 text-dark">Orçamento de Cortina</h1>
            </div>
            <div class="col-sm-6">

            </div>
          </div>
        </div>
        <div class="container-fluid">
          <div class="row card">
            <div class="col-sm-12 mt-3">
              <button class="btn btn-success btn-sisp" id="btnFiltros" type="button"><span class="fas fa-filter"></span> Filtros</button>
              <button class="btn btn-danger btn-sisp" id="btnIncluir"><span class="fas fa-plus"></span> Incluir</button>
              <button class="btn btn-secondary btn-sisp" id="btnImprimir" data-toggle="modal"><i class="fas fa-print"></i> Imprimir</button>
            </div>
            <div class="col-sm-12 table-responsive card-body">
              <h5>Lista de Orçamentos</h5>
              <table id="tabelaOrcamento" class="table table-sm table-select table-hover" style="white-space: nowrap" width="100%">
                <thead>
                </thead>
                <tbody>
                </tbody>
              </table>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>

  <div id="modal-filtros" class="modal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-xl" role="document">
      <div class="modal-content" id="modalBody">
        <div class="modal-header">
          <h4 class="modal-title">Filtros</h4>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body pb-0">
          <div>

            <div class="form-row" id="divRelAnalise">

              <div class="form-group col-4 mb-0">
                <div class="">
                  <label for="">Digitação de/até:</label>
                  <div class="input-group">
                    <input type="date" max="2500-12-31" max="2500-12-31" class="input-default focus form-control validate" id="txtDtDigitacaoI" name="DataDe">
                    <input type="date" max="2500-12-31" max="2500-12-31" class="input-default focus form-control validate" id="txtDtDigitacaoF" name="DataAte">
                  </div>
                </div>
              </div>

              <div class="form-group col-4 mb-0">
                <div class="">
                  <label for="">Entrega de/até:</label>
                  <div class="input-group">
                    <input type="date" max="2500-12-31" max="2500-12-31" class="input-default focus form-control validate" id="txtDtEntregaI" name="DataDe">
                    <input type="date" max="2500-12-31" max="2500-12-31" class="input-default focus form-control validate" id="txtDtEntregaF" name="DataAte">
                  </div>
                </div>
              </div>

              <div class="col-md-4 col-12 mt-4 px-2 py-1 mb-3 mb-md-0">
                <button class="btn btn-danger btn-sisp w-100" type='button' id="btnSelecionarEmpresas">Selecionar Empresas</button>
              </div>


              <div class="form-group col-lg-4 col-12 col-sm-12">
                <label data-error="wrong" data-success="right" for="txtNumero">Número: </label>
                <div class="relative">
                  <div class="input-group">
                    <select class="js-example-programmatic js-states form-control" id="txtNumero" name="txtNumero" multiple="multiple">
                    </select>
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnNumero" name="btnNumero" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btnLimpaNumero" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
              </div>

              <div class="form-group col-lg-4 col-12 col-sm-12">
                <label data-error="wrong" data-success="right" for="txtCliente">Cliente: </label>
                <div class="relative">
                  <div class="input-group">
                    <select class="js-example-programmatic js-states form-control" id="txtCliente" name="txtCliente" multiple="multiple">
                    </select>
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnCliente" name="btnCliente" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btnLimpaCliente" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
              </div>

              <div class="form-group col-lg-4 col-12 col-sm-1 d-none" id="divRepresentante">
                <label data-error="wrong" data-success="right" for="txtRepresentante">Representante: </label>
                <div class="relative">
                  <div class="input-group">
                    <select class="js-example-programmatic js-states form-control" id="txtRepresentante" name="txtRepresentante" multiple="multiple">
                    </select>
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnRepresentante" name="btnRepresentante" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btnLimpaRepresentante" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
        <div class="modal-footer justify-content-end pl-0">
          <!-- <div class="row col-12"> -->
            <div class="row col-12 col-lg-8 d-flex justify-content-end align-items-end">
              <div class="col-md-6 col-sm-12 col-6">
                <label for="txtOrdem">Opção de Relatório:</label>
                <div class="relative d-flex align-items-center">
                  <select id="txtOrdem" class="input-default focus custom-select">
                  </select>
                  <button class="btn btn-sm btn-success ml-2 btnEdicaoRelatorio" title="Edição de ordenações">
                    <i class="fas fa-check"></i>
                  </button>
                </div>
              </div>
              <div class="col-md-6 col-sm-12 col-6" id="ordemRelatorioIndividual">
                <label for="txtOrdemIndividual">Opção de Relatório Individual:</label>
                <div class="relative d-flex align-items-center">
                  <select id="txtOrdemIndividual" class="input-default focus custom-select">
                  </select>
                  <button class="btn btn-sm btn-success ml-2 btnEdicaoRelatorio" title="Edição de ordenações">
                    <i class="fas fa-check"></i>
                  </button>
                </div>
              </div>
            </div>
            <div class="col-12 col-lg-4 d-flex justify-content-end align-items-end pr-0">
              <div class="d-flex">
                <button class="btn btn-primary btn-sisp mr-2" id="btnLimparFiltros" style="background-color: #B22222; border-color: #B22222">
                  <span class="fas fa-trash"></span> Limpar Filtros
                </button>
                <button id="btnConsultar" class="btn btn-primary btn-sisp" type="button">
                  <span class="fas fa-search"></span> Consultar
                </button>
              </div>
            </div>
          <!-- </div> -->
        </div>
      </div>

    </div>

  </div>
  <div id="modalDuplicar" class="modal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-sm" role="document">
      <div class="modal-content" id="modalBody">
        <div class="modal-header">
          <h4 class="modal-title">Duplicar Orçamento</h4>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>

        <div class="modal-body pb-0">
          <div class="form-group">
            <label data-error="wrong" data-success="right" for="txtAntigoNumero">Número: </label>
            <div class="relative">
              <div class="input-group">
                <input type="text" class="input-default focus form-control form-control" disabled id="txtAntigoNumero" name="txtAntigoNumero" placeholder="Número">
              </div>
            </div>
          </div>
          <div class="form-group">
            <label data-error="wrong" data-success="right" for="txtNovoNumero">Novo Número: </label>
            <div class="relative">
              <div class="input-group">
                <input type="text" class="input-default focus form-control form-control" id="txtNovoNumero" name="txtNovoNumero" placeholder="Novo Número">
              </div>
            </div>
          </div>

        </div>
        <div class="modal-footer border-top d-flex justify-content-end align-items-end">
          <div class="mx-auto mx-md-0">
            <button id="btnConfirmaDuplicar" class="btn btn-danger btn-sisp" type="button">Confirmar</button>
          </div>
        </div>
      </div>
    </div>
  </div>

  <div id="modalAntecipacao" class="modal" tabindex="-1" role="dialog" data-backdrop="static">
    <div class="modal-dialog modal-xl" role="document">
      <div class="modal-content" id="modalBody">
        <div class="modal-header">
          <h4 class="modal-title">Antecipação</h4>
          <button type="button" class="close" id="btnCloseAnte" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">

          <div class="row">

            <div class="col-2">
              <label data-error="wrong" data-success="right" for="txtPedidoAnte">Pedido: </label>
              <div class="input-group">
                <input disabled type="text" autocomplete="off" class="input-default focus form-control" id="txtPedidoAnte" name="txtPedidoAnte" class="form-control" placeholder="Pedido">
              </div>
            </div>

            <div class="col-2 d-none">
              <label data-error="wrong" data-success="right" for="txtOrcamentoAnte">Orcamento: </label>
              <div class="input-group">
                <input disabled type="text" autocomplete="off" class="input-default focus form-control" id="txtOrcamentoAnte" name="txtOrcamentoAnte" class="form-control" placeholder="Orcamento">
              </div>
            </div>

            <div class="col-5">
              <label data-error="wrong" data-success="right" for="txtClienteAnte">Cliente: </label>
              <div class="input-group">
                <input disabled type="text" autocomplete="off" class="input-default focus form-control" id="txtClienteAnte" name="txtClienteAnte" class="form-control" placeholder="Cliente">
              </div>
            </div>

            <div class="col-5">
              <label data-error="wrong" data-success="right" for="txtRepresenAnte">Representante: </label>
              <div class="input-group">
                <input disabled type="text" autocomplete="off" class="input-default focus form-control" id="txtRepresenAnte" name="txtRepresenAnte" class="form-control" placeholder="Representante">
              </div>
            </div>

          </div>
          <div class="row" style="margin-top: 1.2%;" style="margin-top: 1.2%;">

            <div class="col-sm-2">
              <label>Emissão: *</label>
              <div class="relative" id="DataEmissao">
                <input type="date" max="2500-12-31" autocomplete="off" class="input-default focus form-control validatel" id="txtDTemissao" name="txtDTemissao">
              </div>
            </div>

            <div class="col-sm-2">
              <label>Vencimento: *</label>
              <div class="relative">
                <input type="date" max="2500-12-31" autocomplete="off" class="input-default focus form-control validate" id="txtDTvencimento" name="txtDTvencimento">
              </div>
            </div>

            <div class="col-4">
              <label data-error="wrong" data-success="right" for="txtMoeda">Moeda: *</label>
              <div class="input-group">
                <input type="text" autocomplete="off" class="input-default focus form-control" id="txtMoeda" name="txtMoeda" class="form-control" placeholder="Moeda">
                <div class="input-group-append">
                  <button class="btn bg-danger" id="btn-Moeda" name="btn-Moeda" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                  <button class="btn bg-danger" id="btn-limpa-Moeda" name="btn-limpa-Moeda" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                </div>
              </div>
            </div>

            <div class="col-4">
              <label data-error="wrong" data-success="right" for="txtHistorico">Histórico: *</label>
              <div class="input-group">
                <input type="text" autocomplete="off" class="input-default focus form-control" id="txtHistorico" name="txtHistorico" class="form-control" placeholder="Histórico">
                <div class="input-group-append">
                  <button class="btn bg-danger" id="btn-Historico" name="btn-Historico" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                  <button class="btn bg-danger" id="btn-limpa-Historico" name="btn-limpa-Historico" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                </div>
              </div>
            </div>

          </div>
          <div class="row" style="margin-top: 1.2%;">

            <div class="col-4">
              <label data-error="wrong" data-success="right" for="txtClasseGer">Classe Gerencial: *</label>
              <div class="input-group">
                <input type="text" autocomplete="off" class="input-default focus form-control" id="txtClasseGer" name="txtClasseGer" class="form-control" placeholder="Classe Gerencial">
                <div class="input-group-append">
                  <button class="btn bg-danger" id="btn-ClasseGer" name="btn-ClasseGer" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                  <button class="btn bg-danger" id="btn-limpa-ClasseGer" name="btn-limpa-ClasseGer" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                </div>
              </div>
            </div>

            <div class="col-4">
              <label data-error="wrong" data-success="right" for="txtSituacao">Situação: *</label>
              <div class="input-group">
                <input type="text" autocomplete="off" class="input-default focus form-control" id="txtSituacao" name="txtSituacao" class="form-control" placeholder="Situação">
                <div class="input-group-append">
                  <button class="btn bg-danger" id="btn-Situacao" name="btn-Situacao" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                  <button class="btn bg-danger" id="btn-limpa-Situacao" name="btn-limpa-Situacao" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                </div>
              </div>
            </div>

            <div class="col-4">
              <label data-error="wrong" data-success="right" for="txtConta">Conta: *</label>
              <div class="input-group">
                <input type="text" autocomplete="off" class="input-default focus form-control" id="txtConta" name="txtConta" class="form-control" placeholder="Conta">
                <div class="input-group-append">
                  <button class="btn bg-danger" id="btn-Conta" name="btn-Conta" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                  <button class="btn bg-danger" id="btn-limpa-Conta" name="btn-limpa-Conta" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                </div>
              </div>
            </div>

          </div>
          <div class="row" style="margin-top: 1.2%;">

            <div class="col-4">
              <label data-error="wrong" data-success="right" for="txtBanco">Banco: *</label>
              <div class="input-group">
                <input type="text" autocomplete="off" class="input-default focus form-control" id="txtBanco" name="txtBanco" class="form-control" placeholder="Banco">
                <div class="input-group-append">
                  <button class="btn bg-danger" id="btn-Banco" name="btn-Banco" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                  <button class="btn bg-danger" id="btn-limpa-Banco" name="btn-limpa-Banco" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                </div>
              </div>
            </div>

            <div class="col-sm-4">
              <label data-error="wrong" data-success="right" for="txtCaixa">Caixa: *</label>
              <div class="input-group">
                <input type="text" data-selecionado="false" class="input-default focus form-control" id="txtCaixa" name="txtCaixa" class="form-control" placeholder="Caixa">
                <div class="input-group-append">
                  <button class="btn bg-danger" id="btn-caixa" name="btn-caixa-filtro" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                  <button class="btn bg-danger" id="btn-limpa-caixa2" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                </div>
              </div>
            </div>

            <div class="col-4">
              <label data-error="wrong" data-success="right" for="txtValor">Valor: *</label>
              <div class="input-group">
                <input type="text" autocomplete="off" class="input-default focus form-control text-right" id="txtValor" name="txtValor" class="form-control" placeholder="Valor">
              </div>
            </div>


          </div>
          <div class="row d-flex justify-content-end" style="margin-top: 1.2%;">
            <div id="LancaCC" class="col-4 d-flex align-items-center">
              <input type="checkbox" id="cbNaoLancaCc" style="width: 20px; height: 20px; margin-right: 10px;" class="d-none">
              <label for="cbNaoLancaCc" id="labelNaoLancaCc" style="margin-bottom: 0rem!important;" class="d-none">
                Não lançar conta corrente
              </label>
            </div>
          </div>

          <div class="d-none" id="cartao" style="margin-top: 1.2%;"><label data-error="wrong" data-success="right" for="txtNSU" style="font-size: 20px; margin-left: -6px;">Dados cartão</label>
            <div class="form-row">
              <div class="col-md-3 col-12 px-0">
                <label data-error="wrong" data-success="right" for="txtNSU">NSU</label>
                <div class="input-group">
                  <input type="text" autocomplete="off" class="input-default focus form-control" id="txtNSU" name="txtNSU" class="form-control" placeholder="NSU">
                </div>
              </div>

              <div class="col-md-3 col-12">
                <label for="select_bandeira">Bandeira</label>
                <div class="input-group">
                  <select class="form-control select2 select2-danger focus" id="select_bandeira" name="select_bandeira" data-dropdown-css-class="select2-danger" style="width: 100%;">
                    <option value="" selected="selected">Selecione uma bandeira</option>
                  </select>
                </div>
              </div>

              <div class="col-md-3 col-12 form-group">
                <label data-error="wrong" data-success="right" for="txtCondicaoDePagamento">Cond. Pagamento</label>
                <div class="input-group">
                  <input type="text" class="input-default focus form-control" id="txtCondicaoDePagamento" name="txtCondicaoDePagamento" placeholder="Condição de Pagamento">
                  <div class="input-group-append">
                    <button class="btn bg-danger" id="btn-CondicaoDePagamento" name="btn-CondicaoDePagamento" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                    <button class="btn bg-danger" id="btn-limpa-condicao" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                  </div>
                </div>
              </div>

              <div class="col-md-3 col-12">
                <div class="group-default">
                  <label for="txtNrParcelas">Nr. Parcelas</label>
                  <div class="relative">
                    <input type="text" placeholder="Nr. Parcelas" class="input-default" id="txtNrParcelas" value="1" name="txtNrParcelas" readonly>
                  </div>
                </div>
              </div>

            </div>
          </div>


        </div>

        <div class="modal-footer">
          <div class="row">
            <button class="btn btn-secondary btn-sisp mr-2" id="btnDesistirAnte">Desistir</button>
            <button class="btn btn-danger btn-sisp" id="btnConfirmarAnte">Confirmar</button>
          </div>
        </div>
      </div>
    </div>
  </div>

  <?php
  include_once('../../../modais.php');
  include_once('../../../modals/modal_anexos.html');
  ?>
  <aside class="control-sidebar control-sidebar-dark">
  </aside>
  </div>
  <script src="plugins/jquery/jquery.min.js?versao=3.258.7.1"></script>
  <script type="text/javascript" src="dist/js/jquery.dataTables.js?versao=3.258.7.1"></script>
  <script type="text/javascript" src="dist/js/dataTables.bootstrap4.min.js?versao=3.258.7.1"></script>
  <script src="plugins/jquery-ui/jquery-ui.min.js?versao=3.258.7.1"></script>
  <script>
    $.widget.bridge('uibutton', $.ui.button);
  </script>
  <script src="plugins/bootstrap/js/bootstrap.bundle.min.js?versao=3.258.7.1"></script>
  <script src="dist/js/adminlte.min.js?versao=3.258.7.1"></script>
  <script src="dist/js/sisplan.js?versao=3.258.7.1"></script>
  <script src="utils/funcoes.js?versao=3.258.7.1"></script>
  <script src="utils/cookies.js?versao=3.258.7.1"></script>
  <script src="dist/js/requisicoes.js?versao=3.258.7.1"></script>
  <script src="dist/js/loadingoverlay.min.js?versao=3.258.7.1"></script>
  <script src="dist/js/driver.min.js?versao=3.258.7.1"></script>
  <script src="plugins/toastr/toastr.min.js?versao=3.258.7.1"></script>
  <script type="text/javascript" src="dist/js/sum().js?versao=3.258.7.1"></script>
  <script type="text/javascript" src="config.js?versao=3.258.7.1"></script>
  <script src="plugins/select2/js/select2.full.min.js?versao=3.258.7.1"></script>
  <script src="dist/js/jquery.maskMoney.min.js?versao=3.258.7.1"></script>
  <script src="dist/js/jquery.mask.min.js?versao=3.258.7.1"></script>
  <script type="text/javascript" src="modals/modal_anexos.js?versao=3.258.7.1"></script>
  <script src="plugins/datatables-colreorder/js/dataTables.colReorder.min.js?versao=3.258.7.1"></script>
  <script src="plugins/datatables-colreorder/js/dataTables.colReorder.min.js?versao=3.258.7.1"></script>
  <script>
    $(document).ready(async function() {
      if (getCookie('usuario') == "") {
        window.location.href = `${BASE_URI}/login`;
        return;
      }

      let usuario = getCookie('usuario');
      let empresa = getCookie('empresa');

      ipInterno = IP_INTERNO;
      ipExterno = IP_EXTERNO;
      basicAuth = BASIC_AUTH;

      const temAcesso = await temAcessoTela('ORCAMENTO_CORTINA');
      if (!temAcesso.resultado) {
        toastrAcesso(temAcesso, BASE_URI);
        return;
      }

      sArquivo = `${BASE_URI}/pages/orcamento_cortina/acesso_orcamento_cortina/acesso_orcamento_cortina.js?versao=3.258.7.1`;
      insereJavaScriptPagina(sArquivo);

    });
  </script>
</body>

</html>