$(document).ready(async function () {

  const orcamento = $(window.location.href.split('/')).get(-1);
  const parametrosComercial = await BuscaParametrosPedido();
  const usaFatorConv = parametrosComercial[12].VALOR == '3'
  let itensAlteracao = []
  await setarDataAtual('dtDigitacao')

  await adicionaEmpresas();
  criaMascaraCampos();
  await addBotoesAvancarVoltar();

  componenteFiltro('vendedor', false, false)
  componenteFiltro('cliente', false, false, 'Cliente', ["TIPO_ENTIDADE = 'C'"])
  componenteFiltro('representante', false, false, 'Assistente')
  componenteFiltro('tabPreco', false, false)
  componenteFiltro('servico', true, true, 'Opcional');
  componenteFiltro('moeda', false, false);
  componenteFiltro('situacao', false, false);
  componenteFiltro('historico', false, false);
  componenteFiltro('classe', false, false);
  componenteFiltro('funcionario', false, false, 'Instalador')
  componenteFiltro('funcionario', false, false, 'Costureira')

  $("#txtCodigo").autocompleta(1, `JSON={"tabela": "PRODUTO", "camposSelect": ["PRODUTO.CODIGO CHAVE", "PRODUTO.DESCRICAO"], "leftJoin": [{"tabela":"GRUPO_PA", "condicao": "GRUPO_PA.CODIGO = PRODUTO.GRUPO"}], "where": ["GRUPO_PA.DESCRICAO LIKE '[PERCENTUAL]CORTINA[PERCENTUAL]'"]}`);
  $('#btnCodigo').pesquisa_serverside(
    ['#txtCodigo'],
    ['PRODUTO.CODIGO'],
    ['PRODUTO.DESCRICAO'],
    `{"tabela": "PRODUTO", "camposSelect": ["PRODUTO.CODIGO", "PRODUTO.DESCRICAO"], "leftJoin": [{"tabela":"GRUPO_PA", "condicao": "GRUPO_PA.CODIGO = PRODUTO.GRUPO"}], "where": ["GRUPO_PA.DESCRICAO LIKE '[PERCENTUAL]CORTINA[PERCENTUAL]'"]}`,
    'Pesquisa de Modelo de Cortina'
  );
  $('#btnLimpaCodigo').on('click', function () {
    $('#txtCodigo').val('')
  })

  $("#txtTrilhoFrontal").autocompleta(1, `JSON={"tabela": "MATERIAL", "camposSelect": ["MATERIAL.CODIGO CHAVE", "MATERIAL.DESCRICAO"], "leftJoin": [{"tabela":"GRUPO_MA", "condicao": "GRUPO_MA.CODIGO = MATERIAL.GRUPO"}], "where": ["GRUPO_MA.DESCRICAO LIKE '[PERCENTUAL]TRILHO[PERCENTUAL]'"]}`);
  $('#btnTrilhoFrontal').pesquisa_serverside(
    ['#txtTrilhoFrontal'],
    ['MATERIAL.CODIGO'],
    ['MATERIAL.DESCRICAO'],
    `{"tabela": "MATERIAL", "camposSelect": ["MATERIAL.CODIGO", "MATERIAL.DESCRICAO"], "leftJoin": [{"tabela":"GRUPO_MA", "condicao": "GRUPO_MA.CODIGO = MATERIAL.GRUPO"}], "where": ["GRUPO_MA.DESCRICAO LIKE '[PERCENTUAL]TRILHO[PERCENTUAL]'"]}`,
    'Pesquisa de Trilho Frontal'
  );
  $('#btnLimpaTrilhoFrontal').on('click', function () {
    $('#txtTrilhoFrontal').val('')
  })

  $("#txtTrilhoTraseiro").autocompleta(1, `JSON={"tabela": "MATERIAL", "camposSelect": ["MATERIAL.CODIGO CHAVE", "MATERIAL.DESCRICAO"], "leftJoin": [{"tabela":"GRUPO_MA", "condicao": "GRUPO_MA.CODIGO = MATERIAL.GRUPO"}], "where": ["GRUPO_MA.DESCRICAO LIKE '[PERCENTUAL]TRILHO[PERCENTUAL]'"]}`);
  $('#btnTrilhoTraseiro').pesquisa_serverside(
    ['#txtTrilhoTraseiro'],
    ['MATERIAL.CODIGO'],
    ['MATERIAL.DESCRICAO'],
    `{"tabela": "MATERIAL", "camposSelect": ["MATERIAL.CODIGO", "MATERIAL.DESCRICAO"], "leftJoin": [{"tabela":"GRUPO_MA", "condicao": "GRUPO_MA.CODIGO = MATERIAL.GRUPO"}], "where": ["GRUPO_MA.DESCRICAO LIKE '[PERCENTUAL]TRILHO[PERCENTUAL]'"]}`,
    'Pesquisa de Trilho Traseiro'
  );
  $('#btnLimpaTrilhoTraseiro').on('click', function () {
    $('#txtTrilhoTraseiro').val('')
  })

  $("#txtDeslizFrontal").autocompleta(1, `JSON={"tabela": "MATERIAL", "camposSelect": ["MATERIAL.CODIGO CHAVE", "MATERIAL.DESCRICAO"], "leftJoin": [{"tabela":"GRUPO_MA", "condicao": "GRUPO_MA.CODIGO = MATERIAL.GRUPO"}], "where": ["GRUPO_MA.DESCRICAO LIKE '[PERCENTUAL]DESLIZ[PERCENTUAL]'"]}`);
  $('#btnDeslizFrontal').pesquisa_serverside(
    ['#txtDeslizFrontal'],
    ['MATERIAL.CODIGO'],
    ['MATERIAL.DESCRICAO'],
    `{"tabela": "MATERIAL", "camposSelect": ["MATERIAL.CODIGO", "MATERIAL.DESCRICAO"], "leftJoin": [{"tabela":"GRUPO_MA", "condicao": "GRUPO_MA.CODIGO = MATERIAL.GRUPO"}], "where": ["GRUPO_MA.DESCRICAO LIKE '[PERCENTUAL]DESLIZ[PERCENTUAL]'"]}`,
    'Pesquisa de Desliz'
  );
  $('#btnLimpaDeslizFrontal').on('click', function () {
    $('#txtDeslizFrontal').val('')
  })

  $("#txtDeslizTraseiro").autocompleta(1, `JSON={"tabela": "MATERIAL", "camposSelect": ["MATERIAL.CODIGO CHAVE", "MATERIAL.DESCRICAO"], "leftJoin": [{"tabela":"GRUPO_MA", "condicao": "GRUPO_MA.CODIGO = MATERIAL.GRUPO"}], "where": ["GRUPO_MA.DESCRICAO LIKE '[PERCENTUAL]DESLIZ[PERCENTUAL]'"]}`);
  $('#btnDeslizTraseiro').pesquisa_serverside(
    ['#txtDeslizTraseiro'],
    ['MATERIAL.CODIGO'],
    ['MATERIAL.DESCRICAO'],
    `{"tabela": "MATERIAL", "camposSelect": ["MATERIAL.CODIGO", "MATERIAL.DESCRICAO"], "leftJoin": [{"tabela":"GRUPO_MA", "condicao": "GRUPO_MA.CODIGO = MATERIAL.GRUPO"}], "where": ["GRUPO_MA.DESCRICAO LIKE '[PERCENTUAL]DESLIZ[PERCENTUAL]'"]}`,
    'Pesquisa de Desliz Traseiro'
  );
  $('#btnLimpaDeslizTraseiro').on('click', function () {
    $('#txtDeslizTraseiro').val('')
  })

  $("#txtSuporte").autocompleta(1, `JSON={"tabela": "MATERIAL", "camposSelect": ["MATERIAL.CODIGO CHAVE", "MATERIAL.DESCRICAO"], "leftJoin": [{"tabela":"GRUPO_MA", "condicao": "GRUPO_MA.CODIGO = MATERIAL.GRUPO"}], "where": ["GRUPO_MA.DESCRICAO LIKE '[PERCENTUAL]SUPORTE[PERCENTUAL]'"]}`);
  $('#btnSuporte').pesquisa_serverside(
    ['#txtSuporte'],
    ['MATERIAL.CODIGO'],
    ['MATERIAL.DESCRICAO'],
    `{"tabela": "MATERIAL", "camposSelect": ["MATERIAL.CODIGO", "MATERIAL.DESCRICAO"], "leftJoin": [{"tabela":"GRUPO_MA", "condicao": "GRUPO_MA.CODIGO = MATERIAL.GRUPO"}], "where": ["GRUPO_MA.DESCRICAO LIKE '[PERCENTUAL]SUPORTE[PERCENTUAL]'"]}`,
    'Pesquisa de Suporte'
  );
  $('#btnLimpaSuporte').on('click', function () {
    $('#txtSuporte').val('')
  })

  $("#txtSuporteFlange").autocompleta(1, `JSON={"tabela": "MATERIAL", "camposSelect": ["MATERIAL.CODIGO CHAVE", "MATERIAL.DESCRICAO"], "leftJoin": [{"tabela":"GRUPO_MA", "condicao": "GRUPO_MA.CODIGO = MATERIAL.GRUPO"}], "where": ["GRUPO_MA.DESCRICAO LIKE '[PERCENTUAL]SUPORTE[PERCENTUAL]'"]}`);
  $('#btnSuporteFlange').pesquisa_serverside(
    ['#txtSuporteFlange'],
    ['MATERIAL.CODIGO'],
    ['MATERIAL.DESCRICAO'],
    `{"tabela": "MATERIAL", "camposSelect": ["MATERIAL.CODIGO", "MATERIAL.DESCRICAO"], "leftJoin": [{"tabela":"GRUPO_MA", "condicao": "GRUPO_MA.CODIGO = MATERIAL.GRUPO"}], "where": ["GRUPO_MA.DESCRICAO LIKE '[PERCENTUAL]SUPORTE[PERCENTUAL]'"]}`,
    'Pesquisa de Suporte Flange'
  );
  $('#btnLimpaSuporteFlange').on('click', function () {
    $('#txtSuporteFlange').val('')
  })

  $("#txtFinalFrontal").autocompleta(1, `JSON={"tabela": "MATERIAL", "camposSelect": ["MATERIAL.CODIGO CHAVE", "MATERIAL.DESCRICAO"], "leftJoin": [{"tabela":"GRUPO_MA", "condicao": "GRUPO_MA.CODIGO = MATERIAL.GRUPO"}], "where": ["GRUPO_MA.DESCRICAO LIKE '[PERCENTUAL]FINAL[PERCENTUAL]'"]}`);
  $('#btnFinalFrontal').pesquisa_serverside(
    ['#txtFinalFrontal'],
    ['MATERIAL.CODIGO'],
    ['MATERIAL.DESCRICAO'],
    `{"tabela": "MATERIAL", "camposSelect": ["MATERIAL.CODIGO", "MATERIAL.DESCRICAO"], "leftJoin": [{"tabela":"GRUPO_MA", "condicao": "GRUPO_MA.CODIGO = MATERIAL.GRUPO"}], "where": ["GRUPO_MA.DESCRICAO LIKE '[PERCENTUAL]FINAL[PERCENTUAL]'"]}`,
    'Pesquisa de Final Frontal'
  );
  $('#btnLimpaFinalFrontal').on('click', function () {
    $('#txtFinalFrontal').val('')
  })

  $("#txtFinalTraseiro").autocompleta(1, `JSON={"tabela": "MATERIAL", "camposSelect": ["MATERIAL.CODIGO CHAVE", "MATERIAL.DESCRICAO"], "leftJoin": [{"tabela":"GRUPO_MA", "condicao": "GRUPO_MA.CODIGO = MATERIAL.GRUPO"}], "where": ["GRUPO_MA.DESCRICAO LIKE '[PERCENTUAL]FINAL[PERCENTUAL]'"]}`);
  $('#btnFinalTraseiro').pesquisa_serverside(
    ['#txtFinalTraseiro'],
    ['MATERIAL.CODIGO'],
    ['MATERIAL.DESCRICAO'],
    `{"tabela": "MATERIAL", "camposSelect": ["MATERIAL.CODIGO", "MATERIAL.DESCRICAO"], "leftJoin": [{"tabela":"GRUPO_MA", "condicao": "GRUPO_MA.CODIGO = MATERIAL.GRUPO"}], "where": ["GRUPO_MA.DESCRICAO LIKE '[PERCENTUAL]FINAL[PERCENTUAL]'"]}`,
    'Pesquisa de Final Traseiro'
  );
  $('#btnLimpaFinalTraseiro').on('click', function () {
    $('#txtFinalTraseiro').val('')
  })

  $("#txtTecido").autocompleta(1, `JSON={"tabela": "MATERIAL", "camposSelect": ["MATERIAL.CODIGO CHAVE", "MATERIAL.DESCRICAO"], "leftJoin": [{"tabela":"GRUPO_MA", "condicao": "GRUPO_MA.CODIGO = MATERIAL.GRUPO"}], "where": ["GRUPO_MA.DESCRICAO LIKE '[PERCENTUAL]TECIDO[PERCENTUAL]'"]}`);
  $('#btnTecido').pesquisa_serverside(
    ['#txtTecido'],
    ['MATERIAL.CODIGO'],
    ['MATERIAL.DESCRICAO'],
    `{"tabela": "MATERIAL", "camposSelect": ["MATERIAL.CODIGO", "MATERIAL.DESCRICAO"], "leftJoin": [{"tabela":"GRUPO_MA", "condicao": "GRUPO_MA.CODIGO = MATERIAL.GRUPO"}], "where": ["GRUPO_MA.DESCRICAO LIKE '[PERCENTUAL]TECIDO[PERCENTUAL]'"]}`,
    'Pesquisa de Tecido'
  );
  $('#btnLimpaTecido').on('click', function () {
    $('#txtTecido').val('')
  })

  $("#txtForro").autocompleta(1, `JSON={"tabela": "MATERIAL", "camposSelect": ["MATERIAL.CODIGO CHAVE", "MATERIAL.DESCRICAO"], "leftJoin": [{"tabela":"GRUPO_MA", "condicao": "GRUPO_MA.CODIGO = MATERIAL.GRUPO"}], "where": ["GRUPO_MA.DESCRICAO LIKE '[PERCENTUAL]FORRO[PERCENTUAL]'"]}`);
  $('#btnForro').pesquisa_serverside(
    ['#txtForro'],
    ['MATERIAL.CODIGO'],
    ['MATERIAL.DESCRICAO'],
    `{"tabela": "MATERIAL", "camposSelect": ["MATERIAL.CODIGO", "MATERIAL.DESCRICAO"], "leftJoin": [{"tabela":"GRUPO_MA", "condicao": "GRUPO_MA.CODIGO = MATERIAL.GRUPO"}], "where": ["GRUPO_MA.DESCRICAO LIKE '[PERCENTUAL]FORRO[PERCENTUAL]'"]}`,
    'Pesquisa de Forro'
  );
  $('#btnLimpaForro').on('click', function () {
    $('#txtForro').val('')
  })

  $("#txtBlackout").autocompleta(1, `JSON={"tabela": "MATERIAL", "camposSelect": ["MATERIAL.CODIGO CHAVE", "MATERIAL.DESCRICAO"], "leftJoin": [{"tabela":"GRUPO_MA", "condicao": "GRUPO_MA.CODIGO = MATERIAL.GRUPO"}], "where": ["GRUPO_MA.DESCRICAO LIKE '[PERCENTUAL]BLACKOUT[PERCENTUAL]'"]}`);
  $('#btnBlackout').pesquisa_serverside(
    ['#txtBlackout'],
    ['MATERIAL.CODIGO'],
    ['MATERIAL.DESCRICAO'],
    `{"tabela": "MATERIAL", "camposSelect": ["MATERIAL.CODIGO", "MATERIAL.DESCRICAO"], "leftJoin": [{"tabela":"GRUPO_MA", "condicao": "GRUPO_MA.CODIGO = MATERIAL.GRUPO"}], "where": ["GRUPO_MA.DESCRICAO LIKE '[PERCENTUAL]BLACKOUT[PERCENTUAL]'"]}`,
    'Pesquisa de Blackout'
  );
  $('#btnLimpaBlackout').on('click', function () {
    $('#txtBlackout').val('')
  })

  const columnsResultado = [
    { title: "Nº" },
    { title: "Código" },
    { title: "Descrição" },
    { title: "Componente" },
    { title: "Tipo LT" },
    { title: "TM" },
    { title: "Dimensão" },
    { title: "Partes" },
    { title: "Quantidade" },
    { title: "UN" },
    { title: "Valor" },
    { title: "Total" },
  ]

  const columnsHistorico = [
    { title: "Nº" },
    { title: "Status" },
    { title: "Usuário" },
    { title: "Data" }
  ]

  const columnsItens = [
    { title: "Código" },
    { title: "Descrição" },
    { title: "Qtd" },
    { title: "Largura" },
    { title: "Altura" },
    { title: "Qtd.Unit" },
    { title: "UM" },
    { title: "Qtd.Total" },
    { title: "Val.Unit" },
    { title: "Subtotal" },
    { title: "Desc.Unit" },
    { title: "Sub.C/Desc." },
    { title: "Val.IPI" },
    { title: "Val.ST" },
    { title: "Val.Total" }
  ]

  const retornaBotaoOpcoes = () => {
    return '<div class="p-0 d-flex"> ' +
      '     <button class="botaoOpcoes btn-sm" type="button" title="Editar" id="btn-editar" style="background-color:var(--blue); padding: 5px 1px 5px 6px;"><span class="fas fa-edit" style="color:white !important"></span></button>  ' +
      '     <button class="divBtnItens botaoOpcoes btn-sm" type="button" title="Excluir" id="btn-excluir" style="padding: 5px 2px 5px 4px;"><span class="fas fa-trash-alt" style="color:white !important"></span></button>  ' +
      '   </div>';
  };

  await validaEdicao();

  $("#msform").validate({
    debug: false,
    ignore: "",
    rules: {
      txtCliente: {
        required: true,
      },
      txtVendedor: {
        required: true,
      },
      dtEntrega: {
        required: true,
      },
    },
    messages: {
      txtCliente: {
        required: "Informe um cliente",
      },
      txtVendedor: {
        required: "Informe um vendedor.",
      },
      dtEntrega: {
        required: "Informe uma data de entrega.",
      },
    },
    errorElement: "span",
    errorPlacement(error, element) {
      error.addClass("invalid-feedback");
      element.closest(".form-group").append(error);
    },
    highlight(element) {
      $(element).addClass("is-invalid");
    },
    unhighlight(element) {
      $(element).removeClass("is-invalid");
    },
    invalidHandler(e, validator) {
      if (validator.errorList.length) {
        console.log(`erro no: ${$(`#${$(validator.errorList[0].element).prop('id')}`)}`);
      }
    },

    async submitHandler(form, event) {
      event.preventDefault();
      $(this).attr('disabled', true);

      $.LoadingOverlay("show");
      try {
        for (let i = 0; i < $('#tabelaItens').DataTable().data().toArray().length; i++) {
          const item = $('#tabelaItens').DataTable().data().toArray()[i]

          arrayItens.push({
            ORDEM_DIG: item.ORDEM,
            ORDEM: 1,
            CODIGO: item.PROTOTIPO != '' ? '' : item.CODIGO,
            PROTOTIPO: item.PROTOTIPO,
            DESCRICAO: item.DESCRICAO,
            QUALIDADE: '1',
            COR: item.COR,
            TAM: item.TAM,
            QTDE: item.QTDE,
            PRECO: item.PRECO,
            PRECO_LIQ: item.PRECO,
            VALOR_TOTAL: item.VALOR,
            TIPO_PROD: item.PROTOTIPO != '' ? 'N' : 'E',
            OBS2: item.OBS2,
            OBS3: item.OBS3,
            OBSERVACAO: item.OBSERVACAO,
            FAIXA: item.FAIXA,
            MARKUP1: item.MARKUP,
            PRECO_ORIG: item.PRECO_ORIG,
            COMPL_PROD: item.COMPL_PROD,
            TELA: 'ORCAMENTO'
          });
        }

        for (let i = 0; i < $('#tabelaDuplicatas').DataTable().data().toArray().length; i++) {
          const item = $('#tabelaDuplicatas').DataTable().data().toArray()[i]
          arrayFinanceiro.push({
            NUM_PARCELA: item.PARCELA,
            VENCTO: item.VENCIMENTO,
            VALOR_PARCELA: item.VALOR,
            QUANT_PARC: $('#txtNParcelas').val(),
            VALOR_TOTAL: $('#txtValorFinanceiro').text().replace('.', '').replace(',', '.'),
            PRZ_PRIM_PARC: $('#txtPrazoPrimeiraParc').val(),
            INTERV_PARC: $('#txtIntervaloParc').val(),
            PRZ_MEDIO: $('#txtPrazoMedioCalc').val(),
            VAL_ENT_PED: parseFloat($('#txtValorEntrada').val()),
            CONSIDERARSIMULACAO: $('#checkConsiderarSimulação').is(':checked') ? 'S' : 'N',
          });
        }

        if (arrayItens.length <= 0) {
          throw new Error('Nenhum item no orçamento!')
        }

        if (arrayFinanceiro.length <= 0) {
          throw new Error('Nenhuma parcela criada no orçamento!')
        }

        const classOs = {
          USUARIO: getCookie('usuario'),
          NUMERO: pegaValor('#txtNumero'),
          EMP_FAT: pegaValor('#selectEmpresa'),
          CLIENTE: pegaChave('#txtCliente'),
          PED_CLI: pegaValor('#txtPedcli'),
          DTDIGITA: pegaValor('#dtDigitacao'),
          CODREP: pegaChave('#txtRepresentante'),
          COM1: pegaValor('#txtComissaoFat'),
          COM2: pegaValor('#txtComissaoRec'),
          CODAGENCIA: pegaChave('#txtAgencia'),
          COM1_AGENCIA: pegaValor('#txtComissao'),
          PEDIDO: pegaChave('#txtPedido'),
          SOLICITANTE: pegaChave('#txtSolicitante'),
          TAB_PRE: pegaChave('#txtTabPreco'),
          BLOQ_COM: pegaValor('#selectStatusComercial'),
          DT_CADASTRO: $('#dtEmissao').val(),
          DT_VALIDADE: pegaValor('#dtValidade'),
          DIAS_ENTREGA: pegaValor('#txtDias'),
          DT_ENTREGA: $('#dtEntrega').val(),
          DT_SAIDA: $('#dtSaida').val(),
          OBSERVACAO: pegaValor('#txtObservacoes'),
          SITUACAO: $('#rdSituacaoAberto').is(':checked') ? 'A' : $('#rdSituacaoFechado').is(':checked') ? 'F' : $('#rdSituacaoEmAprov').is(':checked') ? 'E' : $('#rdSituacaoPerdido').is(':checked') ? 'P' : '',
          SOMA_DIAS_ENT: $('#rdSumDiasCorridos').is(':checked') ? 'C' : 'U',
          MOEDA: pegaChave('#txtMoeda'),
          HISTORICO: pegaChave('#txtHistorico'),
          SIT_DUP: pegaChave('#txtSituacao'),
          CLASSE_GER: pegaChave('#txtClasseGer'),
          TAB_TRANS: pegaChave('#txtTransportadora'),
          CIF: $('#rgTransportador').val(),
          NATUREZA: pegaChave('#txtNatureza'),
          ALIQUOTA: pegaValor('#txtAliquota'),
          FRETE: pegaValor('#txtValFrete'),
          PESO_BRUTO: pegaValor('#txtPesoBruto'),
          PESO_LIQ: pegaValor('#txtPesoLiquido'),
          VOLUMES: pegaValor('#txtVolumes'),
          END_ENT: pegaValor('#txtEndEntrega'),
          BAIRRO_ENT: pegaValor('#txtBairroEntrega'),
          NOME_CIDADE: pegaValor('#txtCidadeEntrega'),
          COD_UF: pegaValor('#txtEstadoEntrega'),
          NUM_ENT: pegaValor('#txtNumeroEntrega'),
          CEP: pegaValor('#txtCepEntrega'),
          MARKUP: pegaChave('#txtMarkup'),
          PGTO: pegaChave('#txtCondicao'),
          PRZ_MEDIO: pegaValor('#txtPrazoMedioCalc'),
          PER_DESC: parseFloat(pegaValor('#txtDesconto')),
          DESC_UNIFICADO: campoDesconto(parseFloat($('#txtDesconto1').val()), parseFloat($('#txtDesconto2').val()), parseFloat($('#txtDesconto3').val()), parseFloat($('#txtDesconto4').val()), parseFloat($('#txtDesconto5').val())),
          TELA: 'ORCAMENTO',
          ITENS: arrayItens,
          EMP_ID: getCookie('emp_id'),
        };

        const response = await requisicao('POST', '/sisplan/os/v1/ordemservico?', '', `JSON=${encodeURIComponent(JSON.stringify(classOs))}`, 90000);

        if (!response) {
          return;
        }

        const jsonStr = await response.json();
        if (response.status != 200) {
          throw new Error(jsonStr.mensagem);
        }

        criaMensagemSucesso('Orçamento gravado com sucesso.', () => { window.location.href = `${BASE_URI}/orcamento`; });

      } catch (error) {
        console.error(error);
        msgErro(`Não foi possível gravar os dados da ordem de serviço: ${error.message}`);
      } finally {
        $(this).attr('disabled', false);
        $.LoadingOverlay('hide')
      }
    },
  });

  $('#btnRemoveTermotape').on('click', function () {
    removeTermotape();
  });

  $('#btnAddComposicao').on('click', function () {
    $('#modalComposicao').modal('show');
  });

  $('#btnAddItem').on('click', function () {
    $('#modalItem').modal('show');
  });

  $('#txtCodigo').on('blur', async function () {

    $.LoadingOverlay('show')
    try {
      const codigo = pegaChave('#txtCodigo');
      if (codigo == '') {
        return;
      }

      $('#txtCor').unbind('autocompleta');
      $('#txtCor').autocompleta(1, `JSON={ "tabela":"PA_ITEN", "camposSelect":["PA_ITEN.COR CHAVE, CADCOR.DESCRICAO"], "leftjoin": [{ "tabela" : "CADCOR", "condicao" : "PA_ITEN.COR = CADCOR.COR" }], "groupBy": ["PA_ITEN.COR", "CADCOR.DESCRICAO"], "where": ["PA_ITEN.CODIGO = '${codigo}' AND PA_ITEN.ATIVO = 'S'"] }`);
      $('#btnCor').off();
      $('#btnCor').unbind();
      $('#btnCor').pesquisa_array(['#txtCor'], ['COR'], ['DESCRICAO'], `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"PA_ITEN", "camposSelect":[ "PA_ITEN.COR", "CADCOR.DESCRICAO" ],"leftjoin": [{ "tabela" : "CADCOR", "condicao" : "PA_ITEN.COR = CADCOR.COR" }], "groupBy": ["PA_ITEN.COR", "CADCOR.DESCRICAO"], "where": ["PA_ITEN.CODIGO = '${codigo}' AND PA_ITEN.ATIVO = 'S'"]}`, 'Pesquisa Cor', 'CADCOR');

      if (itensAlteracao.length <= 0) {
        $('#txtCor').val('')

        const pesquisaCor = {
          tabela: "PA_ITEN",
          camposSelect: [
            "PA_ITEN.COR",
            "CADCOR.DESCRICAO"
          ],
          leftJoin: [{ tabela: "CADCOR", condicao: "PA_ITEN.COR = CADCOR.COR" }],
          groupBy: [
            "PA_ITEN.COR",
            "CADCOR.DESCRICAO"
          ],
          where: [`PA_ITEN.CODIGO = '${codigo}' AND PA_ITEN.ATIVO = 'S'`],
        }
        const jsonStrCor = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaCor));

        if (jsonStrCor && jsonStrCor.length == 1) {
          insereValor('#txtCor', jsonStrCor[0].COR, jsonStrCor[0].DESCRICAO)
          $('#txtCor').trigger('blur')
        }
      }

    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide')
    }

  });

  async function validaEdicao() {
    // if (orcamento == 'create') {
    //   insereValor('#txtNumero', await RetornaProximo('OS', 'OS', 'NUMERO', 5));
    //   const codrep = (await buscaValor('ACESSO_USUARIOS', 'CODREP', 'CODIGO', getCookie('cod_usuario'))).CODREP
    //   if (codrep) insereValor('#txtRepresentante', codrep, { tabela: 'REPRESEN', campoBusca: 'NOME', campoWhere: 'CODREP', valorWhere: codrep })
    //   return;
    // } else {
    await buscarOrcamento(orcamento)

    // }
  }

  // async function buscaContatoCliente() {
  //   const codcli = pegaChave('#txtCliente');

  //   if (codcli == '') {
  //     $("#txtSolicitante").autocompleta(1, `JSON={ "tabela":"CONTATO", "camposSelect":["ID CHAVE, NOME DESCRICAO"], "where": ["NOME <> '' AND CODCLI = '${codcli}'"] }`, [], [], []);
  //     $("#btn-Solicitante").pesquisa_serverside(["#txtSolicitante"], ["ID"], ["NOME"], `{"tabela":"CONTATO", "camposSelect":[ "ID", "NOME" ], "where": ["NOME <> '' AND CODCLI = '${codcli}'"]}`, "Pesquisa Solicitante",);
  //     $("#btn-limpa-Solicitante").on("click", function () { $("#txtSolicitante").val(""); });
  //     return;
  //   }

  //   $("#txtSolicitante").autocompleta(1, `JSON={ "tabela":"CONTATO", "camposSelect":["ID CHAVE, NOME DESCRICAO"], "where": ["NOME <> '' AND CODCLI = '${codcli}'"] }`, [], [], []);
  //   $("#btn-Solicitante").pesquisa_serverside(["#txtSolicitante"], ["ID"], ["NOME"], `{"tabela":"CONTATO", "camposSelect":[ "ID", "NOME" ], "where": ["NOME <> '' AND CODCLI = '${codcli}'"]}`, "Pesquisa Solicitante",);
  //   $("#btn-limpa-Solicitante").on("click", function () { $("#txtSolicitante").val(""); });

  //   const pesquisaParam = {
  //     tabela: 'CONTATO',
  //     camposSelect: ['ID', 'NOME'],
  //     where: [`CODCLI = '${codcli}' AND TIPO = 'Orçamento'`]
  //   }

  //   const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

  //   if (jsonStr.length > 0 && jsonStr[0].NOME != '') {
  //     insereValor('#txtSolicitante', jsonStr[0].ID, jsonStr[0].NOME);
  //   } else {
  //     limpaValor('#txtSolicitante');
  //   }
  // }

  async function buscaPrecoMatCor() {
    const material = pegaChave('#txtMaterialConsumo');
    const cor = $('#txtCorConsumo').attr('data-chave');

    if (cor == '' || material == '') {
      return;
    }

    const pesquisaParam = {
      tabela: 'MAT_PRECO_COR',
      camposSelect: ['PRECO_COMPRA'],
      where: [`CODIGO = '${material}' AND COR = '${cor}'`],
    }

    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

    if (jsonStr.length == 0) {
      return;
    }

    $('#txtCustoUniConsumo').val(coalesce(jsonStr[0].PRECO_COMPRA));
  };

  async function adicionaEmpresas() {
    const pesquisaParam = {
      tabela: 'EMPRESA',
      camposSelect: ['EMP_PAT', 'EMP_NOME'],
      where: ['1 = 1'],
    }
    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));
    jsonStr.map(emp => {
      $("#selectEmpresa").append(new Option(`${emp.EMP_PAT} - ${emp.EMP_NOME}`, emp.EMP_PAT.replace('_', ''), null, emp.EMP_PAT == getCookie('empresa')));
    });
  };

  function adicionaDias() {
    $('#txtDiasValidade').on('blur', function () {
      const dias = pegaValor('#txtDiasValidade');

      if (dias == '') {
        return;
      }

      setarDataAtual('dtValidade', false, parseFloat(dias));
    });

    $('#txtDias').on('blur', function () {
      const dias = pegaValor('#txtDias');

      if (dias == '') {
        return;
      }

      if ($('#rdSumDiasCorridos').is(':checked')) {
        consideraDiasCorridos(dias)
      }

      if ($('#rdSumDiasUteis').is(':checked')) {
        consideraDiasUteis(dias)
      }
    });
  }

  async function retornaPrecoMat(id, codApl, opcional, codigo, cor) {
    $.LoadingOverlay('show')
    try {
      const response = await requisicao('GET', '/sisplan/orcamento/v1/buscaprecomat?', `ID=${id}&COD_APL=${codApl}&OPCIONAL=${opcional}&CODIGO=${codigo}&COR=${cor}`);

      if (!response) {
        return;
      }

      const jsonPrecoMat = await response.json();

      if (response.status != 200) {
        throw new Error(jsonPrecoMat.mensagem);
      }

      if (jsonPrecoMat.length > 0) {
        let valor = (jsonPrecoMat[0].QTDE_TECIDO * jsonPrecoMat[0].PRECO)
        return valor.toFixed(2)
      } else {
        return 0;
      }
    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide')
    }
  };

  function retornaBotaoExcluir(classe) {
    return '<div class="divBtnOpcoes p-0"> ' +
      `     <button class="botaoOpcoes btn-sm" type="button" title="Excluir" id="btn-excluir-${classe}"><span class="fas fa-trash-alt" style="color:red"></span></button>  ` +
      `     <button class="botaoOpcoes btn-sm" type="button" title="Editar" id="btn-editar-${classe}"><span class="fas fa-edit" style="color:blue"></span></button>     ` +
      '   </div>';
  }

  function retornaInputValor(sNomeInput, iIndex = 0, campoQtde = false, valor = 0) {
    const validacao = parametrosComercial[9].VALOR == '1' || itensAlteracao.length > 0
    return !campoQtde ?
      `<input type="text" 
              class="input-default focus form-control camposMascara text-right ${sNomeInput}" 
              ${!validacao && sNomeInput.indexOf('txtPrecoGrade') != -1 ? 'disabled' : ''}
              data-campo="${sNomeInput}" 
              data-index="${iIndex}" 
              value="${valor}">`
      :
      `<input type="text" 
              class="input-default focus form-control camposMascaraQtde text-right ${sNomeInput}" 
              data-campo="${sNomeInput}" 
              data-index="${iIndex}" 
              value="0">`
  };

  function aplicaMascara() {
    $(".camposMascara").maskMoney({
      decimal: ".",
      thousands: "",
      precision: 2,
    });

    $(".camposMascara").on('blur', function () {
      if (($(this).val() == '0.00') || ($(this).val() == '')) {
        $(this).val('0.00');
      }
    });

    $('.camposMascaraQtde').maskMoney({
      decimal: ".",
      thousands: "",
      precision: 0,
    })

    $(".camposMascaraQtde").on('blur', function () {
      if (($(this).val() == '0') || ($(this).val() == '')) {
        $(this).val('0');
      }
    });

    $("#txtDias").maskMoney({
      decimal: ".",
      thousands: "",
      precision: 0,
    });
    $("#txtDiasValidade").maskMoney({
      decimal: ".",
      thousands: "",
      precision: 0,
    });
  }

  function criaMascaraCampos() {
    $("#txtTamCm2, #txtLarguraBordado, #txtAlturaBordado, #txtLarguraSerigrafia, #txtAlturaSerigrafia, #txtComissaoFat, #txtComissaoRec, #txtComissao, #txtAliquota, #txtValFrete, #txtPesoBruto, #txtPesoLiquido, #txtFrete, #txtPreco, #txtLarguraDTF, #txtAlturaDTF").maskMoney({
      decimal: ".",
      thousands: "",
      precision: 2,
    });

    $("#txtTotalPecasTermotape, #txtTotalPecasBordado, #txtQtdeProg, #txtTotalPecasDTF,#txtQtdeProgDTF, #txtTotalPecasSerigrafia, #txtVolumes, #txtQtdeCores").maskMoney({
      decimal: ".",
      thousands: "",
      precision: 0,
    });

    $(".maskConsumos").maskMoney({
      decimal: ".",
      thousands: "",
      precision: 4,
    });

    $('.maskDecimais').maskMoney({
      decimal: ".",
      thousands: "",
      precision: 2,
    });

    $('.maskDecimais').on('blur', function () {
      if ($(this).val() == "") {
        $(this).val('0.00');
      }
    });

    $('.maskInteiro').maskMoney({
      decimal: ".",
      thousands: "",
      precision: 0,
    });

    $('.maskInteiro').on('blur', function () {
      if ($(this).val() == "") {
        $(this).val('0');
      }
    });

    $('.blurEnter').on('keydown', function () {
      if (event.key == "Enter") {
        $(this).trigger("blur");
      }
    })
  };

  async function addBotoesAvancarVoltar() {
    $(".next").click(async function () {
      currentFs = $(this).parent();
      nextFs = $(this).parent().next();

      // if (currentFs.prevObject[0].id == 'avancar1') {
      //   if (!$('#txtCliente').val()) {
      //     throw msgAlerta('Necessário inserir um cliente, verifique!')
      //   }
      // }

      // if (currentFs.prevObject[0].id == 'avancarFinanceiro') {
      //   if (!$('#txtMoeda').val()) {
      //     throw msgAlerta('Necessário inserir uma moeda, verifique!')
      //   }
      //   if (!$('#txtHistorico').val()) {
      //     throw msgAlerta('Necessário inserir um histórico, verifique!')
      //   }
      //   if (!$('#txtSituacao').val()) {
      //     throw msgAlerta('Necessário inserir uma situação, verifique!')
      //   }
      //   if (!$('#txtClasseGer').val()) {
      //     throw msgAlerta('Necessário inserir uma classe, verifique!')
      //   }
      //   if (!$('#txtCondicao').val()) {
      //     throw msgAlerta('Necessário infromar a condição de pagamento, verifique!')
      //   }
      // }

      $("#progressbar li").eq($("fieldset").index(nextFs)).addClass("active");
      nextFs.show();
      currentFs.animate(
        {
          opacity: 0,
        },
        {
          step(now) {
            opacity = 1 - now;
            currentFs.css({
              display: "none",
              position: "relative",
            });
            nextFs.css({
              opacity,
            });
          },
          duration: 600,
        }
      );
      $("#tabelaItens").DataTable().columns.adjust().draw(false);
    });

    $(".previous").click(async function () {
      let currentFs = $(this).parent();
      let previousFs = $(this).parent().prev();
      $("#progressbar li").eq($("fieldset").index(currentFs)).removeClass("active");
      previousFs.show();
      currentFs.animate(
        {
          opacity: 0,
        },
        {
          step(now) {
            opacity = 1 - now;
            currentFs.css({ display: "none", position: "relative" });
            previousFs.css({ opacity });
          },
          duration: 600,
        }
      );
      $("#tabelaItens").DataTable().columns.adjust().draw(false);
    });
  };

  // $("#txtMaterial").on('blur', async function () {
  //   if ($("#txtMaterial").val() == '') {
  //     return
  //   }
  //   $.LoadingOverlay('show')
  //   try {
  //     $("#txtCorItem").autocompleta(1, `JSON={ "tabela":"CADCOR", "camposSelect":["CADCOR.COR CHAVE, CADCOR.DESCRICAO DESCRICAO"], "innerjoin": [{"tabela": "MAT_ITEN", "condicao": "MAT_ITEN.COR = CADCOR.COR"}], "where": ["MAT_ITEN.CODIGO = '${pegaChave('#txtMaterial')}' AND CADCOR.INATIVO <> 'S'"], "groupBy": ["CADCOR.COR, CADCOR.DESCRICAO"] }`);
  //     $("#btnCor").pesquisa("#txtCorItem",
  //       "COR",
  //       "DESCRICAO",
  //       `/sisplan/funcoes/v1/pesquisa?JSON={ 
  //                           "tabela":"CADCOR", 
  //                           "camposSelectSubSelect": ["COR", "DESCRICAO", "SUM(ESTOQUE) ESTOQUE", "SUM(SALDO) SALDO"],
  //                           "camposSelect":[ "CADCOR.COR", "CADCOR.DESCRICAO", "SUM(MAT_ITEN.QTDE) ESTOQUE", "ROUND((MAT_ITEN.QTDE - SUM(COALESCE(MAT_RESERVA.QTDE, 0) - COALESCE(MAT_RESERVA.QTDE_B, 0))),2) SALDO" ], 
  //                           "innerjoin": [{"tabela": "MAT_ITEN", "condicao": "MAT_ITEN.COR = CADCOR.COR"}],
  //                           "leftjoin": [{"tabela": "MAT_RESERVA", "condicao": "MAT_RESERVA.CODIGO = MAT_ITEN.CODIGO AND MAT_RESERVA.COR = MAT_ITEN.COR AND MAT_RESERVA.QUAL = MAT_ITEN.QUALIDADE AND MAT_RESERVA.DEPOSITO = MAT_ITEN.DEPOSITO AND MAT_RESERVA.LOTE = MAT_ITEN.LOTE"}], 
  //                           "where": ["MAT_ITEN.CODIGO = '${pegaChave('#txtMaterial')}' AND CADCOR.INATIVO <> 'S'"], 
  //                           "groupBy": ["CADCOR.COR, CADCOR.DESCRICAO, MAT_ITEN.QTDE"],
  //                           "groupBySubSelect": ["COR, DESCRICAO"]}`,
  //       "Pesquisa Cor",
  //       "CADCOR");
  //   } finally {
  //     $.LoadingOverlay('hide')
  //   }
  // })

  // $('#modalComposicao').on('shown.bs.modal', async function () {
  //   $.LoadingOverlay('show')
  //   try {
  //     if ($("#txtMaterial").val() != '') {
  //       $("#txtCorItem").autocompleta(1, `JSON={ "tabela":"CADCOR", "camposSelect":["CADCOR.COR CHAVE, CADCOR.DESCRICAO DESCRICAO"], "innerjoin": [{"tabela": "MAT_ITEN", "condicao": "MAT_ITEN.COR = CADCOR.COR"}], "where": ["MAT_ITEN.CODIGO = '${pegaChave('#txtMaterial')}' AND CADCOR.INATIVO <> 'S'"], "groupBy": ["CADCOR.COR, CADCOR.DESCRICAO"] }`);
  //       $("#btnCor").pesquisa("#txtCorItem",
  //         "COR",
  //         "DESCRICAO",
  //         `/sisplan/funcoes/v1/pesquisa?JSON={ 
  //                             "tabela":"CADCOR", 
  //                             "camposSelectSubSelect": ["COR", "DESCRICAO", "SUM(ESTOQUE) ESTOQUE", "SUM(SALDO) SALDO"],
  //                             "camposSelect":[ "CADCOR.COR", "CADCOR.DESCRICAO", "SUM(MAT_ITEN.QTDE) ESTOQUE", "ROUND((MAT_ITEN.QTDE - SUM(COALESCE(MAT_RESERVA.QTDE, 0) - COALESCE(MAT_RESERVA.QTDE_B, 0))),2) SALDO" ], 
  //                             "innerjoin": [{"tabela": "MAT_ITEN", "condicao": "MAT_ITEN.COR = CADCOR.COR"}],
  //                             "leftjoin": [{"tabela": "MAT_RESERVA", "condicao": "MAT_RESERVA.CODIGO = MAT_ITEN.CODIGO AND MAT_RESERVA.COR = MAT_ITEN.COR AND MAT_RESERVA.QUAL = MAT_ITEN.QUALIDADE AND MAT_RESERVA.DEPOSITO = MAT_ITEN.DEPOSITO AND MAT_RESERVA.LOTE = MAT_ITEN.LOTE"}], 
  //                             "where": ["MAT_ITEN.CODIGO = '${pegaChave('#txtMaterial')}' AND CADCOR.INATIVO <> 'S'"], 
  //                             "groupBy": ["CADCOR.COR, CADCOR.DESCRICAO, MAT_ITEN.QTDE"],
  //                             "groupBySubSelect": ["COR, DESCRICAO"]}`,
  //         "Pesquisa Cor",
  //         "CADCOR");
  //     }
  //   } finally {
  //     $.LoadingOverlay('hide')
  //   }
  // })

  $('#btnDesistir').on('click', async function () {
    $.LoadingOverlay('show')
    try {
      limpaValoresItens()
    } finally {
      $.LoadingOverlay('hide')
    }
  })

  async function buscarOrcamento(orcamento) {
    $.LoadingOverlay('show')
    try {
      // const pesquisaParam = {
      //   tabela: 'OS',
      //   camposSelect: ['OS.NUMERO', 'OS.CLIENTE', 'ENTIDADE.NOME NOME_CLI', 'OS.PED_CLI', 'OS.DTDIGITA',
      //     'OS.CODREP', 'REPRESEN.NOME NOME_REP', 'OS.COM1', 'OS.COM2', 'OS.CODAGENCIA', 'AGENCIA.NOME NOME_AGEN',
      //     'OS.COM1_AGENCIA', 'OS.PEDIDO', 'OS.TERCEIRO SOLICITANTE', 'CONTATO.NOME NOME_SOL',
      //     'OS.TAB_PRE', 'REGIAO.DESCRICAO DESC_TABPRECO', 'OS.BLOQ_COM', 'OS.DT_CADASTRO DT_EMI', 'OS.VALIDADE',
      //     'OS.DT_VALIDADE', 'OS.DIAS_ENTREGA', 'OS.DT_ENTREGA', 'OS.DT_SAIDA', 'OS.OBSERVACAO', 'OS.SITUACAO', 'OS.SOMA_DIAS_ENT',
      //     'OS.MOEDA', 'MOEDA.DESCRICAO DESC_MOE', 'OS.HISTORICO', 'HISTCP.DESCRICAO DESC_HIST', 'OS.SIT_DUP',
      //     'TABSIT.DESCRICAO DESC_SIT', 'OS.CLASSE_GER', 'CLASSE_GER.DESCRICAO DESC_CLASSE', 'OS.TAB_TRANS',
      //     'TABTRAN.NOME NOME_TRANSP', 'OS.CIF, OS.NATUREZA', 'NATUREZA.DESCRICAO DESC_NATUREZA', 'NATUREZA.ALIQUOTA',
      //     'OS.FRETE', 'OS.PESO_BRUTO', 'OS.PESO_LIQ', 'OS.VOLUMES', 'ENTIDADE.END_ENT', 'ENTIDADE.BAIRRO_ENT',
      //     'CIDADE.NOME NOME_CIDADE', 'CIDADE.COD_UF', 'ENTIDADE.NUM_ENT', 'ENTIDADE.CEP', 'OS.MARKUP',
      //     'OS.PGTO', 'OS.PER_DESC'],
      //   leftJoin: [{ tabela: "ENTIDADE", alias: "ENTIDADE", condicao: "ENTIDADE.CODCLI = OS.CLIENTE" },
      //   { tabela: "REPRESEN", alias: "REPRESEN", condicao: "REPRESEN.CODREP = OS.CODREP" },
      //   { tabela: "REPRESEN", alias: "AGENCIA", condicao: "AGENCIA.CODREP = OS.CODAGENCIA" },
      //   { tabela: "CONTATO", alias: "CONTATO", condicao: "CONTATO.NUMERO = OS.TERCEIRO " },
      //   { tabela: "REGIAO", alias: "REGIAO", condicao: "REGIAO.REGIAO = OS.TAB_PRE " },
      //   { tabela: "MOEDA", alias: "MOEDA", condicao: "MOEDA.CODMOE = OS.MOEDA" },
      //   { tabela: "HISTCP", alias: "HISTCP", condicao: "HISTCP.HISTORICO = OS.HISTORICO " },
      //   { tabela: "TABSIT", alias: "TABSIT", condicao: "TABSIT.CODIGO = OS.SIT_DUP " },
      //   { tabela: "CLASSE_GER", alias: "CLASSE_GER", condicao: "CLASSE_GER.CODIGO = OS.CLASSE_GER " },
      //   { tabela: "TABTRAN", alias: "TABTRAN", condicao: "TABTRAN.CODIGO = OS.TAB_TRANS" },
      //   { tabela: "NATUREZA", alias: "NATUREZA", condicao: "NATUREZA.NATUREZA = OS.NATUREZA " },
      //   { tabela: "CADCEP", alias: "CADCEP", condicao: "ENTIDADE.CEP = CADCEP.CEP " },
      //   { tabela: "CI", alias: "CIDADE", condicao: "CIDADE.CODIGO = CADCEP.CODMUN" }],
      //   where: [`OS.NUMERO = '${orcamento}'`],
      //   limit: 1
      // }

      // const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));
      // const os = jsonStr[0]

      // //PREENCHE OS CAMPOS DO ORCAMENTO
      // $('#txtNumero').val(orcamento)
      // insereValor('#txtCliente', os.CLIENTE, os.NOME_CLI)
      // $('#txtPedcli').val(os.PED_CLI)
      // $('#dtDigitacao').val(os.DTDIGITA)
      // insereValor('#txtRepresentante', os.CODREP, os.NOME_REP)
      // $('#txtComissaoFat').val(os.COM1)
      // $('#txtComissaoRec').val(os.COM2)
      // insereValor('#txtAgencia', os.CODAGENCIA, os.NOME_AGEN)
      // $('#txtComissao').val(os.COM1_AGENCIA)
      // $('#txtPedido').val(os.PEDIDO)
      // insereValor('#txtSolicitante', os.SOLICITANTE, os.NOME_SOL)
      // insereValor('#txtTabPreco', os.TAB_PRE, os.DESC_TABPRECO)
      // $('#selectStatusComercial').val(os.BLOQ_COM)
      // $('#dtEmissao').val(os.DT_EMI)
      // $('#txtDiasValidade').val(os.VALIDADE)
      // $('#dtValidade').val(os.DT_VALIDADE)
      // $('#txtDias').val(os.DIAS_ENTREGA)
      // $('#dtEntrega').val(os.DT_ENTREGA)
      // $('#dtSaida').val(os.DT_SAIDA)
      // $('#txtObservacoes').val(os.OBSERVACAO)
      // switch (os.SITUACAO) {
      //   case 'A': {
      //     $('#rdSituacaoAberto').prop('checked', true)
      //     break
      //   }
      //   case 'F': {
      //     $('#rdSituacaoFechado').prop('checked', true)
      //     break
      //   }
      //   case 'E': {
      //     $('#rdSituacaoEmAprov').prop('checked', true)
      //     break
      //   }
      //   case 'P': {
      //     $('#rdSituacaoPerdido').prop('checked', true)
      //     break
      //   }
      //   default: break
      // }
      // $('#rdSumDiasCorridos').prop('checked', os.SOMA_DIAS_ENT == 'C')
      // $('#rdSumDiasUteis').prop('checked', os.SOMA_DIAS_ENT != 'C')
      // //ABA FINANCEIRO
      // insereValor('#txtMoeda', os.MOEDA, os.DESC_MOE)
      // insereValor('#txtHistorico', os.HISTORICO, os.DESC_HIST)
      // insereValor('#txtHistorico', os.HISTORICO, os.DESC_HIST)
      // insereValor('#txtSituacao', os.SIT_DUP, os.DESC_SIT)
      // insereValor('#txtClasseGer', os.CLASSE_GER, os.DESC_CLASSE)
      // insereValor('#txtCondicao', os.PGTO, { tabela: 'CONDICAO', campoBusca: 'DESCRICAO', campoWhere: 'CODCOND', valorWhere: os.PGTO })
      // $('#txtDesconto').val(os.PER_DESC)
      // //ABA TRANSPORTE
      // insereValor('#txtTransportadora', os.TAB_TRANS, os.NOME_TRANSP)
      // $('#rgTransportador').val(os.CIF)
      // insereValor('#txtNatureza', os.NATUREZA, os.DESC_NATUREZA)
      // $('#txtAliquota').val(os.ALIQUOTA)
      // $('#txtValFrete').val(os.FRETE)
      // $('#txtPesoBruto').val(os.PESO_BRUTO)
      // $('#txtPesoLiquido').val(os.PESO_LIQ)
      // $('#txtVolumes').val(os.VOLUMES)
      // $('#txtEndEntrega').val(os.END_ENT)
      // $('#txtBairroEntrega').val(os.BAIRRO_ENT)
      // $('#txtCidadeEntrega').val(os.NOME_CIDADE)
      // $('#txtEstadoEntrega').val(os.COD_UF)
      // $('#txtNumeroEntrega').val(os.NUM_ENT)
      // $('#txtCepEntrega').val(os.CEP)

      await buscaItens()
      await buscaHistoricoOrcamento()
      $('#txtStatus').val($('#tabelaHistoricoOrcamento').DataTable().data()[3][1])
      // await buscaCustomizacoes(orcamento)
      // await buscaConsumos(orcamento)
      // calculaTotais()

    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide')
    }
  }

  async function buscaItens(orcamento, os) {
    $('#tabelaItens').DataTable({
      language: {
        sEmptyTable: "Nenhum registro encontrado",
        sInfo: "_TOTAL_ registros",
        sInfoEmpty: " 0 registros",
        sInfoFiltered: "(Filtrados de _MAX_ registros)",
        sInfoPostFix: "",
        sInfoThousands: ".",
        sLengthMenu: "_MENU_ resultados",
        sLoadingRecords: "Carregando...",
        sProcessing: "Processando...",
        sZeroRecords: "Nenhum registro encontrado",
        sSearch: "Pesquisar",
        oPaginate: {
          sNext: "Próximo",
          sPrevious: "Anterior",
          sFirst: "Primeiro",
          sLast: "Último",
        },
        oAria: {
          sSortAscending: ": Ordenar colunas de forma ascendente",
          sSortDescending: ": Ordenar colunas de forma descendente",
        },
      },
      lengthChange: false,
      searching: false,
      paging: false,
      info: false,
      order: true,
      scrollX: true,
      scrollY: '400px',
      data: [[1, "0001", "CORTINA WAVE 3.4", 1.0, 1.29, 2.8, 1.0, "PC", 1474.20, 1474.20, 0.00, 0.00, 1474.20, 1, 2, 3, 4]],
      columns: columnsItens,
    });
    // const pesquisaParam = {
    //   tabela: 'OS_ITEN',
    //   camposSelect: ['OS_ITEN.ORDEM_DIG', 'OS_ITEN.CODIGO', 'OS_ITEN.TIPO_PROD',
    //     'PRODUTO.DESCRICAO DESCPRO', 'PROTOTIPO.DESCRICAO DESCPROT',
    //     'OS_ITEN.COR', 'CADCOR.DESCRICAO DESCCOR',
    //     'OS_ITEN.TAM', 'OS_ITEN.QTDE', 'OS_ITEN.PRECO', 'OS_ITEN.FAIXA', 'OS_ITEN.PROTOTIPO',
    //     'OS_ITEN.VALOR_TOTAL VALOR', 'OS_ITEN.CUSTOMIZACAO', 'OS_ITEN.OBS_APROV', 'OS_ITEN.OBS2', 'OS_ITEN.OBS3', 'OS_ITEN.OBSERVACAO',
    //     'OS_ITEN.MARKUP1', 'OS_ITEN.PRECO_ORIG', 'OS_ITEN.COMPL_PROD'],
    //   leftJoin: [{ tabela: "CADCOR", condicao: "CADCOR.COR = OS_ITEN.COR" },
    //   { tabela: "PRODUTO", condicao: "OS_ITEN.CODIGO = PRODUTO.CODIGO AND PRODUTO.CODIGO <> ''" },
    //   { tabela: "PRODUTO", alias: "PROTOTIPO", condicao: "OS_ITEN.PROTOTIPO = PROTOTIPO.PROTOTIPO AND OS_ITEN.PROTOTIPO IS NOT NULL AND OS_ITEN.PROTOTIPO <> ''" }
    //   ],
    //   where: [`OS_ITEN.NUMERO = '${orcamento}'`]
    // }

    // const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));
    // const codigos = []
    // insereValor('#txtMarkup', os.MARKUP, { tabela: 'CAD_MARKUP', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: os.MARKUP })
    // jsonStr.map(item => {
    //   $('#tabelaItens').DataTable().row.add({
    //     ORDEM: item.ORDEM_DIG,
    //     CODIGO: item.CODIGO == '' ? item.PROTOTIPO : item.CODIGO,
    //     DESCRICAO: item.DESCPRO == '' ? item.DESCPROT : item.DESCPRO,
    //     COR: item.COR,
    //     DESCCOR: item.DESCCOR,
    //     TAM: item.TAM,
    //     QTDE: item.QTDE,
    //     PRECO: item.PRECO,
    //     VALOR: item.VALOR,
    //     CUSTOMIZACAO: item.CUSTOMIZACAO,
    //     OBS2: item.OBS2,
    //     OBS3: item.OBS3,
    //     OBSERVACAO: item.OBSERVACAO,
    //     FAIXA: item.FAIXA,
    //     PROTOTIPO: item.PROTOTIPO,
    //     MARKUP: item.MARKUP1,
    //     PRECO_ORIG: parseFloat(item.PRECO_ORIG) <= 0 ? item.PRECO : item.PRECO_ORIG,
    //     COMPL_PROD: item.COMPL_PROD
    //   }).draw(false);

    //   codigos.push(item.PROTOTIPO)
    // });

    // let codigosUnicos = codigos.reduce((acc, item) => {
    //   if (!acc.includes(item)) {
    //     acc.push(item);
    //   }
    //   return acc;
    // }, []);

    // codigosUnicos = await formataListas(codigosUnicos.toString())
    // await buscarCaracteristicas(codigosUnicos)
  }

  $('#btnConfirmar').on('click', async function () {
    $.LoadingOverlay('show')
    const data = [{
      CODIGO: pegaChave('#txtCodigo'),
      DESCRICAO: pegaChave('#txtCor'),
      QTDE: pegaValor('#txtQuantidade'),
      LARGURA: pegaValor('#txtLargura'),
      ALTURA: pegaValor('#txtAltura'),
      QTDE_UNIT: pegaValor('#txtQuantidadeUnitaria'),
      UN: pegaValor('#txtUnidade'),
      QTDE_TOTAL: 0,
      VAL_UNIT: 0,
      SUBTOTAL: 0,
      DESC_UNIT: 0,
      SUB_C: 0,
      VAL_IPI: 0,
      VAL_ST: 0,
      VAL_TOTAL: 0
    }]

    try {
      await preencheItens(data)
      limpaValoresItens()
    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide')
    }
  })

  function limpaValoresItens() {
    $('#txtCodigo').val('')
    $('#txtCor').val('')
    $('#txtLargura').val('')
    $('#txtAltura').val('')
    $('#selectTipoTrilho').val('')
    $('#selectKitTrilho').val('')
    $('#selectAbertura').val('')
    $('#selectTipoCobertura').val('')
    $('#txtTrilhoFrontal').val('')
    $('#txtTrilhoTraseiro').val('')
    $('#txtDeslizFrontal').val('')
    $('#txtDeslizTraseiro').val('')
    $('#txtSuporte').val('')
    $('#txtSuporteFlange').val('')
    $('#txtFinalFrontal').val('')
    $('#txtFinalTraseiro').val('')
    $('#txtTecido').val('')
    $('#selectBarraTecido').val('')
    $('#selectDuplaTecido').val('')
    $('#selectFranzTecido').val('')
    $('#selectInverterTecido').val('')
    $('#txtForro').val('')
    $('#selectBarraForro').val('')
    $('#selectDuplaForro').val('')
    $('#selectFranzForro').val('')
    $('#selectInverterForro').val('')
    $('#txtBlackout').val('')
    $('#selectBarraBlackout').val('')
    $('#selectDuplaBlackout').val('')
    $('#selectFranzBlackout').val('')
    $('#selectInverterBlackout').val('')
    $('#txtCostureira').val('')
    $('#txtInstalador').val('')
    $('#txtInstalador').val('')
    $('#btnLimpaOpcional').trigger('click')
    $('#txtQuantidade').val('')
    $('#txtObsCostureira').val('')
  }

  async function preencheItens(dados) {
    const tabelaItens = $('#tabelaItens').DataTable()

    dados.map((item) => {
      tabelaItens.row.add([
        item.CODIGO,
        item.DESCRICAO,
        item.QTDE,
        item.LARGURA,
        item.ALTURA,
        0,
        0,
        item.QTDE_TOTAL,
        item.VAL_UNIT,
        item.SUBTOTAL,
        item.DESC_UNIT,
        item.SUB_C,
        item.VAL_IPI,
        item.VAL_ST,
        item.VAL_TOTAL
      ]).draw(false);
    })
    calculaTotais()
    $('#modalItem').modal('hide')
  }

  function calculaTotais() {
    let qtdeTotal = 0;
    let valorTotal = 0;
    for (let i = 0; i < $('#tabelaItens').DataTable().data().toArray().length; i++) {
      const item = $('#tabelaItens').DataTable().data().toArray()[i]
      qtdeTotal += parseInt(item.QTDE)
      valorTotal = parseFloat(valorTotal) + parseFloat(item.VALOR)
    }

    const novoValor = parseFloat(valorTotal) || 0
    const desc = $('#txtDesconto').val() || 0
    let novoValorLiq = 0
    if (desc > 0) {
      novoValorLiq = novoValor - (novoValor * (desc / 100))
    } else {
      novoValorLiq = novoValor
    }
    $('.txtTotalQtde').text(qtdeTotal)
    $('.txtValorTotal').html(parseFloat(novoValor.toFixed(2)).toLocaleString("pt-BR", { style: "decimal" }));
    $('.txtTotalLiquido').html(parseFloat(novoValorLiq.toFixed(2)).toLocaleString("pt-BR", { style: "decimal" }));
    $("#txtValorFinanceiro").html(parseFloat(novoValorLiq.toFixed(2)).toLocaleString("pt-BR", { style: "decimal" }))
  }

  $('#modalItem').on('hidden.bs.modal', function () {
    $('#tabelaItens').DataTable().columns.adjust().draw(false)
    itensAlteracao = []
    limpaValoresItens()
  })

  $('#txtQtde').on('keydown', function (e) {
    if (e.key == ',' || e.key == '.') {
      e.preventDefault();
    }
  });

  $('#txtQtde').on('input', function () {
    this.value = this.value.replace(/[^\d-]/g, '');
    this.value = this.value.replace(/(\d+)[.,](\d+)/, '$1');
  });

  $('#voltarAcesso').on('click', async function () {
    await deletaRegistro('ORCAMENTO_CORTINA', getCookie('usuario'), orcamento);
    window.location.href = `${BASE_URI}/orcamento_cortina`;
  })

  async function informacoesCliente(sChave) {
    const pesquisaParam = {
      tabela: "ENTIDADE",
      camposSelect: [
        "ENTIDADE.CODCLI",
        "ENTIDADE.NOME",
        "ENTIDADE.CNPJ",
        "ENTIDADE.EMAIL",
        "ENTIDADE.DDD_FONE",
        "ENTIDADE.TELEFONE",
        "ENTIDADE.COD_PAIS",
        "ENTIDADE.CEP",
        "CIDADE.NOME CIDADE",
        "CIDADE.COD_UF ESTADO",
        "ENTIDADE.BAIRRO",
        "ENTIDADE.ENDERECO",
        "ENTIDADE.NUMERO",
        "ENTIDADE.COMPLEMENTO",
        "ENTIDADE.OBS",
        "ENTIDADE.INSCRICAO",
        "ENTIDADE.DATA_CAD",
        "ENTIDADE.CLASSIFICA",
        "ENTIDADE.PERFIL",
        "PERFIL.DESCRICAO AS DESC_PERFIL",
        "ENTIDADE.GRUPO",
        "GRUPO_CLI.DESCRICAO AS DESC_GRUPO",
        "ENTIDADE.DESCONTO",
        "ENTIDADE.DT_NASC"
      ],
      leftjoin: [{
        tabela: "CADCEP",
        condicao: "ENTIDADE.CEP = CADCEP.CEP"
      },
      {
        tabela: "CIDADE",
        condicao: "CADCEP.CODMUN = CIDADE.CODIGO"
      },
      {
        tabela: "GRUPO_CLI",
        condicao: "ENTIDADE.GRUPO = GRUPO_CLI.CODIGO"
      },
      {
        tabela: "PERFIL",
        condicao: "ENTIDADE.PERFIL = PERFIL.CODIGO"
      }
      ],
      where: [`ENTIDADE.CODCLI = '${sChave}'`],
      camposWhereServerSide: ["ENTIDADE.CODCLI", "ENTIDADE.NOME", "ENTIDADE.CNPJ", "ENTIDADE.FANTASIA", "CIDADE.NOME", "CADCEP.ESTCEP"]
    };

    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));
    // $('#txtDataCadastroInfo').val(jsonStr[0].DATA_CAD.slice(0, 10));
    // $('#txtDataNascimentoInfo').val(jsonStr[0].DT_NASC?.slice(0, 10));
    $('#txtCpfInfoCliente').val(jsonStr[0].CNPJ);
    $('#txtEmailInfoCliente').val(jsonStr[0].EMAIL);
    $('#txtDddInfoCliente').val(jsonStr[0].DDD_FONE);
    $('#txtTelefoneInfoCliente').val(jsonStr[0].TELEFONE);
    await concatenaPais(jsonStr[0].COD_PAIS);
    $('#txtCepInfoCliente').val(jsonStr[0].CEP);
    $('#txtMunicipioInfoCliente').val(jsonStr[0].CIDADE);
    $('#txtEstadoInfoCliente').val(jsonStr[0].ESTADO);
    $('#txtBairroInfoCliente').val(jsonStr[0].BAIRRO);
    $('#txtEnderecoInfoCliente').val(jsonStr[0].ENDERECO);
    $('#txtNumeroInfoCliente').val(jsonStr[0].NUMERO);
    $('#txtComplementoInfoCliente').val(jsonStr[0].COMPLEMENTO);
    $('#txtObsInfoCliente').val(jsonStr[0].OBS);
    $('#txtInscricaoInfoCliente').val(jsonStr[0].INSCRICAO);
    const classificacaoEntidadeInfo = jsonStr[0].CLASSIFICA.replace('    ', '');
    if (classificacaoEntidadeInfo != '' && classificacaoEntidadeInfo != 'null' && classificacaoEntidadeInfo != null) {
      $('#txtClassificacaoInfoCliente').val(classificacaoEntidadeInfo);
    }
    if (jsonStr[0].GRUPO != '' && jsonStr[0].GRUPO != null) {
      $('#txtGrupoInfoCliente').val(`[${jsonStr[0].GRUPO}] - ${jsonStr[0].DESC_GRUPO}`);
    };
    if (jsonStr[0].PERFIL != '' && jsonStr[0].PERFIL != null) {
      $('#txtPerfilInfoCliente').val(`[${jsonStr[0].PERFIL}] - ${jsonStr[0].DESC_PERFIL}`);
    };
    $('#txtPercDescontoInfoCliente').val(jsonStr[0].DESCONTO);
  }

  async function concatenaPais(sPais) {
    let retorno = await requisicao(
      "GET",
      "/Sisplan/Funcoes/v1/pesquisa?",
      `JSON={ "tabela":"CADPAIS",
        "camposSelect":["NOME"],
        "where": ["CODIGO = '${sPais}'"]}`,
      null
    );
    let jsonString = await retorno.json();
    if (jsonString.RESULT[0] != 0) {
      insereValor($("#txtPaisInfoCliente"), sPais, jsonString.RESULT[0][0].NOME);
    }
    return
  }

  $('#btn-info-cliente').on('click', async function () {
    const clienteTitulo = $('#txtCliente').val().replace('[', '').replace(']', '').split('-');
    await informacoesCliente(pegaChave("#txtCliente"));
    $('#modal-info-cliente').modal('show');
    $('#txtCodigoTittle').html(`${clienteTitulo[0]}-${clienteTitulo[1]}`);
  });

  aplicaMascara();
  $('#carregaHistoricoStatus').on('click', function () {
    $('#modalHistorico').modal('show')
  })

  $('#modalHistorico').on('show.bs.modal', async function () {
    await buscaHistoricoOrcamento()
  })

  async function buscaHistoricoOrcamento() {
    if ($.fn.DataTable.isDataTable('#tabelaHistoricoOrcamento')) {
      $('#tabelaHistoricoOrcamento').DataTable().destroy();
      $('#tabelaHistoricoOrcamento').empty();
    };
    try {

      $('#tabelaHistoricoOrcamento').DataTable({
        language: {
          sEmptyTable: "Nenhum registro encontrado",
          sInfo: "_TOTAL_ registros",
          sInfoEmpty: " 0 registros",
          sInfoFiltered: "(Filtrados de _MAX_ registros)",
          sInfoPostFix: "",
          sInfoThousands: ".",
          sLengthMenu: "_MENU_ resultados",
          sLoadingRecords: "Carregando...",
          sProcessing: "Processando...",
          sZeroRecords: "Nenhum registro encontrado",
          sSearch: "Pesquisar",
          oPaginate: {
            sNext: "Próximo",
            sPrevious: "Anterior",
            sFirst: "Primeiro",
            sLast: "Último",
          },
          oAria: {
            sSortAscending: ": Ordenar colunas de forma ascendente",
            sSortDescending: ": Ordenar colunas de forma descendente",
          },
        },
        lengthChange: false,
        searching: false,
        paging: false,
        info: false,
        data: [
          [1, "Pedido Aberto", "teste", "10/07/2025"],
          [2, "PedidoAprovado", "teste2", "20/06/2025"],
          [3, "Expedição", "teste3", "15/07/2025"],
          [4, "Entregue", "teste4", "05/04/2025"],
        ],
        columns: columnsHistorico
      });

    } catch (error) {
      msgAlerta(error.message || 'Não foi possível encontrar o histórico do orçamento')
    } finally {
      $.LoadingOverlay('hide')
    }
  }

  $('#calcular').on('click', function () {
    $('#modalResultado').modal('show')
  })

  $('#modalResultado').on('show.bs.modal', async function () {
    if ($.fn.DataTable.isDataTable('#tabelaResultado')) {
      $('#tabelaResultado').DataTable().destroy();
      $('#tabelaResultado').empty();
    };
    try {

      $('#tabelaResultado').DataTable({
        language: {
          sEmptyTable: "Nenhum registro encontrado",
          sInfo: "_TOTAL_ registros",
          sInfoEmpty: " 0 registros",
          sInfoFiltered: "(Filtrados de _MAX_ registros)",
          sInfoPostFix: "",
          sInfoThousands: ".",
          sLengthMenu: "_MENU_ resultados",
          sLoadingRecords: "Carregando...",
          sProcessing: "Processando...",
          sZeroRecords: "Nenhum registro encontrado",
          sSearch: "Pesquisar",
          oPaginate: {
            sNext: "Próximo",
            sPrevious: "Anterior",
            sFirst: "Primeiro",
            sLast: "Último",
          },
          oAria: {
            sSortAscending: ": Ordenar colunas de forma ascendente",
            sSortDescending: ": Ordenar colunas de forma descendente",
          },
        },
        lengthChange: false,
        searching: false,
        paging: false,
        info: false,
        data: [
          [1, "015533", "LINHO IRLANDES COR 03 CINZA TAPECARIA 3,00L", "TECIDO", "TECIDO", "MP", "3,00M", "3,00 x 3,50", 10.500, "MT", "R$ 32,50", "R$ 341,25"],
          [2, "023264", "MICROFIBRA CLASSICA AREIA TAPECARIA 3,00L", "FORRO", "FORRO", "MP", "3,00M", "3,00 x 3,30", 6.270, "MT", "R$ 29,90", "R$ 206,91"],
          [3, "004492", "KIT TRILHO WAVE MONT C/ ACION 3X1 ATE 3 50", "TRILHO FRONTAL", "TRILHO FRONTAL", "MP", "INDEFINIDO", "", 1.000, "PC", "R$ 299,90", "R$ 299,90"],
          [4, "004733", "FITA WAVE 3X1 BRANCA", "PASSA FITA", "PASSA FITA", "MP", "INDEFINIDO", "", 9.000, "MT", "R$ 12,26", "R$ 110,34"],
          [5, "004732", "ENTRETELA TNT 10 CM BRANCA", "ENTRETELA TECIDO", "ENTRETELA TECIDO", "MP", "INDEFINIDO", "", 8.225, "MT", "R$ 2,20", "R$ 18,10"],
          [6, "004734", "CORDA C/ ESPAÇAMENTO WAVE", "CORDÃO WAVE", "CORDÃO WAVE", "MP", "INDEFINIDO", "", 3.690, "UN", "R$ 8,90", "R$ 32,84"],
          [7, "000055", "TAXA DE CONFECÇÃO NORMAL - TECIDO ATE 3", "CONFECÇÃO INTERNA", "CONFECÇÃO INTERNA", "SE", "INDEFINIDO", "", 3.290, "MT", "R$ 120,00", "R$ 394,80"],
          [8, "000055", "TAXA DE CONFECÇÃO NORMAL - FORRO ATE 3", "CONFECÇÃO INTERNA", "CONFECÇÃO INTERNA", "SE", "INDEFINIDO", "", 3.290, "MT", "R$ 10,00", "R$ 32,90"],
          [9, "010735", "TAXA DE INSTALAÇÃO FIXA", "OPCIONAL", "OPCIONAL", "SE", "INDEFINIDO", "", 1.000, "PC", "R$ 70,00", "R$ 70,00"],
        ],
        columns: columnsResultado
      });

    } catch (error) {
      msgAlerta(error.message || 'Não foi possível encontrar o histórico do orçamento')
    } finally {
      $.LoadingOverlay('hide')
    }
  });
});
