<?php include_once('../../../config.php') ?>

<!DOCTYPE html>
<html>

<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Sisplan Web | Orçamento de Cortinas</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link rel="stylesheet" href="../dist/css/adminlte.min.css?versao=3.258.7.1">
  <link rel="stylesheet" href="../plugins/fontawesome-free/css/all.min.css?versao=3.258.7.1">
  <link href='https://fonts.googleapis.com/css?family=Roboto:400,300,500,600,700,400italic' rel='stylesheet' type='text/css'>
  <link rel="stylesheet" type="text/css" href="../dist/css/dataTables.bootstrap4.min.css?versao=3.258.7.1" />
  <link href='../dist/css/bootstrap.min.css?versao=3.258.7.1'>
  <link rel="stylesheet" href="../dist/css/custom.css?versao=3.258.7.1">
  <link rel="stylesheet" href="../dist/css/sisplan.css?versao=3.258.7.1">
  <link rel="stylesheet" href="../dist/css/PesquisaVariosSelect2.css?versao=3.258.7.1">
  <link rel="stylesheet" type="text/css" href="../plugins/datatables-keytable/css/keyTable.bootstrap4.min.css?versao=3.258.7.1">
  <link rel="stylesheet" type="text/css" href="../dist/css/responsive.bootstrap.min.css?versao=3.258.7.1">
  <link rel="shortcut icon" href="../favicon.ico">
  <link rel="stylesheet" href="../plugins/toastr/toastr.min.css?versao=3.258.7.1">
  <link rel="stylesheet" type="text/css" href="../dist/css/driver.min.css?versao=3.258.7.1" />
  <link rel="stylesheet" href="../dist/css/jquery-ui.css?versao=3.258.7.1">
  <link rel="stylesheet" href="../dist/css/cadastro.css?versao=3.258.7.1">
  <link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700" rel="stylesheet">
  <link rel="stylesheet" href="../plugins/select2/css/select2.min.css?versao=3.258.7.1">
  <link rel="stylesheet" href="../plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css?versao=3.258.7.1">

  <style>
    #progressbar li {
      list-style-type: none;
      font-size: 12px;
      width: 33.33%;
      float: left;
      position: relative
    }


    .input-group-append>a>i {
      margin-left: 0 !important;
      padding-left: 5px;
      padding-right: 5px;
    }

    .focus:read-only:focus {
      border-color: #aa1212 !important;
    }

    .border-Field .textoBorda {
      font-size: 1.0em !important;
      text-align: left !important;
      width: auto;
      padding: 0 10px;
      border-bottom: none;
    }

    .border-Field {
      border: 1.0px solid var(--font-color) !important;
      padding: 0 1.0em 1.0em 1.0em !important;
      margin: 0 0 1.0em 0 !important;
      -webkit-box-shadow: 0px 0px 0px 0px #000;
      box-shadow: 0px 0px 0px 0px #000;
      padding-bottom: 0px !important;
    }
  </style>

</head>

<body class="sidebar-mini layout-fixed">
  <div class="wrapper">


    <div id="myModal" class="modal" tabindex="-1" role="dialog">
      <div class="modal-dialog" role="document">
        <div class="modal-content">
          <div class="modal-header">
            <h5 id="myModalLabel" class="modal-title"></h5>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>
          <div class="modal-body">
            <p id="myModalText"></p>
          </div>
          <div class="modal-footer">
            <button id="btnYes" type="button" class="btn btn-primary">Sim</button>
            <button id="btnNo" type="button" class="btn btn-secondary" data-dismiss="modal">Não</button>
          </div>
        </div>
      </div>
    </div>

    <div class="content-wrapper">
      <section class="content">
        <div class="container-fluid" id="grad1">
          <div class="row justify-content-center mt-0">
            <div class="col-10 text-center p-0 mt-3 mb-2">
              <div class="card px-0 pt-4 pb-0 mt-3 mb-3">
                <div class="card-header text-center flex" style="border: none!important;box-shadow:none!important;">
                  <h2>Orçamento de Cortina
                    <button title="Tutorial" type="button" class="btn btn-info btn-sm ml-2" style="color: white;" id="tutorial">
                      <i class="fas fa-question-circle"></i>
                    </button>
                  </h2>
                </div>

                <div class="row">
                  <div class="col-md-12 mx-0">
                    <form id="msform">
                      <ul id="progressbar">
                        <li class="active" id="account"><strong>Geral</strong></li>
                        <li id="payment"><strong>Itens</strong></li>
                        <li id="confirm"><strong>Previsão de Pagamento</strong></li>
                      </ul>
                      <p>Preencha os dados e clique em avançar até a conclusão do orçamento</p>
                      <fieldset>
                        <div class="form-card" id="tourGeral">
                          <h2 class="fs-title">Dados Gerais</h2>
                          <div class="row">
                            <div class="col-lg-5 col-6 form-group">
                              <label data-error="wrong" data-success="right" for="txtNumero">Número:</label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control" disabled id="txtNumero" name="txtNumero" class="form-control" placeholder="Número">
                              </div>
                            </div>

                            <div class="col-lg-5 col-12 form-group">
                              <label>Empresa: *</label>
                              <div class="input-group">
                                <select class="form-control select2 select2-danger focus" id="selectEmpresa" name="selectEmpresa" data-dropdown-css-class="select2-danger">
                                </select>
                              </div>
                            </div>

                            <div class="col-lg-2 col-3 form-group">
                              <label data-error="wrong" data-success="right" for="txtStatus">Status: <a id="carregaHistoricoStatus" style="text-decoration: underline; cursor: pointer" class="hover-overlay" target="_blank"><i class="fas fa-history"></i></a></label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control" id="txtStatus" disabled name="txtStatus" class="form-control" placeholder="Status" value='Entregue'>
                              </div>
                            </div>

                            <div class="col-lg-6 col-6 form-group">
                              <label data-error="wrong" data-success="right" for="txtVendedor">Vendedor: *</label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control" id="txtVendedor" name="txtVendedor" class="form-control" placeholder="Vendedor" required>
                                <div class="input-group-append">
                                  <button class="btn bg-danger" id="btnVendedor" name="btnVendedor" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                  <button class="btn bg-danger" id="btnLimpaVendedor" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                </div>
                              </div>
                            </div>

                            <div class="col-lg-6 col-6 form-group">
                              <label data-error="wrong" data-success="right" for="txtAssistente">Assistente:</label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control" id="txtAssistente" name="txtAssistente" class="form-control" placeholder="Assistente">
                                <div class="input-group-append">
                                  <button class="btn bg-danger" id="btnAssistente" name="btnAssistente" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                  <button class="btn bg-danger" id="btnLimpaAssistente" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                </div>
                              </div>
                            </div>

                            <div class="col-lg-6 col-6 form-group">
                              <label data-error="wrong" data-success="right" for="txtCliente">Cliente: *</label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control" id="txtCliente" name="txtCliente" class="form-control" placeholder="Cliente">
                                <div class="input-group-append">
                                  <button class="btn bg-danger" id="btn-info-cliente" name="btn-info-cliente" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-user"></i></button>
                                  <button class="btn bg-danger" id="btnCliente" name="btnCliente" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                  <button class="btn bg-danger" id="btnLimpaCliente" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                </div>
                              </div>
                            </div>

                            <div class="col-lg-3 col-12 form-group">
                              <label data-error="wrong" data-success="right" for="dtEntrega">Previsão Entrega: *</label>
                              <div class="input-group">
                                <input type="date" max="2500-12-31" value="" class="input-default focus form-control" id="dtEntrega" name="dtEntrega" class="form-control" placeholder="Comissão 1">
                              </div>
                            </div>

                            <div class="col-lg-3  col-12 form-group">
                              <label data-error="wrong" data-success="right" for="dtDigitacao">Data digitação:</label>
                              <div class="input-group">
                                <input type="date" max="2500-12-31" value="" class="input-default focus form-control" disabled id="dtDigitacao" name="dtDigitacao" class="form-control" placeholder="Comissão 1">
                              </div>
                            </div>

                            <div class="col-lg-12 col-12 form-group">
                              <label data-error="wrong" data-success="right" for="txtObservacoes">Observação:</label>
                              <textarea style="resize: none" id="txtObservacoes" placeholder="Observações" class="input-default focus form-control" rows="4"></textarea>
                            </div>

                          </div>
                        </div>
                        <input type="button" id="avancar1" name="next" class="next action-button" value="Avançar" />
                        <input type="button" id="voltarAcesso" class="previous action-button-previous" value="Voltar" />
                      </fieldset>
                      <fieldset id="ItensFs">
                        <div class="form-card">
                          <div class="row d-flex justify-content-between">
                            <div class="col-lg-6 col-6 form-group">
                              <label data-error="wrong" data-success="right" for="txtTabPreco">Tabela de Preco: *</label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control" id="txtTabPreco" name="txtTabPreco" value="[001] - TABELA PADRÃO" disabled class="form-control" placeholder="Tabela de Preco">
                                <div class="input-group-append">
                                  <button class="btn bg-danger" disabled id="btnTabPreco" name="btnTabPreco" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                  <button class="btn bg-danger" disabled id="btnLimpaTabPreco" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                </div>
                              </div>
                            </div>
                            <div class="col-lg-2 ml-auto mt-auto">
                              <button type="button" id="btnAddItem" class="btn btn-danger col-12">Adicionar Item</button>
                            </div>
                          </div>
                          <div id="items-wrap" class="table-wrap">
                            <div class="col-sm-12 table-responsive">
                              <table id="tabelaItens" style="width:100%" class="table table-responsive-sm table-select table-hover" width="100%">
                                <thead>
                                </thead>
                                <tbody>
                                </tbody>
                              </table>
                            </div>
                          </div>
                        </div>
                        <input type="button" id="avancarItens" name="next" class="next action-button" value="Avançar" />
                        <input type="button" id="calcular" name="calcular" class="btn-sisp btn btn-primary btn-sm action-button" style="background: var(--info-box-primary) !important" value="Calcular" />
                        <input type="button" name="previous" id="voltarItens" class="previous action-button-previous" value="Voltar" />
                      </fieldset>
                      <fieldset id="financeiroFs">
                        <div class="form-card" id="tourFinanceiro">
                          <h2 class="fs-title">Pagamento</h2>

                          <div class="row card-totais">
                            <div class="col-lg-2  col-4 form-group">
                              <label data-error="wrong" data-success="right" for="txtValorLiq">Valor Líq. Total:</label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control maskDecimais" id="txtValorLiq" name="txtValorLiq" disabled>
                              </div>
                            </div>
                            <div class="col-lg-2  col-3 form-group">
                              <label data-error="wrong" data-success="right" for="txtDespesas">Despesas:</label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control maskDecimais" id="txtDespesas" name="txtDespesas" placeholder="Despesas">
                              </div>
                            </div>
                            <div class="col-lg-2  col-3 form-group">
                              <label data-error="wrong" data-success="right" for="txtTaxa">Taxa:</label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control maskDecimais" id="txtTaxa" name="txtTaxa" placeholder="Taxa">
                              </div>
                            </div>
                            <div class="col-lg-2 form-group">
                              <label data-error="wrong" data-success="right" for="txtFrete">Frete:</label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control maskDecimais" id="txtFrete" name="txtFrete" placeholder="Frete">
                              </div>
                            </div>
                            <div class="col-lg-2 form-group">
                              <label data-error="wrong" data-success="right" for="txtFreteTrans">Frete Transp.:</label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control maskDecimais" id="txtFreteTrans" name="txtFreteTrans" placeholder="Frete transportadora">
                              </div>
                            </div>
                            <div class="col-lg-2 form-group">
                              <label data-error="wrong" data-success="right" for="txtBonif">Bonif:</label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control maskDecimais" id="txtBonif" name="txtBonif" placeholder="Bonif">
                              </div>
                            </div>

                            <div class="col-lg-12  col-12 form-group" style="margin-bottom: 0px;">
                              <label data-error="wrong" data-success="right">Condição de pagamento: *</label>
                            </div>
                            <div class="col-lg-1  col-1 form-group">
                              <div class="input-group">
                                <input type="text" value="0" class="input-default focus form-control" id="txtCondPagto1" name="txtCondPagto1" placeholder="1">
                              </div>
                            </div>
                            <div class="col-lg-1  col-1 form-group">
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control" id="txtCondPagto2" name="txtCondPagto2" placeholder="2">
                              </div>
                            </div>
                            <div class="col-lg-1  col-1 form-group">
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control" id="txtCondPagto3" name="txtCondPagto3" placeholder="3">
                              </div>
                            </div>
                            <div class="col-lg-1  col-1 form-group">
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control" id="txtCondPagto4" name="txtCondPagto4" placeholder="4">
                              </div>
                            </div>
                            <div class="col-lg-1  col-1 form-group">
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control" id="txtCondPagto5" name="txtCondPagto5" placeholder="5">
                              </div>
                            </div>
                            <div class="col-lg-1  col-1 form-group">
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control" id="txtCondPagto6" name="txtCondPagto6" placeholder="6">
                              </div>
                            </div>
                            <div class="col-lg-1  col-1 form-group">
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control" id="txtCondPagto7" name="txtCondPagto7" placeholder="7">
                              </div>
                            </div>
                            <div class="col-lg-1  col-1 form-group">
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control" id="txtCondPagto8" name="txtCondPagto8" placeholder="8">
                              </div>
                            </div>
                            <div class="col-lg-1  col-1 form-group">
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control" id="txtCondPagto9" name="txtCondPagto9" placeholder="9">
                              </div>
                            </div>
                            <div class="col-lg-1  col-1 form-group">
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control" id="txtCondPagto10" name="txtCondPagto10" placeholder="10">
                              </div>
                            </div>
                            <div class="col-lg-1  col-1 form-group">
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control" id="txtCondPagto11" name="txtCondPagto11" placeholder="11">
                              </div>
                            </div>
                            <div class="col-lg-1  col-1 form-group">
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control" id="txtCondPagto12" name="txtCondPagto12" placeholder="12">
                              </div>
                            </div>
                            <div class="col-lg-3  col-3 form-group">
                              <label data-error="wrong" data-success="right" for="txtMoeda">Moeda: *</label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control" id="txtMoeda" name="txtMoeda" placeholder="Moeda">
                                <div class="input-group-append">
                                  <button class="btn bg-danger" id="btnMoeda" name="btnMoeda" data-button="absolute" type="button">
                                    <i class="m-0 p-0 fas fa-search"></i>
                                  </button>
                                  <button class="btn bg-danger" id="btnLimpaMoeda" type="button">
                                    <i class="m-0 p-0 fas fa-trash"></i>
                                  </button>
                                </div>
                              </div>
                            </div>

                            <div class="col-lg-3  col-3 form-group">
                              <label for="txtSitDup">Situação Dup.:</label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control" id="txtSitDup" name="txtSitDup" placeholder="Situação Dup.">
                                <div class="input-group-append">
                                  <button class="btn bg-danger" id="btnSitDup" name="btnSitDup" data-button="absolute" type="button">
                                    <i class="m-0 p-0 fas fa-search"></i>
                                  </button>
                                  <button class="btn bg-danger" id="btnLimpaSitDup" type="button">
                                    <i class="m-0 p-0 fas fa-trash"></i>
                                  </button>
                                </div>
                              </div>
                            </div>

                            <div class="col-lg-3  col-3 form-group">
                              <label for="txtHistorico">Histórico:</label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control" id="txtHistorico" name="txtHistorico" placeholder="Histórico">
                                <div class="input-group-append">
                                  <button class="btn bg-danger" id="btnHistorico" name="btnHistorico" data-button="absolute" type="button">
                                    <i class="m-0 p-0 fas fa-search"></i>
                                  </button>
                                  <button class="btn bg-danger" id="btnLimpaHistorico" type="button">
                                    <i class="m-0 p-0 fas fa-trash"></i>
                                  </button>
                                </div>
                              </div>
                            </div>

                            <div class="col-lg-3  col-3 form-group">
                              <label for="txtClasseGer">Classe Gerencial:</label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control" id="txtClasseGer" name="txtClasseGer" placeholder="Classe Gerencial">
                                <div class="input-group-append">
                                  <button class="btn bg-danger" id="btnClasseGer" name="btnClasseGer" data-button="absolute" type="button">
                                    <i class="m-0 p-0 fas fa-search"></i>
                                  </button>
                                  <button class="btn bg-danger" id="btnLimpaClasseGer" type="button">
                                    <i class="m-0 p-0 fas fa-trash"></i>
                                  </button>
                                </div>
                              </div>
                            </div>

                            <div class="col-lg-3  col-3 form-group">
                              <label data-error="wrong" data-success="right" for="txtCondicao">Condição:</label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control" id="txtCondicao" name="txtCondicao" placeholder="Condicao" disabled>
                                <div class="input-group-append">
                                  <button class="btn bg-danger" id="btnCondicao" name="btnCondicao" data-button="absolute" type="button" disabled>
                                    <i class="m-0 p-0 fas fa-search"></i>
                                  </button>
                                  <button class="btn bg-danger" id="btnLimpaCondicao" type="button" disabled>
                                    <i class="m-0 p-0 fas fa-trash"></i>
                                  </button>
                                </div>
                              </div>
                            </div>
                            <div class="col-lg-2  col-2 form-group">
                              <label data-error="wrong" data-success="right" for="txtNrParcelas">Nr. Parcelas:</label>
                              <div class="input-group">
                                <input type="number" class="input-default focus form-control" id="txtNrParcelas" name="txtNrParcelas" value="0" disabled>
                              </div>
                            </div>
                            <div class="col-lg-2  col-2 form-group">
                              <label data-error="wrong" data-success="right" for="txtIntervaloDias">Intervalo de Dias:</label>
                              <div class="input-group">
                                <input type="number" class="input-default focus form-control" id="txtIntervaloDias" name="txtIntervaloDias" value="1" disabled>
                              </div>
                            </div>
                            <div class="col-lg-2  col-2 form-group">
                              <label data-error="wrong" data-success="right" for="dtPrimeiroVencto">1º Vencimento:</label>
                              <div class="input-group">
                                <input type="date" max="2500-12-31" class="input-default focus form-control" id="dtPrimeiroVencto" name="dtPrimeiroVencto" disabled>
                              </div>
                            </div>
                            <div class="col-lg-3  col-3 form-group">
                              <label data-error="wrong" data-success="right" for="txtValorCondicao">Valor condição:</label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control maskDecimais" id="txtValorCondicao" name="txtValorCondicao" placeholder="Valor condição">
                              </div>
                            </div>
                          </div>
                          <div class="form_group">
                            <div class="row d-flex justify-content-end">
                              <div class="col-lg-3  col-3 form-group" style="margin-top: 24px;">
                                <input type="button" class="btn float-right btn-danger btn-sisp" id="btnAtualizar" name="make_payment" value="Atualizar" style="margin: 1px" />
                                <input type="button" class="btn float-right  btn-primary btn-sisp" id="btnLimpar" name="make_payment" value="Limpar" style="margin: 1px" />
                              </div>
                            </div>
                          </div>
                          <div class="col-sm-12 table-responsive card-body">
                            <table id="tabelaCondicao" class="table table-responsive-sm table-select table-hover" width="100%">
                              <thead>
                                <tr>
                                  <th class="th-sm">Dias</th>
                                  <th class="th-sm">Vencimento</th>
                                  <th class="th-sm">Moeda</th>
                                  <th class="th-sm">Condição</th>
                                  <th class="th-sm">Desc. Condição</th>
                                  <th class="th-sm">Valor</th>
                                </tr>
                              </thead>
                              <tbody>
                              </tbody>
                            </table>
                          </div>
                        </div>

                        <input type="submit" id="gravar" class="action-button" value="Gravar" />
                        <input type="button" name="previous" id="ultimoVoltar" class="btn-sisp previous action-button-previous" value="Voltar" />
                      </fieldset>
                    </form>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </section>
    </div>
  </div>

  <div class="modal fade" id="modalItem" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog " style="min-width: 95%;">
      <div class="modal-content">
        <div class="modal-header">
          <h4 class="modal-title">Adicionar Item</h4>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">

          <div class="row">
            <div class="row">
              <div class="col-4 form-group">
                <label data-error="wrong" data-success="right" for="txtCodigo">Modelo de Cortina:</label>
                <div class="input-group">
                  <input type="text" class="input-default focus form-control" id="txtCodigo" name="txtCodigo" class="form-control" placeholder="Código">
                  <div class="input-group-append">
                    <button class="btn bg-danger" id="btnCodigo" name="btnCodigo" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                    <button class="btn bg-danger" id="btnLimpaCodigo" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                  </div>
                </div>
              </div>

              <div class="col-4 form-group">
                <label data-error="wrong" data-success="right" for="txtCor">Cor:</label>
                <div class="input-group">
                  <input type="text" class="input-default focus form-control" id="txtCor" name="txtCor" class="form-control" placeholder="Cor">
                  <div class="input-group-append">
                    <button class="btn bg-danger" id="btnCor" name="btnCor" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                    <button class="btn bg-danger" id="btnLimpaCor" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                  </div>
                </div>
              </div>

              <div class="col-2 form-group">
                <label data-error="wrong" data-success="right" for="txtLargura">Largura:</label>
                <div class="input-group">
                  <input type="text" class="input-default focus form-control camposMascara" id="txtLargura" name="txtLargura" value="0.00" class="form-control" placeholder="Largura">
                </div>
              </div>

              <div class="col-2 form-group">
                <label data-error="wrong" data-success="right" for="txtAltura">Altura:</label>
                <div class="input-group">
                  <input type="text" class="input-default focus form-control camposMascara" id="txtAltura" name="txtAltura" value="0.00" class="form-control" placeholder="Altura">
                </div>
              </div>

              <div class="col-3 form-group">
                <label>Tipo de Trilho:</label>
                <div class="input-group">
                  <select class="form-control select2 select2-danger focus" id="selectStatusComercial" name="selectStatusComercial" data-dropdown-css-class="select2-danger">
                    <option value="" disabled selected>Selecione uma opção</option>
                    <option value="0">Trilho Único</option>
                    <option value="1">Trilho Duplo</option>
                  </select>
                </div>
              </div>

              <div class="col-3 form-group">
                <label>Kit Trilho:</label>
                <div class="input-group">
                  <select class="form-control select2 select2-danger focus" id="selectStatusComercial" name="selectStatusComercial" data-dropdown-css-class="select2-danger">
                    <option value="" disabled selected>Selecione uma opção</option>
                    <option value="0">Sim</option>
                    <option value="1">Não</option>
                  </select>
                </div>
              </div>

              <div class="col-3 form-group">
                <label>Abertura:</label>
                <div class="input-group">
                  <select class="form-control select2 select2-danger focus" id="selectStatusComercial" name="selectStatusComercial" data-dropdown-css-class="select2-danger">
                    <option value="" disabled selected>Selecione uma opção</option>
                    <option value="0">Uma Parte</option>
                    <option value="1">Duas Partes</option>
                  </select>
                </div>
              </div>

              <div class="col-3 form-group">
                <label>Tipo de Costura:</label>
                <div class="input-group">
                  <select class="form-control select2 select2-danger focus" id="selectStatusComercial" name="selectStatusComercial" data-dropdown-css-class="select2-danger">
                    <option value="" disabled selected>Selecione uma opção</option>
                    <option value="0">Junto</option>
                    <option value="1">Separado</option>
                  </select>
                </div>
              </div>

              <div class="col-3 form-group">
                <label data-error="wrong" data-success="right" for="txtTrilhoFrontal">Trilho Frontal:</label>
                <div class="input-group">
                  <input type="text" class="input-default focus form-control" id="txtTrilhoFrontal" name="txtTrilhoFrontal" class="form-control" placeholder="Trilho Frontal">
                  <div class="input-group-append">
                    <button class="btn bg-danger" id="btnTrilhoFrontal" name="btnTrilhoFrontal" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                    <button class="btn bg-danger" id="btnLimpaTrilhoFrontal" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                  </div>
                </div>
              </div>

              <div class="col-3 form-group">
                <label data-error="wrong" data-success="right" for="txtDeslizFrontal">Desliz. Frontal:</label>
                <div class="input-group">
                  <input type="text" class="input-default focus form-control" id="txtDeslizFrontal" name="txtDeslizFrontal" class="form-control" placeholder="Desliz. Frontal">
                  <div class="input-group-append">
                    <button class="btn bg-danger" id="btnDeslizFrontal" name="btnDeslizFrontal" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                    <button class="btn bg-danger" id="btnLimpaDeslizFrontal" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                  </div>
                </div>
              </div>

              <div class="col-3 form-group">
                <label data-error="wrong" data-success="right" for="txtSuporte">Suporte: </label>
                <div class="input-group">
                  <input type="text" class="input-default focus form-control" id="txtSuporte" name="txtSuporte" class="form-control" placeholder="Suporte">
                  <div class="input-group-append">
                    <button class="btn bg-danger" id="btnSuporte" name="btnSuporte" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                    <button class="btn bg-danger" id="btnLimpaSuporte" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                  </div>
                </div>
              </div>

              <div class="col-3 form-group">
                <label data-error="wrong" data-success="right" for="txtFinalFrontal">Final Frontal:</label>
                <div class="input-group">
                  <input type="text" class="input-default focus form-control" id="txtFinalFrontal" name="txtFinalFrontal" class="form-control" placeholder="Final Frontal">
                  <div class="input-group-append">
                    <button class="btn bg-danger" id="btnFinalFrontal" name="btnFinalFrontal" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                    <button class="btn bg-danger" id="btnLimpaFinalFrontal" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                  </div>
                </div>
              </div>

              <div class="col-3 form-group">
                <label data-error="wrong" data-success="right" for="txtTrilhoTraseiro">Trilho Traseiro:</label>
                <div class="input-group">
                  <input type="text" class="input-default focus form-control" id="txtTrilhoTraseiro" name="txtTrilhoTraseiro" class="form-control" placeholder="Trilho Traseiro">
                  <div class="input-group-append">
                    <button class="btn bg-danger" id="btnTrilhoTraseiro" name="btnTrilhoTraseiro" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                    <button class="btn bg-danger" id="btnLimpaTrilhoTraseiro" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                  </div>
                </div>
              </div>

              <div class="col-3 form-group">
                <label data-error="wrong" data-success="right" for="txtDeslizTraseiro">Desliz. Traseiro:</label>
                <div class="input-group">
                  <input type="text" class="input-default focus form-control" id="txtDeslizTraseiro" name="txtDeslizTraseiro" class="form-control" placeholder="Desliz. Traseiro">
                  <div class="input-group-append">
                    <button class="btn bg-danger" id="btnDeslizTraseiro" name="btnDeslizTraseiro" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                    <button class="btn bg-danger" id="btnLimpaDeslizTraseiro" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                  </div>
                </div>
              </div>

              <div class="col-3 form-group">
                <label data-error="wrong" data-success="right" for="txtSuporteFlange">Suporte Flange: </label>
                <div class="input-group">
                  <input type="text" class="input-default focus form-control" id="txtSuporteFlange" name="txtSuporteFlange" class="form-control" placeholder="SuporteFlange">
                  <div class="input-group-append">
                    <button class="btn bg-danger" id="btnSuporteFlange" name="btnSuporteFlange" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                    <button class="btn bg-danger" id="btnLimpaSuporteFlange" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                  </div>
                </div>
              </div>

              <div class="col-3 form-group">
                <label data-error="wrong" data-success="right" for="txtFinalTraseiro">Final Traseiro:</label>
                <div class="input-group">
                  <input type="text" class="input-default focus form-control" id="txtFinalTraseiro" name="txtFinalTraseiro" class="form-control" placeholder="Final Traseiro">
                  <div class="input-group-append">
                    <button class="btn bg-danger" id="btnFinalTraseiro" name="btnFinalTraseiro" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                    <button class="btn bg-danger" id="btnLimpaFinalTraseiro" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                  </div>
                </div>
              </div>
            </div>

            <hr style="width: 100%">

            <div class="row">
              <div class="col-4 form-group">
                <label data-error="wrong" data-success="right" for="txtTecido">Tecido:</label>
                <div class="input-group">
                  <input type="text" class="input-default focus form-control" id="txtTecido" name="txtTecido" class="form-control" placeholder="Tecido">
                  <div class="input-group-append">
                    <button class="btn bg-danger" id="btnTecido" name="btnTecido" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                    <button class="btn bg-danger" id="btnLimpaTecido" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                  </div>
                </div>
              </div>

              <div class="col-2 form-group">
                <label>Barra:</label>
                <div class="input-group">
                  <select class="form-control select2 select2-danger focus" id="selectBarraTecido" name="selectBarraTecido" data-dropdown-css-class="select2-danger">
                    <option value="" disabled selected>Selecione uma opção</option>
                    <option value="05">05cm</option>
                    <option value="10">10cm</option>
                    <option value="15">15cm</option>
                    <option value="20">20cm</option>
                    <option value="25">25cm</option>
                    <option value="30">30cm</option>
                    <option value="35">35cm</option>
                    <option value="40">40cm</option>
                    <option value="45">45cm</option>
                    <option value="50">50cm</option>
                    <option value="55">55cm</option>
                    <option value="60">60cm</option>
                    <option value="65">65cm</option>
                    <option value="70">70cm</option>
                    <option value="75">75cm</option>
                    <option value="80">80cm</option>
                  </select>
                </div>
              </div>

              <div class="col-2 form-group">
                <label>Dupla:</label>
                <div class="input-group">
                  <select class="form-control select2 select2-danger focus" id="selectDuplaTecido" name="selectDuplaTecido" data-dropdown-css-class="select2-danger">
                    <option value="" disabled selected>Selecione uma opção</option>
                    <option value="0">Sim</option>
                    <option value="1">Não</option>
                  </select>
                </div>
              </div>

              <div class="col-2 form-group">
                <label>Franz.:</label>
                <div class="input-group">
                  <select class="form-control select2 select2-danger focus" id="selectFranzTecido" name="selectFranzTecido" data-dropdown-css-class="select2-danger">
                    <option value="" disabled selected>Selecione uma opção</option>
                    <option value="1.00">1.00</option>
                    <option value="1.10"> 1.10</option>
                    <option value="1.20"> 1.20</option>
                    <option value="1.30"> 1.30</option>
                    <option value="1.40"> 1.40</option>
                    <option value="1.50"> 1.50</option>
                    <option value="1.60"> 1.60</option>
                    <option value="1.70"> 1.70</option>
                    <option value="1.80"> 1.80</option>
                    <option value="1.90"> 1.90</option>
                    <option value="2.00"> 2.00</option>
                    <option value="2.10"> 2.10</option>
                    <option value="2.20"> 2.20</option>
                    <option value="2.30"> 2.30</option>
                    <option value="2.40"> 2.40</option>
                    <option value="2.50"> 2.50</option>
                    <option value="2.60"> 2.60</option>
                    <option value="2.70"> 2.70</option>
                    <option value="2.80"> 2.80</option>
                    <option value="2.90"> 2.90</option>
                    <option value="3.00"> 3.00</option>
                    <option value="3.10"> 3.10</option>
                    <option value="3.20"> 3.20</option>
                  </select>
                </div>
              </div>

              <div class="col-2 form-group">
                <label>Inverter:</label>
                <div class="input-group">
                  <select class="form-control select2 select2-danger focus" id="selectInverterTecido" name="selectInverterTecido" data-dropdown-css-class="select2-danger">
                    <option value="" disabled selected>Selecione uma opção</option>
                    <option value="0">Sim</option>
                    <option value="1">Não</option>
                  </select>
                </div>
              </div>

              <div class="col-4 form-group">
                <label data-error="wrong" data-success="right" for="txtForro">Forro:</label>
                <div class="input-group">
                  <input type="text" class="input-default focus form-control" id="txtForro" name="txtForro" class="form-control" placeholder="Forro">
                  <div class="input-group-append">
                    <button class="btn bg-danger" id="btnForro" name="btnForro" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                    <button class="btn bg-danger" id="btnLimpaForro" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                  </div>
                </div>
              </div>

              <div class="col-2 form-group">
                <label>Barra:</label>
                <div class="input-group">
                  <select class="form-control select2 select2-danger focus" id="selectBarraForro" name="selectBarraForro" data-dropdown-css-class="select2-danger">
                    <option value="" disabled selected>Selecione uma opção</option>
                    <option value="05">05cm</option>
                    <option value="10">10cm</option>
                    <option value="15">15cm</option>
                    <option value="20">20cm</option>
                    <option value="25">25cm</option>
                    <option value="30">30cm</option>
                    <option value="35">35cm</option>
                    <option value="40">40cm</option>
                    <option value="45">45cm</option>
                    <option value="50">50cm</option>
                    <option value="55">55cm</option>
                    <option value="60">60cm</option>
                    <option value="65">65cm</option>
                    <option value="70">70cm</option>
                    <option value="75">75cm</option>
                    <option value="80">80cm</option>
                  </select>
                </div>
              </div>

              <div class="col-2 form-group">
                <label>Dupla:</label>
                <div class="input-group">
                  <select class="form-control select2 select2-danger focus" id="selectDuplaForro" name="selectDuplaForro" data-dropdown-css-class="select2-danger">
                    <option value="" disabled selected>Selecione uma opção</option>
                    <option value="0">Sim</option>
                    <option value="1">Não</option>
                  </select>
                </div>
              </div>

              <div class="col-2 form-group">
                <label>Franz.:</label>
                <div class="input-group">
                  <select class="form-control select2 select2-danger focus" id="selectFranzForro" name="selectFranzForro" data-dropdown-css-class="select2-danger">
                    <option value="" disabled selected>Selecione uma opção</option>
                    <option value="1.00">1.00</option>
                    <option value="1.10"> 1.10</option>
                    <option value="1.20"> 1.20</option>
                    <option value="1.30"> 1.30</option>
                    <option value="1.40"> 1.40</option>
                    <option value="1.50"> 1.50</option>
                    <option value="1.60"> 1.60</option>
                    <option value="1.70"> 1.70</option>
                    <option value="1.80"> 1.80</option>
                    <option value="1.90"> 1.90</option>
                    <option value="2.00"> 2.00</option>
                    <option value="2.10"> 2.10</option>
                    <option value="2.20"> 2.20</option>
                    <option value="2.30"> 2.30</option>
                    <option value="2.40"> 2.40</option>
                    <option value="2.50"> 2.50</option>
                    <option value="2.60"> 2.60</option>
                    <option value="2.70"> 2.70</option>
                    <option value="2.80"> 2.80</option>
                    <option value="2.90"> 2.90</option>
                    <option value="3.00"> 3.00</option>
                    <option value="3.10"> 3.10</option>
                    <option value="3.20"> 3.20</option>
                  </select>
                </div>
              </div>

              <div class="col-2 form-group">
                <label>Inverter:</label>
                <div class="input-group">
                  <select class="form-control select2 select2-danger focus" id="selectInverterForro" name="selectInverterForro" data-dropdown-css-class="select2-danger">
                    <option value="" disabled selected>Selecione uma opção</option>
                    <option value="0">Sim</option>
                    <option value="1">Não</option>
                  </select>
                </div>
              </div>

              <div class="col-4 form-group">
                <label data-error="wrong" data-success="right" for="txtBlackout">Blackout:</label>
                <div class="input-group">
                  <input type="text" class="input-default focus form-control" id="txtBlackout" name="txtBlackout" class="form-control" placeholder="Blackout">
                  <div class="input-group-append">
                    <button class="btn bg-danger" id="btnBlackout" name="btnBlackout" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                    <button class="btn bg-danger" id="btnLimpaBlackout" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                  </div>
                </div>
              </div>

              <div class="col-2 form-group">
                <label>Barra:</label>
                <div class="input-group">
                  <select class="form-control select2 select2-danger focus" id="selectBarraBlackout" name="selectBarraBlackout" data-dropdown-css-class="select2-danger">
                    <option value="" disabled selected>Selecione uma opção</option>
                    <option value="05">05cm</option>
                    <option value="10">10cm</option>
                    <option value="15">15cm</option>
                    <option value="20">20cm</option>
                    <option value="25">25cm</option>
                    <option value="30">30cm</option>
                    <option value="35">35cm</option>
                    <option value="40">40cm</option>
                    <option value="45">45cm</option>
                    <option value="50">50cm</option>
                    <option value="55">55cm</option>
                    <option value="60">60cm</option>
                    <option value="65">65cm</option>
                    <option value="70">70cm</option>
                    <option value="75">75cm</option>
                    <option value="80">80cm</option>
                  </select>
                </div>
              </div>

              <div class="col-2 form-group">
                <label>Dupla:</label>
                <div class="input-group">
                  <select class="form-control select2 select2-danger focus" id="selectDuplaBlackout" name="selectDuplaBlackout" data-dropdown-css-class="select2-danger">
                    <option value="" disabled selected>Selecione uma opção</option>
                    <option value="0">Sim</option>
                    <option value="1">Não</option>
                  </select>
                </div>
              </div>

              <div class="col-2 form-group">
                <label>Franz.:</label>
                <div class="input-group">
                  <select class="form-control select2 select2-danger focus" id="selectFranzBlackout" name="selectFranzBlackout" data-dropdown-css-class="select2-danger">
                    <option value="" disabled selected>Selecione uma opção</option>
                    <option value="1.00">1.00</option>
                    <option value="1.10"> 1.10</option>
                    <option value="1.20"> 1.20</option>
                    <option value="1.30"> 1.30</option>
                    <option value="1.40"> 1.40</option>
                    <option value="1.50"> 1.50</option>
                    <option value="1.60"> 1.60</option>
                    <option value="1.70"> 1.70</option>
                    <option value="1.80"> 1.80</option>
                    <option value="1.90"> 1.90</option>
                    <option value="2.00"> 2.00</option>
                    <option value="2.10"> 2.10</option>
                    <option value="2.20"> 2.20</option>
                    <option value="2.30"> 2.30</option>
                    <option value="2.40"> 2.40</option>
                    <option value="2.50"> 2.50</option>
                    <option value="2.60"> 2.60</option>
                    <option value="2.70"> 2.70</option>
                    <option value="2.80"> 2.80</option>
                    <option value="2.90"> 2.90</option>
                    <option value="3.00"> 3.00</option>
                    <option value="3.10"> 3.10</option>
                    <option value="3.20"> 3.20</option>
                  </select>
                </div>
              </div>

              <div class="col-2 form-group">
                <label>Inverter:</label>
                <div class="input-group">
                  <select class="form-control select2 select2-danger focus" id="selectInverterBlackout" name="selectInverterBlackout" data-dropdown-css-class="select2-danger">
                    <option value="" disabled selected>Selecione uma opção</option>
                    <option value="0">Sim</option>
                    <option value="1">Não</option>
                  </select>
                </div>
              </div>
            </div>

            <hr style="width: 100%">

            <div class="row" style="width: 101%;">
              <div class="col-3 form-group">
                <label data-error="wrong" data-success="right" for="txtCostureira">Costureira:</label>
                <div class="input-group">
                  <input type="text" class="input-default focus form-control" id="txtCostureira" name="txtCostureira" class="form-control" placeholder="Costureira">
                  <div class="input-group-append">
                    <button class="btn bg-danger" id="btnCostureira" name="btnCostureira" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                    <button class="btn bg-danger" id="btnLimpaCostureira" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                  </div>
                </div>
              </div>

              <div class="col-3 form-group">
                <label data-error="wrong" data-success="right" for="txtInstalador">Instalador:</label>
                <div class="input-group">
                  <input type="text" class="input-default focus form-control" id="txtInstalador" name="txtInstalador" class="form-control" placeholder="Instalador">
                  <div class="input-group-append">
                    <button class="btn bg-danger" id="btnInstalador" name="btnInstalador" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                    <button class="btn bg-danger" id="btnLimpaInstalador" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                  </div>
                </div>
              </div>

              <div class="col-5 form-group">
                <label data-error="wrong" data-success="right" for="txtOpcional">Opcional: </label>
                <div class="relative">
                  <div class="input-group">
                    <!-- <input type="text" class="input-default focus form-control" id="txtOpcional" name="txtOpcional" class="form-control" placeholder="Opcional"> -->
                    <select class="js-example-programmatic js-states form-control" id="txtOpcional" name="txtOpcional" multiple="multiple">
                    </select>
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnOpcional" name="btnOpcional" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btnLimpaOpcional" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
              </div>

              <div class="col-1 form-group">
                <label data-error="wrong" data-success="right" for="txtQuantidade">Quantidade:</label>
                <div class="input-group">
                  <input type="text" class="input-default focus form-control camposMascaraQtde text-right" id="txtQuantidade" name="txtQuantidade" class="form-control" value="0">
                </div>
              </div>

              <div class="col-lg-12 col-12 form-group">
                <label data-error="wrong" data-success="right" for="txtObsCostureira">Obs para costureira:</label>
                <textarea style="resize: none" id="txtObsCostureira" class="input-default focus form-control" rows="5"></textarea>
              </div>

            </div>
          </div>
        </div>
        <div class="modal-footer">
          <div class="row">
            <div class="col-sm-12">
              <button id="btnDesistir" class="btn btn-sisp btn-danger mr-2" data-dismiss="modal"> Desistir </button>
              <button id="btnConfirmar" class="btn btn-sisp btn-primary"> Confirmar </button>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>

  <div id="modalHistorico" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-md">
      <div class="modal-content">
        <div class="modal-header">
          <h4 class="modal-title">Informações adicionais</h4>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body py-0">
          <div class="row">
            <div class="col-sm-12 table-responsive">
              <table id="tabelaHistoricoOrcamento" class="table display nowrap" style="width:100%; margin-top:0 !important">
                <thead>
                </thead>
                <tbody>
                </tbody>
              </table>
            </div>

          </div>
        </div>
        <div class="modal-footer">
          <div class="row">
            <div class="col-sm-12">
              <button class="btn btn-danger btn-sisp" class="close" data-dismiss="modal" aria-label="Close">Fechar</button>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>

  <div id="modalResultado" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog" style="min-width: 95%">
      <div class="modal-content">
        <div class="modal-header">
          <h4 class="modal-title">Resultados</h4>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body py-0">
          <div class="row">
            <div class="col-sm-12 table-responsive">
              <table id="tabelaResultado" class="table display nowrap" style="width:100%; margin-top:0 !important">
                <thead>
                </thead>
                <tbody>
                </tbody>
              </table>
            </div>
          </div>
        </div>
        <div class="modal-footer pt-1">
          <div class="form-group">
            <label class="mb-0" for="txtTotalServico">Total Serviço:</label>
            <div class="input-group">
              <input type="text" class="input-default focus form-control" id="txtTotalServico" name="txtTotalServico" value="R$ 497,70" disabled class="form-control" placeholder="Tabela de Preco">
            </div>
          </div>
          <div class="form-group">
            <label class="mb-0" for="txtTotalMaterial">Total Material:</label>
            <div class="input-group">
              <input type="text" class="input-default focus form-control" id="txtTotalMaterial" name="txtTotalMaterial" value="R$ 1.009,34" disabled class="form-control" placeholder="Tabela de Preco">
            </div>
          </div>
          <div style="padding-top: 20px;">
            <button class="btn btn-danger btn-sisp" class="close" data-dismiss="modal" aria-label="Close">Fechar</button>
          </div>
        </div>
      </div>
    </div>

    <div class="modal fade" id="modal-info-cliente" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
      <div class="modal-dialog modal-lg">
        <div class="modal-content">
          <div class="modal-header">
            <h4 class="modal-title">Informações do Cliente - [<span id="txtCodigoTittle"></span>]</h4>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>
          <div class="modal-body">
            <div class="row">
              <div class="col-12" id="collapseInfoAdicionais">
                <div class="card card-body p-0">
                  <div class="d-flex">
                    <div class="col-4 pl-0">
                      <label data-error="wrong" data-success="right" for="txtDataCadastroInfo">Data de Cadastro</label>
                      <input type="date" readonly class="input-default focus form-control" id="txtDataCadastroInfo" name="txtDataCadastroInfo">
                    </div>
                    <div class="col-4 pl-0">
                      <label data-error="wrong" data-success="right" for="txtDataNascimentoInfo">Data de Nascimento</label>
                      <input type="date" readonly class="input-default focus form-control" id="txtDataNascimentoInfo" name="txtDataNascimentoInfo">
                    </div>
                  </div>
                  <div class="d-flex pt-2">
                    <div class="col-4 pl-0">
                      <label data-error="wrong" data-success="right" for="txtCpfInfoCliente">CPF/CNPJ</label>
                      <input type="text" readonly class="input-default focus form-control" id="txtCpfInfoCliente" name="txtCpfInfoCliente">
                    </div>
                    <div class="col-4 pl-0">
                      <label data-error="wrong" data-success="right" for="txtInscricaoInfoCliente">Inscrição</label>
                      <input type="text" readonly class="input-default focus form-control" id="txtInscricaoInfoCliente" name="txtInscricaoInfoCliente">
                    </div>
                    <div class="col-1 pl-0">
                      <label data-error="wrong" data-success="right" for="txtDddInfoCliente">DDD</label>
                      <input type="number" readonly class="input-default focus form-control" id="txtDddInfoCliente" name="txtDddInfoCliente">
                    </div>
                    <div class="col-3 pl-0">
                      <label data-error="wrong" data-success="right" for="txtTelefoneInfoCliente">Telefone</label>
                      <input type="text" readonly class="input-default focus form-control" id="txtTelefoneInfoCliente" name="txtTelefoneInfoCliente">
                    </div>
                  </div>
                  <div class="d-flex pt-2">
                    <div class="col-12 pl-0">
                      <label data-error="wrong" data-sucess="right" for="txtEmailInfoCliente">E-mail</label>
                      <input type="text" readonly class="input-default focus form-control" id="txtEmailInfoCliente" name="txtEmailInfoCliente">
                    </div>
                  </div>
                  <div class="d-flex pt-2">
                    <div class="col-2 pl-0">
                      <label data-error="wrong" data-sucess="right" for="txtClassificacaoInfoCliente">Classificação</label>
                      <input type="text" readonly class="input-default focus form-control" id="txtClassificacaoInfoCliente" name="txtClassificacaoInfoCliente">
                    </div>
                    <div class="col-4 pl-0">
                      <label data-error="wrong" data-sucess="right" for="txtGrupoInfoCliente">Grupo</label>
                      <input type="text" readonly class="input-default focus form-control" id="txtGrupoInfoCliente" name="txtGrupoInfoCliente">
                    </div>
                    <div class="col-4 pl-0">
                      <label data-error="wrong" data-sucess="right" for="txtPerfilInfoCliente">Perfil</label>
                      <input type="text" readonly class="input-default focus form-control" id="txtPerfilInfoCliente" name="txtPerfilInfoCliente">
                    </div>
                    <div class="col-2 pl-0">
                      <label data-error="wrong" data-sucess="right" for="txtPercDescontoInfoCliente">% Desconto</label>
                      <input type="text" readonly class="input-default focus form-control text-right" id="txtPercDescontoInfoCliente" name="txtPercDescontoInfoCliente">
                    </div>
                  </div>
                  <div class="d-flex pt-2">
                    <div class="col-3 pl-0">
                      <label data-error="wrong" data-success="right" for="txtPaisInfoCliente">País</label>
                      <input type="text" readonly class="input-default focus form-control" id="txtPaisInfoCliente" name="txtPaisInfoCliente">
                    </div>
                    <div class="col-2 pl-0">
                      <label data-error="wrong" data-success="right" for="txtCepInfoCliente">CEP</label>
                      <input type="number" readonly class="input-default focus form-control" id="txtCepInfoCliente" name="txtCepInfoCliente">
                    </div>
                    <div class="col-6 pl-0">
                      <label data-error="wrong" data-success="right" for="txtMunicipioInfoCliente">Cidade</label>
                      <input type="text" readonly class="input-default focus form-control" id="txtMunicipioInfoCliente" name="txtMunicipioInfoCliente">
                    </div>
                    <div class="col-1 pl-0">
                      <label data-error="wrong" data-success="right" for="txtEstadoInfoCliente">UF</label>
                      <input type="text" readonly class="input-default focus form-control" id="txtEstadoInfoCliente" name="txtEstadoInfoCliente">
                    </div>
                  </div>
                  <div class="d-flex pt-2">
                    <div class="col-3 pl-0">
                      <label data-error="wrong" data-success="right" for="txtBairroInfoCliente">Bairro</label>
                      <input type="text" readonly class="input-default focus form-control" id="txtBairroInfoCliente" name="txtBairroInfoCliente">
                    </div>
                    <div class="col-9 pl-0">
                      <label data-error="wrong" data-success="right" for="txtEnderecoInfoCliente">Rua</label>
                      <input type="text" readonly class="input-default focus form-control" id="txtEnderecoInfoCliente" name="txtEnderecoInfoCliente">
                    </div>
                  </div>
                  <div class="d-flex pt-2">
                    <div class="col-2 pl-0">
                      <label data-error="wrong" data-success="right" for="txtNumeroInfoCliente">Número</label>
                      <input type="number" readonly class="input-default focus form-control" id="txtNumeroInfoCliente" name="txtNumeroInfoCliente">
                    </div>
                    <div class="col-10 pl-0">
                      <label data-error="wrong" data-success="right" for="txtComplementoInfoCliente">Complemento</label>
                      <input type="text" readonly class="input-default focus form-control" id="txtComplementoInfoCliente" name="txtComplementoInfoCliente">
                    </div>
                  </div>
                  <div class="d-flex pt-2">
                    <div class="col-12 pl-0">
                      <label data-error="wrong" data-success="right" for="txtObsInfoCliente">Observação</label>
                      <textarea style="resize: none; border-color: #a9a9a9;" type="text" readonly class="focus form-control" id="txtObsInfoCliente" name="txtObsInfoCliente"></textarea>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
          <div class="modal-footer">
            <button type="button" data-dismiss="modal" class="btn btn-danger btn-sisp"> Fechar </button>
          </div>
        </div>
      </div>
    </div>
    <aside class="control-sidebar control-sidebar-dark"></aside>
    <?php
    include_once('../../../modais.php');
    include_once('../../../modals/modal_entid_simpl.html');
    ?>
  </div>

  <script src="../plugins/jquery/jquery.min.js?versao=3.258.7.1"></script>
  <script src="../plugins/jquery-ui/jquery-ui.min.js?versao=3.258.7.1"></script>
  <script type="text/javascript" src="../dist/js/jquery.dataTables.js?versao=3.258.7.1"></script>
  <script type="text/javascript" src="../dist/js/dataTables.bootstrap4.min.js?versao=3.258.7.1"></script>
  <script src="../plugins/sweetalert2/sweetalert2.min.js?versao=3.258.7.1"></script>
  <script src="../plugins/toastr/toastr.min.js?versao=3.258.7.1"></script>

  <script>
    $.widget.bridge('uibutton', $.ui.button);
  </script>

  <script src="../plugins/bootstrap/js/bootstrap.bundle.min.js?versao=3.258.7.1"></script>

  <script src="../dist/js/adminlte.min.js?versao=3.258.7.1"></script>
  <script src="../dist/js/requisicoes.js?versao=3.258.7.1"></script>
  <script src="../dist/js/loadingoverlay.min.js?versao=3.258.7.1"></script>
  <script src="../plugins/jquery-validation/jquery.validate.min.js?versao=3.258.7.1"></script>
  <script src="../dist/js/sisplan.js?versao=3.258.7.1"></script>
  <script src="../dist/js/popper.min.js?versao=3.258.7.1"></script>
  <script src="../dist/js/tippy-bundle.umd.js?versao=3.258.7.1"></script>
  <script src="../utils/funcoes.js?versao=3.258.7.1"></script>
  <script src="../dist/js/jquery.maskMoney.min.js?versao=3.258.7.1"></script>
  <script src="../plugins/select2/js/select2.full.min.js?versao=3.258.7.1"></script>
  <script src="../utils/cookies.js?versao=3.258.7.1"></script>
  <script src="../dist/js/driver.min.js?versao=3.258.7.1"></script>
  <script src="../dist/js/dataTables.keyTable2.js?versao=3.258.7.1"></script>
  <script type="text/javascript" src="../config.js?versao=3.258.7.1"></script>
  <script type="text/javascript" src="../dist/js/sum().js"></script>
  <script type="text/javascript">
    $(document).ready(async function() {

      if (getCookie('usuario') == "") {
        window.location.href = `${BASE_URI}/login`;
        return;
      }

      let usuario = getCookie('usuario');
      let empresa = getCookie('empresa');

      ipInterno = IP_INTERNO;
      ipExterno = IP_EXTERNO;
      basicAuth = BASIC_AUTH;

      const temAcesso = await temAcessoTela('ORCAMENTO_CORTINA');
      if (!temAcesso.resultado) {
        toastrAcesso(temAcesso, BASE_URI);
        return;
      }

      sArquivo = `${BASE_URI}/pages/orcamento_cortina/cadastro_orcamento_cortina/orcamento_cortina.js?versao=3.258.7.1`;
      insereJavaScriptPagina(sArquivo);

    });
  </script>
</body>

</html>