<?php include_once('../../../config.php') ?>

<!DOCTYPE html>
<html>

<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Sisplan Web | Ordem de Serviço</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link rel="stylesheet" href="plugins/fontawesome-free/css/all.min.css?versao=3.258.7.1">
  <link rel="stylesheet" href="dist/css/adminlte.min.css?versao=3.258.7.1">
  <link href='https://fonts.googleapis.com/css?family=Roboto:400,300,500,600,700,400italic' rel='stylesheet' type='text/css'>
  <link rel="stylesheet" href="dist/css/sisplan.newColorsButtons.css?versao=3.258.7.1" type="text/css" />
  <link rel="stylesheet" href="dist/css/sisplan.adjustDataTableButtons.css?versao=3.258.7.1" type="text/css" />
  <link rel="stylesheet" href="dist/css/custom.css?versao=3.258.7.1">
  <link rel="stylesheet" href="dist/css/sisplan.css?versao=3.258.7.1">
  <link rel="stylesheet" type="text/css" href="dist/css/dataTables.bootstrap4.min.css?versao=3.258.7.1" />
  <link rel="shortcut icon" href="favicon.ico">
  <link rel="stylesheet" href="plugins/toastr/toastr.min.css?versao=3.258.7.1">
  <link rel="stylesheet" type="text/css" href="dist/css/driver.min.css?versao=3.258.7.1" />
  <style>
    #tabelaOs td div button {
      padding: .0rem .5rem;
      margin: .0rem;
    }

    #tabelaOs,
    #tabelaOsVisualizacao td {
      padding: 5px 8px !important;
    }

    .table.dataTable tbody td,
    th {
      white-space: nowrap;
      text-overflow: ellipsis;
      overflow: hidden;
    }

    #tabelaOs_length,
    #tabelaOsVisualizacao_length {
      margin-top: 15px;
    }

    .dataTables_scroll {
      margin-top: -5px !important;
    }


    .btnSuccess {
      background-color: #25d366 !important;
      border-color: #25d366 !important;
      color: #fff;
    }

    .btnSuccess:hover {
      background-color: #20ae59 !important;
      border-color: #20ae59 !important;
      color: #fff;
    }

    #tabelaReceber_filter {
      visibility: hidden;
      margin: 0px;
      padding: 0px;
      height: 0px;
    }

    .quadrado {
      width: 25px;
      margin-right: 5px;
      height: 25px;
    }

    .border-field .texto-borda {
      font-size: 1.1em !important;
      text-align: left !important;
      width: auto;
      padding: 0 10px;
      border-bottom: none;
      font-weight: 700;
    }

    .border-field {
      border: 1px solid var(--font-color) !important;
      -webkit-box-shadow: 0px 0px 0px 0px #000;
      box-shadow: 0px 0px 0px 0px #000;
      border-radius: 4px !important;
      padding: 0px !important;
    }

    h5 {
      margin-bottom: -0.9rem !important;
    }
  </style>
</head>

<body class="hold-transition sidebar-mini layout-fixed">
  <div class="wrapper">
    <div class="content-wrapper">
      <div class="content-header">
        <div class="container-fluid">
          <div class="row mb-2">
            <div class="col-sm-6 flex">
              <h1 class="m-0 text-dark">Ordem de Serviço</h1>
              <button type="button" class="btn btn-info btn-sm ml-2" title="Tutorial" style="color: white;" id="tutorial">
                <i class="fas fa-question-circle"></i></button>
            </div>
          </div>
        </div>
        <div class="container-fluid">
          <div class="row card">
            <div class="row mt-2" style="padding-left: 20px; padding-right: 20px;">
              <div class="col-6 d-flex">
                <div class="d-flex align-items-center">
                  <button class="btn btnFiltros btn-sisp" id="btnFiltros"><span class="fas fa-filter"></span> Filtros</button>
                  <button class="btn btn-danger btn-sisp marginBtnH" id="btnNovaOrdemProducao"><span class="fas fa-plus"></span> Incluir</button>
                  <button class="btn btn-secondary btn-sisp marginBtnH" id="btnImprimir"><span class="fas fa-print" style="color: white!important"></span> Imprimir</button>
                </div>
              </div>
              <div class="col-6 d-flex justify-content-end align-items-center">
                <div class="col-md-12 row d-flex justify-content-end" style="grid-gap: 4px;">
                  <div>
                    <div class="d-flex align-items-center gap-2">
                      <div class="quadrado" style="background: rgba(245, 81, 81, 1);">
                      </div>
                      <span> Em aberto(Pendente) </span>
                    </div>
                  </div>
                  <div>
                    <div class="d-flex align-items-center gap-2">
                      <div class="quadrado" style="background: rgba(67, 57, 205, 1);">
                      </div>
                      <span> Romaneio </span>
                    </div>
                  </div>
                  <div>
                    <div class="d-flex align-items-center gap-2">
                      <div class="quadrado" style="background: rgba(114, 103, 103, 1);">
                      </div>
                      <span> Faturado </span>
                    </div>
                  </div>
                  <div>
                    <div class="d-flex align-items-center gap-2">
                      <div class="quadrado" style="background: rgba(43, 156, 43, 1);">
                      </div>
                      <span> Encerrado(Baixado) </span>
                    </div>
                  </div>
                </div>
              </div>
            </div>
            <div class="row">
              <div class="col-sm-6 d-flex justify-content-center align-items-center" style="height: 100%;">
                <div id="graficosOs" class="mt-5" style="width: 100%;"></div>
              </div>
              <div class="col-sm-6 d-flex justify-content-center align-items-center" style="height: 100%;">
                <div id="graficosOs1" class="mt-5" style="width: 100%;"></div>
              </div>
            </div>

            <div class="col-sm-12 table-responsive card-body">
              <h5>Ordens de Serviço</h5>
              <table id="tabelaOs" class="table table-sm table-sm-sisp table-select table-hover" width="100%">
                <thead>
                </thead>
                <tbody>
                </tbody>
              </table>
            </div>
          </div>

          <div class="row mt-4">
            <div class="table-responsive card card-body col-12">
              <h5>Itens</h5>
              <table id="tabelaOsVisualizacao" class="table table-sm table-sm-sisp table-select table-hover" width="100%">
                <thead></thead>
                <tbody></tbody>
              </table>
            </div>
          </div>
        </div>
      </div>
      <div id="modal-filtros" class="modal" tabindex="-1" role="dialog">
        <div class="modal-dialog modal-xl" role="document">
          <div class="modal-content" id="modalBody">
            <div class="modal-header">
              <h4 class="modal-title">Filtros</h4>
              <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
              </button>
            </div>
            <div class="modal-body">
              <div class="row">
                <div class="col-6 form-group" id="OrdemProducaoInfoTour">
                  <label data-error="wrong" data-success="right" for="txtOs">Ordem de serviço: </label>
                  <div class="input-group">
                    <input type="text" autocomplete="off" class="input-default focus form-control" id="txtOs" name="txtOs" class="form-control" placeholder="Ordem de serviço">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btn-Os" name="btn-Os" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btn-limpa-Os" name="btn-limpa-Os" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
                <div class="col-6 form-group" id="ClienteInfoTour">
                  <label data-error="wrong" data-success="right" for="txtCliente">Cliente: </label>
                  <div class="input-group">
                    <input type="text" autocomplete="off" class="input-default focus form-control" id="txtCliente" name="txtCliente" class="form-control" placeholder="Cliente">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnCliente" name="btnCliente" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btnLimpaCliente" name="btnLimpaCliente" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
                <div class="col-6 form-group">
                  <label data-error="wrong" class="labelGeral" data-success="right" for="dtEmissaoDe">Emissão de/até:</label>
                  <div class="input-group">
                    <input type="date" max="2500-12-31" class="input-default focus form-control validate" value="1200-01-01" id="dtEmissaoDe" name="dtEmissaoDe">
                    <input type="date" max="2500-12-31" class="input-default focus form-control validate" value="2500-12-31" id="dtEmissaoAte" name="dtEmissaoAte">
                  </div>
                </div>
                <div class="col-6 form-group">
                  <label data-error="wrong" class="labelGeral" data-success="right" for="dtEntregaDe">Saída de/até:</label>
                  <div class="input-group">
                    <input type="date" max="2500-12-31" class="input-default focus form-control validate" value="1200-01-01" id="dtEntregaDe" name="dtEntregaDe">
                    <input type="date" max="2500-12-31" class="input-default focus form-control validate" value="2500-12-31" id="dtEntregaAte" name="dtEntregaAte">
                  </div>
                </div>
                <div class="col-lg-12 col-sm-12 col-12 form-group">
                  <div class="form" id="area">
                    <fieldset class="form border-field">
                      <legend class="texto-borda mb-0 pb-0">Situação:</legend>
                      <div class="form-row ml-2">
                        <div class="form-group form-check">
                          <input class="form-check-input" type="radio" id="rdTodos" checked name="rdSituacao" class='rdSituacao' value="">
                          <label class="form-check-label pr-4" for="rdTodos">Todos</label>
                        </div>
                        <div class="form-group form-check">
                          <input class="form-check-input" type="radio" id="rdPendente" name="rdSituacao" class='rdSituacao' value="P">
                          <label class="form-check-label pr-4" for="rdPendente">Pendente</label>
                        </div>
                        <div class="form-group form-check">
                          <input class="form-check-input" type="radio" id="rdBaixado" name="rdSituacao" class='rdSituacao' value="B">
                          <label class="form-check-label pr-4" for="rdBaixado">Baixado</label>
                        </div>

                        <div class="form-group form-check">
                          <input class="form-check-input" type="radio" id="rdRomaneio" name="rdSituacao" class='rdSituacao' value="R">
                          <label class="form-check-label pr-4" for="rdRomaneio">Romaneio</label>
                        </div>
                        <div class="form-group form-check">
                          <input class="form-check-input" type="radio" id="rdFaturado" name="rdSituacao" class='rdSituacao' value="F">
                          <label class="form-check-label pr-4" for="rdFaturado">Faturado</label>
                        </div>

                        <div class="form-group form-check">
                          <input class="form-check-input" type="radio" id="rdRomaneioFaturado" name="rdSituacao" class='rdSituacao' value="RF">
                          <label class="form-check-label pr-4" for="rdRomaneioFaturado">Romaneio/Faturado</label>
                        </div>
                        <div class="form-group form-check">
                          <input class="form-check-input" type="radio" id="rdBaixadoPendente" name="rdSituacao" class='rdSituacao' value="BP">
                          <label class="form-check-label pr-4" for="rdBaixadoPendente">Baixado/Pendente</label>
                        </div>
                      </div>
                    </fieldset>
                  </div>
                </div>
              </div>
            </div>
            <div class="modal-footer">
              <div class="row">
                <button class="btn btn-primary btn-sisp" id="btnConsultar"><span class="fas fa-search"></span> Consultar</button>
                <button class="btn btn-danger btn-sisp marginBtnH" id="btnLimparFiltros"><span class="fas fa-trash"></span> Limpar Filtros</button>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>

    <div id="modal-gerarReceber" class="modal" tabindex="-1" data-backdrop="static" role="dialog">
      <div class="modal-dialog modal-xl" role="document">
        <div class="modal-content" id="modalBody">
          <div class="modal-header">
            <h4 class="modal-title">Incluir Contas a Receber</h4>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>
          <div class="modal-body">
            <div class="card card-body">
              <div class="row">
                <div class="col-lg-12 col-md-auto col-12 d-flex mb-lg-0 p-0">
                  <div class="col-3">
                    <label for="txtNumero">Numero:</label>
                    <div class="relative">
                      <input type="text" disabled class="input-default focus form-control validate" id="txtNumero" name="Numero">
                    </div>
                  </div>
                  <div class="col-3">
                    <label for="txtOrdemServico">Ordem Serviço:</label>
                    <div class="relative">
                      <input type="text" disabled class="input-default focus form-control validate" id="txtOrdemServico" name="OrdemServico">
                    </div>
                  </div>
                  <div class="col-2">
                    <label for="txtStatusOS">Status OS:</label>
                    <div class="relative">
                      <input type="text" disabled class="input-default focus form-control validate" id="txtStatusOS" name="StatusOS" value="R">
                    </div>
                  </div>
                  <div class="col-2">
                    <label for="txtVencimento">Vencimento:</label>
                    <div class="relative">
                      <input type="date" max="2500-12-31" value="1200-01-01" class="input-default focus form-control validate" id="txtVencimento" name="Vencimento">
                    </div>
                  </div>
                  <div class="col-2">
                    <label for="txtEmissao">Emissão:</label>
                    <div class="relative">
                      <input type="date" max="2500-12-31" value="1200-01-01" class="input-default focus form-control validate" id="txtEmissao" name="Emissao">
                    </div>
                  </div>
                </div>
              </div>
              <div class="row mt-2">
                <div class="col-3 text-left" style="padding-right: 8px !important;">
                  <label data-error="wrong" data-success="right" for="txtClasse">Classe Gerencial: </label>
                  <div class="input-group">
                    <input type="text" data-selecionado="false" class="input-default focus form-control validate" id="txtClasse" name="txtClasse" class="form-control" placeholder="Classe Gerencial">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnClasse" name="btnClasse" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btnLimpaClasse" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
                <div class="col-3 text-left" style="padding-right: 8px !important;">
                  <label data-error="wrong" data-success="right" for="txtHistorico">Historico: </label>
                  <div class="input-group">
                    <input type="text" data-selecionado="false" class="input-default focus form-control validate" id="txtHistorico" name="txtHistorico" class="form-control" placeholder="Historico">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnHistorico" name="btnHistorico" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btnLimpaHistorico" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
                <div class="col-3 text-left" style="padding-right: 8px !important;">
                  <label data-error="wrong" data-success="right" for="txtBanco">Banco: </label>
                  <div class="input-group">
                    <input type="text" data-selecionado="false" class="input-default focus form-control validate" id="txtBanco" name="txtBanco" class="form-control" placeholder="Banco">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnBanco" name="btnBanco" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btnLimpaBanco" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
                <div class="col-3 text-left" style="padding-right: 8px !important;">
                  <label data-error="wrong" data-success="right" for="txtSituacao">Stiuação: </label>
                  <div class="input-group">
                    <input type="text" data-selecionado="false" class="input-default focus form-control validate" id="txtSituacao" name="txtSituacao" class="form-control" placeholder="Stiuação">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnSituacao" name="btnSituacao" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btnLimpaSituacao" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
              </div>
              <div class="row mt-2">
                <div class="col-3 text-left" style="padding-right: 8px !important;">
                  <label data-error="wrong" data-success="right" for="txtMoeda">Moeda: </label>
                  <div class="input-group">
                    <input type="text" data-selecionado="false" class="input-default focus form-control validate" id="txtMoeda" name="txtMoeda" class="form-control" placeholder="Moeda">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnMoeda" name="btnMoeda" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btnLimpaMoeda" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
                <div class="col-1 text-left" style="padding-right: 8px !important;">
                  <label data-error="wrong" data-success="right" for="txtValor">Valor: </label>
                  <div class="input-group">
                    <input type="text" data-selecionado="false" class="input-default focus form-control validate campoValor" id="txtValor" name="txtValor" class="form-control" placeholder="Valor">
                  </div>
                </div>
                <div class="col-1 text-left" style="padding-right: 8px !important;">
                  <label data-error="wrong" data-success="right" for="txtValorParc">Valor Parc.: </label>
                  <div class="input-group">
                    <input type="text" data-selecionado="false" class="input-default focus form-control validate campoValor" id="txtValorParc" name="txtValorParc" class="form-control" placeholder="Valor Parc.">
                  </div>
                </div>
                <div class="col-1 text-left" style="padding-right: 8px !important;">
                  <label data-error="wrong" data-success="right" for="txtParcelas">Parcelas: </label>
                  <div class="input-group">
                    <input type="number" data-selecionado="false" class="input-default focus form-control validate" id="txtParcelas" name="txtParcelas" class="form-control" placeholder="Parcelas">
                  </div>
                </div>
                <div class="col-1 text-left" style="padding-right: 8px !important;">
                  <label data-error="wrong" data-success="right" for="txtIntDias">Int. Dias: </label>
                  <div class="input-group">
                    <input type="number" data-selecionado="false" class="input-default focus form-control validate" id="txtIntDias" name="txtIntDias" class="form-control" placeholder="Int. Dias">
                  </div>
                </div>
                <div class="col-2">
                  <label for="txtPrimeiroVencto">1° Vencimento:</label>
                  <div class="relative">
                    <input type="date" max="2500-12-31" value="1200-01-01" class="input-default focus form-control validate" id="txtPrimeiroVencto" name="PrimeiroVencto">
                  </div>
                </div>
                <div class="col-3">
                  <div class="col-12 col-md-12 d-flex justify-content-end p-0 mt-3">
                    <div class="icheck-primary mr-2 pt-3"><input type="checkbox" class="chkOpcoes" value="S" id="cbBaixarReceber"><label class="labelCheck" for="cbBaixarReceber"> Baixar Receber</label></div>
                    <button class="btn btn-primary btn-sisp mt-2" id="btnGerarReceber" style="height: 37px !important;">Gerar Parcelas</button>
                  </div>
                </div>
              </div>
              <div class="row mt-1 justify-content-start">
                <div class="row col-12 col-md-12 p-0">
                  <div class="col-9 col-md-9 d-flex justify-content-start pl-2">
                    <div class="col-4 text-left d-none" id="divConta" style="padding-right: 0px !important;">
                      <label data-error="wrong" data-success="right" for="txtConta">Conta: </label>
                      <div class="input-group">
                        <input type="text" data-selecionado="false" class="input-default focus form-control validate" id="txtConta" name="txtConta" class="form-control" placeholder="Conta">
                        <div class="input-group-append">
                          <button class="btn bg-danger" id="btnConta" name="btnConta" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                          <button class="btn bg-danger" id="btnLimpaConta" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
              <div class="row mt-1">
                <div class="pt-2 form-row col-12">
                  <div class="col-lg-12 table-responsive table-selecttable-lg">
                    <table id="tabelaReceber" class="table table-sm table-select table-hover" style="width: 100%; white-space: nowrap">
                      <thead>
                        <tr>
                          <th class="th-sm">Num Rec</th>
                          <th class="th-sm">Duplicata/Número</th>
                          <th class="th-sm">Valor</th>
                          <th class="th-sm">Vencimento</th>
                          <th class="th-sm">Emissão</th>
                          <th class="th-sm">Competencia</th>
                          <th class="th-sm">Dia da semana</th>
                        </tr>
                      </thead>
                      <tbody>
                      </tbody>
                    </table>
                  </div>
                </div>
              </div>
            </div>
          </div>
          <div class="modal-footer">
            <div class="row col-12 col-md-12 p-0">
              <div class="col-12 col-md-12 d-flex">
                <button class="btn btnVerde btn-sisp" id="btnConfirmarReceber"><span class="fas fa-check"></span> Confirmar</button>
                <button type="button" class="btn btn-danger btn-sisp marginBtnH" id="btnDesistirReceber"><span class="fas fa-times"></span> Desistir</button>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
    <div class="modal fade" id="modalEntregaOs" role="dialog" aria-labelledby="mySmallModalLabel" aria-hidden="true">
      <div class="modal-dialog modal-lg modal-dialog-centered" style="width: 450px;">
        <div class="modal-content">
          <div class="modal-header">
            <h5 class="modal-title">Importar Consumos</h5>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>
          <div class="modal-body">
            <div class="form-group">
              <label data-error="wrong" class="labelGeral" data-success="right" for="txtDataEntrega">Informe a data de entrega (Formato: dd/mm/aaaa):</label>
              <div class="input-group">
                <input type="text" data-selecionado="false" size="1" class="input-default focus form-control" id="txtDataEntrega" name="txtDataEntrega" placeholder="dd/mm/aaaa">
                <div class="input-group-append">
                  <button class="btn bg-danger" id="btn-limpa-dataEntrega" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                </div>
              </div>
            </div>
            <div class="form-group">
              <label data-error="wrong" class="labelGeral" data-success="right" for="txtHorarioEntrega">Informe o horário de entrega (Formato: 00:00:00):</label>
              <div class="input-group">
                <input type="text" data-selecionado="false" size="1" class="input-default focus form-control" id="txtHorarioEntrega" name="txtHorarioEntrega" placeholder="00:00:00">
                <div class="input-group-append">
                  <button class="btn bg-danger" id="btn-limpa-HorarioEntrega" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                </div>
              </div>
            </div>
            <div class="form-group">
              <label data-error="wrong" class="labelGeral" data-success="right" for="txtClienteEntrega">Informe o cliente:</label>
              <div class="input-group">
                <input type="text" data-selecionado="false" size="1" class="input-default focus form-control" id="txtClienteEntrega" name="txtClienteEntrega" placeholder="Cliente">
                <div class="input-group-append">
                  <button class="btn bg-danger" id="btn-limpa-ClienteEntrega" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                </div>
              </div>
              <input type="text" data-selecionado="false" size="1" class="input-default focus form-control d-none" id="txtOrdemServicoEntrega" name="txtOrdemServicoEntrega" placeholder="Cliente">
            </div>
          </div>
          <div class="modal-footer">
            <div class="row">
              <button class="btn btnVerde btn-sisp" id="btnConfirmaEntrega"><span class="fas fa-check"></span> Confirmar</button>
              <button class="btn btn-danger btn-sisp marginBtnH" id="btnCancelarEntregaOs" data-dismiss="modal"><span class="fas fa-times"></span> Desistir</button>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
  <?php
  include_once('../../../modais.php');
  include_once('../../../modals/modal_anexos.html');
  ?>
  <aside class="control-sidebar control-sidebar-dark">
  </aside>
  </div>
  <script src="plugins/jquery/jquery.min.js?versao=3.258.7.1"></script>
  <script type="text/javascript" src="dist/js/jquery.dataTables.js?versao=3.258.7.1"></script>
  <script type="text/javascript" src="dist/js/dataTables.bootstrap4.min.js?versao=3.258.7.1"></script>
  <script src="plugins/jquery-ui/jquery-ui.min.js?versao=3.258.7.1"></script>
  <script>
    $.widget.bridge('uibutton', $.ui.button);
  </script>
  <script src="plugins/bootstrap/js/bootstrap.bundle.min.js?versao=3.258.7.1"></script>
  <script src="dist/js/adminlte.min.js?versao=3.258.7.1"></script>
  <script src="dist/js/sisplan.js?versao=3.258.7.1"></script>
  <script src="dist/js/jquery.maskMoney.min.js?versao=3.258.7.1"></script>
  <script src="utils/funcoes.js?versao=3.258.7.1"></script>
  <script src="utils/cookies.js?versao=3.258.7.1"></script>
  <script src="dist/js/requisicoes.js?versao=3.258.7.1"></script>
  <script src="dist/js/loadingoverlay.min.js?versao=3.258.7.1"></script>
  <script src="dist/js/driver.min.js?versao=3.258.7.1"></script>
  <script src="plugins/toastr/toastr.min.js?versao=3.258.7.1"></script>
  <script src="plugins/moment/moment.min.js?versao=3.258.7.1"></script>
  <script type="text/javascript" src="dist/js/sum().js?versao=3.258.7.1"></script>
  <script type="text/javascript" src="config.js?versao=3.258.7.1"></script>
  <script type="text/javascript" src="modals/modal_anexos.js?versao=3.258.7.1"></script>
  <script src="graficos/graficos.js?versao=3.258.7.1"></script>
  <script src="plugins/high-charts/highcharts.js"></script>
  <script src="plugins/high-charts/highcharts-3d.js"></script>
  <script src="plugins/high-charts/cylinder.js"></script>
  <script src="plugins/high-charts/exporting.js"></script>
  <script src="plugins/high-charts/export-data.js"></script>

  <script>
    $(document).ready(async function() {
      if (getCookie('usuario') == "") {
        window.location.href = `${BASE_URI}/login`;
        return;
      }

      let usuario = getCookie('usuario');
      let empresa = getCookie('empresa');

      ipInterno = IP_INTERNO;
      ipExterno = IP_EXTERNO;
      basicAuth = BASIC_AUTH;

      const temAcesso = await temAcessoTela('ORDEM_SERVICO');
      if (!temAcesso.resultado) {
        toastrAcesso(temAcesso, BASE_URI);
        return;
      }

      sArquivo = `${BASE_URI}/pages/ordemservico/acesso_os/acesso_os.js?versao=3.258.7.1`;
      insereJavaScriptPagina(sArquivo);

    });
  </script>

</body>

</html>