<?php include_once('../../config.php'); ?>


<!DOCTYPE html>
<html class="theme-light">

<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Sisplan Web | Pedidos B2B</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link rel="stylesheet" href="plugins/fontawesome-free/css/all.min.css?versao=3.258.7.1">
  <link rel="shortcut icon" href="favicon.ico">
  <link rel="stylesheet" href="https://code.ionicframework.com/ionicons/2.0.1/css/ionicons.min.css?versao=3.258.7.1">
  <link rel="stylesheet" href="plugins/icheck-bootstrap/icheck-bootstrap.min.css?versao=3.258.7.1">
  <link rel="stylesheet" href="dist/css/adminlte.min.css?versao=3.258.7.1">
  <link rel="stylesheet" href="plugins/overlayScrollbars/css/OverlayScrollbars.min.css?versao=3.258.7.1">
  <link href='https://fonts.googleapis.com/css?family=Roboto:400,300,500,600,700,400italic' rel='stylesheet' type='text/css'>
  <link rel="stylesheet" href="plugins/select2/css/select2.min.css?versao=3.258.7.1">
  <link rel="stylesheet" href="plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css?versao=3.258.7.1">
  <link rel="stylesheet" type="text/css" href="dist/css/driver.min.css?versao=3.258.7.1" />
  <link rel="stylesheet" href="dist/css/jquery-ui.css?versao=3.258.7.1">
  <link rel="stylesheet" type="text/css" href="plugins/datatables-keytable/css/keyTable.bootstrap4.min.css?versao=3.258.7.1">
  <link rel="stylesheet" href="plugins/toastr/toastr.min.css?versao=3.258.7.1">
  <link rel="stylesheet" href="plugins/daterangepicker/daterangepicker.css?versao=3.258.7.1">
  <link rel="stylesheet" href="dist/css/animate.min.css?versao=3.258.7.1">
  <link rel="stylesheet" href="dist/css/custom.css?versao=3.258.7.1">
  <link rel="stylesheet" type="text/css" href="dist/css/dataTables.bootstrap4.min.css?versao=3.258.7.1" />
  <link rel="stylesheet" href="dist/css/sisplan.css?versao=3.258.7.1">
  <link href='../dist/css/bootstrap.min.css'>
  <link rel="stylesheet" href="dist/css/cadastro.css?versao=3.258.7.1">

  <link rel="stylesheet" href="dist/css/normalize.css?versao=3.258.7.1">
  <link rel="stylesheet" href="plugins/datatables-colreorder/css/colReorder.bootstrap4.min.css?versao=3.258.7.1">
  <link rel="stylesheet" href="dist/css/cards-financeiro.css">


  <style>
    .content-wrapper {
      margin-left: 0px !important;
    }

    .main-header,
    .main-sidebar {
      display: none;
    }

    .info-box .info-box-icon {
      min-width: 30px !important;
      width: 30px !important;
    }

    .info-box-icon>i {
      font-size: 20px !important;
    }

    .info-box .info-box-text,
    .info-box .progress-description {
      overflow: unset;
      font-size: 20px;
      font-weight: 400;
    }

    .bg-info,
    .text-info {
      color: #343a40 !important;
    }


    .btn-info {
      background-color: #343a40 !important;
    }

    .botoesPainel {
      background: none;
      color: inherit;
      border: none;
      padding: 0;
      font: inherit;
      cursor: pointer;
      outline: inherit;
      width: 100%;
      text-align: left;
    }

    .dt-buttons {
      display: flex;
    }

    .buttonColVis,
    .buttonExcel {
      max-width: 40px !important;
      max-height: 40px !important;
    }
  </style>

</head>

<body class="hold-transition sidebar-mini layout-fixed">
  <div class="wrapper">
    <?php
    include_once('../../menu.php');
    ?>

    <div class="content-wrapper">
      <div class="content-header">
        <div class="container-fluid">
          <div class="row mb-2">
            <div class="col-sm-6 flex">
              <h1 class="m-0 text-dark">Pedidos B2B</h1>
              <button title="Tutorial" type="button" class="btn btn-info ml-2 btn-sm" id="tutorial">
                <i class="fas fa-question-circle"></i>
              </button>
            </div>
            <div class="col-sm-6">

            </div>
          </div>
        </div>
      </div>

      <section class="content">
        <div class="container-fluid" id="painelLojaTour">
          <div class="row">
            <div class="col-lg-4 col-12">
              <div class="small-box animate__animated animate__fadeInLeft text-white" style="background: linear-gradient(141deg, rgb(67 176 229) 15%, rgb(18 130 185) 69%) !important">
                <div class="inner">
                  <h3 id="txt_pedidos_carteira">
                    R$ 0,00
                  </h3>
                  <p>Pedidos em Carteira</p>
                </div>
                <div class="icon">
                  <i class="ion ion-bag"></i>
                </div>
                <a href="" id="btnInfoPedCarteira" class="small-box-footer">Mais Informações <i class="fas fa-arrow-circle-right"></i></a>
              </div>
            </div>

            <div class="col-lg-4 col-12">
              <div class="small-box animate__animated animate__zoomIn text-white" style="background: linear-gradient(141deg, rgb(59 161 33) 15%, rgb(2 121 11) 69%) !important">
                <div class="inner">
                  <h3 id="txt_pedidos_faturados">
                    R$ 0,00
                  </h3>
                  <p>Pedidos Faturados</p>
                </div>
                <div class="icon">
                  <i class="ion ion-stats-bars"></i>
                </div>
                <a href="" id="btnInfoPedFaturados" class="small-box-footer">Mais Informações <i class="fas fa-arrow-circle-right"></i></a>
              </div>
            </div>

            <div class="col-lg-4 col-12">
              <div class="small-box animate__animated animate__fadeInRight text-white" style="background: linear-gradient(141deg, rgb(255 193 7) 15%, rgb(213 160 0) 69%) !important">
                <div style="color:white!important;" class="inner">
                  <h3 id="txt_previsao_comissao">
                    R$ 0,00
                  </h3>
                  <p>Previsão Comissão</p>
                </div>
                <div class="icon">
                  <i class="ion ion-pie-graph"></i>
                </div>
                <a href="" id="btnInfoPrevComissao" style="color:white!important;" class="small-box-footer">Mais Informações <i class="fas fa-arrow-circle-right"></i></a>
              </div>
            </div>
          </div>
          <div class="row">
            <div class="col-lg-4 col-12">
              <div class="small-box animate__animated animate__fadeInLeft text-white" style="background: linear-gradient(141deg, rgb(67 176 229) 15%, rgb(18 130 185) 69%) !important">
                <div class="inner">
                  <h3 id="txt_mix_produtos">
                    0
                  </h3>
                  <p>Mix de Produtos</p>
                </div>
                <div class="icon">
                  <i class="ion ion-bag"></i>
                </div>
                <a href="" id="btnInfoMixProdutos" class="small-box-footer">Mais Informações <i class="fas fa-arrow-circle-right"></i></a>
              </div>
            </div>

            <div class="col-lg-4 col-12">
              <div class="small-box animate__animated animate__zoomIn text-white" style="background: linear-gradient(141deg, rgb(59 161 33) 15%, rgb(2 121 11) 69%) !important">
                <div class="inner">
                  <h3 id="txt_adm_carteira">
                    0 de 0
                  </h3>
                  <p>ADM de Carteira</p>
                </div>
                <div class="icon">
                  <i class="ion ion-stats-bars"></i>
                </div>
                <a href="" id="btnInfoAdmCarteira" class="small-box-footer">Mais Informações <i class="fas fa-arrow-circle-right"></i></a>
              </div>
            </div>

            <div class="col-lg-4 col-12">
              <div class="small-box animate__animated animate__fadeInRight text-white" style="background: linear-gradient(141deg, rgb(255 193 7) 15%, rgb(213 160 0) 69%) !important">
                <div style="color:white!important;" class="inner">
                  <h3 id="txt_abertura_clientes">
                    0 de 0
                  </h3>
                  <p>Abertura de Clientes</p>
                </div>
                <div class="icon">
                  <i class="ion ion-pie-graph"></i>
                </div>
                <a href="" id="btnInfoAberturaClientes" style="color:white!important;" class="small-box-footer">Mais Informações <i class="fas fa-arrow-circle-right"></i></a>
              </div>
            </div>
          </div>
        </div>

        <div class="card">
          <div class="card-body">
            <div class="container-fluid">
              <div class="row">
                <div class="col-lg-2 col-12">
                  <div class="info-box bg-info pointer" id="atalhoClienteTour">
                    <span class="info-box-icon bg-white"><i class="fas fa-users text-info"></i></span>

                    <div class="info-box-content">
                      <span class="info-box-text text-white">Clientes</span>
                      <span class="info-box-number text-white">(F2)</span>
                    </div>
                  </div>
                </div>
                <div class="col-lg-2 col-12">
                  <button id="btnPreVenda" class="botoesPainel">
                    <div class="info-box bg-info" id="atalhoPrevendaTour" style="cursor: pointer;">
                      <span class="info-box-icon bg-white"><i class="fas fa-cart-plus text-info"></i></span>

                      <div class="info-box-content">
                        <span class="info-box-text text-white">Pré-Pedido</span>
                        <span class="info-box-number text-white">(F3)</span>
                      </div>
                    </div>
                  </button>
                </div>
                <div class="col-lg-2 col-12">
                  <div class="info-box bg-info pointer" id="atalhoPrecoTour">
                    <span class="info-box-icon bg-white"><i class="fas fa-book text-info"></i></span>
                    <div class="info-box-content">
                      <span class="info-box-text text-white">Preços</span>
                      <span class="info-box-number text-white">(F6)</span>
                    </div>
                  </div>
                </div>

                <div class="col-lg-2 col-12">
                  <div class="info-box bg-info pointer" id="atalhoEstoqueTour">
                    <span class="info-box-icon bg-white"> <i class="nav-icon fas fa-box-open text-info"></i></span>
                    <div class="info-box-content">
                      <span class="info-box-text text-white">Estoque</span>
                      <span class="info-box-number text-white">(F7)</span>
                    </div>
                  </div>
                </div>

              </div>
            </div>
            <div class="container-fluid">
              <div class="row pb-4">
                <div class="col-sm-12">
                  <button class="btn btn-success btn-sisp" id="btnFiltros" type="button">
                    <span class="fas fa-filter"></span> Filtros
                  </button>

                  <button class="btn btn-success btn-sisp" id="btnAtendimentoPendente" type="button">
                    <span class="fas fa-paste"></span> Carrinhos Pendentes
                  </button>
                </div>
              </div>
            </div>
            <div class="row">
              <div class="col-sm-12 table-responsive" style="padding-left:14px;">
                <div class="col-sm-12 table-responsive card-body">
                  <h5>Lista de pedidos</h5>
                  <table id="tabelaPedido" class="table table-sm table-select table-hover" width="100%">
                    <thead></thead>
                    <tbody></tbody>
                  </table>
                </div>
              </div>
            </div>
          </div>
        </div>
      </section>

      <div id="modal-filtros" class="modal" tabindex="-1" role="dialog">
        <div class="modal-dialog modal-xl" role="document">
          <div class="modal-content" id="modalBody">
            <div class="modal-header">
              <h4 class="modal-title">Filtros</h4>
              <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
              </button>
            </div>
            <div class="modal-body">

              <div class="row" style="margin-top: 1.4%;">
                <div class="group-default form-group col-3">
                  <label for="txtDataEmiDe">Data Cadastro De: </label>
                  <div class="relative">
                    <input type="date" max="2500-12-31" value="1200-01-01" class="input-default focus form-control validate" id="txtDataEmiDe" name="DataDe">
                  </div>
                </div>
                <div class="group-default form-group col-3">
                  <label for="txtDataEntregaDe">Data Entrega De: </label>
                  <div class="relative">
                    <input type="date" max="2500-12-31" value="1200-01-01" class="input-default focus form-control validate" id="txtDataEntregaDe" name="DataDe">
                  </div>
                </div>
                <div class="group-default form-group col-3">
                  <label for="txtDataFaturaDe">Data Fatura De: </label>
                  <div class="relative">
                    <input type="date" max="2500-12-31" value="1200-01-01" class="input-default focus form-control validate" id="txtDataFaturaDe" name="DataDe">
                  </div>
                </div>
                <div class="group-default form-group col-3">
                  <label for="txtDataSaidaDe">Data Saída De: </label>
                  <div class="relative">
                    <input type="date" max="2500-12-31" value="1200-01-01" class="input-default focus form-control validate" id="txtDataSaidaDe" name="DataDe">
                  </div>
                </div>
                <div class="group-default form-group col-3">
                  <label for="txtDataEmiAte">Até: </label>
                  <div class="relative">
                    <input type="date" max="2500-12-31" value="2500-12-01" class="input-default focus form-control validate" id="txtDataEmiAte" name="DataAte">
                  </div>
                </div>
                <div class="group-default form-group col-3">
                  <label for="txtDataEntregaAte">Até: </label>
                  <div class="relative">
                    <input type="date" max="2500-12-31" value="2500-12-01" class="input-default focus form-control validate" id="txtDataEntregaAte" name="DataAte">
                  </div>
                </div>
                <div class="group-default form-group col-3">
                  <label for="txtDataFaturaAte">Até: </label>
                  <div class="relative">
                    <input type="date" max="2500-12-31" value="2500-12-01" class="input-default focus form-control validate" id="txtDataFaturaAte" name="DataAte">
                  </div>
                </div>
                <div class="group-default form-group col-3">
                  <label for="txtDataSaidaAte">Até: </label>
                  <div class="relative">
                    <input type="date" max="2500-12-31" value="2500-12-01" class="input-default focus form-control validate" id="txtDataSaidaAte" name="DataAte">
                  </div>
                </div>
              </div>

              <div class="row">

                <div class="col-lg-9">
                  <label data-error="wrong" data-success="right" for="txtPedidoConsulta">Pedido </label>
                  <div class="input-group col-12" style="padding-left: 0px;">
                    <input type="text" class="input-default col-lg-2 col-12 focus form-control" id="txtPedidoConsulta" name="txtPedidoConsulta" class="form-control" placeholder="Pedido">
                    <button class="btn bg-danger" id="btn-PedidoConsulta" name="btn-PedidoConsulta" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                    <input type="text" id="txtListaPedidos" class="form-group col-lg-12 col-12 input-default focus form-control" placeholder="Lista de Pedidos" disabled>
                    <button class="btn bg-danger" id="btn-limpa-PedidoConsulta" name="btn-limpa-PedidoConsulta" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                  </div>
                </div>

                <div class="col-lg-3 pl-5 pt-4">
                  <button class="btn btn-danger btn-sisp" type='button' id="btnSelecionarEmpresas">Selecionar Empresas</button>   
                </div>

              </div>

              <div class="row" style="margin-top: 1.4%;">
                <div class="col-4" id="ClienteConsulta">
                  <label data-error="wrong" data-success="right" for="txtClienteConsulta">Cliente </label>
                  <div class="input-group">
                    <input type="text" autocomplete="off" class="input-default focus form-control" id="txtClienteConsulta" name="txtClienteConsulta" class="form-control" placeholder="Cliente">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btn-ClienteConsulta" name="btn-ClienteConsulta" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btn-limpa-ClienteConsulta" name="btn-limpa-ClienteConsulta" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>

                <div class="col-4" id="RepresentanteConsulta">
                  <label data-error="wrong" data-success="right" for="txtRepresentanteConsulta">Representante </label>
                  <div class="input-group">
                    <input type="text" autocomplete="off" class="input-default focus form-control" id="txtRepresentanteConsulta" name="txtRepresentanteConsulta" class="form-control" placeholder="Representante">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btn-RepresentanteConsulta" name="btn-RepresentanteConsulta" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btn-limpa-RepresentanteConsulta" name="btn-limpa-RepresentanteConsulta" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>

                <div class="col-4" id="StatusConsulta">
                  <label data-error="wrong" data-success="right" for="txtStatusConsulta">Status </label>
                  <div class="input-group">
                    <input type="text" autocomplete="off" class="input-default focus form-control" id="txtStatusConsulta" name="txtStatusConsulta" class="form-control" placeholder="Status">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btn-StatusConsulta" name="btn-StatusConsulta" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btn-limpa-StatusConsulta" name="btn-limpa-StatusConsulta" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
              </div>

              <div class="row" style="margin-top: 1.4%;">
                <div class="col-4" id="TabPrecoConsulta">
                  <label data-error="wrong" data-success="right" for="txtTabPrecoConsulta">Tabela de Preço </label>
                  <div class="input-group">
                    <input type="text" autocomplete="off" class="input-default focus form-control" id="txtTabPrecoConsulta" name="txtTabPrecoConsulta" class="form-control" placeholder="Tabela de preço">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btn-TabPrecoConsulta" name="btn-TabPrecoConsulta" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btn-limpa-TabPrecoConsulta" name="btn-limpa-TabPrecoConsulta" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>

                <div class="col-4" id="ColecaoConsulta">
                  <label data-error="wrong" data-success="right" for="txtColecaoConsulta">Coleção </label>
                  <div class="input-group">
                    <input type="text" autocomplete="off" class="input-default focus form-control" id="txtColecaoConsulta" name="txtColecaoConsulta" class="form-control" placeholder="Coleção">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btn-ColecaoConsulta" name="btn-ColecaoConsulta" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btn-limpa-ColecaoConsulta" name="btn-limpa-ColecaoConsulta" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>

                <div class="col-4" id="TipoProdConsulta">
                  <label data-error="wrong" data-success="right" for="txtTipoProdConsulta">Tipo Produto </label>
                  <div class="input-group">
                    <input type="text" autocomplete="off" class="input-default focus form-control" id="txtTipoProdConsulta" name="txtTipoProdConsulta" class="form-control" placeholder="Tipo produto">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btn-TipoProdConsulta" name="btn-TipoProdConsulta" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btn-limpa-TipoProdConsulta" name="btn-limpa-TipoProdConsulta" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>

              </div>

              <div class="row" style="margin-top: 1.4%;">
                <div class="col-4" id="GrupoPedConsulta">
                  <label data-error="wrong" data-success="right" for="txtGrupoPedConsulta">Grupo Pedido </label>
                  <div class="input-group">
                    <input type="text" autocomplete="off" class="input-default focus form-control" id="txtGrupoPedConsulta" name="txtGrupoPedConsulta" class="form-control" placeholder="Grupo pedido">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btn-GrupoPedConsulta" name="btn-GrupoPedConsulta" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btn-limpa-GrupoPedConsulta" name="btn-limpa-GrupoPedConsulta" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>

                <div class="col-4" id="GrupoProdConsulta">
                  <label data-error="wrong" data-success="right" for="txtGrupoProdConsulta">Grupo Produto </label>
                  <div class="input-group">
                    <input type="text" autocomplete="off" class="input-default focus form-control" id="txtGrupoProdConsulta" name="txtGrupoProdConsulta" class="form-control" placeholder="Grupo produto">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btn-GrupoProdConsulta" name="btn-GrupoProdConsulta" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btn-limpa-GrupoProdConsulta" name="btn-limpa-GrupoProdConsulta" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>

              </div>

              <div class="row" style="margin-top: 1.4%;">
                <div class="group-default form-group col-4">
                  <label for="">Financeiro: </label>
                  <div class="relative">
                    <select name="" id="txtBloqFinConsulta" value="" class="form-group input-default">
                      <option value="">Todos</option>
                      <option value="1">Liberados</option>
                      <option value="0">Bloqueados</option>
                    </select>
                  </div>
                </div>
                <div class="group-default form-group col-4">
                  <label for="">Comercial: </label>
                  <div class="relative">
                    <select name="" id="txtBloqComConsulta" value="" class="form-group input-default">
                      <option value="">Todos</option>
                      <option value="1">Liberados</option>
                      <option value="0">Bloqueados</option>
                    </select>
                  </div>
                </div>
                <div class="group-default form-group col-4">
                  <label for="">Situação: </label>
                  <div class="relative">
                    <select name="" id="txtSituacaoConsulta" value="" class="form-group input-default">
                      <option value="">Todos</option>
                      <option value="P">Pendentes</option>
                      <option value="F">Faturados</option>
                    </select>
                  </div>
                </div>
              </div>
            </div>

            <div class="modal-footer d-flex align-items-end">
              <div class="row col-12 ml-0">
                <div class="col-lg-4 col-sm-6 col-md-6 ml-0 pl-0">
                  <label for="txtOrdem">Opção de Relatório:</label>
                  <div class="relative d-flex align-items-center">
                    <select id="txtOrdem" class="input-default focus custom-select">
                    </select>
                    <button class="btn btn-sm btn-success ml-2 btnEdicaoRelatorio" title="Edição de ordenações">
                      <i class="fas fa-check"></i>
                    </button>
                  </div>
                </div>
                <div class="col-6 col-lg-8 d-flex justify-content-end align-items-end pr-0">
                  <div class="d-flex">
                    <button class="btn btn-primary btn-sisp mr-2" id="btnLimparFiltros" style="background-color: #B22222; border-color: #B22222">
                      <span class="fas fa-trash"></span> Limpar Filtros
                    </button>
                    <button id="btnConsultar" class="btn btn-primary btn-sisp" type="button">
                      <span class="fas fa-search"></span> Consultar
                    </button>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>

      <div class="modal fade" id="modal-atendimentosPendentes" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-xl">
          <div class="modal-content">
            <div class="modal-header" style="border:none">
              <h4 id="modal-simular-titulo" class="modal-title">Atendimentos Pendentes</h4>
              <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
              </button>
            </div>
            <div class="modal-body">
              <div class="row">
                <div class="col-6 d-flex align-items-center">
                  <h5>Lista Atendimentos Pendentes</h5>
                </div>
                <div class="col-12 table-responsive">
                  <table id="tabelaAtendimentosPendente" style="width:100%;" width="100%" class="table table-sm table-select">
                    <thead>
                    </thead>
                    <tbody></tbody>
                  </table>
                </div>

              </div>
            </div>
            <!-- <div class="col-sm-4">
              <button name="btn-confirmarduplicata" class="btn btn-info btn-block text-white" id="btn-confirmarduplicata" value="">Confirmar <small>(ALT + S)</small></button>
            </div> -->

          </div>
        </div>
      </div>

      <div class="modal fade" id="modal-pedidos-carteira" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-xl">
          <div class="modal-content">
            <div class="modal-header" style="border:none">
              <h4 id="modal-simular-titulo" class="modal-title">Pedidos em Carteira</h4>
              <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
              </button>
            </div>
            <div class="modal-body">
              <div class="row">
                <!-- <div class="col-6 d-flex align-items-center">
                    <h5>Lista Atendimentos Pendentes</h5>
                  </div> -->
                <div class="col-8 table-responsive">
                  <table id="tabelaPedidosCarteira" style="width:100%;" width="100%" class="table table-sm table-select">
                    <thead>
                    </thead>
                    <tbody></tbody>
                  </table>
                </div>
                <div class="col-4">

                  Pedidos X Tipos
                  <div id="chartPedidosCarteira"></div>

                </div>

              </div>
            </div>

          </div>
        </div>
      </div>

      <div class="modal fade" id="modal-pedidos-faturados" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-xl">
          <div class="modal-content">
            <div class="modal-header" style="border:none">
              <h4 id="modal-simular-titulo" class="modal-title">Pedidos Faturados</h4>
              <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
              </button>
            </div>
            <div class="modal-body">
              <div class="row">
                <!-- <div class="col-6 d-flex align-items-center">
                  <h5>Lista Atendimentos Pendentes</h5>
                </div> -->
                <div class="col-8 table-responsive">
                  <h5>Pedidos Faturados</h5>
                  <table id="tabelaPedidosFaturados" style="width:100%;" width="100%" class="table table-sm table-select">
                    <thead>
                    </thead>
                    <tbody></tbody>
                  </table>
                </div>

                <div class="col-4">
                  Faturados X Devolvidos
                  <div id="chartPedidosFaturados"></div>
                </div>
                <div class="col-12 table-responsive">
                  <h5>Pedidos Devolvidos</h5>
                  <table id="tabelaPedidosDevolvidos" style="width:100%;" width="100%" class="table table-sm table-select">
                    <thead>
                    </thead>
                    <tbody></tbody>
                  </table>
                </div>
              </div>
            </div>

          </div>
        </div>
      </div>

      <div class="modal fade" id="modal-previsao-comissao" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-xl">
          <div class="modal-content">
            <div class="modal-header" style="border:none">
              <h4 id="modal-simular-titulo" class="modal-title">Abertura de Clientes</h4>
              <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
              </button>
            </div>
            <div class="modal-body">
              <div class="row">
                <!-- <div class="col-6 d-flex align-items-center">
                  <h5>Lista Atendimentos Pendentes</h5>
                </div> -->
                <div class="col-12 table-responsive">
                  <table id="tabelaPrevisaoComissao" style="width:100%;" width="100%" class="table table-sm table-select">
                    <thead>
                    </thead>
                    <tbody></tbody>
                  </table>
                </div>
              </div>
            </div>

          </div>
        </div>
      </div>

      <div class="modal fade" id="modal-mix-produtos" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-xl">
          <div class="modal-content">
            <div class="modal-header" style="border:none">
              <h4 id="modal-simular-titulo" class="modal-title">Mix de Produtos</h4>
              <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
              </button>
            </div>
            <div class="modal-body">
              <div class="row">
                <!-- <div class="col-6 d-flex align-items-center">
                  <h5>Lista Atendimentos Pendentes</h5>
                </div> -->
                <div class="col-8 table-responsive">
                  <table id="tabelaMixProdutos" style="width:100%;" width="100%" class="table table-sm table-select">
                    <thead>
                    </thead>
                    <tbody></tbody>
                  </table>
                </div>
                <div class="col-4">
                  Produtos X Pedidos
                  <div id="chartMixProd">
                  </div>
                </div>
              </div>
            </div>

          </div>
        </div>
      </div>

      <div class="modal fade" id="modal-adm-carteira" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-xl">
          <div class="modal-content">
            <div class="modal-header" style="border:none">
              <h4 id="modal-simular-titulo" class="modal-title">ADM de Carteira</h4>
              <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
              </button>
            </div>
            <div class="modal-body">
              <!-- <div class="col-6 d-flex align-items-center">
                <h5>Lista Atendimentos Pendentes</h5>
              </div> -->
              <div class="row d-flex align-items-center justify-content-end">
                <div class="col-8 table-responsive">
                  <table id="tabelaAdmCarteiraAtendidos" style="width:100%;" width="100%" class="table table-sm table-select">
                    <thead>
                    </thead>
                    <tbody></tbody>
                  </table>
                </div>
                <div class="col-4">
                  Cidades X Pedidos
                  <div class="" id="chartAdmCarteira"></div>
                </div>
              </div>
              <div class="row">

              </div>
            </div>

          </div>
        </div>
      </div>

      <div class="modal fade" id="modal-abertura-clientes" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-xl">
          <div class="modal-content">
            <div class="modal-header" style="border:none">
              <h4 id="modal-simular-titulo" class="modal-title">Abertura de Clientes</h4>
              <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
              </button>
            </div>
            <div class="modal-body">
              <div class="row">
                <!-- <div class="col-6 d-flex align-items-center">
                  <h5>Lista Atendimentos Pendentes</h5>
                </div> -->
                <div class="col-12 table-responsive">
                  <table id="tabelaAberturaClientes" style="width:100%;" width="100%" class="table table-sm table-select">
                    <thead>
                    </thead>
                    <tbody></tbody>
                  </table>
                </div>
              </div>
            </div>

          </div>
        </div>
      </div>


      <?php
      include_once('modal/modal_pedido.php');
      include_once('modal/modal_dados_entrega.php');
      ?>
    </div>
  </div>

  <?php
  include_once('../../modais.php');
  ?>

  <!-- jQuery -->
  <script src="plugins/jquery/jquery.min.js?versao=3.258.7.1"></script>
  <!-- jQuery UI 1.11.4 -->
  <script src="plugins/jquery-ui/jquery-ui.min.js?versao=3.258.7.1"></script>
  <script>
    if ($('[type="date"]').prop('type') != 'date') {
      $('[type="date"]').datepicker();
    }
    $.widget.bridge('uibutton', $.ui.button)
  </script>

  <!-- Bootstrap 4 -->
  <script src="plugins/bootstrap/js/bootstrap.bundle.min.js?versao=3.258.7.1"></script>
  <!-- ChartJS -->
  <script src="plugins/chart.js/Chart.min.js?versao=3.258.7.1"></script>
  <!-- Sparkline -->
  <script src="plugins/sparklines/sparkline.js?versao=3.258.7.1"></script>

  <script src="dist/js/adminlte.min.js?versao=3.258.7.1"></script>
  <script src="dist/js/adminltemenu.js?versao=3.258.7.1"></script>
  <script type="text/javascript" src="utils/funcoes.js?versao=3.258.7.1"></script>
  <script type="text/javascript" src="dist/js/jquery.dataTables.min.js?versao=3.258.7.1"></script>
  <script type="text/javascript" src="dist/js/loadingoverlay.min.js?versao=3.258.7.1"></script>
  <script type="text/javascript" src="dist/js/jquery.dataTables.js?versao=3.258.7.1"></script>
  <script type="text/javascript" src="dist/js/dataTables.bootstrap4.min.js?versao=3.258.7.1"></script>
  <script src="dist/js/dataTables.keyTable.js?versao=3.258.7.1"></script>
  <script src="utils/cookies.js?versao=3.258.7.1"></script>
  <script src="dist/js/requisicoes.js?versao=3.258.7.1"></script>
  <script src="dist/js/driver.min.js?versao=3.258.7.1"></script>
  <script src="plugins/toastr/toastr.min.js?versao=3.258.7.1"></script>
  <script src="dist/js/sisplan.js?versao=3.258.7.1"></script>

  <script src="dist/js/jquery.maskMoney.min.js?versao=3.258.7.1"></script>
  <script src="pages/loja/js/rotinas.js?versao=3.258.7.1"></script>
  <script src="pages/pedidosb2b/js/arrayColunasDatatablePedido.js?versao=3.258.7.1"></script>
  <script src="plugins/jquery-validation/jquery.validate.min.js?versao=3.258.7.1"></script>
  <script src="plugins/jquery-validation/additional-methods.min.js?versao=3.258.7.1"></script>
  <script src="dist/js/datetime.js?versao=3.258.7.1"></script>
  <script type="text/javascript" src="plugins/jszip/jszip.min.js?versao=3.258.7.1"></script>
  <script type="text/javascript" src="plugins/pdfmake/pdfmake.min.js?versao=3.258.7.1"></script>
  <script type="text/javascript" src="plugins/pdfmake/vfs_fonts.js?versao=3.258.7.1"></script>
  <script type="text/javascript" src="plugins/datatables-buttons/js/dataTables.buttons.min.js?versao=3.258.7.1"></script>
  <script type="text/javascript" src="plugins/datatables-buttons/js/buttons.html5.min.js?versao=3.258.7.1"></script>
  <script src="plugins/datatables-colreorder/js/dataTables.colReorder.min.js?versao=3.258.7.1"></script>
  <script src="pages/pedidosb2b/modal/modal_pedido.js?versao=3.258.7.1"></script>
  <script src="pages/pedidosb2b/modal/modal_dados_entrega.js?versao=3.258.7.1"></script>

  <script>
    $(document).ready(async function() {
      if (getCookie('usuario') == "") {
        window.location.href = `${BASE_URI}/login`;
        return;
      }

      let usuario = getCookie('usuario');
      let empresa = getCookie('empresa');

      ipInterno = IP_INTERNO;
      ipExterno = IP_EXTERNO;
      basicAuth = BASIC_AUTH;

      const temAcesso = await temAcessoTela('PEDIDOSB2B');
      if (!temAcesso.resultado) {
        toastrAcesso(temAcesso, BASE_URI);
        return;
      }

      sArquivo = `${BASE_URI}/pages/pedidosb2b/js/acesso_b2b.js`;
      const nomeTela = ('<?php echo basename(__FILE__) ?>').replace('.php', '');
      await insereJavaScriptPagina(sArquivo);

      habilitaCamposObrigatoriosTela(nomeTela);
    });
  </script>

</body>

</html>