$(document).ready(async function () {

  // $('#tutorial').on('click', function () {
  //   $(document).ready(async function () {
  //     const driver = new Driver({
  //       doneBtnText: 'Sair',
  //       closeBtnText: 'Fechar',
  //       nextBtnText: 'Próximo',
  //       prevBtnText: 'Anterior',
  //       allowClose: false
  //     });
  //     driver.defineSteps([{
  //       element: '#btnFiltros',
  //       popover: {
  //         title: 'Botão Filtros',
  //         description: 'Clique aqui para abrir os filtros e realizar alguma consulta.',
  //         position: 'right'
  //       }
  //     },
  //     {
  //       element: '#btnImprimir',
  //       popover: {
  //         title: 'Botão Imprimir',
  //         description: 'Clique aqui para Imprimir um relatório.',
  //         position: 'right'
  //       }
  //     }
  //     ]);
  //     driver.start();
  //   });
  // });

  iniciaTela();

  const dataSetCols_FACCAO = [
    { title: "Número", data: "NUMERO", desabilitado: true },
    { title: "Pedido", data: "PEDIDO", desabilitado: true },
    { title: "Código", data: "CODIGO", desabilitado: true },
    { title: "Descrição", data: "DESCRICAO" },
    { title: "Unidade", data: "UNIDADE" },
    { title: "Codcli", data: "CODCLI" },
    { title: "Nome", data: "NOME" },
    { title: "CNPJ", data: "CNPJ" },
    { title: "Célula", data: "CELULA" },
    { title: "Nome Célula", data: "NOME_CELULA" },
    { title: "Tam. R.", data: "TAM_R" },
    { title: "Setor", data: "SETOR" },
    { title: "Preço", data: "PRECO" },
    { title: "Custo", data: "CUSTO" },
    { title: "Fluxo", data: "FLUXO" },
    { title: "Parte", data: "PARTE" },
    { title: "Ped. Cli.", data: "PED_CLI" },
    { title: "Codcli Pedido", data: "CODCLI_PEDIDO" },
    { title: "Nome Pedido", data: "NOME_PEDIDO" },
    { title: "Fantasia", data: "FANTASIA" },
    { title: "Codcor", data: "CODCOR" },
    { title: "Cor", data: "COR" },
    { title: "Cor Parte", data: "CORPARTE" },
    { title: "Composicao", data: "COMPOSICAO" },
    { title: "Grupo", data: "GRUPO" },
    { title: "Desc. Grupo", data: "DESCGRUPO" },
    { title: "Desc. Parte", data: "DESC_PARTE" },
    { title: "Cabeçalho", data: "CABECALHO" },
    { title: "Texto", data: "TEXTO" },
    { title: "Qtde", data: "QTDE" },
    { title: "Cor Tin.", data: "CORTIN" },
    { title: "Dt. Entrega Ped.", data: "DT_ENTREGAPED" },
    { title: "Ris. Ped.", data: "RIS_PED" },
    { title: "Dt. Ofini", data: "DT_OFINI" },
    { title: "Dt. Offim", data: "DT_OFFIM" },
    { title: "Período", data: "PERIODO" },
    { title: "Fantasia Pro.", data: "FANTASIA_PRO" },
    { title: "Dt. S.", data: "DT_S" },
    { title: "Dt. R.", data: "DT_R" },
    { title: "Peso", data: "PESO" },
    { title: "V. Consumo", data: "VCONSUMO" },
    { title: "Opções", data: "OPCOES" },
    { title: "Opções 2", data: "OPCOES2" },
    { title: "Código 2", data: "CODIGO2" },
    { title: "Descrição 2", data: "DESCRICAO2" },
    { title: "Cubagem", data: "CUBAGEM" },
    { title: "Movimento", data: "MOVIMENTO" },
    { title: "Telefone", data: "TELEFONE" },
    { title: "Fone Compl.", data: "FONE_COMPL" },
    { title: "T. Movimentos", data: "T_MOVIMENTOS" },
    { title: "ID", data: "ID" },
    { title: "Obs. Of", data: "OBSOF" },
    { title: "Obs. Ped.", data: "OBSPED" },
    { title: "Endereço", data: "ENDERECO" },
    { title: "Num. End.", data: "NUM_END" },
    { title: "Bairro", data: "BAIRRO" },
    { title: "Cidade", data: "CIDADE" },
    { title: "Desc. Fac3", data: "DESC_FAC3" },
    { title: "Dt. Prev. Pg.", data: "DT_PREVPG" },
    { title: "Dt. Prev. Pg. Fac.", data: "DT_PREVPG_FAC" },
    { title: "Cod. Marca", data: "COD_MARCA" },
    { title: "Desc. Marca", data: "DESC_MARCA" },
    { title: "Etiqueta", data: "ETIQUETA" },
    { title: "Desc. Etiqueta", data: "DESC_ETIQUETA" },
    { title: "Peso Prod.", data: "PESO_PROD" },
    { title: "Mínimo", data: "MINIMO" },
    { title: "Of Ref.", data: "OF_REF" },
    { title: "Mov. Ref.", data: "MOV_REF" },
    { title: "Setor R.", data: "SETOR_R" },
    { title: "Lancto", data: "LANCTO" },
    { title: "Ciclo", data: "CICLO" },
    { title: "Sortido", data: "SORTIDO" },
    { title: "Mov. Lanc.", data: "MOV_LANC" },
    { title: "Programação", data: "PROGRAMACAO" },
    { title: "Máquina", data: "MAQUINA" },
    { title: "Desc. Máquina", data: "DESC_MAQUINA" },
    { title: "Lista Of Ped.", data: "LISTAOFPED" },
    { title: "Depósito", data: "DEPOSITO" },
    { title: "Desc. Dep.", data: "DESCDEP" },
    { title: "Mov. Setor", data: "MOV_SETOR" },
    { title: "Mov. Setor 2", data: "MOV_SETOR_2" },
    { title: "Ordem", data: "ORDEM" },
    { title: "Tipo", data: "TIPO" },
    { title: "Tp. Rel.", data: "TPREL" },
    { title: "Dt. Saída", data: "DT_SAIDA" },
    { title: "Dt. Fatura", data: "DT_FATURA" },
    { title: "Tipo Of 2", data: "TIPO_OF2" },
    { title: "Capac. Prod.", data: "CAPAC_PROD" },
    { title: "Tempo Total", data: "TEMPO_TOTAL" },
    { title: "Qtde Prod.", data: "QUANT_PROD" },
    { title: "Classifica", data: "CLASSIFICA" },
    { title: "Estimativa Mês", data: "ESTIMATIVA_MES" },
    { title: "ABVTEX", data: "ABVTEX" },
    { title: "Composição 1", data: "COMPOSICAO1" },
    { title: "Composição 2", data: "COMPOSICAO2" },
    { title: "Composição 3", data: "COMPOSICAO3" },
    { title: "Composição 4", data: "COMPOSICAO4" },
    { title: "Obs. Fluxo", data: "OBS_FLUXO" },
    { title: "Tipo Venda", data: "TIPOVENDA" },
    { title: "Obs. Setor", data: "OBS_SETOR" },
    { title: "Obs. Cor", data: "OBS_COR" },
    { title: "Composição 5", data: "COMPOSICAO5" },
    { title: "Composição 6", data: "COMPOSICAO6" },
    { title: "Composição 7", data: "COMPOSICAO7" },
    { title: "Qtde Programada", data: "QTDE_PROGRAMADA" },
    { title: "Perc. Pontualidade", data: "PERC_PONTUALIDADE" },
    { title: "Perc. Qual.", data: "PERC_QUAL" },
    { title: "Perc. 100", data: "PERC_100" },
    { title: "Fac. Preço Obs", data: "FACPRECO_OBS" },
    { title: "Coleção", data: "COLECAO" },
    { title: "Desc. Colecao", data: "DESC_COLECAO" },
    { title: "Cod.2 Cor", data: "COD2_COR" },
    { title: "ID Tipo", data: "ID_TIPO" },
    { title: "Desc. Tipo", data: "DESC_TIPO" },
    { title: "Sub Coleção", data: "SUB_COLECAO" },
    { title: "Desc. SubColeção", data: "DESC_SUBCOLECAO" },
    { title: "Obs Fac. Setor", data: "OBS_FACSETOR" },
    { title: "Movn. Ant.", data: "MOV_ANT" },
    { title: "Tabela", data: "TABELA" },
    { title: "Comp. Ent.", data: "COMP_ENT" },
    { title: "Linha", data: "LINHA" },
    { title: "Desc. Linha", data: "DESC_LINHA" },
    { title: "Perc. Consumo", data: "PERC_CONSUMO" },
    { title: "Ordem Pa.Iten", data: "ORDEM_PAITEN" },
    { title: "Json App", data: "JSONAPP" },
    { title: "Campo Preço", data: "CAMPO_PRECO", desabilitado: true },
    { title: "Campo Preço Certo", data: "CAMPO_PRECO_CERTO", desabilitado: true },
  ];

  const dataSetCols_CONSUMOS = [
    { title: "Imprimir", data: "IMPRIMIR" },
    { title: "Desc. Prod", data: "DESC_PROD" },
    { title: "Cor Prod", data: "COR_PROD" },
    { title: "Desc. Cor Prod.", data: "DESC_COR_PROD" },
    { title: "Insumo", data: "INSUMO" },
    { title: "Descrição", data: "DESCRICAO" },
    { title: "Unidade", data: "UNIDADE" },
    { title: "Cubagem", data: "CUBAGEM" },
    { title: "Local", data: "LOCAL" },
    { title: "Cor", data: "COR" },
    { title: "Desc. Cor", data: "DESCCOR" },
    { title: "Cod. Apl.", data: "CODAPL" },
    { title: "Aplicação", data: "APLICACAO" },
    { title: "Consumo", data: "CONSUMO" },
    { title: "Consumo Unitário", data: "CONSUMO_UNITARIO" },
    { title: "Imprime", data: "IMPRIME" },
    { title: "Setor", data: "SETOR"},
    { title: "Desc. Setor", data: "DESCSETOR" },
    { title: "Peso", data: "PESO" },
    { title: "Largura", data: "LARGURA" },
    { title: "Rocas", data: "ROCAS" },
    { title: "Ord. Tec.", data: "ORD_TEC" },
    { title: "Observação", data: "OBSERVACAO" },
    { title: "Perda", data: "PERDA" },
    { title: "Gramatura", data: "GRAMATURA" },
    { title: "Parte", data: "PARTE" },
    { title: "Desperdício", data: "DESPERDICIO" },
    { title: "Consumo Desp.", data: "CONSUMO_DESP" },
    { title: "Código 2", data: "CODIGO2" },
    { title: "Friso", data: "FRISO" },
    { title: "Barra", data: "BARRA" },
    { title: "Qtde Baixa", data: "QTDE_BAIXA" },
    { title: "Preço Baixa", data: "PRECO_BAIXA" },
    { title: "Total Baixa", data: "TOTAL_BAIXA" },
    { title: "Composição", data: "COMPOSICAO" }
  ];

  let tabelaColVis = '';
  let primeiraConsulta = true;

  let colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
  if (colunas === null || colunas.relfaccaoFaccao === undefined) {
    localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, relfaccaoFaccao: [] }));
    colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
  };
  if (colunas === null || colunas.relfaccaoConsumos === undefined) {
    localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, relfaccaoConsumos: [] }));
    colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
  };
  if (colunas === null || colunas.relfaccaoComposicao === undefined) {
    localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, relfaccaoComposicao: [] }));
    colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
  };

  $('#txtOrdemProducaoRelFaccao').autocompleta(1, `JSON={ "tabela":"OF1", "camposSelect":["NUMERO CHAVE", "CODIGO DESCRICAO"], "where": null}`);
  $('#txtMovimentoRelFaccao').pesquisa_variosServerside(1, `{ "tabela":"FACCAO", "camposSelect":["MOV", "INSUMO"], "where": null, "groupby": ["MOV", "NUMERO"]}`, 'MOV', 'NUMERO');
  $('#txtSetorRelFaccao').autocompleta(1, `JSON={ "tabela":"CADFLUXO", "camposSelect":["CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
  $('#txtFaccaoRelFaccao').autocompleta(1, `JSON={ "tabela":"ENTIDADE", "camposSelect":["CODCLI CHAVE", "NOME DESCRICAO"], "where": ["ATIVO = 'S'"]}`);
  $('#txtCorRelFaccao').pesquisa_variosServerside(1, `{ "tabela":"CADCOR", "camposSelect":["COR", "DESCRICAO"], "where": null}`, 'COR', 'DESCRICAO');
  $('#txtLancamentoRelFaccao').autocompleta(1, `JSON={ "tabela":"FACCAO", "camposSelect":["LANCTO CHAVE", "NUMERO DESCRICAO"], "where": null}`);

  $('#btnOrdemProducaoRelFaccao').pesquisa_serverside(['#txtOrdemProducaoRelFaccao'], ['NUMERO'], ['CODIGO'], '{"tabela":"OF1", "camposSelect":["NUMERO", "CODIGO"], "where": null}', 'Pesquisa de Ordem de Produção');
  $('#btnMovimentoRelFaccao').pesquisa_serversideSel('#txtMovimentoRelFaccao', `{ "tabela":"FACCAO", "camposSelect":["MOV", "NUMERO"], "where": null, "groupby": ["MOV", "NUMERO"]}`, 'Pesquisa de Movimento');
  $('#btnSetorRelFaccao').pesquisa('#txtSetorRelFaccao', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CADFLUXO", "camposSelect":["CODIGO", "DESCRICAO"]}`, 'Pesquisa Setores', 'CADFLUXO', undefined, () => { $("#txtSetorRelFaccao").trigger("blur"); $("#txtSetorRelFaccao").trigger("change"); });
  $('#btnFaccaoRelFaccao').pesquisa_serverside(['#txtFaccaoRelFaccao'], ['CODCLI'], ['NOME'], `{"tabela":"ENTIDADE", "camposSelect":["CODCLI", "NOME"], "where": ["ATIVO = 'S'"]}`, 'Pesquisa de Facção');
  $('#btnCorRelFaccao').pesquisa_serversideSel('#txtCorRelFaccao', `{ "tabela":"CADCOR", "camposSelect":["COR", "DESCRICAO"], "where": null}`, 'Pesquisa de Cores');
  $('#btnLancamentoRelFaccao').pesquisa_serverside(['#txtLancamentoRelFaccao'], ['LANCTO'], ['NUMERO'], `{"tabela":"FACCAO", "camposSelect":["LANCTO", "NUMERO"], "where": null}`, 'Pesquisa de Lançamentos');

  $("#btnLimpaOrdemProducaoRelFaccao").on("click", function () {
    $("#txtOrdemProducaoRelFaccao").val("");
    bloqueiaCampoMovimento(true);
  });

  $("#btnLimpaMovimentoRelFaccao").on("click", function () {
    $("#txtMovimentoRelFaccao").empty().trigger('change');
  });

  $("#btnLimpaSetorRelFaccao").on("click", function () {
    $("#txtSetorRelFaccao").val("");
    bloqueiaCampoMovimento(true);
  });

  $("#btnLimpaFaccaoRelFaccao").on("click", function () {
    $("#txtFaccaoRelFaccao").val("");
  });

  $("#btnLimpaCorRelFaccao").on("click", function () {
    $("#txtCorRelFaccao").empty().trigger("change");
  });

  $("#btnLimpaLancamentoRelFaccao").on("click", function () {
    $("#txtLancamentoRelFaccao").val("");
  });

  $("#btnLimpaSetorConsumosRelFaccao").on("click", function () {
    $("#txtSetorConsumosRelFaccao").empty().trigger("change");
  });

  $("#btnLimpaParteConsumosRelFaccao").on("click", function () {
    $("#txtParteConsumosRelFaccao").empty().trigger("change");
  });

  $("#btnLimpaAplicacaoConsumosRelFaccao").on("click", function () {
    $("#txtAplicacaoConsumosRelFaccao").empty().trigger("change");
  });

  $("#txtOrdemProducaoRelFaccao").on("change", async function () {
    const ordemProducao = pegaChave(this);
    montaPesquisaFiltrosConsumos();
    await carregaPartes(ordemProducao);
  });

  $('#txtPrecoRelFaccao').maskMoney({
    decimal: ',',
    thousands: '',
    precision: 2
  });

  $("#txtOrdemProducaRelFaccao").on("blur", function () {
    const ordemProducao = pegaChave(this);
    const setor = pegaChave("#txtSetorRelFaccao");
    if (ordemProducao != "" && setor != "") {
      bloqueiaCampoMovimento(false);
      montaPesquisaMovimento(ordemProducao, setor);
    } else {
      bloqueiaCampoMovimento(true);
    };
  });

  $("#btnConsultarRelFaccao").on("click", async function () {
    $.LoadingOverlay("show");
    try {
      validaCampos()
      await eventoClickBtnConsultarRelFaccao();
    } catch (error) {
      msgAlerta(error.message);
      console.log(error);
    } finally {
      $.LoadingOverlay("hide");
    };
  });

  $("#btnImprimirRelFaccao").on("click", async function () {
    $.LoadingOverlay("show");
    try {
      await imprimirRelFaccao();
    } finally {
      $.LoadingOverlay("hide");
    };
  });

  $("#btnGravarPrecoRelFaccao").on("click", async function () {
    $.LoadingOverlay("show");
    try {
      validaCampos()
      await gravarPrecoRelFaccao();
      await eventoClickBtnConsultarRelFaccao();
    } catch (error) {
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay("hide");
    };
  });

  $("#btnGravarObservacaoRelFaccao").on("click", async function () {
    $.LoadingOverlay("show");
    try {
      await gravarObservacaoRelFaccao();
    } finally {
      $.LoadingOverlay("hide");
    };
  });

  $("#cbSetorConsumosRelFaccao, #cbParteConsumosRelFaccao, #cbAplicacaoConsumosRelFaccao").on("click", function () {
    if ($("#cbSetorConsumosRelFaccao").prop("checked") || $("#cbParteConsumosRelFaccao").prop("checked") || $("#cbAplicacaoConsumosRelFaccao").prop("checked")) {
      $("#divSetorConsumosRelFaccao").removeClass("d-none");
      $("#divParteConsumosRelFaccao").removeClass("d-none");
      $("#divAplicacaoConsumosRelFaccao").removeClass("d-none");
    } else {
      $("#divSetorConsumosRelFaccao").addClass("d-none");
      $("#divParteConsumosRelFaccao").addClass("d-none");
      $("#divAplicacaoConsumosRelFaccao").addClass("d-none");
    };
  });

  $("#txtSetorRelFaccao").on("change", async function () {
    $.LoadingOverlay("show");
    try {
      const observacao = await retornaObservacaoRelFaccao();
      $("#txtObservacaoRelFaccao").val(observacao);
    } finally {
      $.LoadingOverlay("hide");
    };
  });

  $("#txtSetorRelFaccao").on("blur", function () {
    const ordemProducao = pegaChave("#txtOrdemProducaoRelFaccao");
    const setor = pegaChave(this);
    if (ordemProducao != "" && setor != "") {
      bloqueiaCampoMovimento(false);
      montaPesquisaMovimento(ordemProducao, setor);
    } else {
      bloqueiaCampoMovimento(true);
    };
  });

  $("#txtParteRelFaccao").on("change", function () {
    if ($(this).val() == "") {
      $("#txtPrecoCertoRelFaccao").val("");
      $("#txtPrecoRelFaccao").val("");
      $("#txtPrecoRelFaccao").attr("disabled", true);
    } else {
      $("#txtPrecoRelFaccao").attr("disabled", false);
    };
    limparGrids();
  });

  $('#abaComposicaoRelFaccao').on('shown.bs.collapse', function () {
    if ($.fn.DataTable.isDataTable("#tabelaComposicaoRelFaccao")) {
      $('#tabelaComposicaoRelFaccao').DataTable().columns.adjust().draw(false);
    };
  });

  $(".collapse")
    .on("shown.bs.collapse", function (e) {
      let clicked = $(document).find(`[href='#${$(e.target).attr("id")}']`);

      clicked
        .parent()
        .find(".fa-angle-right")
        .removeClass("fa-angle-right")
        .addClass("fa-angle-down");
    })
    .on("hidden.bs.collapse", function (e) {
      let clicked = $(document).find(`[href='#${$(e.target).attr("id")}']`);

      clicked
        .parent()
        .find(".fa-angle-down")
        .removeClass("fa-angle-down")
        .addClass("fa-angle-right");
    });

  function iniciaTela() {
    montaPesquisaFiltrosConsumos();
    retornaHintRelatorio('btnImprimirRelFaccao', 'relfaccao');
  };

  function validaCampos() {
    const ordemProducao = pegaChave("#txtOrdemProducaoRelFaccao");
    const setor = pegaChave("#txtSetorRelFaccao");
    const dataSaida = pegaChave("#txtDataSaidaRelFaccao");
    const parte = pegaChave("#txtParteRelFaccao");

    if (ordemProducao == "") {
      throw new Error("Necessário informar o campo número.");
    };

    if (dataSaida == "") {
      throw new Error("Necessário informar o campo data saída.");
    };

    if (setor == "") {
      throw new Error("Necessário informar o campo setor.");
    };

    if (parte == "") {
      throw new Error("Necessário informar o campo parte.");
    };
  };

  async function consultarRelFaccao() {
    const params = await retornaFiltros();
    const url = `/sisplan/relenviofaccao/v1/consultarelfaccao?`;
    try {

      const response = await requisicao('GET', url, params, '', 360000);

      if (!response) {
        throw new Error("Não foi possível realizar a consulta do relatório de facção.");
      };

      const json = await response.json();
      if (response.status != 200) {
        throw new Error(json.mensagem);
      };

      return json;
    } catch (error) {
      msgAlerta(error.message);
      console.error(error);
    };
  };

  async function retornaFiltros() {
    const ordemProducao = pegaChave("#txtOrdemProducaoRelFaccao");
    const dataSaida = $("#txtDataSaidaRelFaccao").val();
    const movimento = await formataListas($("#txtMovimentoRelFaccao").val().toString());
    const setor = pegaChave("#txtSetorRelFaccao");
    const descSetor = pegaDescricao("#txtSetorRelFaccao");
    const parte = $("#txtParteRelFaccao").val();
    const faccao = pegaChave("#txtFaccaoRelFaccao");
    const cor = await formataListas($('#txtCorRelFaccao').val().toString());
    const peso = $("#txtPesoRelFaccao").val();
    const lancamento = $("#txtLancamentoRelFaccao").val();
    const checkSetor = $("#cbSetorConsumosRelFaccao").prop("checked");
    const setorConsumos = await formataListas($("#txtSetorConsumosRelFaccao").val().toString());
    const checkParte = $("#cbSetorConsumosRelFaccao").prop("checked");
    const parteConsumos = await formataListas($("#txtParteConsumosRelFaccao").val().toString());
    const checkAplicacao = $("#cbSetorConsumosRelFaccao").prop("checked");
    const aplicacaoConsumos = await formataListas($("#txtAplicacaoConsumosRelFaccao").val().toString());
    const observacao = $("#txtObservacaoRelFaccao").val();


    return `ORDEM_PRODUCAO=${ordemProducao}` +
      `&DATA_SAIDA=${dataSaida}` +
      `&MOVIMENTO=${movimento}` +
      `&SETOR=${setor}` +
      `&DESC_SETOR=${descSetor}` +
      `&PARTE=${parte}` +
      `&FACCAO=${faccao}` +
      `&COR=${cor}` +
      `&PESO=${peso}` +
      `&LANCAMENTO=${lancamento}` +
      `&CHECK_SETOR=${checkSetor}` +
      `&SETOR_CONSUMOS=${setorConsumos}` +
      `&CHECK_PARTE=${checkParte}` +
      `&PARTE_CONSUMOS=${parteConsumos}` +
      `&CHECK_APLICACAO=${checkAplicacao}` +
      `&APLICACAO_CONSUMOS=${aplicacaoConsumos}` +
      `&OBSERVACAO=${observacao}`;
  };

  async function gravarPrecoRelFaccao() {
    const url = "/sisplan/relenviofaccao/v1/gravarpreco?";
    // const precoMaximo = await retornaPrecoMaximo();
    const preco = $("#txtPrecoRelFaccao").val();
    const lancamento = $("#txtLancamentoRelFaccao").val();
    const dadosTabelaFaccao = $("#tabelaFaccaoRelFaccao").DataTable().data().toArray();
    try {

      if (dadosTabelaFaccao.length == 0) {
        throw new Error("Não foi possível gravar o preço. Não existem informações no grid.");
      } else {
        // if (preco > precoMaximo) {
        //   throw new Error("Não foi possível realizar a ação. Preço maior que o permitido.")
        // }

        const response = await requisicao("PUT", url, `LANCAMENTO${lancamento}&PRECO=${preco}`, `&JSON=${JSON.stringify(dadosTabelaFaccao)}`, 360000);

        if (!response) {
          throw new Error("Não foi possível gravar o preço.");
        }

        if (response.status != 200) {
          const json = await response.json();
          throw new Error(json.mensagem);
        };
      };
    } catch (error) {
      msgAlerta(error.message);
      console.log(error);
    };
  };

  async function gravarObservacaoRelFaccao() {
    const ordemProducao = pegaChave("#txtOrdemProducaoRelFaccao");
    const movimento = await formataListas($("#txtMovimentoRelFaccao").val().toString());
    const faccao = pegaChave("#txtFaccaoRelFaccao");
    const setor = pegaChave("#txtSetorRelFaccao");
    const parte = $("#txtParteRelFaccao").val();
    const observacao = $("#txtObservacaoRelFaccao").val();
    const url = `/sisplan/relenviofaccao/v1/observacaomovimento?`;
    const params = `ORDEM_PRODUCAO=${ordemProducao}` +
      `&MOVIMENTO=${movimento}` +
      `&FACCAO=${faccao}` +
      `&SETOR=${setor}` +
      `&PARTE=${parte}` +
      `&OBSERVACAO=${encodeURIComponent(observacao)}`;
    try {

      if (ordemProducao == "") {
        throw new Error("Necessário informar o campo número.");
      };

      if (setor == "") {
        throw new Error("Necessário informar o campo setor.");
      };

      if (parte == "") {
        throw new Error("Necessário informar o campo parte.");
      };

      const response = await requisicao('PUT', url, params, "", 360000);

      if (!response) {
        throw new Error("Não foi possível gravar a observação.");
      };

      if (response.status != 200) {
        const json = await response.json();
        throw new Error(json.mensagem);
      };

      criaMensagemSucesso('Observação gravada com sucesso!', () => { }, () => { });

    } catch (error) {
      msgAlerta(error.message);
      console.error(error);
    };
  };

  function montaPesquisaFiltrosConsumos() {
    const ordemProducao = pegaChave("#txtOrdemProducaoRelFaccao");

    $('#txtSetorConsumosRelFaccao').pesquisa_variosServerside(1, `{ "tabela":"FAC_SETOR", "camposSelect":["SETOR", "DESCRICAO"], "where": ${ordemProducao != "" ? `["FAC_SETOR.NUMERO = '${ordemProducao}'"]` : "null"}, "innerJoin": [{"tabela": "CADFLUXO", "condicao": "FAC_SETOR.SETOR = CADFLUXO.CODIGO"}], "groupBy": ["SETOR", "DESCRICAO"]}`, 'SETOR', 'DESCRICAO');
    $('#txtParteConsumosRelFaccao').pesquisa_variosServerside(1, `{ "tabela":"OF1", "camposSelect":["PCPFT2.PARTE", "TIPO_APL.DESCRICAO"], "where": ${ordemProducao != "" ? `["OF1.NUMERO = '${ordemProducao}'"]` : "null"}, "leftJoin": [{"tabela": "TIPO_APL", "condicao": "OF1.PARTE = TIPO_APL.CODIGO"}, {"tabela": "PCPFT2", "condicao": "PCPFT2.CODIGO = OF1.CODIGO"}], "groupBy": ["PCPFT2.PARTE", "TIPO_APL.DESCRICAO"]}`, 'PARTE', 'DESCRICAO');
    $('#txtAplicacaoConsumosRelFaccao').pesquisa_variosServerside(1, `{ "tabela":"OF1", "camposSelect":["PCPFT2.APLICACAO", "PCPAPL.DESCRICAO"], "where": ${ordemProducao != "" ? `["OF1.NUMERO = '${ordemProducao}'"]` : "null"}, "leftJoin": [{"tabela": "PCPFT2", "condicao": "PCPFT2.CODIGO = OF1.CODIGO"}, {"tabela": "PCPAPL", "condicao": "PCPFT2.APLICACAO = PCPAPL.CODIGO"}], "groupBy": ["APLICACAO", "DESCRICAO"]}`, 'APLICACAO', 'DESCRICAO');

    $('#btnSetorConsumosRelFaccao').pesquisa_serversideSel('#txtSetorConsumosRelFaccao', `{ "tabela":"FAC_SETOR", "camposSelect":["SETOR", "DESCRICAO"], "where": ${ordemProducao != "" ? `["FAC_SETOR.NUMERO = '${ordemProducao}'"]` : "null"}, "innerJoin": [{"tabela": "CADFLUXO", "condicao": "FAC_SETOR.SETOR = CADFLUXO.CODIGO"}], "groupBy": ["SETOR", "DESCRICAO"]}`, 'Pesquisa de Setor');
    $('#btnParteConsumosRelFaccao').pesquisa_serversideSel('#txtParteConsumosRelFaccao', `{ "tabela":"OF1", "camposSelect":["PCPFT2.PARTE", "TIPO_APL.DESCRICAO"], "where": ${ordemProducao != "" ? `["OF1.NUMERO = '${ordemProducao}'"]` : "null"}, "leftJoin": [{"tabela": "TIPO_APL", "condicao": "OF1.PARTE = TIPO_APL.CODIGO"}, {"tabela": "PCPFT2", "condicao": "PCPFT2.CODIGO = OF1.CODIGO"}], "groupBy": ["PCPFT2.PARTE", "TIPO_APL.DESCRICAO"]}`, 'Pesquisa de Parte');
    $('#btnAplicacaoConsumosRelFaccao').pesquisa_serversideSel('#txtAplicacaoConsumosRelFaccao', `{ "tabela":"OF1", "camposSelect":["PCPFT2.APLICACAO", "PCPAPL.DESCRICAO"], "where": ${ordemProducao != "" ? `["OF1.NUMERO = '${ordemProducao}'"]` : "null"}, "leftJoin": [{"tabela": "PCPFT2", "condicao": "PCPFT2.CODIGO = OF1.CODIGO"}, {"tabela": "PCPAPL", "condicao": "PCPFT2.APLICACAO = PCPAPL.CODIGO"}], "groupBy": ["PCPFT2.APLICACAO", "PCPAPL.DESCRICAO"]}`, 'Pesquisa de Aplicação');
  };

  function buscaCampos(campo) {
    const listaNumeros = [
      '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'
    ];
    const listaTraducoes = {
      TAMENF: 'Tam. e NF',
      QTDEFOLHAGRADEENF: 'Qtde Folha Grade e NF',
      QTD_GRADE: 'Qtde Grade',
      QTD: 'Qtde',
      TAM: 'Tam.',
      QTDEFOLHAENF: 'Qtde Folha e NF',
      QTDEFOLHAGRADEENF: 'Qtde Folha Grade e NF',
      PRECO: 'Preço'
    };

    const contemNumero = listaNumeros.some(num => campo.includes(num));
    if (!contemNumero) {
      return undefined;
    };

    let title = listaTraducoes[campo.replace(/[0-9]/g, '')];
    if (title) {
      const data = campo;
      const indice = campo.replace(/[^0-9]/g, '');
      title += indice !== '' ? ` ${indice}` : '';
      // const oculto = parseInt(indice) > 15;
      return { data, title/*, oculto*/ };
    };
    return undefined;
  };

  function colunasInvisiveis(dataset) {
    const colunasInvisiveis = [];
    for (let x = 0; x < dataset.length; x++) {
      if (dataset[x].oculto || false)
        colunasInvisiveis.push(x)
    };
    return colunasInvisiveis;
  };

  function preencheTabelaFaccao(registros) {
    if ($.fn.DataTable.isDataTable('#tabelaFaccaoRelFaccao')) {
      $("#tabelaFaccaoRelFaccao").DataTable().data().clear().draw(false);
    };

    if (registros.length > 0) {
      const keys = Object.keys(registros[0]);
      for (var k in keys) {
        if (primeiraConsulta && keys[k]) {
          const campo = buscaCampos(keys[k])
          if (campo)
            dataSetCols_FACCAO.push(campo);
        };
      };
      criaDataTableCamposNaoFixos(
        '#tabelaFaccaoRelFaccao',
        undefined,
        registros,
        dataSetCols_FACCAO,
        colunasInvisiveis(dataSetCols_FACCAO)
      );
    };
  };

  function preencheTabelaConsumos(registros) {
    if ($.fn.DataTable.isDataTable("#tabelaConsumosRelFaccao")) {
      $("#tabelaConsumosRelFaccao").DataTable().data().clear().draw(false);
    }

    if (registros.length > 0) {
      criaDataTableCamposNaoFixos(
        '#tabelaConsumosRelFaccao',
        undefined,
        registros,
        dataSetCols_CONSUMOS,
        colunasInvisiveis(dataSetCols_CONSUMOS),
      );

      $('#tabelaConsumosRelFaccao tbody').unbind('click');
      $('#tabelaConsumosRelFaccao tbody').on('click', 'tr', async function () {
        // if ($(this).hasClass('selected')) {
        //     $(this).removeClass('selected');
        // } else {
        $('#tabelaConsumosRelFaccao').DataTable().$('tr.selected').removeClass('selected');
        $(this).addClass('selected');
        const dadosRow = $("#tabelaConsumosRelFaccao").DataTable().rows($(this)).data().toArray();
        const jsonComposicao = retornaJsonDadosComposicao(dadosRow.map(dados => dados.COMPOSICAO))
        preencheTabelaComposicao(jsonComposicao);
        // }
      });

      $($('#tabelaConsumosRelFaccao tbody tr')[0]).trigger('click');
    };
  };

  function preencheTabelaComposicao(registros) {
    if ($.fn.DataTable.isDataTable("#tabelaComposicaoRelFaccao")) {
      $("#tabelaComposicaoRelFaccao").DataTable().data().clear().draw(false);
      $("#tabelaComposicaoRelFaccao").DataTable().rows.add(registros).draw(false);
    } else {
      if (registros.length > 0) {
        const dataSetCols = [];
        const keys = Object.keys(registros[0]);
        for (var k in keys) {
          dataSetCols.push({
            'title': keys[k],
            'data': keys[k]
          });
        };

        criaDataTableCamposNaoFixos(
          '#tabelaComposicaoRelFaccao',
          undefined,
          registros,
          dataSetCols,
        );
      };
    };
  };

  async function carregaPartes(ordemProducao) {
    try {

      if (ordemProducao == "") {
        return;
      };

      const responsePartes = await requisicao("GET", "/sisplan/funcoes/v1/pesquisa?", `JSON={"tabela": "FACCAO", "camposSelect": [" DISTINCT FACCAO.PARTE", "TIPO_APL.DESCRICAO"], "where": ["FACCAO.NUMERO = '${ordemProducao}'"], "leftJoin": [{"tabela": "TIPO_APL", "condicao": "FACCAO.PARTE = TIPO_APL.CODIGO"}], "orderBy": ["FACCAO.PARTE"]}`);

      if (!responsePartes) {
        return;
      };

      const json = await responsePartes.json();
      if (responsePartes.status != 200) {
        msgAlerta(json.RESULT[0].mensagem);
        return;
      };

      await insereValorPesquisaVarios('txtParteRelFaccao', 'PARTE', 'DESCRICAO', json.RESULT[0]);
      $("#txtParteRelFaccao").val("");

      if (json?.RESULT?.[0]?.length === 1) {
        $("#txtParteRelFaccao").val(json?.RESULT?.[0]?.[0]?.PARTE ?? "");
      };


    } catch (error) {
      msgAlerta(error.message);
      console.error(error);
    };
  };

  function retornaJsonDadosComposicao(registros) {
    // return registros.map(registro => JSON.parse(registro.replaceAll("%", '"')));
    return JSON.parse(registros.toString().replaceAll("%", '"'));
  }

  async function retornaObservacaoRelFaccao() {
    const ordemProducao = pegaChave("#txtOrdemProducaoRelFaccao");
    const setor = pegaChave("#txtSetorRelFaccao");
    const movimento = await formataListas($("#txtMovimentoRelFaccao").val().toString());
    const parte = $("#txtParteRelFaccao").val();
    const url = `/sisplan/relenviofaccao/v1/observacaomovimento?`;
    const params = `ORDEM_PRODUCAO=${ordemProducao}` +
      `&SETOR=${setor}` +
      `&PARTE=${parte}` +
      `&MOVIMENTO=${movimento}`;
    try {

      if (setor == "") {
        return;
      };

      const response = await requisicao('GET', url, params, '', 360000);

      if (!response) {
        throw new Error("Não foi possível consultar a observação.");
      };

      const observacao = await response.text();
      if (response.status != 200) {
        const json = await response.json();
        throw new Error(json.mensagem);
      };

      return observacao;

    } catch (error) {
      msgAlerta(error.message);
      console.error(error);
    };
  };

  async function imprimirRelFaccao() {
    try {
      const url = "/sisplan/impressao/v1/relfaccao?";
      const filtros = await retornaFiltros();
      const bImprimeAutomatico = await verificaImprimirAutomatico("RelFaccao");
      const arquivo = await GeraRelatorio(`${url}${filtros}`, "GET", 1000000, false, "RelFaccao");
      if (arquivo != undefined) {
        if (!bImprimeAutomatico) {
          window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
        };
        await limparRelatorios();
      };
    } catch (error) {
      console.error(error);
    };
  };

  function preencheCamposPreco(precoCerto, preco) {
    $("#txtPrecoCertoRelFaccao").val(parseFloat(precoCerto).toFixed(2).replace('.',','));
    $("#txtPrecoRelFaccao").val(parseFloat(preco).toFixed(2).replace('.',','));
  };

  function bloqueiaCampoMovimento(bloquear) {
    $("#txtMovimentoRelFaccao").attr("disabled", bloquear);
    $("#btnMovimentoRelFaccao").attr("disabled", bloquear);
    $("#btnLimpaMovimentoRelFaccao").attr("disabled", bloquear);
    if (bloquear) {
      $("#btnLimpaMovimentoRelFaccao").trigger("click");
    };
  };

  function montaPesquisaMovimento(ordemProducao, setor) {
    $('#txtMovimentoRelFaccao').pesquisa_variosServerside(1, `{ "tabela":"FACCAO", "camposSelect":["MOV", "INSUMO"], "where": ["NUMERO = '${ordemProducao} AND OP = '${setor}''"], "groupby": ["MOV", "NUMERO"]}`, 'MOV', 'NUMERO');
    $('#btnMovimentoRelFaccao').pesquisa_serversideSel('#txtMovimentoRelFaccao', `{ "tabela":"FACCAO", "camposSelect":["MOV", "NUMERO"], "where": ["NUMERO = '${ordemProducao}' AND OP = '${setor}'"], "groupby": ["MOV", "NUMERO"]}`, 'Pesquisa de Movimento');
  };

  function limparGrids() {
    if ($.fn.DataTable.isDataTable('#tabelaFaccaoRelFaccao')) {
      $("#tabelaFaccaoRelFaccao").DataTable().data().clear().draw(false);
    };
    if ($.fn.DataTable.isDataTable('#tabelaConsumosRelFaccao')) {
      $("#tabelaConsumosRelFaccao").DataTable().data().clear().draw(false);
    };
    if ($.fn.DataTable.isDataTable('#tabelaComposicaoRelFaccao')) {
      $("#tabelaComposicaoRelFaccao").DataTable().data().clear().draw(false);
    };
  };

  async function eventoClickBtnConsultarRelFaccao() {
    const registros = await consultarRelFaccao();
    preencheTabelaFaccao(registros[0]);
    preencheTabelaConsumos(registros[1]);
    $("#faccaoaba").trigger("click")
    if (registros[0].length > 0) {
      preencheCamposPreco(registros[0][0].CAMPO_PRECO_CERTO, registros[0][0].CAMPO_PRECO)
    }

    if ($.fn.DataTable.isDataTable('#tabelaFaccaoRelFaccao'))
      $('#tabelaFaccaoRelFaccao').DataTable().columns.adjust().draw(false);

    if ($.fn.DataTable.isDataTable('#tabelaConsumosRelFaccao'))
      $('#tabelaConsumosRelFaccao').DataTable().columns.adjust().draw(false);

    if ($.fn.DataTable.isDataTable('#tabelaComposicaoRelFaccao'))
      $('#tabelaComposicaoRelFaccao').DataTable().columns.adjust().draw(false);

    primeiraConsulta = false;
  };

  await preencheDadosDeMovimentacao()

  async function preencheDadosDeMovimentacao() {
    const storageJson = JSON.parse(localStorage.getItem('objenviorelfaccao'))

    if (storageJson) {
      insereValor('#txtOrdemProducaoRelFaccao', storageJson.NUMERO, storageJson.PRODUTO);
      insereValor('#txtSetorRelFaccao', storageJson.CODSETOR, storageJson.DESCSETOR);
      insereValor('#txtFaccaoRelFaccao', storageJson.CODFACCAO, storageJson.DESCFACCAO);
      $('#txtDataSaidaRelFaccao').val(storageJson.SAIDA);

      await carregaPartes(storageJson.NUMERO);

      $('#txtParteRelFaccao').val(storageJson.PARTE).trigger('change');
      localStorage.removeItem('objenviorelfaccao');

      $("#btnConsultarRelFaccao").trigger("click");
    };
  };

  window.addEventListener('storage', async function (e) {
    if (e.key == 'objenviorelfaccao') {
      await preencheDadosDeMovimentacao();
    };
  });

  function criaDataTableCamposNaoFixos(
    sIdTabela,
    sScrollY = "15vh",
    sData,
    sColumns,
    sColunasInvisiveis = [],
    sColunasDinheiro = [],
    sColunasDecimais = [],
    casasDecimais = 0,
    sColunasCentro = [],
    sColunasDireita = [],
    sBotoesOpcoes = false,
    sBotoesOpcoesPersonalizados = []
  ) {
    criaDataTablePadrao(
      sIdTabela,
      true,
      true,
      true,
      true,
      true,
      true,
      sScrollY,
      sData,
      sColumns,
      sColunasInvisiveis,
      [],
      sColunasDinheiro,
      sColunasDecimais,
      {},
      casasDecimais,
      `buttonColVis_${sIdTabela.replace("#", "")}`,
      `buttonExcel_${sIdTabela.replace("#", "")}`,
      false,
      sColunasCentro,
      sColunasDireita,
      [],
      [],
      false,
      sBotoesOpcoes,
      sBotoesOpcoesPersonalizados
    );

    $(`#buttonExcel_${sIdTabela.replace("#", "")}`).on("click", async function () {
      $.LoadingOverlay('show');
      try {
        const dados = $(sIdTabela).DataTable().data().toArray();
        await exportaCSV("", "", undefined, null, 'Relatório Facção - Relatório de Terceiros', '', '', 999, false, false, dados);
      } catch (error) {
        console.log(error.message);
      } finally {
        $.LoadingOverlay('hide');
      };
    });

    $(`#buttonColVis_${sIdTabela.replace("#", "")}`).on("click", async function () {
      $.LoadingOverlay('show');
      try {
        tabelaColVis = `#${sIdTabela.replace("#", "")}`;
        $('#modal-ColunasVisiveis').modal('show');
      } finally {
        $.LoadingOverlay('hide');
      };
    });
  };

  $('#btnConfirmarColunas').on('click', async function () {
    $.LoadingOverlay('show');
    try {
      const novasColunas = retornaNovasColunasInvisiveis();

      if (tabelaColVis === "#tabelaFaccaoRelFaccao") {
        localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, relfaccaoFaccao: novasColunas }))
        $('#tabelaFaccaoRelFaccao').DataTable().columns().visible(true);
        $('#tabelaFaccaoRelFaccao').DataTable().columns().every(
          function () {
            if ((novasColunas).indexOf(this.dataSrc()) != -1) {
              this.visible(false);
            };
          }
        );
      } else if (tabelaColVis === "#tabelaConsumosRelFaccao") {
        localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, relfaccaoConsumos: novasColunas }))
        $('#tabelaConsumosRelFaccao').DataTable().columns().visible(true);
        $('#tabelaConsumosRelFaccao').DataTable().columns().every(
          function () {
            if ((novasColunas).indexOf(this.dataSrc()) != -1) {
              this.visible(false);
            };
          }
        );
      } else if (tabelaColVis === "#tabelaComposicaoRelFaccao") {
        localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, relfaccaoComposicao: novasColunas }))
        $('#tabelaComposicaoRelFaccao').DataTable().columns().visible(true);
        $('#tabelaComposicaoRelFaccao').DataTable().columns().every(
          function () {
            if ((novasColunas).indexOf(this.dataSrc()) != -1) {
              this.visible(false);
            };
          }
        );
      };

      tabelaProdutosColVis = false;
      tabelaSetoresColVis = false;
    } catch (error) {
      console.error(error);
      msgAlerta(error.message);
    } finally {
      $.LoadingOverlay('hide');
      $('#modal-ColunasVisiveis').modal('hide');
    };
  });

  $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
    const cols = [];
    let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

    $(tabelaColVis).DataTable().columns().every(function () {
      cols.push({
        'title': $(this.header()).text(),
        'data': this.dataSrc()
      });
    });

    if (tabelaColVis === "#tabelaFaccaoRelFaccao") {
      // for (let x = 0; x < dataSetCols_FACCAO.length; x++) {
      //   if (dataSetCols_FACCAO[x].oculto)
      //     colunasInvisiveis.relfaccaoFaccao.push(dataSetCols_FACCAO[x].data)
      // };
      let desabilitadas = [];
      for (let x = 0; x < dataSetCols_FACCAO.length; x++) {
        if (dataSetCols_FACCAO[x].desabilitado)
          desabilitadas.push(dataSetCols_FACCAO[x].title)
      };
      adicionaColunas(cols, colunasInvisiveis.relfaccaoFaccao ?? [], desabilitadas);
    } else if (tabelaColVis === "#tabelaConsumosRelFaccao") {
      for (let x = 0; x < dataSetCols_CONSUMOS.length; x++) {
        if (dataSetCols_CONSUMOS[x].oculto)
          colunasInvisiveis.relfaccaoConsumos.push(dataSetCols_CONSUMOS[x].data)
      };
      adicionaColunas(cols, colunasInvisiveis.relfaccaoConsumos ?? [], []);
    } else if (tabelaColVis === "#tabelaComposicaoRelFaccao") {
      adicionaColunas(cols, colunasInvisiveis.relfaccaoComposicao ?? [], []);
    };
  });
});