$(document).ready(async function () {

  $('#tutorial').on('click', function () {
    $(document).ready(async function () {
      const driver = new Driver({
        doneBtnText: 'Sair',
        closeBtnText: 'Fechar',
        nextBtnText: 'Próximo',
        prevBtnText: 'Anterior',
        allowClose: false
      });
      driver.defineSteps([{
        element: '#btnFiltros',
        popover: {
          title: 'Botão Filtros',
          description: 'Clique aqui para abrir os filtros e realizar uma consulta.',
          position: 'right'
        }
      },
      {
        element: '#btnImprimir',
        popover: {
          title: 'Botão Imprimir',
          description: 'Clique aqui para imprimir um relatório.',
          position: 'right'
        }
      },
      {
        element: '#divRelatorio',
        popover: {
          title: 'Tabela com os Dados',
          description: 'Aqui, após clicar em consultar ficam os dados filtrados.',
          position: 'bottom'
        }
      }
      ]);
      driver.start();
    });
  });

  let activeColVis = '';

  let colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

  if (colunas == null || colunas.relNfEntra == undefined) {
    localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, relNfEntra: [] }))
    colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))
  }
  if (colunas == null || colunas.relNfEntraNotas == undefined) {
    localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, relNfEntraNotas: [] }))
    colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))
  }

  // confirma as colunas
  $('#btnConfirmarColunas').on('click', async function () {
    try {
      $.LoadingOverlay('show');

      const novasColunas = retornaNovasColunasInvisiveis();
      let cols = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
      if (activeColVis == 'buttonColVisNotas') {
        tabela = '#tabelaNotasVisualizacao'
        localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...cols, relNfEntraNotas: novasColunas }))
      }
      if (activeColVis == 'buttonColVis') {
        tabela = '#tabelaNotas'
        localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...cols, relNfEntra: novasColunas }))
      }
      $(tabela).DataTable().columns().visible(true);

      $(tabela).DataTable().columns().every(
        function () {
          if ((novasColunas).indexOf(this.dataSrc()) != -1) {
            this.visible(false);
          }
        })
    } finally {
      $.LoadingOverlay('hide');
      $('#modal-ColunasVisiveis').modal('hide');
    }
  })

  $('#btnLimparFiltros').on('click', async function () {

    setarDataAtual('dtEmissaoDe', true);
    setarDataAtual('dtEmissaoAte');
    setarDataAtual('dtEntradaDe', true);
    setarDataAtual('dtEntradaAte');

    $('#btnLimpaProduto').trigger('click');
    $('#btnLimpaMaterial').trigger('click');
    $('#btnLimpaServico').trigger('click');
    $('#btnLimpaCor').trigger('click');
    $('#btnLimpaTamanho').trigger('click');
    $('#btnLimpaLote').trigger('click');
    $('#btnLimpaOrdemCompra').trigger('click');
    $('#btnLimpaNotaEntra').trigger('click');
    $('#btnLimpaFornecedor').trigger('click');
    $('#btnLimpaDeposito').trigger('click');
    $('#btnLimpaNatureza').trigger('click');
    $('#btnLimpaOperacao').trigger('click');

    // $('#selectXML').val('')
    $('#selectDuplicatas').val('')
    $('#selectNotas').val('')
    $('#selectMovimento').val('')
  });

  $('#btnFiltros').on('click', async function () {
    $('#modal-filtros').modal('show');
  });

  $('#rdTipoProduto, #rdTipoMaterial, #rdTipoServico, #rdTipoTodos').on('change', function () {
    $('#txtProduto').empty().trigger('change')
    $('#txtMaterial').empty().trigger('change')
    $('#txtServico').empty().trigger('change')

    if ($('#rdTipoTodos').is(':checked')) {
      $('#inputMaterial').removeClass('d-none')
      $('#inputProduto').removeClass('d-none')
      $('#inputServico').removeClass('d-none')
    } else if ($('#rdTipoServico').is(':checked')) {
      $('#inputMaterial').addClass('d-none')
      $('#inputProduto').addClass('d-none')
      $('#inputServico').removeClass('d-none')
    } else if ($('#rdTipoProduto').is(':checked')) {
      $('#inputMaterial').addClass('d-none')
      $('#inputServico').addClass('d-none')
      $('#inputProduto').removeClass('d-none')
    } else {
      $('#inputMaterial').removeClass('d-none')
      $('#inputProduto').addClass('d-none')
      $('#inputServico').addClass('d-none')
    }
  });

  async function retornaFiltros() {
    const empresas = $('.empresa_selecionada:checked').toArray().length > 0 ? $('.empresa_selecionada:checked').toArray().map(input => input.id.substring(input.id.indexOf('-') + 1, input.id.length))
      : [getCookie('emp_id')];
    const tipo = $('#rdTipoTodos').is(':checked') ? '' : $('#rdTipoProduto').is(':checked') ? '1' : $('#rdTipoServico').is(':checked') ? '2' : '0';
    const cod_item = [await formataListas($('#txtProduto').val().toString()), await formataListas($('#txtMaterial').val().toString()), await formataListas($('#txtServico').val().toString())].filter((a) => a != '').toString()

    const retorno =
      `DT_EMISSAO_DE=${$('#dtEmissaoDe').val()}` +
      `&DT_EMISSAO_ATE=${$('#dtEmissaoAte').val()}` +
      `&DT_ENTRADA_DE=${$('#dtEntradaDe').val()}` +
      `&DT_ENTRADA_ATE=${$('#dtEntradaAte').val()}` +
      `&COD_ITEM=${cod_item}` +
      `&COR=${await formataListas($('#txtCor').val().toString())}` +
      `&TAMANHO=${await formataListas($('#txtTamanho').val().toString())}` +
      `&LOTE=${await formataListas($('#txtLote').val().toString())}` +
      `&ORDEM_COMPRA=${await formataListas($('#txtOrdemCompra').val().toString())}` +
      `&NOTAS=${await formataListas($('#txtNotaEntra').val().toString())}` +
      `&FORNECEDOR=${await formataListas($('#txtFornecedor').val().toString())}` +
      `&DEPOSITO=${await formataListas($('#txtDeposito').val().toString())}` +
      `&NATUREZA=${await formataListas($('#txtNatureza').val().toString())}` +
      `&EMPRESAS=${empresas}` +
      `&TIPO=${tipo}` +
      `&NOTAS_ORDEM=${$('#selectNotas').val()}` +
      `&DUPLICATA=${$('#selectDuplicatas').val()}` +
      `&ESTOQUE=${$('#selectMovimento').val()}`

    return retorno;
  }

  retornaHintRelatorio('btnImprimir', 'RelNfEntra');

  $('#btnImprimir').on('click', async function () {
    try {
      $.LoadingOverlay('show');
      try {
        const url = `/sisplan/impressao/v1/relnfentra?`;
        const filtros = await retornaFiltros();
        const bImprimeAutomatico = await verificaImprimirAutomatico('RelNfEntra');
        const arquivo = await GeraRelatorio(`${url}${filtros}`, 'POST', 100000, false, 'RelNfEntra');
        if (arquivo != undefined) {
          if (!bImprimeAutomatico) {
            window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
          }
          await limparRelatorios();
        }

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  $('#btnConsultar').on('click', async function () {
    try {
      $.LoadingOverlay("show");
      const filtros = await retornaFiltros();
      var response = await requisicao('GET', '/sisplan/impressao/v1/relnfentra?', filtros, null);

      if (!response) {
        return;
      }

      var jsonStr = await response.json();
      if (response.status != 200) {
        msgAlerta(jsonStr.mensagem);
        return;
      }

      if (jsonStr.length == 0) {
        msgAlerta('Nenhum registro encontrado.');
        return;
      }

      const columns = Object.keys(jsonStr[0]).map(k => ({ title: k, data: k }));
      const colunasInvisiveis = JSON.parse(
        localStorage.getItem("colunasInvisiveisRelatorios")
      );

      criaDataTablePadrao('#tabelaNotas', true, false, false, false, true, true, false, jsonStr, columns, [], [], [], [], {}, '', 'buttonColVis', 'buttonExcel2');

      $('#tabelaNotas').DataTable().columns().every(
        function () {
          if ((colunasInvisiveis.relNfEntra).indexOf(this.dataSrc()) != -1) {
            this.visible(false);
          }
        }
      )

      $('#modal-filtros').modal('hide');

      $('#buttonColVis').on('click', async function () {
        $.LoadingOverlay('show');
        activeColVis = 'buttonColVis'
        $('#modal-ColunasVisiveis').modal('show');
        $.LoadingOverlay('hide');
      })

    } catch (error) {
      console.log(error);
    } finally {
      $.LoadingOverlay("hide");
    }
  });

  async function buscaNotas(data) {
    let urlRequisicao = `/sisplan/entradanf/v1/EntradaNF?`;
    let notafiscal = data.NUMERO;
    let credor = data.CODCRE;
    let produto = '';
    let dtemissaode = $('#dtEmissaoDe ').val();
    let dtemissaoate = $('#dtEmissaoAte').val();
    let dtentradade = $('#dtEntradaDe').val();
    let dtentradaate = $('#dtEntradaAte').val();
    let paramsRequisicao = `DT_EMISSAOI=${dtemissaode}&DT_EMISSAOF=${dtemissaoate}&DT_ENTRADAI=${dtentradade}&DT_ENTRADAF=${dtentradaate}&NOTAFISCAL=${notafiscal}&FORNECEDOR=${credor}&CODIGO=${produto}`;

    try {
      let response = await requisicao('GET', urlRequisicao, paramsRequisicao, null, 10000);

      if (!response) {
        return;
      }

      if (response.status != 200) {
        msgErro(jsonStr.RESULT[0].mensagem);
        return;
      }

      let jsonStr = await response.json();
      return jsonStr;
    } catch (error) {
      console.error(error);
      msgErro('Não foi possível buscar os dados.');
    }
  }

  async function retornaInformacoesNFCompra(nota) {
    try {
      $.LoadingOverlay('show');
      const numero = nota.NUMERO;
      const notas = await buscaNotas(nota);
      const dataSetColsNotas = []

      if ($.fn.DataTable.isDataTable('#tabelaNotasVisualizacao')) {
        $('#tabelaNotasVisualizacao').DataTable().destroy();
        $('#tabelaNotasVisualizacao').empty();
      };

      if (notas.length > 0) {
        var keys = Object.keys(notas[0]);
        for (var k in keys) {
          dataSetColsNotas.push({
            'title': keys[k],
            'data': keys[k]
          });
        }

        const colunasInvisiveis = JSON.parse(
          localStorage.getItem("colunasInvisiveisRelatorios")
        );
        criaDataTablePadrao('#tabelaNotasVisualizacao', true, false, false, false, true, true, false, notas, dataSetColsNotas, [], [], [], [], {}, '', 'buttonColVisNotas', 'buttonExcel2');
        $('#tabelaNotasVisualizacao').DataTable().columns().every(
          function () {
            if ((colunasInvisiveis.relNfEntraNotas).indexOf(this.dataSrc()) != -1) {
              this.visible(false);
            }
          }
        )
      }

      $('#buttonExcel2').on('click', async function () {
        await exportaCSV('', '', true, null, 'Relatório da Nota de Compra', undefined, '', 999, false, false, itens);
      })

      $('#buttonColVisNotas').on('click', async function () {
        $.LoadingOverlay('show')
        try {
          activeColVis = 'buttonColVisNotas'
          $('#modal-ColunasVisiveis').modal('show');
        } finally {
          $.LoadingOverlay('hide')
        }
      });

    } finally {
      $.LoadingOverlay('hide');
    }
  }

  $('#tabelaNotas').on('click', 'tr', async function () {
    const data = $('#tabelaNotas').DataTable().row($(this)).data();

    if ($(this).hasClass('selected')) {
      $(this).removeClass('selected');
    } else {
      $('#tabelaNotas').DataTable().$('tr.selected').removeClass('selected');
      $(this).addClass('selected');
    }

    await retornaInformacoesNFCompra(data)
  });

  $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
    const cols = [];
    let tabela = ''
    let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

    if (activeColVis == 'buttonColVis') {
      tabela = '#tabelaNotas'
    }
    if (activeColVis == 'buttonColVisNotas') {
      tabela = '#tabelaNotasVisualizacao'
    }

    $(tabela).DataTable().columns().every(function () {
      cols.push({
        'title': $(this.header()).text().trim(),
        'data': this.dataSrc()
      })
    });

    if (activeColVis == 'buttonColVis') {
      adicionaColunas(cols, colunasInvisiveis.relNfEntra ?? [])
    }
    if (activeColVis == 'buttonColVisNotas') {
      adicionaColunas(cols, colunasInvisiveis.relNfEntraNotas ?? [])
    }

  })

  $('#btnSelecionarEmpresas').on('click', function () {
    carregaEmpresasDisponiveis();
  });

  function addPesquisaAutocompleta() {
    componenteFiltro('produto', true, true);
    componenteFiltro('material', true, true);
    componenteFiltro('servico', true, true);
    componenteFiltro('cor', true, true);
    componenteFiltro('tamanho', true, true);
    componenteFiltro('lote', true, true);
    componenteFiltro('ordemCompra', true, true);
    componenteFiltro('notaEntra', true, true);
    componenteFiltro('fornecedor', true, true);
    componenteFiltro('deposito', true, true);
    componenteFiltro('natureza', true, true);
    componenteFiltro('operacao', true, true);
  }

  function innitDateAtual() {
    setarDataAtual('dtEmissaoDe', true);
    setarDataAtual('dtEmissaoAte');
    setarDataAtual('dtEntradaDe', true);
    setarDataAtual('dtEntradaAte');
  }

  addPesquisaAutocompleta();
  innitDateAtual();

  $('#btnConsultar').trigger('click');
});